/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.metadata;

import java.io.File;
import java.util.List;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;

public abstract class AbstractMetadataProvider<T extends CompilerMetadata>
implements CompilerMetaDataProvider<T> {
    private final ExecActionFactory execActionFactory;

    public AbstractMetadataProvider(ExecActionFactory execActionFactory) {
        this.execActionFactory = execActionFactory;
    }

    @Override
    public T getCompilerMetaData(File binary, List<String> additionalArgs) {
        ImmutableList allArgs = ImmutableList.builder().addAll(additionalArgs).addAll(this.compilerArgs()).build();
        Pair<String, String> transform = this.runCompiler(binary, (List<String>)allArgs);
        if (transform == null) {
            return this.brokenMetadata(String.format("Could not determine %s metadata: failed to execute %s %s.", this.getCompilerType().getDescription(), binary.getName(), Joiner.on((char)' ').join((Iterable)allArgs)));
        }
        String output = transform.getLeft();
        String error = transform.getRight();
        try {
            return this.parseCompilerOutput(output, error, binary);
        }
        catch (BrokenResultException e) {
            return this.brokenMetadata(e.getMessage());
        }
    }

    protected abstract T parseCompilerOutput(String var1, String var2, File var3);

    private Pair<String, String> runCompiler(File gccBinary, List<String> args) {
        ExecAction exec = this.execActionFactory.newExecAction();
        exec.executable(gccBinary.getAbsolutePath());
        exec.setWorkingDir(gccBinary.getParentFile());
        exec.args(args);
        StreamByteBuffer buffer = new StreamByteBuffer();
        StreamByteBuffer errorBuffer = new StreamByteBuffer();
        exec.setStandardOutput(buffer.getOutputStream());
        exec.setErrorOutput(errorBuffer.getOutputStream());
        exec.setIgnoreExitValue(true);
        ExecResult result = exec.execute();
        int exitValue = result.getExitValue();
        if (exitValue == 0) {
            return Pair.of(buffer.readAsString(), errorBuffer.readAsString());
        }
        return null;
    }

    protected abstract List<String> compilerArgs();

    protected abstract T brokenMetadata(String var1);

    public static class BrokenResultException
    extends RuntimeException {
        public BrokenResultException(String message) {
            super(message);
        }
    }

    public static class AbstractBrokenMetadata
    implements CompilerMetadata {
        private final String message;

        public AbstractBrokenMetadata(String message) {
            this.message = message;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node(this.message);
        }

        @Override
        public String getVendor() {
            throw new UnsupportedOperationException();
        }
    }
}

