/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleMethodSignature {
    @NotNull
    private final String methodName;
    @NotNull
    private final List<String> erasedParameterTypes;
    private static final Pattern PATTERN = Pattern.compile("(\\w+)(\\((((\\w+\\.)*\\w+,)*(\\w+\\.)*\\w+)?\\))?");

    public SimpleMethodSignature(@NotNull String methodName, @NotNull List<String> erasedParameterTypes) {
        if (methodName == null) {
            SimpleMethodSignature.$$$reportNull$$$0(0);
        }
        if (erasedParameterTypes == null) {
            SimpleMethodSignature.$$$reportNull$$$0(1);
        }
        this.methodName = methodName;
        this.erasedParameterTypes = erasedParameterTypes;
    }

    @NotNull
    public static SimpleMethodSignature get(@NotNull PsiMethod method) {
        if (method == null) {
            SimpleMethodSignature.$$$reportNull$$$0(2);
        }
        String methodName = method.getName();
        List erasedParameterTypes = ContainerUtil.map((Object[])method.getHierarchicalMethodSignature().getErasedParameterTypes(), parameterType -> parameterType.getCanonicalText(true));
        SimpleMethodSignature simpleMethodSignature = new SimpleMethodSignature(methodName, erasedParameterTypes);
        if (simpleMethodSignature == null) {
            SimpleMethodSignature.$$$reportNull$$$0(3);
        }
        return simpleMethodSignature;
    }

    @Nullable
    public static SimpleMethodSignature get(@Nullable String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(text = text.replace(" ", ""));
        if (matcher.matches()) {
            String types = matcher.group(3);
            return new SimpleMethodSignature(matcher.group(1), (List<String>)(types == null ? Collections.emptyList() : new SmartList((Object[])types.split(","))));
        }
        return null;
    }

    @NotNull
    public String getMethodName() {
        String string = this.methodName;
        if (string == null) {
            SimpleMethodSignature.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<String> getErasedParameterTypes() {
        List<String> list = this.erasedParameterTypes;
        if (list == null) {
            SimpleMethodSignature.$$$reportNull$$$0(5);
        }
        return list;
    }

    public String toString(boolean presentation) {
        StringBuilder result = new StringBuilder();
        result.append(this.methodName);
        if (!this.erasedParameterTypes.isEmpty()) {
            result.append("(");
            result.append(StringUtil.join(this.erasedParameterTypes, (String)(presentation ? ", " : ",")));
            result.append(")");
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "erasedParameterTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/util/SimpleMethodSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/util/SimpleMethodSignature";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErasedParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

