/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.editorActions.VtlCommenter;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlDirectiveImpl;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VtlAssignment
extends VtlDirectiveImpl {
    protected VtlAssignment(ASTNode node, @NotNull String presentableName, boolean needsClosing) {
        if (presentableName == null) {
            VtlAssignment.$$$reportNull$$$0(0);
        }
        super(node, presentableName, needsClosing);
    }

    @Nullable
    public VtlReferenceExpression getAssignedVariableElement(@Nullable FixedNameVariable scope) {
        VtlReferenceExpression expression = (VtlReferenceExpression)this.findChildByType(VtlCompositeElementTypes.REFERENCE_EXPRESSION);
        if (expression == null) {
            return null;
        }
        VtlReferenceExpression qualifier = (VtlReferenceExpression)expression.getQualifier();
        if (qualifier != null && scope != null && scope.equals(qualifier.resolve()) || qualifier == null && scope == null) {
            return expression;
        }
        return null;
    }

    @Nullable
    public PsiElement getAssignedMethodCallExpression() {
        return this.findChildByType(VtlElementTypes.METHOD_CALL_EXPRESSION);
    }

    @Nullable
    public abstract PsiType getAssignedVariableElementType(@Nullable FixedNameVariable var1);

    @Override
    @NotNull
    public String getPresentableName() {
        String dirName = super.getPresentableName();
        PsiElement nameElement = this.findChildByType(VtlElementTypes.REFERENCE_EXPRESSION);
        String string = nameElement == null ? dirName : dirName + " '" + nameElement.getText() + "'";
        if (string == null) {
            VtlAssignment.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public VtlVariable getAssignedVariable(@Nullable FixedNameVariable scope) {
        VtlReferenceExpression varElement = this.getAssignedVariableElement(scope);
        if (varElement == null) {
            return null;
        }
        String name = varElement.getReferenceName();
        if (name == null || this.getContainingFile().findImplicitVariable(name, null) != null) {
            return null;
        }
        return new AssignedVariable(this, scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/directives/VtlAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/directives/VtlAssignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AssignedVariable
    extends RenameableFakePsiElement
    implements VtlVariable {
        private VtlAssignment myVtlAssignment;
        private final FixedNameVariable myScope;

        private AssignedVariable(VtlAssignment vtlAssignment, FixedNameVariable scope) {
            super((PsiElement)vtlAssignment.getContainingFile());
            this.myVtlAssignment = vtlAssignment;
            this.myScope = scope;
        }

        @NotNull
        public String getName() {
            VtlReferenceExpression expression = this.myVtlAssignment.getAssignedVariableElement(this.myScope);
            assert (expression != null);
            String string = expression.getReferenceName();
            if (string == null) {
                AssignedVariable.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
            if (name == null) {
                AssignedVariable.$$$reportNull$$$0(1);
            }
            VtlReferenceExpression nameElement = this.myVtlAssignment.getAssignedVariableElement(this.myScope);
            assert (nameElement != null);
            nameElement.handleElementRename(name);
            return this;
        }

        @Nullable
        public PsiElement getNavigationElement() {
            VtlReferenceExpression expression = this.myVtlAssignment.getAssignedVariableElement(this.myScope);
            assert (expression != null);
            return expression.getReferenceNameElement();
        }

        public PsiElement getParent() {
            return this.myVtlAssignment.getAssignedVariableElement(this.myScope);
        }

        public String getTypeName() {
            return VelocityBundle.message("type.name.variable", new Object[0]);
        }

        public Icon getIcon() {
            return PlatformIcons.VARIABLE_ICON;
        }

        @Override
        public PsiType getPsiType() {
            return this.myVtlAssignment.getAssignedVariableElementType(this.myScope);
        }

        @Override
        @Nullable
        public PsiComment getDocComment() {
            return VtlCommenter.findDocComment(this.myVtlAssignment);
        }

        public boolean isEquivalentTo(PsiElement another) {
            if (!this.getClass().isInstance(another)) {
                return false;
            }
            AssignedVariable other = (AssignedVariable)another;
            return this.getName().equals(other.getName()) && this.getContainingFile().equals(other.getContainingFile());
        }

        public String toString() {
            return "AssignedVariable " + this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AssignedVariable)) {
                return false;
            }
            AssignedVariable that = (AssignedVariable)o;
            return this.myVtlAssignment.equals(that.myVtlAssignment);
        }

        public int hashCode() {
            return this.myVtlAssignment.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/velocity/psi/directives/VtlAssignment$AssignedVariable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/velocity/psi/directives/VtlAssignment$AssignedVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

