/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.BaseBeanValidationInspection;
import com.intellij.beanValidation.highlighting.fixes.CreateConstraintValidatorFix;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConstraintValidatorCreator
extends BaseBeanValidationInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiModifierList modifierList;
        if (aClass == null) {
            ConstraintValidatorCreator.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ConstraintValidatorCreator.$$$reportNull$$$0(1);
        }
        if ((modifierList = aClass.getModifierList()) == null) {
            return null;
        }
        PsiAnnotation anno = modifierList.findAnnotation("javax.validation.Constraint");
        if (anno == null) {
            return null;
        }
        PsiAnnotationMemberValue value = anno.findAttributeValue("validatedBy");
        if (value instanceof PsiClassObjectAccessExpression) {
            value = ((PsiClassObjectAccessExpression)value).getOperand().getFirstChild();
        }
        if (value instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)value).resolve() == null) {
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)value, BVInspectionBundle.message("constraint.validator.does.not.exist", new Object[0]), (LocalQuickFix)new CreateConstraintValidatorFix((PsiJavaCodeReferenceElement)value, aClass), ProblemHighlightType.ERROR, isOnTheFly)};
        }
        return super.checkClass(aClass, manager, isOnTheFly);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BVBundle.message("constraint.validator.creator", new Object[0]);
        if (string == null) {
            ConstraintValidatorCreator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/highlighting/ConstraintValidatorCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/highlighting/ConstraintValidatorCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

