/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.BaseBeanValidationInspection;
import com.intellij.beanValidation.highlighting.fixes.SwapMinMax;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinMaxValuesInspection
extends BaseBeanValidationInspection {
    private static final PsiConstantEvaluationHelper HELPER = new PsiConstantEvaluationHelperImpl();

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BVInspectionBundle.message("min.max.inspection", new Object[0]);
        if (string == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public ProblemDescriptor[] checkAnnotation(@NotNull PsiAnnotation anno, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(2);
        }
        if (MinMaxValuesInspection.isMinMaxAnnotation(anno)) {
            PsiAnnotationMemberValue maxValue = anno.findAttributeValue("max");
            PsiAnnotationMemberValue minValue = anno.findAttributeValue("min");
            if (maxValue == null || minValue == null) {
                return null;
            }
            PsiElement maxElement = maxValue.getOriginalElement();
            PsiElement minElement = minValue.getOriginalElement();
            if (maxElement instanceof PsiExpression && minElement instanceof PsiExpression) {
                Integer max = MinMaxValuesInspection.getIntOrNull(HELPER.computeConstantExpression(maxElement));
                Integer min = MinMaxValuesInspection.getIntOrNull(HELPER.computeConstantExpression(minElement));
                if (max == null && min == null) {
                    return null;
                }
                ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
                if (min != null && min < 0 && MinMaxValuesInspection.isLengthAnnotation(anno)) {
                    problems.add(manager.createProblemDescriptor(minElement, BVInspectionBundle.message("min.value.is.negative", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                if (max != null && min != null && min > max) {
                    problems.add(manager.createProblemDescriptor(maxElement, BVInspectionBundle.message("max.value.is.less.than.min", new Object[0]), (LocalQuickFix)new SwapMinMax(minElement, maxElement), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                }
                return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
            }
        }
        return null;
    }

    @Nullable
    public static Integer getIntOrNull(@Nullable Object obj) {
        String value;
        String string = value = obj == null ? null : obj.toString();
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isMinMaxAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(3);
        }
        return MinMaxValuesInspection.isLengthAnnotation(anno) || MinMaxValuesInspection.isSizeAnnotation(anno);
    }

    public static boolean isLengthAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(4);
        }
        return "org.hibernate.validator.constraints.Length".equals(anno.getQualifiedName());
    }

    public static boolean isSizeAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(5);
        }
        return "javax.validation.constraints.Size".equals(anno.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/highlighting/MinMaxValuesInspection";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/highlighting/MinMaxValuesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMinMaxAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLengthAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSizeAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

