/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.quirksmode.Browser;
import com.jetbrains.quirksmode.BrowserFamily;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BrowserSet {
    public static final BrowserSet IE = new BrowserSet(BrowserFamily.IE);
    public static final BrowserSet IE_50 = new BrowserSet(Browser.IE_50_WINDOWS);
    public static final BrowserSet IE_55 = new BrowserSet(Browser.IE_55_WINDOWS);
    public static final BrowserSet IE_55_AND_60 = new BrowserSet(Browser.IE_55_WINDOWS).and(Browser.IE_6_WINDOWS);
    public static final BrowserSet IE_LESS_THAN_7 = new BrowserSet(Browser.IE_50_WINDOWS).and(Browser.IE_55_WINDOWS).and(Browser.IE_6_WINDOWS);
    public static final BrowserSet MOZILLA = new BrowserSet(BrowserFamily.MOZILLA);
    public static final BrowserSet SAFARI = new BrowserSet(BrowserFamily.SAFARI);
    private final Set<BrowserFamily> myBrowserFamilies;
    private final Set<Browser> myBrowsers;
    public static final BrowserSet ALL = new BrowserSet(new Browser[0]){

        @Override
        public boolean contains(Browser browser) {
            return true;
        }
    };

    public BrowserSet(Browser ... browsers) {
        this.myBrowserFamilies = new HashSet<BrowserFamily>();
        this.myBrowsers = new HashSet<Browser>();
        ContainerUtil.addAll(this.myBrowsers, (Object[])browsers);
    }

    public BrowserSet(@NotNull BrowserFamily family) {
        if (family == null) {
            BrowserSet.$$$reportNull$$$0(0);
        }
        this.myBrowserFamilies = new HashSet<BrowserFamily>();
        this.myBrowsers = new HashSet<Browser>();
        this.myBrowserFamilies.add(family);
    }

    public BrowserSet(@NotNull Set<BrowserFamily> browserFamilies, @NotNull Set<Browser> browsers) {
        if (browserFamilies == null) {
            BrowserSet.$$$reportNull$$$0(1);
        }
        if (browsers == null) {
            BrowserSet.$$$reportNull$$$0(2);
        }
        this.myBrowserFamilies = new HashSet<BrowserFamily>();
        this.myBrowsers = new HashSet<Browser>();
        this.myBrowserFamilies.addAll(browserFamilies);
        this.myBrowsers.addAll(browsers);
    }

    public BrowserSet and(@NotNull Browser browser) {
        if (browser == null) {
            BrowserSet.$$$reportNull$$$0(3);
        }
        BrowserSet copy = this.copy();
        copy.add(browser);
        return copy;
    }

    public BrowserSet and(@NotNull BrowserSet browserSet) {
        if (browserSet == null) {
            BrowserSet.$$$reportNull$$$0(4);
        }
        BrowserSet copy = this.copy();
        for (Browser browser : browserSet.myBrowsers) {
            copy.add(browser);
        }
        for (BrowserFamily family : browserSet.myBrowserFamilies) {
            copy.add(family);
        }
        return copy;
    }

    public BrowserSet and(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            BrowserSet.$$$reportNull$$$0(5);
        }
        BrowserSet copy = this.copy();
        copy.add(browserFamily);
        return copy;
    }

    private void add(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            BrowserSet.$$$reportNull$$$0(6);
        }
        this.myBrowserFamilies.add(browserFamily);
    }

    private void add(@NotNull Browser browser) {
        if (browser == null) {
            BrowserSet.$$$reportNull$$$0(7);
        }
        if (!this.myBrowserFamilies.contains((Object)browser.getFamily())) {
            this.myBrowsers.add(browser);
        }
    }

    private BrowserSet copy() {
        return new BrowserSet(this.myBrowserFamilies, this.myBrowsers);
    }

    public boolean contains(Browser browser) {
        return this.myBrowserFamilies.contains((Object)browser.getFamily()) || this.myBrowsers.contains(browser);
    }

    public String toString() {
        String result = "";
        for (BrowserFamily family : this.myBrowserFamilies) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + family.getName();
        }
        for (Browser browser : this.myBrowsers) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + browser.getName();
        }
        return result;
    }

    public boolean intersects(@NotNull BrowserSet browserSet) {
        if (browserSet == null) {
            BrowserSet.$$$reportNull$$$0(8);
        }
        for (Browser browser : this.myBrowsers) {
            if (!browserSet.contains(browser)) continue;
            return true;
        }
        for (BrowserFamily family : this.myBrowserFamilies) {
            if (!browserSet.contains(family)) continue;
            return true;
        }
        for (Browser browser : browserSet.myBrowsers) {
            if (!this.contains(browser)) continue;
            return true;
        }
        for (BrowserFamily family : browserSet.myBrowserFamilies) {
            if (!this.contains(family)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            BrowserSet.$$$reportNull$$$0(9);
        }
        return this.myBrowserFamilies.contains((Object)browserFamily);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserFamilies";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browsers";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserSet";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserFamily";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/quirksmode/BrowserSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "and";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "intersects";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

