/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SharedProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.quirksmode.PsiRecursiveVisitor2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssHtmlPatternUtil {
    public static final Key<CssDeclaration[]> COMPUTED_STYLES_KEY = new Key("COMPUTED_STYLES_KEY");
    public static final Key<List<XmlTag>> APPLIED_TAGS_KEY = new Key("APPLIED_TAGS_KEY");

    private CssHtmlPatternUtil() {
    }

    @Nullable
    public static String getStyle(@NotNull PsiElement element, @NotNull @NonNls String propertyName, @NotNull SharedProcessingContext context) {
        CssDeclaration[] declarations;
        if (element == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(2);
        }
        if ((declarations = CssHtmlPatternUtil.getStyles(element, context)) == null) {
            return null;
        }
        for (CssDeclaration decl : declarations) {
            if (!propertyName.equals(CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)decl))) continue;
            return CssPsiUtil.getTokenText((PsiElement)decl.getValue());
        }
        return null;
    }

    @Nullable
    public static CssDeclaration[] getStyles(@NotNull PsiElement element, @NotNull SharedProcessingContext context) {
        if (element == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(3);
        }
        if (context == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(4);
        }
        return (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)element);
    }

    @Nullable
    public static XmlTag[] getAppliedTags(@NotNull CssDeclaration declaration, @NotNull SharedProcessingContext context) {
        List list;
        if (declaration == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(6);
        }
        return (list = (List)context.get(APPLIED_TAGS_KEY, (Object)declaration)) == null ? null : list.toArray(XmlTag.EMPTY);
    }

    public static void buildCaches(@NotNull PsiElement element, final @NotNull SharedProcessingContext context) {
        if (element == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(8);
        }
        new PsiRecursiveVisitor2(){

            public void visitElement(final PsiElement element) {
                new ReadAction(){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        CssHtmlPatternUtil.cacheStyles(element, context);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/quirksmode/CssHtmlPatternUtil$1$1", "run"));
                    }
                }.execute();
                CssDeclaration[] declarations = (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)element);
                if (declarations != null) {
                    for (CssDeclaration decl : declarations) {
                        ArrayList<XmlTag> appliedTags = (ArrayList<XmlTag>)context.get(APPLIED_TAGS_KEY, (Object)decl);
                        if (appliedTags == null) {
                            appliedTags = new ArrayList<XmlTag>();
                            context.put(APPLIED_TAGS_KEY, (Object)decl, appliedTags);
                        }
                        appliedTags.add((XmlTag)element);
                    }
                }
                super.visitElement(element);
            }
        }.accept(element);
    }

    public static void cacheStyles(@Nullable PsiElement element, @NotNull SharedProcessingContext context) {
        CssDeclaration[] computedStyles;
        if (context == null) {
            CssHtmlPatternUtil.$$$reportNull$$$0(9);
        }
        if ((computedStyles = (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)element)) != null) {
            return;
        }
        if (!(element instanceof XmlTag)) {
            return;
        }
        ArrayList<CssDeclaration> decls = new ArrayList<CssDeclaration>();
        Object[] styles = CssResolveManager.getInstance().resolve((XmlTag)element);
        if (styles != null && styles.length != 0) {
            CssDeclaration[] parentDecls;
            ContainerUtil.addAll(decls, (Object[])styles);
            PsiElement parent = element.getParent();
            if (parent != null && (parentDecls = (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)parent)) != null) {
                for (CssDeclaration parentDecl : parentDecls) {
                    boolean inherited = true;
                    Collection descriptors = parentDecl.getDescriptors();
                    for (CssPropertyDescriptor descriptor : descriptors) {
                        if (descriptor.isInherited()) continue;
                        inherited = false;
                        break;
                    }
                    if (descriptors.isEmpty() || !inherited) continue;
                    decls.add(parentDecl);
                }
            }
        }
        context.put(COMPUTED_STYLES_KEY, (Object)element, (Object)decls.toArray(CssDeclaration.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/quirksmode/CssHtmlPatternUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStyle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStyles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAppliedTags";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "buildCaches";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheStyles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

