/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.quirksmode.Browser;
import com.jetbrains.quirksmode.BrowserFamily;
import com.jetbrains.quirksmode.BrowserSet;
import com.jetbrains.quirksmode.CssPatterns;
import com.jetbrains.quirksmode.HtmlPatterns;
import com.jetbrains.quirksmode.HtmlTagPattern;
import com.jetbrains.quirksmode.ProblemDetectorImpl;
import com.jetbrains.quirksmode.QuirksModeInspectionTool;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QuirksModeRegistrar {
    static Set<String> ourDetectorIds = new HashSet<String>();

    private QuirksModeRegistrar() {
    }

    public static void register() {
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.001", (ElementPattern)HtmlPatterns.htmlTag("li").withFirstSubTag((ElementPattern)HtmlPatterns.htmlTag("blockquote").withStyle("position", "relative")), "If a blockquote inside a list is positioned relatively, the list marker appears lower down, or not at all", "http://www.quirksmode.org/bugreports/archives/2006/06/Blockquote_List_Bug.html", BrowserFamily.OPERA));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.002", (ElementPattern)HtmlPatterns.htmlTag().isBlock().withStyle("position", "absolute").inside((ElementPattern)HtmlPatterns.htmlTag().isBlock().withStyle("position", "fixed")), "In Opera 8.5, putting an absolutely positioned element inside a fixed positioned element results in the absolute positioned block disappearing completely", "http://www.quirksmode.org/bugreports/archives/2006/05/FixedAbsolute_Positioning_invisible.html", Browser.OPERA_85));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.003", (ElementPattern)HtmlPatterns.htmlTag("span").withStyle("background-color").withStyle("text-align", "justify"), "When using a background-color on a span of inline text, while in text-align: justify, Opera 8 draws the background color before the word wrap. This leaves background colors behind when the foreground text is word-wrapped to the next line.", "http://www.quirksmode.org/bugreports/archives/2006/07/Inline_background_color_quirk_in_justified_text.html", Browser.OPERA_85));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.004", (ElementPattern)HtmlPatterns.htmlTag("form").withStyle("display", "table-cell"), "Hang up on form style=\"display:table-cell\"", "http://www.quirksmode.org/bugreports/archives/2006/07/Hangs_up_on_form_element_with_displaytable_cell.html", BrowserFamily.SAFARI));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.005", (ElementPattern)HtmlPatterns.htmlTag().withStyle("position", "relative").inside((ElementPattern)HtmlPatterns.htmlTag().withStyle("overflow", "hidden").inside((ElementPattern)HtmlPatterns.htmlTag().withStyle("position", "fixed"))), "Fixed > Overflow > Relative objects get hidden when scrolling", "http://www.quirksmode.org/bugreports/archives/2006/07/Fixed__Overflow__Relative_objects_get_hidden_when_.html", BrowserFamily.SAFARI));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.006", (ElementPattern)HtmlPatterns.htmlTag().withStyle("visibility", "hidden").withStyle("overflow", "auto", "visible"), "Scrollbars are not hidden when a div is hidden and overflow is set to auto or visible", "http://www.quirksmode.org/bugreports/archives/2006/06/Scrollbars_are_not_hidden_when_a_div_is_hidden_and.html", BrowserFamily.MOZILLA));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.007", (ElementPattern)((HtmlTagPattern)HtmlPatterns.htmlTag("input").withAttributeValue("type", "submit")).withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName("height").withAppliedTags((ElementPattern)StandardPatterns.collection(XmlTag.class).atLeastOne((ElementPattern)HtmlPatterns.htmlTag("input").withoutAttributeValue("type", "submit"))))), "Any button uses the traditional box model instead of W3C's, regardless of rendering mode", "http://www.quirksmode.org/bugreports/archives/2004/10/box_model_of_fo.html", BrowserSet.MOZILLA.and(BrowserSet.IE)));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.008", (ElementPattern)((HtmlTagPattern)HtmlPatterns.htmlTag().withoutStyle("display", "inline").isFirstSubtag((ElementPattern)HtmlPatterns.htmlTag().withStyle("display", "block"))).and(StandardPatterns.or((ElementPattern[])new ElementPattern[]{HtmlPatterns.htmlTag().withStyle("float", "left").withStyle("margin-left"), HtmlPatterns.htmlTag().withStyle("float", "right").withStyle("margin-right")})), "Float margin is doubled", "http://www.positioniseverything.net/explorer/doubled-margin.html", BrowserSet.IE));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.009", (ElementPattern)((HtmlTagPattern)HtmlPatterns.htmlTag().withName(StandardPatterns.or((ElementPattern[])new ElementPattern[]{StandardPatterns.string().oneOf(new String[]{"ul", "ol"})}))).withStyle("width"), "When you apply a width to an ol or ul, Explorer Windows secretly applies more rules.", "http://www.quirksmode.org/bugreports/archives/2004/11/width_on_olul.html", BrowserFamily.IE));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.010", (ElementPattern)HtmlPatterns.htmlTag().withStyle("position", "absolute").withStyle("left").inside((ElementPattern)HtmlPatterns.htmlTag().withStyle("position", "relative")), "When placing an absolutely positioned element in a relatively positioned one, Explorer 5.0 Windows may calculate the left relative to the browser window instead of to the relatively positioned element.", "http://www.quirksmode.org/bugreports/archives/2005/01/ie_50_position.html", Browser.IE_50_WINDOWS));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("1.011", (ElementPattern)HtmlPatterns.htmlTag().withStyle("display", "block").and(StandardPatterns.or((ElementPattern[])new ElementPattern[]{HtmlPatterns.htmlTag().withNonZeroStyle("margin-top").isFirstSubtag((ElementPattern)HtmlPatterns.htmlTag().withStyle("display", "block").withNonZeroStyle("padding-top"))})), "For nested boxes IE doesn't add the outer top box padding and the inner top box margin, as all other browsers do.", "http://www.quirksmode.org/bugreports/archives/2005/01/IE_nested_boxes_padding_topmargin_top.html", BrowserFamily.IE));
        QuirksModeRegistrar.addCssDetectors();
        QuirksModeRegistrar.addModesDetectors();
    }

    private static void addCssDetectors() {
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.001", (ElementPattern)CssPatterns.cssSelector().withGreaterSuffix(), "http://www.quirksmode.org/css/contents.html", Pair.create((Object)BrowserSet.IE_50, (Object)"Explorer 5.0 Windows sees the part after the > as the selector"), Pair.create((Object)BrowserSet.IE_55_AND_60, (Object)"The > selector is not supported")));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.002", (ElementPattern)CssPatterns.cssSelector().withPlusSuffix(), "http://www.quirksmode.org/css/contents.html", new Pair((Object)BrowserSet.IE_50, (Object)"Explorer 5.0 Windows sees the part after the + as the selector"), new Pair((Object)BrowserSet.IE_55_AND_60, (Object)"The + selector is not supported"), new Pair((Object)BrowserSet.MOZILLA.and(BrowserSet.SAFARI), (Object)"Firefox and Safari don't correctly update styles after elements have been added dynamically.")));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.003", (ElementPattern)CssPatterns.cssSelector().withTildeSuffix(), "http://www.quirksmode.org/css/contents.html", new Pair((Object)BrowserSet.IE_50, (Object)"Explorer 5.0 Windows sees the part after the ~ as the selector"), new Pair((Object)BrowserSet.IE_55_AND_60.and(BrowserSet.SAFARI), (Object)"The ~ selector is not supported")));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.004", (ElementPattern)CssPatterns.cssSelector().withAttribute(), "http://www.quirksmode.org/css/contents.html", new Pair((Object)BrowserSet.IE_LESS_THAN_7, (Object)"The [] selector is not supported")));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.005", (ElementPattern)CssPatterns.cssSelector().withClassDefinitions((ElementPattern<Collection<CssClass>>)StandardPatterns.collection(CssClass.class).atLeast(2)), "http://www.quirksmode.org/bugreports/archives/2004/12/IE_CSS_rendering_bug_with_multiple_classnames.html", new Pair((Object)BrowserSet.IE_LESS_THAN_7.and(Browser.IE_MAC), (Object)"When using multiple class names for an element, Explorer will ignore all but the last of class names")));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.006", (ElementPattern)CssPatterns.cssSelector().withPseudoElement("before", "after"), "http://www.quirksmode.org/css/contents.html", new Pair((Object)BrowserSet.IE, (Object)":before and :after selectors are not supported")));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.007", (ElementPattern)CssPatterns.cssSelector().withPseudoClass("focus"), "http://www.quirksmode.org/css/contents.html", new Pair((Object)BrowserSet.IE, (Object)"Focus pseudo class is not supported")));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("3.008", (ElementPattern)CssPatterns.cssSelector().isUniversalSelector().withCssDeclaration("visibility", "hidden"), "http://www.quirksmode.org/bugreports/archives/2004/11/when_you_define.html", new Pair((Object)BrowserSet.IE.and(Browser.SAFARI), (Object)"When you define visibility: hidden on * Explorer Windows and Safari don't show anything ever again.")));
    }

    private static void addModesDetectors() {
        QuirksModeRegistrar.add(new ProblemDetectorImpl("2.001", (ElementPattern)HtmlPatterns.htmlTag().isBlock().inQuirksMode().withAtLeastOneStyle("width", "height").withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne(StandardPatterns.or((ElementPattern[])new ElementPattern[]{CssPatterns.cssDeclaration().withPropertyName("padding", "border"), CssPatterns.cssDeclaration().withPropertyName("margin", "margin-left", "margin-right").withoutText((ElementPattern)StandardPatterns.string().contains("auto"))}))), "Traditional box model is used in quirks mode", "http://www.quirksmode.org/css/box.html", BrowserFamily.IE));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("2.002", (ElementPattern)HtmlPatterns.htmlTag().withStyle("white-space", "pre").inQuirksMode(), "White-space:pre is not working in quirks mode", "http://www.quirksmode.org/css/whitespace.html", BrowserFamily.IE));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("2.003", (ElementPattern)HtmlPatterns.htmlTag().isInline().withStyle("width").inQuirksMode(), "Explorer tries to honour a width by giving the element display: inline-block, which does allow a width declaration in quirks mode", "http://www.quirksmode.org/css/quirksmode.html", BrowserFamily.IE));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("2.004", (ElementPattern)HtmlPatterns.htmlTag().withStyle("width").withStyle("margin", "auto").inQuirksMode(), "Margin:auto doesn't center element in quirks mode", "http://www.quirksmode.org/css/quirksmode.html", BrowserFamily.IE));
        QuirksModeRegistrar.add(new ProblemDetectorImpl("2.005", (ElementPattern)HtmlPatterns.htmlTag().inQuirksMode().withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().inside((ElementPattern)CssPatterns.cssRuleset().withSelectors((ElementPattern)StandardPatterns.collection(CssSelector.class).atLeastOne((ElementPattern)CssPatterns.cssSelector().withClassDefinition().withTagName("").withPseudoClass("hover")))))), "The .test:hover selector (without an element selector like p.test:hover) doesn't work", "http://www.quirksmode.org/css/quirksmode.html", BrowserSet.IE.and(BrowserSet.MOZILLA)));
    }

    private static void add(@NotNull ProblemDetectorImpl detector) {
        if (detector == null) {
            QuirksModeRegistrar.$$$reportNull$$$0(0);
        }
        assert (!ourDetectorIds.contains(detector.getId())) : "Duplicate id: " + detector.getId();
        QuirksModeInspectionTool.register(detector);
        ourDetectorIds.add(detector.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/jetbrains/quirksmode/QuirksModeRegistrar", "add"));
    }
}

