/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.SimpleEventRenderer;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleEventComponent<E extends Enum<E>>
extends AnimatedComponent {
    @NotNull
    private final EventModel<E> myModel;
    @NotNull
    private final Map<E, SimpleEventRenderer<E>> mRenderers;
    @NotNull
    private final ArrayList<EventRenderData<E>> mIconsToDraw;
    private boolean myRender;

    public SimpleEventComponent(@NotNull EventModel<E> model, @NotNull Map<E, SimpleEventRenderer<E>> renderers) {
        if (model == null) {
            SimpleEventComponent.$$$reportNull$$$0(0);
        }
        if (renderers == null) {
            SimpleEventComponent.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.mRenderers = renderers;
        this.mIconsToDraw = new ArrayList();
        this.myRender = true;
        this.myModel.addDependency(this.myAspectObserver).onChange(EventModel.Aspect.EVENT, this::modelChanged);
    }

    private void modelChanged() {
        this.myRender = true;
        this.opaqueRepaint();
    }

    protected void render() {
        double max = this.myModel.getRangedSeries().getXRange().getMax();
        this.mIconsToDraw.clear();
        List<SeriesData<EventAction<E>>> series = this.myModel.getRangedSeries().getSeries();
        int size = series.size();
        for (int i = 0; i < size; ++i) {
            SeriesData<EventAction<E>> seriesData = series.get(i);
            EventAction data = (EventAction)seriesData.value;
            long endTimeUs = data.getEndUs() == 0L ? (long)max : data.getEndUs();
            this.mIconsToDraw.add(new EventRenderData(data.getStartUs(), endTimeUs, data));
        }
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        if (this.myRender) {
            this.render();
            this.myRender = false;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double min = this.myModel.getRangedSeries().getXRange().getMin();
        double max = this.myModel.getRangedSeries().getXRange().getMax();
        double scaleFactor = dim.getWidth();
        for (int i = 0; i < this.mIconsToDraw.size(); ++i) {
            EventRenderData<E> data = this.mIconsToDraw.get(i);
            double normalizedPositionStart = ((double)data.getStartTimestamp() - min) / (max - min);
            double normalizedPositionEnd = ((double)data.getEndTimestamp() - min) / (max - min);
            AffineTransform translate = AffineTransform.getTranslateInstance(normalizedPositionStart * scaleFactor, 0.0);
            EventAction<E> action = data.getAction();
            SimpleEventRenderer<E> renderer = this.mRenderers.get(action.getType());
            renderer.draw(this, g2d, translate, (normalizedPositionEnd - normalizedPositionStart) * scaleFactor, action);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "renderers";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/SimpleEventComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EventRenderData<E> {
        private final long mStartTimestamp;
        private final long mEndTimestamp;
        private final EventAction<E> mAction;

        public EventAction<E> getAction() {
            return this.mAction;
        }

        public long getStartTimestamp() {
            return this.mStartTimestamp;
        }

        public long getEndTimestamp() {
            return this.mEndTimestamp;
        }

        public EventRenderData(long startTimestamp, long endTimestamp, EventAction<E> action) {
            this.mStartTimestamp = startTimestamp;
            this.mEndTimestamp = endTimestamp;
            this.mAction = action;
        }
    }
}

