/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LineChartModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final List<RangedContinuousSeries> mySeries = new ArrayList<RangedContinuousSeries>();
    private boolean myFirstUpdate = true;

    @Override
    public void update(long elapsedNs) {
        Range range;
        HashMap<Range, Double> max = new HashMap<Range, Double>();
        for (RangedContinuousSeries rangedContinuousSeries : this.mySeries) {
            range = rangedContinuousSeries.getYRange();
            double yMax = Double.MIN_VALUE;
            List seriesList = rangedContinuousSeries.getSeries();
            for (int i = 0; i < seriesList.size(); ++i) {
                double value = ((Long)seriesList.get((int)i).value).longValue();
                if (!(yMax < value)) continue;
                yMax = value;
            }
            Double m = (Double)max.get(range);
            max.put(range, m == null ? yMax : Math.max(yMax, m));
        }
        for (Map.Entry entry : max.entrySet()) {
            range = (Range)entry.getKey();
            if (!(range.getMax() < (Double)entry.getValue())) continue;
            float fraction = this.myFirstUpdate ? 1.0f : 0.99f;
            range.setMax(Updater.lerp(range.getMax(), (Double)entry.getValue(), fraction, elapsedNs, (double)((float)((Double)entry.getValue() * (double)0.001f))));
        }
        this.myFirstUpdate = false;
        this.changed(Aspect.LINE_CHART);
    }

    public void addAll(List<RangedContinuousSeries> series) {
        series.forEach(this::add);
    }

    public void add(RangedContinuousSeries series) {
        this.mySeries.add(series);
    }

    public void remove(RangedContinuousSeries series) {
        this.mySeries.remove(series);
    }

    @NotNull
    public List<RangedContinuousSeries> getSeries() {
        List<RangedContinuousSeries> list = this.mySeries;
        if (list == null) {
            LineChartModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/LineChartModel", "getSeries"));
    }

    public static enum Aspect {
        LINE_CHART;

    }
}

