/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.style.JavaStylePropertiesInvocationFixer;
import org.jetbrains.plugins.groovy.codeInspection.utils.JavaStylePropertiesUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class JavaStylePropertiesInvocationInspection
extends BaseInspection {
    private static final LocalQuickFix[] myFixes = new LocalQuickFix[]{new JavaStylePropertiesInvocationFixer()};

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                if (methodCallExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(methodCallExpression);
                this.visitMethodCall(methodCallExpression);
            }

            @Override
            public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                if (applicationStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitApplicationStatement(applicationStatement);
                this.visitMethodCall(applicationStatement);
            }

            private void visitMethodCall(GrMethodCall methodCall) {
                if (JavaStylePropertiesUtil.isPropertyAccessor(methodCall)) {
                    String message = GroovyInspectionBundle.message("java.style.property.access", new Object[0]);
                    GrExpression expression = methodCall.getInvokedExpression();
                    if (expression instanceof GrReferenceExpression) {
                        PsiElement referenceNameElement = ((GrReferenceExpression)expression).getReferenceNameElement();
                        this.registerError(referenceNameElement, message, myFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "applicationStatement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitApplicationStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (baseInspectionVisitor == null) {
            JavaStylePropertiesInvocationInspection.$$$reportNull$$$0(0);
        }
        return baseInspectionVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationInspection", "buildVisitor"));
    }
}

