/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.StubHierarchyInheritorSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public class GroovyDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @NotNull
    private static List<PsiClass> getDerivingClassCandidates(PsiClass clazz, GlobalSearchScope scope, boolean includeAnonymous) {
        String name = clazz.getName();
        if (name == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                GroovyDirectInheritorsSearcher.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<PsiClass> inheritors = new ArrayList<PsiClass>();
        for (GrReferenceList list : StubIndex.getElements(GrDirectInheritorsIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, GrReferenceList.class)) {
            PsiElement parent = list.getParent();
            if (!(parent instanceof GrTypeDefinition)) continue;
            inheritors.add((PsiClass)parent);
        }
        if (includeAnonymous) {
            Collection classes2 = StubIndex.getElements(GrAnonymousClassIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, GrAnonymousClassDefinition.class);
            for (GrAnonymousClassDefinition aClass : classes2) {
                inheritors.add(aClass);
            }
        }
        ArrayList<PsiClass> arrayList = inheritors;
        if (arrayList == null) {
            GroovyDirectInheritorsSearcher.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters queryParameters, @NotNull Processor<PsiClass> consumer) {
        if (queryParameters == null) {
            GroovyDirectInheritorsSearcher.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            GroovyDirectInheritorsSearcher.$$$reportNull$$$0(3);
        }
        PsiClass clazz = queryParameters.getClassToProcess();
        SearchScope scope = queryParameters.getScope();
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)clazz);
        GlobalSearchScope globalSearchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)scope, (Project)project);
        List candidates = (List)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            if (queryParameters == null) {
                GroovyDirectInheritorsSearcher.$$$reportNull$$$0(4);
            }
            if (!clazz.isValid()) {
                return Collections.emptyList();
            }
            GlobalSearchScope restrictedScope = StubHierarchyInheritorSearcher.restrictScope((GlobalSearchScope)globalSearchScope);
            return GroovyDirectInheritorsSearcher.getDerivingClassCandidates(clazz, restrictedScope, queryParameters.includeAnonymous());
        });
        for (PsiClass candidate : candidates) {
            if (queryParameters.isCheckInheritance() && !GroovyDirectInheritorsSearcher.isInheritor(clazz, candidate, project) || consumer.process((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInheritor(PsiClass clazz, PsiClass candidate, Project project) {
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> candidate.isValid() && candidate.isInheritor(clazz, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivingClassCandidates";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

