/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007JJ\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J\u001f\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0018H\u0007\u00a2\u0006\u0002\u0010*JF\u0010+\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00180/2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u001a\u0012\u0004\u0012\u00020\u00180/J\u001c\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00104\u001a\u00020#H\u0007J\u001a\u00105\u001a\u0004\u0018\u00010#2\u0006\u00106\u001a\u0002072\u0006\u0010$\u001a\u00020%H\u0007J \u00108\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0018H\u0007J\u001a\u0010<\u001a\u00020\u00182\b\u0010=\u001a\u0004\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020%H\u0007\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/common/CodegenUtil;", "", "()V", "constructFakeFunctionCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "project", "Lcom/intellij/openapi/project/Project;", "arity", "", "copyFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "inheritedMember", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "traitMember", "newOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "copyOverrides", "", "getActualDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDelegatePropertyIfAny", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getLineNumberForElement", "statement", "Lcom/intellij/psi/PsiElement;", "markEndOffset", "(Lcom/intellij/psi/PsiElement;Z)Ljava/lang/Integer;", "getMemberToGenerate", "name", "", "isReturnTypeOk", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "areParametersOk", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "getNonPrivateTraitMethods", "descriptor", "getSuperClassBySuperTypeListEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "isExhaustive", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "isStatement", "isFinalPropertyWithBackingField", "propertyDescriptor", "backend-common"})
public final class CodegenUtil {
    public static final CodegenUtil INSTANCE;

    @JvmStatic
    @Nullable
    public static final PropertyDescriptor getDelegatePropertyIfAny(@NotNull KtExpression expression2, @NotNull ClassDescriptor classDescriptor, @NotNull BindingContext bindingContext2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        KtExpression ktExpression = expression2;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        if ((object = (KtSimpleNameExpression)ktExpression) == null || (object = CallUtilKt.getResolvedCall((KtElement)object, bindingContext2)) == null) {
            return null;
        }
        Object call2 = object;
        Object d = call2.getResultingDescriptor();
        if (!(d instanceof ValueParameterDescriptor)) {
            d = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)d;
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor callResultingDescriptor = valueParameterDescriptor;
        if (callResultingDescriptor.getContainingDeclaration() instanceof ConstructorDescriptor && callResultingDescriptor.getContainingDeclaration().getContainingDeclaration() == classDescriptor) {
            return (PropertyDescriptor)bindingContext2.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, callResultingDescriptor);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isFinalPropertyWithBackingField(@Nullable PropertyDescriptor propertyDescriptor, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (propertyDescriptor == null) return false;
        if (propertyDescriptor.isVar()) return false;
        Boolean bl = (Boolean)bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        if (bl == null) return false;
        boolean bl2 = bl;
        if (!bl2) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final Map<FunctionDescriptor, FunctionDescriptor> getNonPrivateTraitMethods(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> result2 = new LinkedHashMap<FunctionDescriptor, FunctionDescriptor>();
        for (DeclarationDescriptor declaration2 : DescriptorUtils.getAllDescriptors(descriptor2.getDefaultType().getMemberScope())) {
            boolean bl;
            CallableMemberDescriptor traitMember;
            if (!(declaration2 instanceof CallableMemberDescriptor) || (traitMember = ImplKt.findInterfaceImplementation((CallableMemberDescriptor)declaration2)) == null || Visibilities.isPrivate(traitMember.getVisibility()) || Intrinsics.areEqual((Object)traitMember.getVisibility(), (Object)Visibilities.INVISIBLE_FAKE)) continue;
            boolean bl2 = bl = traitMember.getModality() != Modality.ABSTRACT;
            if (_Assertions.ENABLED && !bl) {
                String string = "Cannot delegate to abstract trait method: " + declaration2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declaration2;
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)declaration2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"declaration.containingDeclaration");
            Modality modality = traitMember.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality), (String)"traitMember.modality");
            Visibility visibility = Visibilities.PUBLIC;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PUBLIC");
            result2.putAll(INSTANCE.copyFunctions(callableMemberDescriptor, traitMember, declarationDescriptor, modality, visibility, CallableMemberDescriptor.Kind.DECLARATION, true));
        }
        return result2;
    }

    @NotNull
    public final Map<FunctionDescriptor, FunctionDescriptor> copyFunctions(@NotNull CallableMemberDescriptor inheritedMember, @NotNull CallableMemberDescriptor traitMember, @NotNull DeclarationDescriptor newOwner, @NotNull Modality modality, @NotNull Visibility visibility, @NotNull CallableMemberDescriptor.Kind kind2, boolean copyOverrides) {
        Intrinsics.checkParameterIsNotNull((Object)inheritedMember, (String)"inheritedMember");
        Intrinsics.checkParameterIsNotNull((Object)traitMember, (String)"traitMember");
        Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
        Intrinsics.checkParameterIsNotNull((Object)((Object)modality), (String)"modality");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind2), (String)"kind");
        CallableMemberDescriptor copy = inheritedMember.copy(newOwner, modality, visibility, kind2, copyOverrides);
        LinkedHashMap<PropertyAccessorDescriptor, PropertyAccessorDescriptor> result2 = new LinkedHashMap<PropertyAccessorDescriptor, PropertyAccessorDescriptor>();
        if (traitMember instanceof SimpleFunctionDescriptor) {
            Map map2 = result2;
            CallableMemberDescriptor callableMemberDescriptor = copy;
            if (callableMemberDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableMemberDescriptor;
            map2.put(traitMember, functionDescriptor2);
        } else if (traitMember instanceof PropertyDescriptor) {
            for (PropertyAccessorDescriptor traitAccessor : ((PropertyDescriptor)traitMember).getAccessors()) {
                CallableMemberDescriptor callableMemberDescriptor = copy;
                if (callableMemberDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                }
                for (PropertyAccessorDescriptor inheritedAccessor : ((PropertyDescriptor)callableMemberDescriptor).getAccessors()) {
                    if (!Intrinsics.areEqual(inheritedAccessor.getClass(), traitAccessor.getClass())) continue;
                    result2.put(traitAccessor, inheritedAccessor);
                }
            }
        }
        return result2;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getSuperClassBySuperTypeListEntry(@NotNull KtSuperTypeListEntry specifier, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)specifier, (String)"specifier");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        ReadOnlySlice readOnlySlice = BindingContext.TYPE;
        KtTypeReference ktTypeReference = specifier.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KotlinType kotlinType = (KotlinType)bindingContext2.get(readOnlySlice, ktTypeReference);
        if (kotlinType == null) {
            String string = "superType should not be null: " + specifier.getText();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinType superType = kotlinType;
        ClassifierDescriptor classifierDescriptor = superType.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @JvmStatic
    @Nullable
    public static final Integer getLineNumberForElement(@NotNull PsiElement statement2, boolean markEndOffset) {
        Integer n;
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)statement2, (String)"statement");
        PsiFile file2 = statement2.getContainingFile();
        if (file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null) {
            return null;
        }
        if (statement2 instanceof KtConstructorDelegationReferenceExpression && ((KtConstructorDelegationReferenceExpression)statement2).getTextLength() == 0) {
            return null;
        }
        PsiFile psiFile = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"file.viewProvider");
        Document document2 = document = fileViewProvider.getDocument();
        if (document2 != null) {
            int n2;
            if (markEndOffset) {
                TextRange textRange = statement2.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"statement.textRange");
                n2 = textRange.getEndOffset();
            } else {
                n2 = statement2.getTextOffset();
            }
            n = document2.getLineNumber(n2) + 1;
        } else {
            n = null;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final FunctionDescriptor getMemberToGenerate(@NotNull ClassDescriptor classDescriptor, @NotNull String name, @NotNull Function1<? super KotlinType, Boolean> isReturnTypeOk, @NotNull Function1<? super List<? extends ValueParameterDescriptor>, Boolean> areParametersOk) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(isReturnTypeOk, (String)"isReturnTypeOk");
            Intrinsics.checkParameterIsNotNull(areParametersOk, (String)"areParametersOk");
            v0 = classDescriptor.getUnsubstitutedMemberScope();
            v1 = Name.identifier(name);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"Name.identifier(name)");
            var5_5 = v0.getContributedFunctions(v1, NoLookupLocation.FROM_BACKEND);
            single$iv = null;
            found$iv = false;
            for (T element$iv : $receiver$iv) {
                function = (SimpleFunctionDescriptor)element$iv;
                var11_11 = function.getKind();
                kind = var11_11;
                if (!(Intrinsics.areEqual((Object)kind, (Object)CallableMemberDescriptor.Kind.SYNTHESIZED) != false || Intrinsics.areEqual((Object)kind, (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE) != false) || !(Intrinsics.areEqual((Object)function.getModality(), (Object)Modality.FINAL) ^ true)) ** GOTO lbl-1000
                v2 = function.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(v2, (String)"function.valueParameters");
                if (!((Boolean)areParametersOk.invoke(v2)).booleanValue() || function.getReturnType() == null) ** GOTO lbl-1000
                v3 = function.getReturnType();
                if (v3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"function.returnType!!");
                if (((Boolean)isReturnTypeOk.invoke((Object)v3)).booleanValue()) {
                    v4 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                if (found$iv) {
                    v5 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v5 = found$iv == false ? null : single$iv;
        }
        return v5;
    }

    @JvmStatic
    public static final boolean isExhaustive(@NotNull BindingContext bindingContext2, @NotNull KtWhenExpression whenExpression2, boolean isStatement) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)whenExpression2, (String)"whenExpression");
        WritableSlice<KtWhenExpression, Boolean> slice = isStatement && !BindingContextUtilsKt.isUsedAsExpression(whenExpression2, bindingContext2) ? BindingContext.IMPLICIT_EXHAUSTIVE_WHEN : BindingContext.EXHAUSTIVE_WHEN;
        return Intrinsics.areEqual((Object)((Boolean)bindingContext2.get(slice, whenExpression2)), (Object)true);
    }

    @JvmStatic
    @NotNull
    public static final KtCallExpression constructFakeFunctionCall(@NotNull Project project, int arity) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        int n = 1;
        Function1 function1 = constructFakeFunctionCall.fakeFunctionCall.1.INSTANCE;
        CharSequence charSequence = null;
        int n2 = 0;
        CharSequence charSequence2 = ")";
        CharSequence charSequence3 = ", ";
        CharSequence charSequence4 = "callableReferenceFakeCall(";
        String fakeFunctionCall2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(n, arity)), (CharSequence)charSequence3, (CharSequence)charSequence4, (CharSequence)charSequence2, (int)n2, charSequence, (Function1)function1, (int)24, null);
        KtExpression ktExpression = new KtPsiFactory(project, false).createExpression(fakeFunctionCall2);
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        return (KtCallExpression)ktExpression;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtDeclaration> getActualDeclarations(@NotNull KtFile file2) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Iterable iterable = $receiver$iv = (Iterable)file2.getDeclarations();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtDeclaration p1 = (KtDeclaration)element$iv$iv;
            if (PsiUtilsKt.hasExpectModifier(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    private CodegenUtil() {
    }

    static {
        CodegenUtil codegenUtil;
        INSTANCE = codegenUtil = new CodegenUtil();
    }
}

