/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeLabel;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionWithNext;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.InlinedLocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraverseInstructionResult;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010N\u001a\u00020O2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010P\u001a\u00020O2\u0006\u0010\u001a\u001a\u00020\u0017J\u000e\u0010Q\u001a\u00020O2\u0006\u0010R\u001a\u00020\u001eJ\u0010\u0010S\u001a\u00020O2\u0006\u0010R\u001a\u00020TH\u0002J\u000e\u0010U\u001a\u00020O2\u0006\u0010I\u001a\u00020(J\u0018\u0010V\u001a\u00020O2\u0006\u0010W\u001a\u00020\u00112\u0006\u0010X\u001a\u00020\u001eH\u0002J\u0016\u0010Y\u001a\u00020O2\u0006\u0010Z\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u0011J\u000e\u0010[\u001a\u00020O2\u0006\u0010\\\u001a\u00020*J\b\u0010]\u001a\u00020OH\u0002J\b\u0010^\u001a\u00020OH\u0002J\b\u0010_\u001a\u00020\u0000H\u0016J$\u0010`\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u001e2\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020*0bH\u0002J0\u0010d\u001a\b\u0012\u0004\u0012\u00020c0M2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020c0e2\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020*0bH\u0002J\u0018\u0010f\u001a\u00020*2\u0006\u0010g\u001a\u00020h2\b\u0010i\u001a\u0004\u0018\u00010hJ\u0014\u0010j\u001a\u0004\u0018\u00010\u00112\b\u0010Z\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010k\u001a\u00020\u001e2\u0006\u0010l\u001a\u00020cH\u0002J\f\u0010m\u001a\b\u0012\u0004\u0012\u00020*0\"J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010n\u001a\u00020\u0001H\u0002J\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020\u00110,2\u0006\u0010W\u001a\u00020\u0011H\u0002J\u0010\u0010p\u001a\u00020\u001e2\u0006\u0010q\u001a\u00020rH\u0002J\u0018\u0010s\u001a\b\u0012\u0004\u0012\u00020\u001e0M2\b\u0010W\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\b\u0010W\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010u\u001a\u0004\u0018\u00010C2\u0006\u0010Z\u001a\u00020\u0003H\u0016J\u0010\u0010v\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u001eH\u0016J\b\u0010w\u001a\u00020OH\u0002J\u0006\u0010x\u001a\u00020OJ,\u0010y\u001a\u00020r2\u0006\u0010z\u001a\u00020\u00002\b\u0010{\u001a\u0004\u0018\u00010c2\b\u0010|\u001a\u0004\u0018\u00010c2\u0006\u0010}\u001a\u00020rH\u0002J:\u0010~\u001a\u00020O2\u0006\u0010\u007f\u001a\u00020\u001e2\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020*0b2\u0014\u0010\u0080\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020c0\u0081\u0001H\u0002J \u0010\u0082\u0001\u001a\u00020r2\u0006\u0010{\u001a\u00020c2\u0006\u0010|\u001a\u00020c2\u0007\u0010\u0083\u0001\u001a\u00020rJ\u0011\u0010\u0084\u0001\u001a\u00020O2\u0006\u0010z\u001a\u00020\u0000H\u0002J\u0015\u0010\u0085\u0001\u001a\u00020O*\u00020\u001e2\u0006\u0010q\u001a\u00020rH\u0002R$\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R6\u00102\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110,03j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110,`4X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010 R(\u00107\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u001e0>j\b\u0012\u0004\u0012\u00020\u001e`?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001a\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020C03X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001e0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010$R\u0014\u0010F\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u00109R\u001e\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u001e0>j\b\u0012\u0004\u0012\u00020\u001e`?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010I\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR6\u0010L\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0M03j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0M`4X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "correspondingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isInlined", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Z)V", "<set-?>", "containsDoWhile", "getContainsDoWhile", "()Z", "setContainsDoWhile$frontend", "(Z)V", "getCorrespondingElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToValues", "Lcom/intellij/util/containers/BidirectionalMap;", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "enterInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "getEnterInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "errorInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "getErrorInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "exitInstruction", "getExitInstruction", "instructions", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getInstructions", "()Ljava/util/ArrayList;", "instructionsIncludingDeadCode", "", "getInstructionsIncludingDeadCode", "()Ljava/util/List;", "internalErrorInstruction", "internalExitInstruction", "internalSinkInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "labels", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeLabel;", "localDeclarations", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/LocalFunctionDeclarationInstruction;", "getLocalDeclarations", "()Ljava/util/Set;", "localDeclarations$delegate", "Lkotlin/Lazy;", "mergedValues", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "mutableInstructionList", "getMutableInstructionList$frontend", "parent", "getParent", "()Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "setParent", "(Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;)V", "postPrecessed", "reachableInstructions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getReachableInstructions", "()Ljava/util/HashSet;", "representativeInstructions", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/KtElementInstruction;", "reversedInstructions", "getReversedInstructions", "rootPseudocode", "getRootPseudocode", "sideEffectFree", "sinkInstruction", "getSinkInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "valueUsages", "", "addErrorInstruction", "", "addExitInstruction", "addInstruction", "instruction", "addMergedValues", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MergeInstruction;", "addSinkInstruction", "addValueUsage", "value", "usage", "bindElementToValue", "element", "bindLabel", "label", "collectAndCacheReachableInstructions", "collectReachableInstructions", "copy", "copyInstruction", "originalToCopy", "", "Lorg/jetbrains/kotlin/cfg/Label;", "copyLabels", "", "createLabel", "name", "", "comment", "getElementValue", "getJumpTarget", "targetLabel", "getLabels", "pseudocode", "getMergedValues", "getNextPosition", "currentPosition", "", "getUsages", "getValueElements", "instructionForElement", "isSideEffectFree", "markDeadInstructions", "postProcess", "repeatInternal", "originalPseudocode", "startLabel", "finishLabel", "labelCountArg", "repeatLabelsBindingForInstruction", "originalInstruction", "originalLabelsForInstruction", "Lcom/google/common/collect/Multimap;", "repeatPart", "labelCount", "repeatWhole", "processInstruction", "frontend"})
public final class PseudocodeImpl
implements Pseudocode {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ArrayList<Instruction> mutableInstructionList;
    @NotNull
    private final ArrayList<Instruction> instructions;
    private final BidirectionalMap<KtElement, PseudoValue> elementsToValues;
    private final HashMap<PseudoValue, List<Instruction>> valueUsages;
    private final HashMap<PseudoValue, Set<PseudoValue>> mergedValues;
    private final HashSet<Instruction> sideEffectFree;
    @Nullable
    private Pseudocode parent;
    @NotNull
    private final Lazy localDeclarations$delegate;
    @NotNull
    private final HashSet<Instruction> reachableInstructions;
    private final HashMap<KtElement, KtElementInstruction> representativeInstructions;
    private final ArrayList<PseudocodeLabel> labels;
    private SubroutineExitInstruction internalExitInstruction;
    private SubroutineSinkInstruction internalSinkInstruction;
    private SubroutineExitInstruction internalErrorInstruction;
    private boolean postPrecessed;
    private boolean containsDoWhile;
    @NotNull
    private final KtElement correspondingElement;
    private final boolean isInlined;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PseudocodeImpl.class), "localDeclarations", "getLocalDeclarations()Ljava/util/Set;"))};
    }

    @NotNull
    public final ArrayList<Instruction> getMutableInstructionList$frontend() {
        return this.mutableInstructionList;
    }

    @NotNull
    public ArrayList<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    @Nullable
    public Pseudocode getParent() {
        return this.parent;
    }

    private void setParent(Pseudocode pseudocode2) {
        this.parent = pseudocode2;
    }

    @Override
    @NotNull
    public Set<LocalFunctionDeclarationInstruction> getLocalDeclarations() {
        Lazy lazy = this.localDeclarations$delegate;
        PseudocodeImpl pseudocodeImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Set)lazy.getValue();
    }

    @NotNull
    public final HashSet<Instruction> getReachableInstructions() {
        return this.reachableInstructions;
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalExitInstruction;
        if (subroutineExitInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Exit instruction is read before initialization"));
        }
        return subroutineExitInstruction;
    }

    @Override
    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        SubroutineSinkInstruction subroutineSinkInstruction = this.internalSinkInstruction;
        if (subroutineSinkInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Sink instruction is read before initialization"));
        }
        return subroutineSinkInstruction;
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getErrorInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalErrorInstruction;
        if (subroutineExitInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Error instruction is read before initialization"));
        }
        return subroutineExitInstruction;
    }

    @Override
    public boolean getContainsDoWhile() {
        return this.containsDoWhile;
    }

    public void setContainsDoWhile$frontend(boolean bl) {
        this.containsDoWhile = bl;
    }

    private final Set<LocalFunctionDeclarationInstruction> getLocalDeclarations(Pseudocode pseudocode2) {
        LinkedHashSet<Instruction> localDeclarations2 = new LinkedHashSet<Instruction>();
        Pseudocode pseudocode3 = pseudocode2;
        if (pseudocode3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        }
        for (Instruction instruction : ((PseudocodeImpl)pseudocode3).mutableInstructionList) {
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            localDeclarations2.add(instruction);
            localDeclarations2.addAll((Collection)this.getLocalDeclarations(((LocalFunctionDeclarationInstruction)instruction).getBody()));
        }
        return localDeclarations2;
    }

    @Override
    @NotNull
    public Pseudocode getRootPseudocode() {
        for (Pseudocode parent2 = this.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2.getParent() != null) continue;
            return parent2;
        }
        return this;
    }

    @NotNull
    public final PseudocodeLabel createLabel(@NotNull String name2, @Nullable String comment2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        PseudocodeLabel label2 = new PseudocodeLabel(this, name2, comment2);
        this.labels.add(label2);
        return label2;
    }

    @Override
    @NotNull
    public List<Instruction> getReversedInstructions() {
        LinkedHashSet traversedInstructions = new LinkedHashSet();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.isInlined() ? (Instruction)CollectionsKt.last((List)this.getInstructions()) : (Instruction)this.getSinkInstruction(), traversedInstructions, TraversalOrder.BACKWARD, null);
        if (traversedInstructions.size() < ((ArrayList)this.getInstructions()).size()) {
            List simplyReversedInstructions = CollectionsKt.reversed((Iterable)this.getInstructions());
            for (Instruction instruction : simplyReversedInstructions) {
                if (traversedInstructions.contains(instruction)) continue;
                PseudocodeTraverserKt.traverseFollowingInstructions(instruction, traversedInstructions, TraversalOrder.BACKWARD, null);
            }
        }
        return CollectionsKt.toList((Iterable)traversedInstructions);
    }

    @Override
    @NotNull
    public List<Instruction> getInstructionsIncludingDeadCode() {
        return this.mutableInstructionList;
    }

    @NotNull
    public final List<PseudocodeLabel> getLabels() {
        return this.labels;
    }

    public final void addExitInstruction(@NotNull SubroutineExitInstruction exitInstruction) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)exitInstruction, (String)"exitInstruction");
        this.addInstruction(exitInstruction);
        boolean bl2 = bl = this.internalExitInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Repeated initialization of exit instruction: " + this.internalExitInstruction + " --> " + exitInstruction;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.internalExitInstruction = exitInstruction;
    }

    public final void addSinkInstruction(@NotNull SubroutineSinkInstruction sinkInstruction) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)sinkInstruction, (String)"sinkInstruction");
        this.addInstruction(sinkInstruction);
        boolean bl2 = bl = this.internalSinkInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Repeated initialization of sink instruction: " + this.internalSinkInstruction + " --> " + sinkInstruction;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.internalSinkInstruction = sinkInstruction;
    }

    public final void addErrorInstruction(@NotNull SubroutineExitInstruction errorInstruction) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)errorInstruction, (String)"errorInstruction");
        this.addInstruction(errorInstruction);
        boolean bl2 = bl = this.internalErrorInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Repeated initialization of error instruction: " + this.internalErrorInstruction + " --> " + errorInstruction;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.internalErrorInstruction = errorInstruction;
    }

    public final void addInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
        if (instruction instanceof KtElementInstruction && !this.representativeInstructions.containsKey(((KtElementInstruction)instruction).getElement())) {
            this.representativeInstructions.put(((KtElementInstruction)instruction).getElement(), (KtElementInstruction)instruction);
        }
        if (instruction instanceof MergeInstruction) {
            this.addMergedValues((MergeInstruction)instruction);
        }
        for (PseudoValue inputValue : instruction.getInputValues()) {
            this.addValueUsage(inputValue, instruction);
            for (PseudoValue mergedValue : this.getMergedValues(inputValue)) {
                this.addValueUsage(mergedValue, instruction);
            }
        }
        if (PseudocodeUtilsKt.calcSideEffectFree(instruction)) {
            this.sideEffectFree.add(instruction);
        }
    }

    @Override
    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        Instruction instruction = this.mutableInstructionList.get(0);
        if (instruction == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction");
        }
        return (SubroutineEnterInstruction)instruction;
    }

    @Override
    @Nullable
    public PseudoValue getElementValue(@Nullable KtElement element3) {
        return (PseudoValue)this.elementsToValues.get((Object)element3);
    }

    @Override
    @NotNull
    public List<KtElement> getValueElements(@Nullable PseudoValue value2) {
        List list2 = this.elementsToValues.getKeysByValue((Object)value2);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Instruction> getUsages(@Nullable PseudoValue value2) {
        Map map2 = this.valueUsages;
        List list2 = (List)map2.get(value2);
        if (list2 == null) {
            list2 = new ArrayList();
        }
        return list2;
    }

    @Override
    public boolean isSideEffectFree(@NotNull Instruction instruction) {
        Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
        return this.sideEffectFree.contains(instruction);
    }

    public final void bindElementToValue(@NotNull KtElement element3, @NotNull PseudoValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.elementsToValues.put((Object)element3, (Object)value2);
    }

    public final void bindLabel(@NotNull PseudocodeLabel label2) {
        Intrinsics.checkParameterIsNotNull((Object)label2, (String)"label");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)label2.getPseudocode());
        if (_Assertions.ENABLED && !bl) {
            String string = "Attempt to bind label " + label2 + " to instruction from different pseudocode: " + "\nowner pseudocode = " + label2.getPseudocode().mutableInstructionList + ", " + "\nbound pseudocode = " + this.mutableInstructionList;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        label2.setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    private final Set<PseudoValue> getMergedValues(PseudoValue value2) {
        Set set2 = this.mergedValues.get(value2);
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    private final void addMergedValues(MergeInstruction instruction) {
        LinkedHashSet<PseudoValue> result2 = new LinkedHashSet<PseudoValue>();
        for (PseudoValue value2 : instruction.getInputValues()) {
            result2.addAll((Collection)this.getMergedValues(value2));
            result2.add(value2);
        }
        this.mergedValues.put(instruction.getOutputValue(), result2);
    }

    private final void addValueUsage(PseudoValue value2, Instruction usage) {
        Object object;
        if (usage instanceof MergeInstruction) {
            return;
        }
        Map $receiver$iv = this.valueUsages;
        Object value$iv = $receiver$iv.get(value2);
        if (value$iv == null) {
            ArrayList answer$iv = new ArrayList();
            $receiver$iv.put(value2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(usage);
    }

    public final void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        this.getErrorInstruction().setSink(this.getSinkInstruction());
        this.getExitInstruction().setSink(this.getSinkInstruction());
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)this.mutableInstructionList)) {
            int index2 = indexedValue.component1();
            Instruction instruction = (Instruction)indexedValue.component2();
            this.processInstruction(instruction, index2);
        }
        this.collectAndCacheReachableInstructions();
    }

    private final void collectAndCacheReachableInstructions() {
        this.collectReachableInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!this.reachableInstructions.contains(instruction)) continue;
            ((ArrayList)this.getInstructions()).add(instruction);
        }
        this.markDeadInstructions();
    }

    private final void processInstruction(@NotNull Instruction $receiver, int currentPosition) {
        $receiver.accept(new InstructionVisitor(this, currentPosition){
            final /* synthetic */ PseudocodeImpl this$0;
            final /* synthetic */ int $currentPosition;

            public void visitInstructionWithNext(@NotNull InstructionWithNext instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
            }

            public void visitJump(@NotNull AbstractJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                instruction.setResolvedTarget(PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel()));
            }

            public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, PseudocodeImpl.access$getJumpTarget(this.this$0, targetLabel));
                }
            }

            public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                Instruction nextInstruction = PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition);
                Instruction jumpTarget = PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel());
                if (instruction.getOnTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            public void visitLocalFunctionDeclarationInstruction(@NotNull LocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                Pseudocode pseudocode2 = instruction.getBody();
                if (pseudocode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                }
                PseudocodeImpl body2 = (PseudocodeImpl)pseudocode2;
                PseudocodeImpl.access$setParent$p(body2, this.this$0);
                body2.postProcess();
                instruction.setNext(this.this$0.getSinkInstruction());
            }

            public void visitInlinedLocalFunctionDeclarationInstruction(@NotNull InlinedLocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                Pseudocode pseudocode2 = instruction.getBody();
                if (pseudocode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                }
                PseudocodeImpl body2 = (PseudocodeImpl)pseudocode2;
                PseudocodeImpl.access$setParent$p(body2, this.this$0);
                body2.postProcess();
                instruction.setNext(((ArrayList)body2.getInstructions()).contains(body2.getExitInstruction()) ? PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition) : (Instruction)this.this$0.getSinkInstruction());
            }

            public void visitSubroutineExit(@NotNull SubroutineExitInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
            }

            public void visitSubroutineSink(@NotNull SubroutineSinkInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
            }

            public void visitInstruction(@NotNull Instruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                throw (Throwable)new UnsupportedOperationException(instruction.toString());
            }
            {
                this.this$0 = $outer;
                this.$currentPosition = $captured_local_variable$1;
            }
        });
    }

    private final void collectReachableInstructions() {
        HashSet<InstructionImpl> reachableFromThisPseudocode = new HashSet<InstructionImpl>();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.getEnterInstruction(), (Set<Instruction>)reachableFromThisPseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)((Function1)collectReachableInstructions.1.INSTANCE));
        if (!this.isInlined()) {
            reachableFromThisPseudocode.add(this.getExitInstruction());
            reachableFromThisPseudocode.add(this.getErrorInstruction());
            reachableFromThisPseudocode.add(this.getSinkInstruction());
        }
        Iterable $receiver$iv = reachableFromThisPseudocode;
        for (Object element$iv : $receiver$iv) {
            Instruction it = (Instruction)element$iv;
            Pseudocode pseudocode2 = it.getOwner();
            if (pseudocode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
            }
            ((PseudocodeImpl)pseudocode2).reachableInstructions.add(it);
        }
    }

    private final void markDeadInstructions() {
        HashSet instructionSet = CollectionsKt.toHashSet((Iterable)this.getInstructions());
        for (Instruction instruction : this.mutableInstructionList) {
            if (instructionSet.contains(instruction)) continue;
            Instruction instruction2 = instruction;
            if (!(instruction2 instanceof InstructionImpl)) {
                instruction2 = null;
            }
            InstructionImpl instructionImpl = (InstructionImpl)instruction2;
            if (instructionImpl != null) {
                instructionImpl.setMarkedAsDead(true);
            }
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                Object object;
                Instruction instruction3 = nextInstruction;
                if (!(instruction3 instanceof InstructionImpl)) {
                    instruction3 = null;
                }
                if ((object = (InstructionImpl)instruction3) == null || (object = ((InstructionImpl)object).getPreviousInstructions()) == null) continue;
                object.remove(instruction);
            }
        }
    }

    private final Instruction getJumpTarget(Label targetLabel) {
        return targetLabel.resolveToInstruction();
    }

    private final Instruction getNextPosition(int currentPosition) {
        boolean bl;
        int targetPosition = currentPosition + 1;
        boolean bl2 = bl = targetPosition < this.mutableInstructionList.size();
        if (_Assertions.ENABLED && !bl) {
            Integer n = currentPosition;
            throw (Throwable)((Object)new AssertionError(n));
        }
        Instruction instruction = this.mutableInstructionList.get(targetPosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)instruction, (String)"mutableInstructionList[targetPosition]");
        return instruction;
    }

    @Override
    @NotNull
    public PseudocodeImpl copy() {
        PseudocodeImpl result2 = new PseudocodeImpl(this.getCorrespondingElement(), this.isInlined());
        result2.repeatWhole(this);
        return result2;
    }

    @Override
    @Nullable
    public KtElementInstruction instructionForElement(@NotNull KtElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.representativeInstructions.get(element3);
    }

    private final void repeatWhole(PseudocodeImpl originalPseudocode) {
        this.repeatInternal(originalPseudocode, null, null, 0);
        this.setParent(originalPseudocode.getParent());
    }

    public final int repeatPart(@NotNull Label startLabel, @NotNull Label finishLabel, int labelCount) {
        Intrinsics.checkParameterIsNotNull((Object)startLabel, (String)"startLabel");
        Intrinsics.checkParameterIsNotNull((Object)finishLabel, (String)"finishLabel");
        Pseudocode pseudocode2 = startLabel.getPseudocode();
        if (pseudocode2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        }
        return this.repeatInternal((PseudocodeImpl)pseudocode2, startLabel, finishLabel, labelCount);
    }

    /*
     * WARNING - void declaration
     */
    private final int repeatInternal(PseudocodeImpl originalPseudocode, Label startLabel, Label finishLabel, int labelCountArg) {
        int labelCount = labelCountArg;
        Label label2 = startLabel;
        int startIndex = label2 != null ? label2.getTargetInstructionIndex() : 0;
        Label label3 = finishLabel;
        int finishIndex = label3 != null ? label3.getTargetInstructionIndex() : originalPseudocode.mutableInstructionList.size();
        LinkedHashMap<PseudocodeLabel, PseudocodeLabel> originalToCopy = new LinkedHashMap<PseudocodeLabel, PseudocodeLabel>();
        HashMultimap originalLabelsForInstruction = HashMultimap.create();
        for (PseudocodeLabel label4 : originalPseudocode.labels) {
            int n;
            int index2 = label4.getTargetInstructionIndex();
            if (index2 < 0 || label4 == startLabel || label4 == finishLabel || startIndex > (n = index2) || finishIndex < n) continue;
            originalToCopy.put(label4, label4.copy(this, labelCount++));
            PseudocodeLabel pseudocodeLabel = label4;
            Intrinsics.checkExpressionValueIsNotNull((Object)pseudocodeLabel, (String)"label");
            originalLabelsForInstruction.put((Object)this.getJumpTarget(pseudocodeLabel), (Object)label4);
        }
        for (PseudocodeLabel label4 : originalToCopy.values()) {
            this.labels.add(label4);
        }
        int label5 = startIndex;
        int n = finishIndex;
        while (label5 < n) {
            void index3;
            Instruction originalInstruction;
            Instruction instruction = originalInstruction = originalPseudocode.mutableInstructionList.get((int)index3);
            Intrinsics.checkExpressionValueIsNotNull((Object)instruction, (String)"originalInstruction");
            Map map2 = originalToCopy;
            HashMultimap hashMultimap = originalLabelsForInstruction;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"originalLabelsForInstruction");
            this.repeatLabelsBindingForInstruction(instruction, map2, (Multimap<Instruction, Label>)((Multimap)hashMultimap));
            Instruction copy = this.copyInstruction(originalInstruction, (Map<Label, PseudocodeLabel>)originalToCopy);
            this.addInstruction(copy);
            if (originalInstruction == originalPseudocode.internalErrorInstruction && copy instanceof SubroutineExitInstruction) {
                this.internalErrorInstruction = (SubroutineExitInstruction)copy;
            }
            if (originalInstruction == originalPseudocode.internalExitInstruction && copy instanceof SubroutineExitInstruction) {
                this.internalExitInstruction = (SubroutineExitInstruction)copy;
            }
            if (originalInstruction == originalPseudocode.internalSinkInstruction && copy instanceof SubroutineSinkInstruction) {
                this.internalSinkInstruction = (SubroutineSinkInstruction)copy;
            }
            ++index3;
        }
        if (finishIndex < originalPseudocode.mutableInstructionList.size()) {
            Instruction instruction = originalPseudocode.mutableInstructionList.get(finishIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)instruction, (String)"originalPseudocode.mutab\u2026tructionList[finishIndex]");
            Map map3 = originalToCopy;
            HashMultimap hashMultimap = originalLabelsForInstruction;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"originalLabelsForInstruction");
            this.repeatLabelsBindingForInstruction(instruction, map3, (Multimap<Instruction, Label>)((Multimap)hashMultimap));
        }
        return labelCount;
    }

    private final void repeatLabelsBindingForInstruction(Instruction originalInstruction, Map<Label, PseudocodeLabel> originalToCopy, Multimap<Instruction, Label> originalLabelsForInstruction) {
        for (Label originalLabel : originalLabelsForInstruction.get((Object)originalInstruction)) {
            PseudocodeLabel pseudocodeLabel = originalToCopy.get(originalLabel);
            if (pseudocodeLabel == null) {
                Intrinsics.throwNpe();
            }
            this.bindLabel(pseudocodeLabel);
        }
    }

    private final Instruction copyInstruction(Instruction instruction, Map<Label, PseudocodeLabel> originalToCopy) {
        Label originalTarget;
        if (instruction instanceof AbstractJumpInstruction && originalToCopy.containsKey(originalTarget = ((AbstractJumpInstruction)instruction).getTargetLabel())) {
            AbstractJumpInstruction abstractJumpInstruction = (AbstractJumpInstruction)instruction;
            PseudocodeLabel pseudocodeLabel = originalToCopy.get(originalTarget);
            if (pseudocodeLabel == null) {
                Intrinsics.throwNpe();
            }
            return abstractJumpInstruction.copy(pseudocodeLabel);
        }
        if (instruction instanceof NondeterministicJumpInstruction) {
            List<Label> originalTargets = ((NondeterministicJumpInstruction)instruction).getTargetLabels();
            List<Label> copyTargets = this.copyLabels((Collection<? extends Label>)originalTargets, originalToCopy);
            return ((NondeterministicJumpInstruction)instruction).copy(copyTargets);
        }
        Instruction instruction2 = instruction;
        if (instruction2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl");
        }
        return ((InstructionImpl)instruction2).copy();
    }

    private final List<Label> copyLabels(Collection<? extends Label> labels2, Map<Label, PseudocodeLabel> originalToCopy) {
        ArrayList<Label> newLabels = new ArrayList<Label>();
        for (Label label2 : labels2) {
            PseudocodeLabel newLabel;
            PseudocodeLabel pseudocodeLabel = newLabel = originalToCopy.get(label2);
            newLabels.add(pseudocodeLabel != null ? (Label)pseudocodeLabel : label2);
        }
        return newLabels;
    }

    @Override
    @NotNull
    public KtElement getCorrespondingElement() {
        return this.correspondingElement;
    }

    @Override
    public boolean isInlined() {
        return this.isInlined;
    }

    public PseudocodeImpl(@NotNull KtElement correspondingElement, boolean isInlined) {
        Intrinsics.checkParameterIsNotNull((Object)correspondingElement, (String)"correspondingElement");
        this.correspondingElement = correspondingElement;
        this.isInlined = isInlined;
        this.mutableInstructionList = new ArrayList();
        this.instructions = new ArrayList();
        this.elementsToValues = new BidirectionalMap();
        PseudocodeImpl pseudocodeImpl = this;
        Cloneable cloneable2 = new HashMap();
        pseudocodeImpl.valueUsages = cloneable2;
        pseudocodeImpl = this;
        cloneable2 = new HashMap();
        pseudocodeImpl.mergedValues = cloneable2;
        pseudocodeImpl = this;
        cloneable2 = new HashSet();
        pseudocodeImpl.sideEffectFree = cloneable2;
        this.localDeclarations$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends LocalFunctionDeclarationInstruction>>(this){
            final /* synthetic */ PseudocodeImpl this$0;

            @NotNull
            public final Set<LocalFunctionDeclarationInstruction> invoke() {
                return PseudocodeImpl.access$getLocalDeclarations(this.this$0, this.this$0);
            }
            {
                this.this$0 = pseudocodeImpl;
                super(0);
            }
        }));
        pseudocodeImpl = this;
        cloneable2 = new HashSet();
        pseudocodeImpl.reachableInstructions = cloneable2;
        this.representativeInstructions = new HashMap();
        this.labels = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ Instruction access$getNextPosition(PseudocodeImpl $this, int currentPosition) {
        return $this.getNextPosition(currentPosition);
    }

    @NotNull
    public static final /* synthetic */ Instruction access$getJumpTarget(PseudocodeImpl $this, @NotNull Label targetLabel) {
        return $this.getJumpTarget(targetLabel);
    }

    @Nullable
    public static final /* synthetic */ Pseudocode access$getParent$p(PseudocodeImpl $this) {
        return $this.getParent();
    }

    public static final /* synthetic */ void access$setParent$p(PseudocodeImpl $this, @Nullable Pseudocode pseudocode2) {
        $this.setParent(pseudocode2);
    }

    @NotNull
    public static final /* synthetic */ Set access$getLocalDeclarations(PseudocodeImpl $this, @NotNull Pseudocode pseudocode2) {
        return $this.getLocalDeclarations(pseudocode2);
    }
}

