/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.caches.resolve.LibraryModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.caches.resolve.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryWithoutSourceScope;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.TargetPlatform;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#H\u0016J\u0013\u0010$\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010&H\u0096\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020)H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/caches/resolve/LibraryModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/resolve/BinaryModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;)V", "isLibrary", "", "()Z", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "sourcesModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/SourceForBinaryModuleInfo;", "getSourcesModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/resolve/SourceForBinaryModuleInfo;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "dependencies", "", "equals", "other", "", "getLibraryRoots", "", "", "hashCode", "", "toString", "idea-core"})
public final class LibraryInfo
implements IdeaModuleInfo,
LibraryModuleInfo,
BinaryModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return (GlobalSearchScope)new LibraryWithoutSourceScope(this.project, this.library);
    }

    @Override
    public boolean isLibrary() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        void $receiver$iv$iv;
        void libraries;
        IdeaModuleInfo ideaModuleInfo;
        Library it;
        Collection collection;
        LinkedHashSet<LibraryInfo> result2 = new LinkedHashSet<LibraryInfo>();
        result2.add(this);
        Pair<List<Library>, List<Sdk>> pair2 = LibraryDependenciesCache.Companion.getInstance(this.project).getLibrariesAndSdksUsedWith(this.library);
        List list2 = (List)pair2.component1();
        List sdks = (List)pair2.component2();
        Iterable $receiver$iv = sdks;
        for (Object item$iv : $receiver$iv) {
            Sdk sdk = (Sdk)item$iv;
            collection = result2;
            ideaModuleInfo = new SdkInfo(this.project, (Sdk)it);
            collection.add(ideaModuleInfo);
        }
        $receiver$iv = (Iterable)libraries;
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Library it2 = (Library)element$iv$iv;
            if (!(it2 instanceof LibraryEx && !((LibraryEx)it2).isDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object item$iv : $receiver$iv) {
            it = (Library)item$iv;
            collection = result2;
            ideaModuleInfo = new LibraryInfo(this.project, it);
            collection.add(ideaModuleInfo);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return LibraryKindsKt.getLibraryPlatform(this.library);
    }

    @Override
    @NotNull
    public SourceForBinaryModuleInfo getSourcesModuleInfo() {
        return new LibrarySourceInfo(this.project, this.library);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getLibraryRoots() {
        void var3_3;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        VirtualFile[] virtualFileArray = this.library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        Object[] objectArray = $receiver$iv = (Object[])virtualFileArray;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv$iv : $receiver$iv$iv) {
            String string;
            void element$iv$iv = element$iv$iv$iv;
            VirtualFile p1 = (VirtualFile)element$iv$iv;
            if (PathUtil.getLocalPath((VirtualFile)p1) == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public String toString() {
        return "LibraryInfo(libraryName=" + this.library.getName() + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LibraryInfo && Intrinsics.areEqual((Object)this.library, (Object)((LibraryInfo)other).library);
    }

    public int hashCode() {
        return 43 * this.library.hashCode();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibraryInfo(@NotNull Project project, @NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        this.project = project;
        this.library = library2;
        Name name2 = Name.special("<library " + this.library.getName() + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<library ${library.name}>\")");
        this.name = name2;
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    @NotNull
    public String getDisplayedName() {
        return IdeaModuleInfo.DefaultImpls.getDisplayedName(this);
    }

    @Override
    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @Override
    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope binariesScope() {
        return BinaryModuleInfo.DefaultImpls.binariesScope(this);
    }
}

