/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilder$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContextKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.TypeClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.flags.FlagsKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.flags.FlagsToModifiers;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B?\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010$\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020\u001dH\u0002J\u0016\u0010'\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0016\u0010(\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0018\u0010)\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002J \u0010,\u001a\u00020\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010-\u001a\u00020\nH\u0002J\u0010\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002J\b\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClassClsStubBuilder;", "", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "classProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "outerContext", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;", "(Lcom/intellij/psi/stubs/StubElement;Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/descriptors/SourceElement;Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;)V", "c", "classKind", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Kind;", "classOrObjectStub", "companionObjectName", "Lorg/jetbrains/kotlin/name/Name;", "supertypeIds", "", "thisAsProtoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer$Class;", "typeStubBuilder", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/TypeClsStubBuilder;", "build", "", "createCallableMemberStubs", "classBody", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinPlaceHolderStubImpl;", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "createClassBodyAndMemberStubs", "createClassOrObjectStubAndModifierListStub", "createCompanionObjectStub", "createConstructorStub", "createDelegationSpecifierList", "createEnumEntryStubs", "createInnerAndNestedClasses", "createModifierListForClass", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl;", "parent", "createNestedClassStub", "nestedClassId", "doCreateClassOrObjectStub", "isClass", "", "Companion", "idea-core"})
final class ClassClsStubBuilder {
    private final ProtoContainer.Class thisAsProtoContainer;
    private final ProtoBuf.Class.Kind classKind;
    private final ClsStubBuilderContext c;
    private final TypeClsStubBuilder typeStubBuilder;
    private final List<ClassId> supertypeIds;
    private final Name companionObjectName;
    private final StubElement<? extends PsiElement> classOrObjectStub;
    private final StubElement<? extends PsiElement> parentStub;
    private final ProtoBuf.Class classProto;
    private final ClassId classId;
    private static final Logger LOG;
    public static final Companion Companion;

    public final void build() {
        List<ProtoBuf.TypeParameter> list2 = this.classProto.getTypeParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.typeParameterList");
        List<Pair<Name, ProtoBuf.Type>> typeConstraintListData = this.typeStubBuilder.createTypeParameterListStub(this.classOrObjectStub, list2);
        this.createConstructorStub();
        this.createDelegationSpecifierList();
        this.typeStubBuilder.createTypeConstraintListStub(this.classOrObjectStub, typeConstraintListData);
        this.createClassBodyAndMemberStubs();
    }

    private final StubElement<? extends PsiElement> createClassOrObjectStubAndModifierListStub() {
        StubElement<? extends PsiElement> classOrObjectStub = this.doCreateClassOrObjectStub();
        KotlinModifierListStubImpl modifierList = this.createModifierListForClass(classOrObjectStub);
        Boolean bl = Flags.HAS_ANNOTATIONS.get(this.classProto.getFlags());
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"Flags.HAS_ANNOTATIONS.get(classProto.flags)");
        if (bl.booleanValue()) {
            ClsStubBuildingKt.createAnnotationStubs(this.c.getComponents().getAnnotationLoader().loadClassAnnotations(this.thisAsProtoContainer), modifierList);
        }
        return classOrObjectStub;
    }

    private final KotlinModifierListStubImpl createModifierListForClass(StubElement<? extends PsiElement> parent2) {
        List list2;
        ArrayList relevantFlags = CollectionsKt.arrayListOf((Object[])new FlagsToModifiers[]{FlagsKt.getVISIBILITY()});
        relevantFlags.add(FlagsKt.getEXTERNAL_CLASS());
        if (this.isClass()) {
            relevantFlags.add(FlagsKt.getINNER());
            relevantFlags.add(FlagsKt.getDATA());
            relevantFlags.add(FlagsKt.getMODALITY());
        }
        switch (ClassClsStubBuilder$WhenMappings.$EnumSwitchMapping$0[this.classKind.ordinal()]) {
            case 1: {
                list2 = CollectionsKt.listOf((Object)((Object)KtTokens.ENUM_KEYWORD));
                break;
            }
            case 2: {
                list2 = CollectionsKt.listOf((Object)((Object)KtTokens.COMPANION_KEYWORD));
                break;
            }
            case 3: {
                list2 = CollectionsKt.listOf((Object)((Object)KtTokens.ANNOTATION_KEYWORD));
                break;
            }
            default: {
                list2 = CollectionsKt.emptyList();
            }
        }
        List additionalModifiers = list2;
        return ClsStubBuildingKt.createModifierListStubForDeclaration(parent2, this.classProto.getFlags(), relevantFlags, additionalModifiers);
    }

    private final StubElement<? extends PsiElement> doCreateClassOrObjectStub() {
        StubElement stubElement;
        ClassId it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean isCompanionObject = Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.COMPANION_OBJECT);
        FqName fqName2 = this.classId.asSingleFqName();
        Name name2 = fqName2.shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"fqName.shortName()");
        StringRef shortName = ClsStubBuildingKt.ref(name2);
        Iterable iterable = $receiver$iv = (Iterable)this.supertypeIds;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ClassId)element$iv$iv;
            FqNameUnsafe fqNameUnsafe = it.asSingleFqName().toUnsafe();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"it.asSingleFqName().toUnsafe()");
            if (FunctionTypesKt.isNumberedFunctionClassFqName(fqNameUnsafe)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ClassId)item$iv$iv;
            Collection collection = destination$iv$iv;
            ClassId classId = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"it");
            Name name3 = classId.getShortClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"it.shortClassName");
            StringRef stringRef = ClsStubBuildingKt.ref(name3);
            collection.add(stringRef);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        StringRef[] stringRefArray = thisCollection$iv.toArray(new StringRef[0]);
        if (stringRefArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StringRef[] superTypeRefs = stringRefArray;
        switch (ClassClsStubBuilder$WhenMappings.$EnumSwitchMapping$1[this.classKind.ordinal()]) {
            case 1: 
            case 2: {
                stubElement = (StubElement)new KotlinObjectStubImpl(this.parentStub, shortName, fqName2, superTypeRefs, !this.classId.isNestedClass(), isCompanionObject, false, false);
                break;
            }
            default: {
                KtClassElementType ktClassElementType = KtClassElementType.getStubType(Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.ENUM_ENTRY));
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktClassElementType), (String)"KtClassElementType.getSt\u2026uf.Class.Kind.ENUM_ENTRY)");
                FqName fqName3 = fqName2;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName");
                stubElement = (StubElement)new KotlinClassStubImpl(ktClassElementType, this.parentStub, ClsStubBuildingKt.ref(fqName3), shortName, superTypeRefs, Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.INTERFACE), Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.ENUM_ENTRY), false, !this.classId.isNestedClass());
            }
        }
        return stubElement;
    }

    private final void createConstructorStub() {
        Object v2;
        block3: {
            Iterable iterable;
            if (!this.isClass()) {
                return;
            }
            List<ProtoBuf.Constructor> list2 = this.classProto.getConstructorList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.constructorList");
            Iterable iterable2 = iterable = (Iterable)list2;
            for (Object t : iterable2) {
                ProtoBuf.Constructor it;
                ProtoBuf.Constructor constructor2 = it = (ProtoBuf.Constructor)t;
                Intrinsics.checkExpressionValueIsNotNull((Object)constructor2, (String)"it");
                if (!(Flags.IS_SECONDARY.get(constructor2.getFlags()) == false)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        ProtoBuf.Constructor constructor3 = v2;
        if (constructor3 == null) {
            return;
        }
        ProtoBuf.Constructor primaryConstructorProto = constructor3;
        CallableClsStubBuilderKt.createConstructorStub(this.classOrObjectStub, primaryConstructorProto, this.c, this.thisAsProtoContainer);
    }

    private final void createDelegationSpecifierList() {
        if (this.supertypeIds.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl delegationSpecifierListStub = new KotlinPlaceHolderStubImpl((StubElement)this.classOrObjectStub, KtStubElementTypes.SUPER_TYPE_LIST);
        Iterable $receiver$iv = ProtoTypeTableUtilKt.supertypes(this.classProto, this.c.getTypeTable());
        for (Object element$iv : $receiver$iv) {
            ProtoBuf.Type type2 = (ProtoBuf.Type)element$iv;
            KotlinPlaceHolderStubImpl superClassStub = new KotlinPlaceHolderStubImpl(delegationSpecifierListStub, KtStubElementTypes.SUPER_TYPE_ENTRY);
            TypeClsStubBuilder.createTypeReferenceStub$default(this.typeStubBuilder, superClassStub, type2, null, 4, null);
        }
    }

    private final void createClassBodyAndMemberStubs() {
        KotlinPlaceHolderStubImpl<KtClassBody> classBody = new KotlinPlaceHolderStubImpl<KtClassBody>((StubElement)this.classOrObjectStub, KtStubElementTypes.CLASS_BODY);
        this.createEnumEntryStubs(classBody);
        this.createCompanionObjectStub(classBody);
        this.createCallableMemberStubs(classBody);
        this.createInnerAndNestedClasses(classBody);
    }

    private final void createCompanionObjectStub(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        if (this.companionObjectName == null) {
            return;
        }
        ClassId companionObjectId = this.classId.createNestedClassId(this.companionObjectName);
        StubElement stubElement = classBody;
        ClassId classId = companionObjectId;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"companionObjectId");
        this.createNestedClassStub((StubElement<? extends PsiElement>)stubElement, classId);
    }

    private final void createEnumEntryStubs(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        if (Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.ENUM_CLASS) ^ true) {
            return;
        }
        List<ProtoBuf.EnumEntry> list2 = this.classProto.getEnumEntryList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.enumEntryList");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            ProtoBuf.EnumEntry entry = (ProtoBuf.EnumEntry)element$iv;
            NameResolver nameResolver = this.c.getNameResolver();
            ProtoBuf.EnumEntry enumEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)enumEntry, (String)"entry");
            Name name2 = nameResolver.getName(enumEntry.getName());
            List<ClassId> annotations2 = this.c.getComponents().getAnnotationLoader().loadEnumEntryAnnotations(this.thisAsProtoContainer, entry);
            KtClassElementType ktClassElementType = KtStubElementTypes.ENUM_ENTRY;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktClassElementType), (String)"KtStubElementTypes.ENUM_ENTRY");
            StubElement stubElement = classBody;
            FqName fqName2 = this.c.getContainerFqName().child(name2);
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"c.containerFqName.child(name)");
            StringRef stringRef = ClsStubBuildingKt.ref(fqName2);
            Name name3 = name2;
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
            KotlinClassStubImpl enumEntryStub = new KotlinClassStubImpl(ktClassElementType, (StubElement<? extends PsiElement>)stubElement, stringRef, ClsStubBuildingKt.ref(name3), new StringRef[0], false, true, false, false);
            Collection collection = annotations2;
            if (!(!collection.isEmpty())) continue;
            ClsStubBuildingKt.createAnnotationStubs(annotations2, ClsStubBuildingKt.createEmptyModifierListStub(enumEntryStub));
        }
    }

    private final void createCallableMemberStubs(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        Iterator<ProtoBuf.Constructor> iterator2 = this.classProto.getConstructorList().iterator();
        while (iterator2.hasNext()) {
            ProtoBuf.Constructor secondaryConstructorProto;
            ProtoBuf.Constructor constructor2 = secondaryConstructorProto = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)constructor2, (String)"secondaryConstructorProto");
            Boolean bl = Flags.IS_SECONDARY.get(constructor2.getFlags());
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"Flags.IS_SECONDARY.get(s\u2026ryConstructorProto.flags)");
            if (!bl.booleanValue()) continue;
            CallableClsStubBuilderKt.createConstructorStub((StubElement<? extends PsiElement>)classBody, secondaryConstructorProto, this.c, this.thisAsProtoContainer);
        }
        StubElement stubElement = classBody;
        ProtoContainer protoContainer = this.thisAsProtoContainer;
        List<ProtoBuf.Function> list2 = this.classProto.getFunctionList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.functionList");
        List<ProtoBuf.Property> list3 = this.classProto.getPropertyList();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"classProto.propertyList");
        List<ProtoBuf.TypeAlias> list4 = this.classProto.getTypeAliasList();
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"classProto.typeAliasList");
        CallableClsStubBuilderKt.createDeclarationsStubs((StubElement<? extends PsiElement>)stubElement, this.c, protoContainer, list2, list3, list4);
    }

    private final boolean isClass() {
        return Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.CLASS) || Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.ENUM_CLASS) || Intrinsics.areEqual((Object)this.classKind, (Object)ProtoBuf.Class.Kind.ANNOTATION_CLASS);
    }

    private final void createInnerAndNestedClasses(KotlinPlaceHolderStubImpl<KtClassBody> classBody) {
        List<Integer> list2 = this.classProto.getNestedClassNameList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classProto.nestedClassNameList");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            Integer id = (Integer)element$iv;
            NameResolver nameResolver = this.c.getNameResolver();
            Integer n = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"id");
            Name nestedClassName = nameResolver.getName(n);
            if (!(Intrinsics.areEqual((Object)nestedClassName, (Object)this.companionObjectName) ^ true)) continue;
            ClassId nestedClassId = this.classId.createNestedClassId(nestedClassName);
            StubElement stubElement = classBody;
            ClassId classId = nestedClassId;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nestedClassId");
            this.createNestedClassStub((StubElement<? extends PsiElement>)stubElement, classId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createNestedClassStub(StubElement<? extends PsiElement> classBody, ClassId nestedClassId) {
        void nameResolver;
        ClassDataWithSource classDataWithSource = this.c.getComponents().getClassDataFinder().findClassData(nestedClassId);
        if (classDataWithSource == null) {
            void $receiver$iv;
            VirtualFile rootFile = this.c.getComponents().getVirtualFileForDebug();
            Logger logger = ClassClsStubBuilder.Companion.getLOG();
            StringBuilder stringBuilder = new StringBuilder().append("Could not find class data for nested class ").append(nestedClassId).append(" of class ").append(nestedClassId.getOuterClassId()).append('\n').append("Root file: ").append(rootFile.getCanonicalPath()).append('\n').append("Dir: ");
            VirtualFile virtualFile2 = rootFile.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"rootFile.parent");
            StringBuilder stringBuilder2 = stringBuilder.append(virtualFile2.getCanonicalPath()).append('\n').append("Children:\n");
            VirtualFile virtualFile3 = rootFile.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"rootFile.parent");
            VirtualFile[] virtualFileArray = virtualFile3.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"rootFile.parent.children");
            Object[] objectArray = virtualFileArray;
            StringBuilder stringBuilder3 = stringBuilder2;
            Logger logger2 = logger;
            void var6_10 = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    VirtualFile it;
                    VirtualFile virtualFile2 = it = (VirtualFile)a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it");
                    it = (VirtualFile)b;
                    Comparable comparable = (Comparable)((Object)virtualFile2.getName());
                    VirtualFile virtualFile3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it");
                    String string = virtualFile3.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            };
            List list2 = ArraysKt.sortedWith((Object[])var6_10, (Comparator)comparator);
            logger2.error(stringBuilder3.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, (Function1)createNestedClassStub.2.INSTANCE, (int)30, null)).toString());
            return;
        }
        ClassData classData = classDataWithSource.getClassData();
        NameResolver rootFile = classData.component1();
        ProtoBuf.Class classProto = classData.component2();
        ClassClsStubBuilderKt.createClassStub(classBody, classProto, (NameResolver)nameResolver, nestedClassId, classDataWithSource.getSourceElement(), this.c);
    }

    /*
     * WARNING - void declaration
     */
    public ClassClsStubBuilder(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver, @NotNull ClassId classId, @Nullable SourceElement source, @NotNull ClsStubBuilderContext outerContext) {
        List list2;
        boolean bl;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(parentStub, (String)"parentStub");
        Intrinsics.checkParameterIsNotNull((Object)classProto, (String)"classProto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull((Object)outerContext, (String)"outerContext");
        this.parentStub = parentStub;
        this.classProto = classProto;
        this.classId = classId;
        ProtoBuf.TypeTable typeTable = this.classProto.getTypeTable();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
        this.thisAsProtoContainer = new ProtoContainer.Class(this.classProto, nameResolver, new TypeTable(typeTable), source, outerContext.getProtoContainer());
        this.classKind = this.thisAsProtoContainer.getKind();
        List<ProtoBuf.TypeParameter> list3 = this.classProto.getTypeParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"classProto.typeParameterList");
        this.c = ClsStubBuilderContextKt.child(outerContext, list3, this.classId.getShortClassName(), nameResolver, this.thisAsProtoContainer.getTypeTable(), this.thisAsProtoContainer);
        this.typeStubBuilder = new TypeClsStubBuilder(this.c);
        ClassClsStubBuilder classClsStubBuilder = this;
        ClassClsStubBuilder classClsStubBuilder2 = this;
        ClassClsStubBuilder $receiver = classClsStubBuilder;
        Iterable iterable = $receiver$iv = (Iterable)ProtoTypeTableUtilKt.supertypes($receiver.classProto, $receiver.c.getTypeTable());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            ClassId classId2 = $receiver.c.getNameResolver().getClassId(it.getClassName());
            collection.add(classId2);
        }
        List supertypeIds = (List)destination$iv$iv;
        ClassId classId3 = (ClassId)CollectionsKt.singleOrNull((List)supertypeIds);
        if (classId3 != null) {
            ClassId classId4;
            ClassId it = classId4 = classId3;
            bl = Intrinsics.areEqual((Object)KotlinBuiltIns.FQ_NAMES.any, (Object)it.asSingleFqName().toUnsafe());
        } else {
            bl = false;
        }
        classClsStubBuilder2.supertypeIds = list2 = bl ? CollectionsKt.emptyList() : supertypeIds;
        this.companionObjectName = this.classProto.hasCompanionObjectName() ? this.c.getNameResolver().getName(this.classProto.getCompanionObjectName()) : null;
        this.classOrObjectStub = this.createClassOrObjectStubAndModifierListStub();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(ClassClsStubBuilder.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClassClsStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-core"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

