/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractPrimitiveRangeToInspection;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractPrimitiveRangeToInspection;", "()V", "visitRangeToExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isMinusOne", "", "ReplaceWithUntilQuickFix", "idea"})
public final class ReplaceRangeToWithUntilInspection
extends AbstractPrimitiveRangeToInspection {
    @Override
    public void visitRangeToExpression(@NotNull KtExpression expression2, @NotNull ProblemsHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Object object = ReplaceUntilWithRangeToIntentionKt.getArguments(expression2);
        if (object == null || (object = (KtExpression)object.getSecond()) == null || !this.isMinusOne((KtExpression)object)) {
            return;
        }
        holder.registerProblem((PsiElement)expression2, "'rangeTo' or the '..' call can be replaced with 'until'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithUntilQuickFix()});
    }

    private final boolean isMinusOne(@NotNull KtExpression $receiver) {
        ConstantValue constantValue;
        if (!($receiver instanceof KtBinaryExpression)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((KtBinaryExpression)$receiver).getOperationToken(), (Object)((Object)KtTokens.MINUS)) ^ true) {
            return false;
        }
        KtExpression ktExpression = ((KtBinaryExpression)$receiver).getRight();
        ConstantValue constantValue2 = constantValue = ktExpression != null ? AbstractPrimitiveRangeToInspection.Companion.constantValueOrNull$default(AbstractPrimitiveRangeToInspection.Companion, ktExpression, null, 1, null) : null;
        Object object = constantValue2 != null ? constantValue2.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        if (number == null) {
            return false;
        }
        int rightValue = number.intValue();
        return rightValue == 1;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection$ReplaceWithUntilQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class ReplaceWithUntilQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Replace with until";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            KtExpression ktExpression;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression element3 = (KtExpression)psiElement2;
            Pair<KtExpression, KtExpression> pair2 = ReplaceUntilWithRangeToIntentionKt.getArguments(element3);
            if (pair2 == null) {
                return;
            }
            Pair<KtExpression, KtExpression> args = pair2;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression2 = (KtExpression)args.getFirst();
            if (ktExpression2 == null) {
                return;
            }
            objectArray[0] = ktExpression2;
            Object object = args.getSecond();
            if (!(object instanceof KtBinaryExpression)) {
                object = null;
            }
            if ((ktExpression = (KtBinaryExpression)object) == null || (ktExpression = ktExpression.getLeft()) == null) {
                return;
            }
            objectArray[1] = ktExpression;
            element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0 until $1", objectArray, false, 4, null));
        }
    }
}

