/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.intentions.ConvertPropertyToFunctionIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyToFunctionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "startInWriteAction", "Converter", "idea"})
public final class ConvertPropertyToFunctionIntention
extends SelfTargetingIntention<KtProperty>
implements LowPriorityAction {
    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        PsiElement identifier2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = identifier2 = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"identifier");
        if (!psiElement3.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        return element3.getDelegate() == null && !element3.isVar() && !element3.isLocal();
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        BindingContext context = ResolutionUtils.analyze$default(element3, null, 1, null);
        DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor descriptor2 = callableDescriptor;
        Project project = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        new Converter(project, descriptor2).run();
    }

    public ConvertPropertyToFunctionIntention() {
        super(KtProperty.class, "Convert property to function", null, 4, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyToFunctionIntention$Converter;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyToFunctionIntention;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)V", "newName", "", "convertProperty", "", "originalProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "performRefactoring", "descriptorsForChange", "", "idea"})
    private final class Converter
    extends CallableRefactoring<CallableDescriptor> {
        private final String newName;

        /*
         * WARNING - void declaration
         */
        private final void convertProperty(KtProperty originalProperty, KtPsiFactory psiFactory) {
            PsiElement psiElement2 = originalProperty.copy();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            KtProperty property2 = (KtProperty)psiElement2;
            KtPropertyAccessor getter = property2.getGetter();
            KtNamedFunction sampleFunction = psiFactory.createFunction("fun foo() {\n\n}");
            PsiElement psiElement3 = property2.getValOrVarKeyword();
            PsiElement psiElement4 = sampleFunction.getFunKeyword();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            psiElement3.replace(psiElement4);
            property2.addAfter((PsiElement)psiFactory.createParameterList("()"), property2.getNameIdentifier());
            if (property2.getInitializer() == null && getter != null) {
                Object element$iv3;
                block9: {
                    void $receiver$iv;
                    PsiElement psiElement5;
                    Sequence<PsiElement> sequence2;
                    Sequence<PsiElement> sequence3 = getter.getEqualsToken();
                    if (sequence3 == null) {
                        sequence3 = sequence2 = (PsiElement)getter.getBodyExpression();
                    }
                    if (sequence3 != null && (sequence2 = PsiUtilsKt.siblings((PsiElement)sequence2, false, false)) != null) {
                        Object v5;
                        block8: {
                            void $receiver$iv2;
                            Sequence<PsiElement> sequence4 = sequence2;
                            for (Object element$iv2 : $receiver$iv2) {
                                PsiElement it = (PsiElement)element$iv2;
                                if (!(!(it instanceof PsiWhiteSpace))) continue;
                                v5 = element$iv2;
                                break block8;
                            }
                            v5 = null;
                        }
                        psiElement5 = v5;
                    } else {
                        psiElement5 = null;
                    }
                    PsiElement dropGetterTo = psiElement5;
                    getter.deleteChildRange(getter.getFirstChild(), dropGetterTo);
                    Sequence<PsiElement> sequence5 = PsiUtilsKt.siblings(getter, false, false);
                    for (Object element$iv3 : $receiver$iv) {
                        PsiElement it = (PsiElement)element$iv3;
                        if (!(!(it instanceof PsiWhiteSpace))) continue;
                        break block9;
                    }
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                PsiElement dropPropertyFrom = ((PsiElement)element$iv3).getNextSibling();
                property2.deleteChildRange(dropPropertyFrom, getter.getPrevSibling());
            }
            property2.setName(this.newName);
            String string = property2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.text");
            originalProperty.replace(psiFactory.createFunction(string));
        }

        @Override
        protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
            Intrinsics.checkParameterIsNotNull(descriptorsForChange, (String)"descriptorsForChange");
            String propertyName = this.getCallableDescriptor().getName().asString();
            boolean nameChanged = Intrinsics.areEqual((Object)propertyName, (Object)this.newName) ^ true;
            String getterName = JvmAbi.getterName(this.getCallableDescriptor().getName().asString());
            MultiMap conflicts2 = new MultiMap();
            List<PsiElement> callables = CallableRefactoringKt.getAffectedCallables(this.getProject(), descriptorsForChange);
            ArrayList kotlinRefsToReplaceWithCall = new ArrayList();
            ArrayList refsToRename = new ArrayList();
            ArrayList javaRefsToReplaceWithCall = new ArrayList();
            ProgressUtilKt.runSynchronouslyWithProgress(this.getProject(), "Looking for usages and conflicts...", true, (Function0)new Function0<Unit>(this, callables, conflicts2, propertyName, kotlinRefsToReplaceWithCall, nameChanged, refsToRename, getterName, javaRefsToReplaceWithCall){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ List $callables;
                final /* synthetic */ MultiMap $conflicts;
                final /* synthetic */ String $propertyName;
                final /* synthetic */ ArrayList $kotlinRefsToReplaceWithCall;
                final /* synthetic */ boolean $nameChanged;
                final /* synthetic */ ArrayList $refsToRename;
                final /* synthetic */ String $getterName;
                final /* synthetic */ ArrayList $javaRefsToReplaceWithCall;

                public final void invoke() {
                    ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ performRefactoring.1 this$0;

                        public final void invoke() {
                            double progressStep = 1.0 / (double)this.this$0.$callables.size();
                            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)this.this$0.$callables)) {
                                PsiMethod psiMethod;
                                Object renderedCallable;
                                int i = indexedValue.component1();
                                PsiElement callable2 = (PsiElement)indexedValue.component2();
                                ProgressManager progressManager = ProgressManager.getInstance();
                                Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                                ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                                if (progressIndicator == null) {
                                    Intrinsics.throwNpe();
                                }
                                progressIndicator.setFraction((double)(i + 1) * progressStep);
                                if (!(callable2 instanceof PsiNamedElement)) continue;
                                if (!Converter.access$checkModifiable(this.this$0.this$0, callable2)) {
                                    String string = RefactoringUIUtil.getDescription((PsiElement)callable2, (boolean)true);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringUIUtil.getDescription(callable, true)");
                                    renderedCallable = StringsKt.capitalize((String)string);
                                    this.this$0.$conflicts.putValue((Object)callable2, (Object)("Can't modify " + (String)renderedCallable));
                                }
                                if (callable2 instanceof KtProperty) {
                                    Object object = CallableRefactoringKt.getContainingScope((DeclarationDescriptor)this.this$0.this$0.getCallableDescriptor());
                                    if (object != null) {
                                        HierarchicalScope hierarchicalScope = (HierarchicalScope)object;
                                        Name name2 = this.this$0.this$0.getCallableDescriptor().getName();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"callableDescriptor.name");
                                        object = ScopeUtilsKt.findFunction(hierarchicalScope, name2, NoLookupLocation.FROM_IDE, (Function1<? super FunctionDescriptor, Boolean>)((Function1)Converter.performRefactoring.1.INSTANCE));
                                        if (object != null) {
                                            Object it = renderedCallable = object;
                                            object = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.this$0.this$0.getProject(), (DeclarationDescriptor)it);
                                            if (object != null) {
                                                it = renderedCallable = object;
                                                KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)this.this$0.$conflicts, (PsiElement)it, (Function1<? super String, String>)((Function1)performRefactoring.3.1.INSTANCE));
                                            }
                                        }
                                    }
                                } else if (callable2 instanceof PsiMethod && (psiMethod = ((PsiMethod)callable2).getContainingClass()) != null && (psiMethod = psiMethod.findMethodsByName(this.this$0.$propertyName, true)) != null) {
                                    Object v9;
                                    PsiMethod $receiver$iv;
                                    block16: {
                                        renderedCallable = (Object[])psiMethod;
                                        int it = ((void)$receiver$iv).length;
                                        for (int $i$a$3$let = 0; $i$a$3$let < it; ++$i$a$3$let) {
                                            PsiMethod it2;
                                            void element$iv = $receiver$iv[$i$a$3$let];
                                            PsiMethod psiMethod2 = it2 = (PsiMethod)element$iv;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"it");
                                            PsiParameterList psiParameterList = psiMethod2.getParameterList();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"it.parameterList");
                                            if (!(psiParameterList.getParametersCount() == 0 && !CollectionsKt.contains((Iterable)this.this$0.$callables, (Object)((PsiElement)LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)it2))))) continue;
                                            v9 = element$iv;
                                            break block16;
                                        }
                                        v9 = null;
                                    }
                                    if ((psiMethod = (PsiMethod)v9) != null) {
                                        PsiMethod it = $receiver$iv = psiMethod;
                                        KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)this.this$0.$conflicts, (PsiElement)it, (Function1<? super String, String>)((Function1)performRefactoring.5.1.INSTANCE));
                                    }
                                }
                                Query usages2 = ReferencesSearch.search((PsiElement)callable2);
                                for (PsiReference usage : usages2) {
                                    Object refElement;
                                    if (usage instanceof KtReference) {
                                        if (usage instanceof KtSimpleNameReference) {
                                            PsiElement $receiver$iv;
                                            KtSimpleNameExpression expression2 = (KtSimpleNameExpression)((KtSimpleNameReference)usage).getExpression();
                                            if (CallUtilKt.getCall(expression2, ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL)) != null && PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = (PsiElement)expression2), KtCallableReferenceExpression.class, (boolean)true) == null) {
                                                this.this$0.$kotlinRefsToReplaceWithCall.add(expression2);
                                                continue;
                                            }
                                            if (!this.this$0.$nameChanged) continue;
                                            this.this$0.$refsToRename.add(usage);
                                            continue;
                                        }
                                        refElement = ((KtReference)usage).getElement();
                                        this.this$0.$conflicts.putValue(refElement, (Object)("Unrecognized reference will be skipped: " + StringUtil.htmlEmphasize((String)refElement.getText())));
                                        continue;
                                    }
                                    PsiReference psiReference = usage;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"usage");
                                    Object object = refElement = psiReference.getElement();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"refElement");
                                    String string = object.getText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"refElement.text");
                                    String string2 = this.this$0.$getterName;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getterName");
                                    if (StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
                                    if (usage instanceof PsiJavaReference) {
                                        if (!(usage.resolve() instanceof PsiField) || !(usage instanceof PsiReferenceExpression)) continue;
                                        this.this$0.$javaRefsToReplaceWithCall.add(usage);
                                        continue;
                                    }
                                    this.this$0.$conflicts.putValue(refElement, (Object)("Can't replace foreign reference with call expression: " + StringUtil.htmlEmphasize((String)refElement.getText())));
                                }
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = converter;
                    this.$callables = list2;
                    this.$conflicts = multiMap;
                    this.$propertyName = string;
                    this.$kotlinRefsToReplaceWithCall = arrayList;
                    this.$nameChanged = bl;
                    this.$refsToRename = arrayList2;
                    this.$getterName = string2;
                    this.$javaRefsToReplaceWithCall = arrayList3;
                    super(0);
                }
            });
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(this.getProject(), conflicts2, null, (Function0)new Function0<Unit>(this, kotlinRefsToReplaceWithCall, refsToRename, javaRefsToReplaceWithCall, callables){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ ArrayList $kotlinRefsToReplaceWithCall;
                final /* synthetic */ ArrayList $refsToRename;
                final /* synthetic */ ArrayList $javaRefsToReplaceWithCall;
                final /* synthetic */ List $callables;

                public final void invoke() {
                    ApplicationUtilsKt.executeWriteCommand(this.this$0.getProject(), this.this$0.ConvertPropertyToFunctionIntention.this.getText(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ performRefactoring.2 this$0;

                        public final void invoke() {
                            KtSimpleNameExpression it;
                            KtPsiFactory kotlinPsiFactory = new KtPsiFactory(this.this$0.this$0.getProject(), false, 2, null);
                            PsiElementFactory javaPsiFactory = PsiElementFactory.SERVICE.getInstance((Project)this.this$0.this$0.getProject());
                            KtExpression newKotlinCallExpr = kotlinPsiFactory.createExpression("" + Converter.access$getNewName$p(this.this$0.this$0) + "()");
                            Iterable $receiver$iv = this.this$0.$kotlinRefsToReplaceWithCall;
                            for (T element$iv : $receiver$iv) {
                                it = (KtSimpleNameExpression)element$iv;
                                it.replace((PsiElement)newKotlinCallExpr);
                            }
                            $receiver$iv = this.this$0.$refsToRename;
                            for (T element$iv : $receiver$iv) {
                                it = (PsiReference)element$iv;
                                it.handleElementRename(Converter.access$getNewName$p(this.this$0.this$0));
                            }
                            $receiver$iv = this.this$0.$javaRefsToReplaceWithCall;
                            for (T element$iv : $receiver$iv) {
                                it = (PsiReferenceExpression)element$iv;
                                PsiElement getterRef = it.handleElementRename(Converter.access$getNewName$p(this.this$0.this$0));
                                StringBuilder stringBuilder = new StringBuilder().append("");
                                PsiElement psiElement2 = getterRef;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"getterRef");
                                getterRef.replace((PsiElement)javaPsiFactory.createExpressionFromText(stringBuilder.append(psiElement2.getText()).append("()").toString(), null));
                            }
                            $receiver$iv = this.this$0.$callables;
                            for (T element$iv : $receiver$iv) {
                                it = (PsiElement)element$iv;
                                KtSimpleNameExpression ktSimpleNameExpression = it;
                                if (ktSimpleNameExpression instanceof KtProperty) {
                                    Converter.access$convertProperty(this.this$0.this$0, (KtProperty)((Object)it), kotlinPsiFactory);
                                    continue;
                                }
                                if (!(ktSimpleNameExpression instanceof PsiMethod)) continue;
                                ((PsiMethod)it).setName(Converter.access$getNewName$p(this.this$0.this$0));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = converter;
                    this.$kotlinRefsToReplaceWithCall = arrayList;
                    this.$refsToRename = arrayList2;
                    this.$javaRefsToReplaceWithCall = arrayList3;
                    this.$callables = list2;
                    super(0);
                }
            }, 2, null);
        }

        public Converter(@NotNull Project project, CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            super(project, descriptor2, ConvertPropertyToFunctionIntention.this.getText());
            String string = JvmAbi.getterName(this.getCallableDescriptor().getName().asString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JvmAbi.getterName(callab\u2026scriptor.name.asString())");
            this.newName = string;
        }

        public static final /* synthetic */ boolean access$checkModifiable(Converter $this, @NotNull PsiElement element3) {
            return $this.checkModifiable(element3);
        }

        @NotNull
        public static final /* synthetic */ String access$getNewName$p(Converter $this) {
            return $this.newName;
        }

        public static final /* synthetic */ void access$convertProperty(Converter $this, @NotNull KtProperty originalProperty, @NotNull KtPsiFactory psiFactory) {
            $this.convertProperty(originalProperty, psiFactory);
        }
    }
}

