/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationTarget;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationTargetFixKt;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingTraceContext;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0005H\u0002\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u000bH\u0002\u001a\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0011"}, d2={"addAnnotationTargets", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "annotationTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "asNameString", "", "getActualTargetList", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getRequiredAnnotationTargets", "annotationClass", "project", "Lcom/intellij/openapi/project/Project;", "toArgumentListString", "idea"})
public final class AddAnnotationTargetFixKt {
    /*
     * WARNING - void declaration
     */
    private static final List<KotlinTarget> getRequiredAnnotationTargets(@NotNull KtAnnotationEntry $receiver, KtClass annotationClass, Project project) {
        Object $receiver$iv$iv;
        PsiReference reference2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        List<KotlinTarget> requiredTargets = AddAnnotationTargetFixKt.getActualTargetList($receiver);
        if (requiredTargets.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
        GlobalSearchScope searchScope2 = SearchUtilKt.restrictToKotlinSources(globalSearchScope);
        Query query = ReferencesSearch.search((PsiElement)annotationClass, (SearchScope)((SearchScope)searchScope2));
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(\u2026tationClass, searchScope)");
        Iterable iterable = $receiver$iv = (Iterable)query;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<KotlinTarget> list2;
            Object it;
            Object $receiver$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            PsiReference psiReference = reference2 = (PsiReference)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"reference");
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference.getElement(), (String)"reference.element");
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtAnnotationEntry.class, (boolean)false);
            List<KotlinTarget> list3 = ktAnnotationEntry != null && (ktAnnotationEntry = Intrinsics.areEqual((Object)(it = ($receiver$iv2 = ktAnnotationEntry)), (Object)$receiver) ^ true ? $receiver$iv2 : null) != null ? AddAnnotationTargetFixKt.getActualTargetList(ktAnnotationEntry) : null;
            if (list3 == null) continue;
            List<KotlinTarget> it$iv$iv = list2 = list3;
            destination$iv$iv.add(it$iv$iv);
        }
        Set otherReferenceRequiredTargets = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        Object $receiver$iv3 = AnnotationTarget.values();
        destination$iv$iv = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(((Object[])$receiver$iv3).length);
        for (void item$iv$iv : $receiver$iv$iv) {
            void it;
            reference2 = (AnnotationTarget)item$iv$iv;
            Collection collection = destination$iv$iv2;
            String string = it.name();
            collection.add(string);
        }
        List annotationTargetValueNames = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv3 = (Iterable)CollectionsKt.plus((Collection)requiredTargets, (Iterable)otherReferenceRequiredTargets);
        destination$iv$iv2 = new ArrayList();
        Iterator iterator3 = $receiver$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv$iv = iterator3.next();
            KotlinTarget it = (KotlinTarget)((Object)element$iv$iv);
            if (!annotationTargetValueNames.contains(it.name())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private static final List<KotlinTarget> getActualTargetList(@NotNull KtAnnotationEntry $receiver) {
        PsiElement $receiver$iv = (PsiElement)$receiver;
        KtModifierList ktModifierList = (KtModifierList)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtModifierList.class, (boolean)true);
        Object object = ktModifierList != null ? ktModifierList.getOwner() : null;
        if (!(object instanceof KtElement)) {
            object = null;
        }
        KtElement ktElement = (KtElement)object;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement annotatedElement = ktElement;
        return AnnotationChecker.Companion.getDeclarationSiteActualTargetList(annotatedElement, null, new BindingTraceContext());
    }

    /*
     * WARNING - void declaration
     */
    private static final void addAnnotationTargets(@NotNull KtClass $receiver, List<? extends KotlinTarget> annotationTargets, KtPsiFactory psiFactory) {
        Object v3;
        Object object;
        String targetAnnotationName;
        block6: {
            targetAnnotationName = KotlinBuiltIns.FQ_NAMES.target.shortName().asString();
            List<KtAnnotationEntry> list2 = $receiver.getAnnotationEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationEntries");
            object = list2;
            Iterable iterable = object;
            for (Object object2 : iterable) {
                KtAnnotationEntry it;
                KtAnnotationEntry ktAnnotationEntry = it = (KtAnnotationEntry)object2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"it");
                KtTypeReference ktTypeReference = ktAnnotationEntry.getTypeReference();
                if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)targetAnnotationName)) continue;
                v3 = object2;
                break block6;
            }
            v3 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v3;
        if (ktAnnotationEntry == null) {
            Object $receiver2 = object = $receiver;
            String string = '@' + targetAnnotationName + "" + AddAnnotationTargetFixKt.toArgumentListString(annotationTargets);
            ((KtModifierListOwnerStub)$receiver2).addAnnotationEntry(psiFactory.createAnnotationEntry(string));
            return;
        }
        KtAnnotationEntry targetAnnotationEntry = ktAnnotationEntry;
        KtValueArgumentList valueArgumentList = targetAnnotationEntry.getValueArgumentList();
        if (valueArgumentList == null) {
            String text3 = AddAnnotationTargetFixKt.toArgumentListString(annotationTargets);
            targetAnnotationEntry.add((PsiElement)psiFactory.createCallArguments(text3));
        } else {
            void $receiver$iv$iv;
            Iterable iterable;
            List<? extends ValueArgument> list3 = targetAnnotationEntry.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"targetAnnotationEntry.valueArguments");
            Iterable $i$a$2$run = iterable = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                ValueArgument it = (ValueArgument)element$iv$iv;
                KtExpression ktExpression = it.getArgumentExpression();
                String string2 = ktExpression != null ? ktExpression.getText() : null;
                if (string2 == null) continue;
                String it$iv$iv = string = string2;
                destination$iv$iv.add(it$iv$iv);
            }
            List arguments2 = (List)destination$iv$iv;
            for (KotlinTarget kotlinTarget : annotationTargets) {
                String text4 = AddAnnotationTargetFixKt.asNameString(kotlinTarget);
                if (arguments2.contains(text4)) continue;
                valueArgumentList.addArgument(psiFactory.createArgument(text4));
            }
        }
    }

    private static final String toArgumentListString(@NotNull List<? extends KotlinTarget> $receiver) {
        return CollectionsKt.joinToString$default((Iterable)$receiver, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)toArgumentListString.1.INSTANCE, (int)24, null);
    }

    private static final String asNameString(@NotNull KotlinTarget $receiver) {
        return "" + KotlinBuiltIns.FQ_NAMES.annotationTarget.shortName().asString() + '.' + $receiver.name();
    }

    @NotNull
    public static final /* synthetic */ List access$getRequiredAnnotationTargets(@NotNull KtAnnotationEntry $receiver, @NotNull KtClass annotationClass, @NotNull Project project) {
        return AddAnnotationTargetFixKt.getRequiredAnnotationTargets($receiver, annotationClass, project);
    }

    public static final /* synthetic */ void access$addAnnotationTargets(@NotNull KtClass $receiver, @NotNull List annotationTargets, @NotNull KtPsiFactory psiFactory) {
        AddAnnotationTargetFixKt.addAnnotationTargets($receiver, annotationTargets, psiFactory);
    }

    @NotNull
    public static final /* synthetic */ String access$asNameString(@NotNull KotlinTarget $receiver) {
        return AddAnnotationTargetFixKt.asNameString($receiver);
    }
}

