/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.CommonBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/MoveFileToPackageMatchingDirectoryIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "startInWriteAction", "idea"})
public final class MoveFileToPackageMatchingDirectoryIntention
extends SelfTargetingOffsetIndependentIntention<KtPackageDirective> {
    @Override
    public boolean isApplicableTo(@NotNull KtPackageDirective element3) {
        String qualifiedName2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (KotlinRefactoringUtilKt.isInsideInjectedFragment(element3)) {
            return false;
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
        if (PackageUtilsKt.packageMatchesDirectory(ktFile)) {
            return false;
        }
        String string = qualifiedName2 = element3.getQualifiedName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifiedName");
        CharSequence charSequence = string;
        String dirName = charSequence.length() == 0 ? "source root" : '\'' + StringsKt.replace$default((String)qualifiedName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + '\'';
        this.setText("Move file to " + dirName);
        return true;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtPackageDirective element3, @Nullable Editor editor) {
        KtFile file2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtFile ktFile = file2 = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
        Project project = ktFile.getProject();
        List sourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)project);
        PackageWrapper packageWrapper = new PackageWrapper(PsiManager.getInstance((Project)project), element3.getQualifiedName());
        PsiFile fileToMove = element3.getContainingFile();
        List list2 = sourceRoots;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"sourceRoots");
        VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.singleOrNull((List)list2);
        if (virtualFile2 == null) {
            PsiFile psiFile = fileToMove;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"fileToMove");
            virtualFile2 = MoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)packageWrapper, (List)sourceRoots, (PsiDirectory)psiFile.getContainingDirectory());
        }
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile chosenRoot = virtualFile2;
        AutocreatingSingleSourceRootMoveDestination targetDirFactory = new AutocreatingSingleSourceRootMoveDestination(packageWrapper, chosenRoot);
        String string = targetDirFactory.verify(fileToMove);
        if (string != null) {
            String string2;
            String it = string2 = string;
            Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        PsiDirectory psiDirectory = (PsiDirectory)ApplicationUtilsKt.runWriteAction((Function0)new Function0<PsiDirectory>(targetDirFactory, fileToMove){
            final /* synthetic */ AutocreatingSingleSourceRootMoveDestination $targetDirFactory;
            final /* synthetic */ PsiFile $fileToMove;

            public final PsiDirectory invoke() {
                return this.$targetDirFactory.getTargetDirectory(this.$fileToMove);
            }
            {
                this.$targetDirFactory = autocreatingSingleSourceRootMoveDestination;
                this.$fileToMove = psiFile;
                super(0);
            }
        });
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory targetDirectory2 = psiDirectory;
        String string3 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDirectory2, (String)file2.getName());
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(file2, targetDirectory2){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ PsiDirectory $targetDirectory;

            public final void invoke() {
                MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)this.$file), (PsiDirectory)this.$targetDirectory);
            }
            {
                this.$file = ktFile;
                this.$targetDirectory = psiDirectory;
                super(0);
            }
        });
    }

    public MoveFileToPackageMatchingDirectoryIntention() {
        super(KtPackageDirective.class, "", "Move file to package-matching directory");
    }
}

