/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "entityName", "getDialogDescription", "getDialogTitle", "isSelectedByDefault", "", "processHierarchy", "", "idea"})
public final class AutomaticParameterRenamer
extends AutomaticRenamer {
    /*
     * WARNING - void declaration
     */
    private final void processHierarchy(KtParameter element3, String newName2) {
        KtDeclarationWithBody ktDeclarationWithBody = element3.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        KtDeclarationWithBody function2 = ktDeclarationWithBody;
        PsiElement psiElement2 = function2;
        KtDeclarationWithBody ktDeclarationWithBody2 = function2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclarationWithBody2, (String)"function");
        SearchScope searchScope2 = ktDeclarationWithBody2.getUseScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"function.useScope");
        Iterator iterator2 = OverridersSearchKt.searchOverriders(new HierarchySearchRequest(psiElement2, searchScope2, false, 4, null)).iterator();
        while (iterator2.hasNext()) {
            PsiNamedElement parameter;
            PsiNamedElement psiNamedElement;
            Object[] $receiver$iv;
            PsiNamedElement callable2;
            PsiMethod overrider;
            PsiMethod psiMethod = overrider = (PsiMethod)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"overrider");
            if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)psiMethod) == null) {
                continue;
            }
            if (!KotlinRefactoringUtilKt.canRefactor((PsiElement)callable2)) continue;
            Object object = callable2;
            if (object instanceof KtCallableDeclaration) {
                Object v7;
                block10: {
                    List<KtParameter> list2 = ((KtCallableDeclaration)callable2).getValueParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callable.valueParameters");
                    $receiver$iv = (Object[])list2;
                    for (Object t : $receiver$iv) {
                        KtParameter it;
                        KtParameter ktParameter = it = (KtParameter)t;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
                        if (!Intrinsics.areEqual((Object)ktParameter.getName(), (Object)element3.getName())) continue;
                        v7 = t;
                        break block10;
                    }
                    v7 = null;
                }
                psiNamedElement = v7;
            } else if (object instanceof PsiMethod) {
                Object object2;
                block11: {
                    void var11_14;
                    PsiParameterList psiParameterList = ((PsiMethod)callable2).getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"callable.parameterList");
                    PsiParameter[] psiParameterArray = psiParameterList.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"callable.parameterList.parameters");
                    $receiver$iv = psiParameterArray;
                    int n = $receiver$iv.length;
                    boolean bl = false;
                    while (var11_14 < n) {
                        PsiParameter it;
                        Object element$iv = $receiver$iv[var11_14];
                        PsiParameter psiParameter = it = (PsiParameter)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"it");
                        if (Intrinsics.areEqual((Object)psiParameter.getName(), (Object)element3.getName())) {
                            object2 = element$iv;
                            break block11;
                        }
                        ++var11_14;
                    }
                    object2 = null;
                }
                psiNamedElement = (PsiNamedElement)object2;
            } else {
                psiNamedElement = parameter = null;
            }
            if (parameter == null) continue;
            object = this.myElements;
            object.add(parameter);
        }
        this.suggestAllNames(element3.getName(), UtilsKt.quoteIfNeeded(newName2));
    }

    @NotNull
    public String getDialogTitle() {
        return "Rename Parameters";
    }

    @NotNull
    public String getDialogDescription() {
        return "Rename parameter in hierarchy to:";
    }

    @NotNull
    public String entityName() {
        return "Parameter";
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public AutomaticParameterRenamer(@NotNull KtParameter element3, @NotNull String newName2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        this.processHierarchy(element3, newName2);
    }
}

