/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0004\u001a\u0012\u0010\t\u001a\u00020\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a#\u0010\r\u001a\u00020\u0003*\u00020\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0005*\u00020\u0014\u001a.\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a\u0015\u0010\u001e\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002\u001a\r\u0010\u001f\u001a\u00020\u0005*\u00020\u0005H\u0086\u0002\u001a\u0015\u0010 \u001a\u00020\u0003*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0004\u001a\n\u0010!\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\"\u001a\u00020\u0005*\u00020\u00052\u0006\u0010#\u001a\u00020\u0010\u001a\u001a\u0010\"\u001a\n $*\u0004\u0018\u00010\u00030\u0003*\u00020\u00032\u0006\u0010#\u001a\u00020\u0010\u001a\n\u0010%\u001a\u00020\u0005*\u00020\u0005\u001a\u0012\u0010%\u001a\n $*\u0004\u0018\u00010\u00030\u0003*\u00020\u0003\u001a\u0012\u0010&\u001a\u00020\u0003*\u00020\u00032\u0006\u0010'\u001a\u00020\u0003\u00a8\u0006("}, d2={"isOnlyKotlinSearch", "", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/openapi/project/Project;", "and", "otherScope", "effectiveSearchScope", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "element", "Lcom/intellij/psi/PsiElement;", "excludeFileTypes", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/psi/search/SearchScope;[Lcom/intellij/openapi/fileTypes/FileType;)Lcom/intellij/psi/search/SearchScope;", "excludeKotlinSources", "fileScope", "Lcom/intellij/psi/PsiFile;", "isCheapEnoughToSearchConsideringOperators", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "Lcom/intellij/psi/search/PsiSearchHelper;", "name", "", "scope", "fileToIgnoreOccurrencesIn", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "minus", "not", "or", "projectScope", "restrictByFileType", "fileType", "kotlin.jvm.PlatformType", "restrictToKotlinSources", "unionSafe", "other", "idea-core"})
public final class SearchUtilKt {
    @NotNull
    public static final SearchScope and(@NotNull SearchScope $receiver, @NotNull SearchScope otherScope) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)otherScope, (String)"otherScope");
        SearchScope searchScope2 = $receiver.intersectWith(otherScope);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"intersectWith(otherScope)");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope or(@NotNull SearchScope $receiver, @NotNull SearchScope otherScope) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)otherScope, (String)"otherScope");
        SearchScope searchScope2 = $receiver.union(otherScope);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"union(otherScope)");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope minus(@NotNull SearchScope $receiver, @NotNull GlobalSearchScope otherScope) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)otherScope, (String)"otherScope");
        return SearchUtilKt.and($receiver, (SearchScope)SearchUtilKt.not(otherScope));
    }

    @NotNull
    public static final GlobalSearchScope not(@NotNull GlobalSearchScope $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.notScope(this)");
        return globalSearchScope;
    }

    @NotNull
    public static final SearchScope unionSafe(@NotNull SearchScope $receiver, @NotNull SearchScope other) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if ($receiver instanceof LocalSearchScope) {
            PsiElement[] psiElementArray = ((LocalSearchScope)$receiver).getScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"this.scope");
            objectArray = psiElementArray;
            if (objectArray.length == 0) {
                return other;
            }
        }
        if (other instanceof LocalSearchScope) {
            PsiElement[] psiElementArray = ((LocalSearchScope)other).getScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"other.scope");
            objectArray = psiElementArray;
            if (objectArray.length == 0) {
                return $receiver;
            }
        }
        SearchScope searchScope2 = $receiver.union(other);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"this.union(other)");
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope allScope(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(this)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope projectScope(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(this)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope fileScope(@NotNull PsiFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.fileScope(this)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope restrictByFileType(@NotNull GlobalSearchScope $receiver, @NotNull FileType fileType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)$receiver, (FileType[])new FileType[]{fileType});
    }

    /*
     * WARNING - void declaration
     */
    public static final SearchScope restrictByFileType(@NotNull SearchScope $receiver, @NotNull FileType fileType) {
        SearchScope searchScope2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        SearchScope searchScope3 = $receiver;
        if (searchScope3 instanceof GlobalSearchScope) {
            searchScope2 = (SearchScope)SearchUtilKt.restrictByFileType((GlobalSearchScope)$receiver, fileType);
        } else if (searchScope3 instanceof LocalSearchScope) {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            PsiElement[] psiElementArray = ((LocalSearchScope)$receiver).getScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"scope");
            Object[] objectArray = $receiver$iv = (Object[])psiElementArray;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                PsiElement it;
                PsiElement psiElement2 = it = (PsiElement)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it");
                PsiFile psiFile = psiElement2.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it.containingFile");
                if (!Intrinsics.areEqual((Object)psiFile.getFileType(), (Object)fileType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List elements2 = (List)destination$iv$iv;
            int n = elements2.size();
            if (n == 0) {
                searchScope2 = (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
            } else if (n == ((Object[])((LocalSearchScope)$receiver).getScope()).length) {
                searchScope2 = $receiver;
            } else {
                PsiElement[] psiElementArray2;
                Collection $receiver$iv2;
                Collection thisCollection$iv = $receiver$iv2 = (Collection)elements2;
                PsiElement[] psiElementArray3 = thisCollection$iv.toArray(new PsiElement[0]);
                if (psiElementArray3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                PsiElement[] psiElementArray4 = psiElementArray2 = psiElementArray3;
                searchScope2 = (SearchScope)new LocalSearchScope(psiElementArray4);
            }
        } else {
            searchScope2 = $receiver;
        }
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope restrictToKotlinSources(@NotNull GlobalSearchScope $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        return SearchUtilKt.restrictByFileType($receiver, (FileType)kotlinFileType);
    }

    public static final SearchScope restrictToKotlinSources(@NotNull SearchScope $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        return SearchUtilKt.restrictByFileType($receiver, (FileType)kotlinFileType);
    }

    @NotNull
    public static final SearchScope excludeKotlinSources(@NotNull SearchScope $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FileType[] fileTypeArray = new FileType[1];
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        fileTypeArray[0] = (FileType)kotlinFileType;
        return SearchUtilKt.excludeFileTypes($receiver, fileTypeArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SearchScope excludeFileTypes(@NotNull SearchScope $receiver, FileType ... fileTypes) {
        SearchScope searchScope2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fileTypes, (String)"fileTypes");
        if ($receiver instanceof GlobalSearchScope) {
            void $receiver$iv$iv;
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTypeRegistry, (String)"FileTypeRegistry.getInstance()");
            FileType[] fileTypeArray = fileTypeRegistry.getRegisteredFileTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTypeArray, (String)"FileTypeRegistry.getInstance().registeredFileTypes");
            Object $receiver$iv = fileTypeArray;
            Object[] objectArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                FileType it = (FileType)element$iv$iv;
                if (!(!ArraysKt.contains((Object[])fileTypes, (Object)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            FileType[] fileTypeArray2 = thisCollection$iv.toArray(new FileType[0]);
            if (fileTypeArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            FileType[] includedFileTypes = fileTypeArray2;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)$receiver), (FileType[])Arrays.copyOf(includedFileTypes, includedFileTypes.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.getSco\u2026this, *includedFileTypes)");
            searchScope2 = (SearchScope)globalSearchScope;
        } else {
            SearchScope searchScope3;
            void $receiver$iv$iv;
            Object $receiver$iv;
            LocalSearchScope cfr_ignored_0 = (LocalSearchScope)$receiver;
            PsiElement[] psiElementArray = ((LocalSearchScope)$receiver).getScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"scope");
            Object thisCollection$iv = $receiver$iv = (Object[])psiElementArray;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                PsiElement it = (PsiElement)element$iv$iv;
                Object[] objectArray = fileTypes;
                PsiElement psiElement2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it");
                PsiFile psiFile = psiElement2.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it.containingFile");
                if (!(!ArraysKt.contains((Object[])objectArray, (Object)psiFile.getFileType()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredElements = (List)destination$iv$iv;
            $receiver$iv = filteredElements;
            if (!$receiver$iv.isEmpty()) {
                PsiElement[] psiElementArray2;
                thisCollection$iv = $receiver$iv = (Collection)filteredElements;
                PsiElement[] psiElementArray3 = thisCollection$iv.toArray(new PsiElement[0]);
                if (psiElementArray3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                PsiElement[] psiElementArray4 = psiElementArray2 = psiElementArray3;
                searchScope3 = (SearchScope)new LocalSearchScope(psiElementArray4);
            } else {
                searchScope3 = (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
            }
            searchScope2 = searchScope3;
            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope3, (String)"if (filteredElements.isN\u2026alSearchScope.EMPTY_SCOPE");
        }
        return searchScope2;
    }

    @NotNull
    public static final SearchScope effectiveSearchScope(@NotNull ReferencesSearch.SearchParameters $receiver, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3, (Object)$receiver.getElementToSearch())) {
            SearchScope searchScope2 = $receiver.getEffectiveSearchScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"effectiveSearchScope");
            return searchScope2;
        }
        if ($receiver.isIgnoreAccessScope()) {
            SearchScope searchScope3 = $receiver.getScopeDeterminedByUser();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope3, (String)"scopeDeterminedByUser");
            return searchScope3;
        }
        SearchScope accessScope = PsiSearchHelper.SERVICE.getInstance((Project)element3.getProject()).getUseScope(element3);
        SearchScope searchScope4 = $receiver.getScopeDeterminedByUser().intersectWith(accessScope);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope4, (String)"scopeDeterminedByUser.intersectWith(accessScope)");
        return searchScope4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnlyKotlinSearch(@NotNull SearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        if (!(searchScope2 instanceof LocalSearchScope)) return false;
        PsiElement[] psiElementArray = ((LocalSearchScope)searchScope2).getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"searchScope.scope");
        Object[] $receiver$iv = psiElementArray;
        int n = $receiver$iv.length;
        int n2 = 0;
        while (n2 < n) {
            PsiElement it;
            Object element$iv = $receiver$iv[n2];
            PsiElement psiElement2 = it = (PsiElement)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it");
            if (!(psiElement2.getContainingFile() instanceof KtFile)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @NotNull
    public static final PsiSearchHelper.SearchCostResult isCheapEnoughToSearchConsideringOperators(@NotNull PsiSearchHelper $receiver, @NotNull String name2, @NotNull GlobalSearchScope scope2, @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        if (OperatorConventions.isConventionName(Name.identifier(name2))) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = $receiver.isCheapEnoughToSearch(name2, scope2, fileToIgnoreOccurrencesIn, progress2);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchCostResult, (String)"isCheapEnoughToSearch(na\u2026eOccurrencesIn, progress)");
        return searchCostResult;
    }
}

