/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser;", "", "()V", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParseResult;", "reader", "Ljava/io/Reader;", "MappingStream", "js.parser"})
public final class SourceMapParser {
    public static final SourceMapParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SourceMapParseResult parse(@NotNull Reader reader) throws IOException {
        List list2;
        Pair $i$a$1$map;
        Pair it;
        Iterable $receiver$iv;
        List list3;
        Object object;
        Object object2;
        void $receiver$iv$iv;
        Object destination$iv$iv;
        String string;
        JsonNode version;
        JsonNode jsonNode;
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        try {
            jsonNode = JSONKt.parseJson(reader);
        }
        catch (JsonSyntaxException e) {
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "parse error";
            }
            return new SourceMapError(string2);
        }
        JsonNode jsonObject = jsonNode;
        if (!(jsonObject instanceof JsonObject)) {
            return new SourceMapError("Top-level object expected");
        }
        JsonNode jsonNode2 = ((JsonObject)jsonObject).getProperties().get("version");
        if (jsonNode2 == null) {
            return new SourceMapError("Version not defined");
        }
        JsonNode it2 = e = (version = jsonNode2);
        if (!(version instanceof JsonNumber) || ((JsonNumber)version).getValue() != 3.0) {
            return new SourceMapError("Unsupported version: " + it2);
        }
        it2 = ((JsonObject)jsonObject).getProperties().get("sourceRoot");
        JsonNode it3 = it2;
        if (it3 != null) {
            JsonNode jsonNode3 = it3;
            if (!(jsonNode3 instanceof JsonString)) {
                jsonNode3 = null;
            }
            JsonString jsonString = (JsonString)jsonNode3;
            if (jsonString == null) {
                return new SourceMapError("'sourceRoot' property is not of string type");
            }
            string = jsonString.getValue();
        } else {
            string = "";
        }
        String sourceRoot = string;
        it3 = ((JsonObject)jsonObject).getProperties().get("sources");
        JsonNode it4 = it3;
        if (it4 != null) {
            Iterable $receiver$iv2;
            JsonNode jsonNode4 = it4;
            if (!(jsonNode4 instanceof JsonArray)) {
                jsonNode4 = null;
            }
            JsonArray jsonArray = (JsonArray)jsonNode4;
            if (jsonArray == null) {
                return new SourceMapError("'sources' property is not of array type");
            }
            JsonArray sourcesProperty = jsonArray;
            Iterable iterable = $receiver$iv2 = (Iterable)sourcesProperty.getElements();
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it5;
                JsonNode jsonNode5 = (JsonNode)item$iv$iv;
                object2 = destination$iv$iv;
                Object v7 = it5;
                if (!(v7 instanceof JsonString)) {
                    v7 = null;
                }
                JsonString jsonString = v7;
                if (jsonString == null) {
                    return new SourceMapError("'sources' array must contain strings");
                }
                object = jsonString.getValue();
                object2.add(object);
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List sources = list3;
        it4 = ((JsonObject)jsonObject).getProperties().get("sourcesContent");
        JsonNode it6 = it4;
        if (it6 != null) {
            void $receiver$iv$iv2;
            JsonNode jsonNode6 = it6;
            if (!(jsonNode6 instanceof JsonArray)) {
                jsonNode6 = null;
            }
            JsonArray jsonArray = (JsonArray)jsonNode6;
            if (jsonArray == null) {
                return new SourceMapError("'sourcesContent' property is not of array type");
            }
            JsonArray sourcesContentProperty = jsonArray;
            $receiver$iv = sourcesContentProperty.getElements();
            destination$iv$iv = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                String string3;
                object2 = (JsonNode)item$iv$iv;
                object = destination$iv$iv2;
                $i$a$1$map = it;
                if ($i$a$1$map instanceof JsonNull) {
                    string3 = null;
                } else if ($i$a$1$map instanceof JsonString) {
                    string3 = ((JsonString)it).getValue();
                } else {
                    return new SourceMapError("'sources' array must contain strings");
                }
                String $i$f$mapTo = string3;
                object.add($i$f$mapTo);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List sourcesContent = list2;
        Iterable $receiver$iv3 = CollectionsKt.zip((Iterable)sources, (Iterable)sourcesContent);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10)), (int)16);
        $receiver$iv = $receiver$iv3;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object item$iv$iv;
            item$iv$iv = destination$iv$iv;
            $i$a$1$map = it = (Pair)element$iv$iv;
            item$iv$iv.put((Object)$i$a$1$map.getFirst(), (Object)$i$a$1$map.getSecond());
        }
        Object sourcePathToContent = destination$iv$iv;
        JsonNode jsonNode7 = ((JsonObject)jsonObject).getProperties().get("mappings");
        if (jsonNode7 == null) {
            return new SourceMapError("'mappings' property not found");
        }
        JsonNode mappings = jsonNode7;
        if (!(mappings instanceof JsonString)) {
            return new SourceMapError("'mappings' property is not of string type");
        }
        int jsColumn = 0;
        int sourceLine = 0;
        int sourceColumn = 0;
        int sourceIndex = 0;
        MappingStream stream2 = new MappingStream(((JsonString)mappings).getValue());
        SourceMap sourceMap2 = new SourceMap((Function1<? super String, ? extends Reader>)((Function1)new Function1<String, StringReader>((Map)sourcePathToContent){
            final /* synthetic */ Map $sourcePathToContent;

            @Nullable
            public final StringReader invoke(@NotNull String it) {
                StringReader stringReader;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = (String)this.$sourcePathToContent.get(it);
                if (string != null) {
                    String string2;
                    String it2 = string2 = string;
                    stringReader = new StringReader(it2);
                } else {
                    stringReader = null;
                }
                return stringReader;
            }
            {
                this.$sourcePathToContent = map2;
                super(1);
            }
        }));
        Object it7 = object = new SourceMapGroup();
        Collection collection = sourceMap2.getGroups();
        collection.add(it7);
        Object currentGroup = object;
        while (!stream2.isEof()) {
            if (stream2.isGroupTerminator()) {
                it7 = object = new SourceMapGroup();
                collection = sourceMap2.getGroups();
                collection.add(it7);
                currentGroup = object;
                jsColumn = 0;
                stream2.skipChar();
                continue;
            }
            Integer n = stream2.readInt();
            if (n == null) {
                return stream2.createError("VLQ-encoded JS column number expected");
            }
            jsColumn += n.intValue();
            if (stream2.isEncodedInt()) {
                int n2;
                Integer n3 = stream2.readInt();
                if (n3 == null) {
                    return stream2.createError("VLQ-encoded source index expected");
                }
                sourceIndex += n3.intValue();
                Integer n4 = stream2.readInt();
                if (n4 == null) {
                    return stream2.createError("VLQ-encoded source line expected");
                }
                sourceLine += n4.intValue();
                Integer n5 = stream2.readInt();
                if (n5 == null) {
                    return stream2.createError("VLQ-encoded source column expected");
                }
                sourceColumn += n5.intValue();
                if (stream2.isEncodedInt()) {
                    Integer n6 = stream2.readInt();
                    if (n6 != null) {
                        n6.intValue();
                    } else {
                        return stream2.createError("VLQ-encoded name index expected");
                    }
                }
                if (0 > (n2 = sourceIndex) || ((Collection)sources).size() <= n2) {
                    return stream2.createError("Source index " + sourceIndex + " is out of bounds " + CollectionsKt.getIndices((Collection)sources));
                }
                object = ((SourceMapGroup)currentGroup).getSegments();
                it7 = new SourceMapSegment(jsColumn, sourceRoot + (String)sources.get(sourceIndex), sourceLine, sourceColumn);
                object.add(it7);
            } else {
                object = ((SourceMapGroup)currentGroup).getSegments();
                it7 = new SourceMapSegment(jsColumn, null, -1, -1);
                object.add(it7);
            }
            if (stream2.isEof()) {
                return stream2.createError("Unexpected EOF, ',' or ';' expected");
            }
            if (stream2.isGroupTerminator()) {
                it7 = object = new SourceMapGroup();
                collection = sourceMap2.getGroups();
                collection.add(it7);
                currentGroup = object;
                jsColumn = 0;
            } else if (!stream2.isSegmentTerminator()) {
                return stream2.createError("Unexpected char, ',' or ';' expected");
            }
            stream2.skipChar();
        }
        return new SourceMapSuccess(sourceMap2);
    }

    private SourceMapParser() {
    }

    static {
        SourceMapParser sourceMapParser;
        INSTANCE = sourceMapParser = new SourceMapParser();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\r\u0010\u001a\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser$MappingStream;", "", "string", "", "(Ljava/lang/String;)V", "isEncodedInt", "", "()Z", "isEof", "isGroupTerminator", "isSegmentTerminator", "position", "", "getPosition", "()I", "setPosition", "(I)V", "getString", "()Ljava/lang/String;", "base64value", "c", "", "(C)Ljava/lang/Integer;", "createError", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapError;", "error", "readInt", "()Ljava/lang/Integer;", "skipChar", "", "js.parser"})
    public static final class MappingStream {
        private int position;
        @NotNull
        private final String string;

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final boolean isEof() {
            return this.position == this.string.length();
        }

        public final boolean isSegmentTerminator() {
            return this.string.charAt(this.position) == ',';
        }

        public final boolean isGroupTerminator() {
            return this.string.charAt(this.position) == ';';
        }

        public final boolean isEncodedInt() {
            return !this.isEof() && !this.isSegmentTerminator() && !this.isGroupTerminator();
        }

        public final void skipChar() {
            int n = this.position;
            this.position = n + 1;
        }

        @Nullable
        public final Integer readInt() {
            int value2 = 0;
            int shift = 0;
            while (true) {
                if (this.isEof()) {
                    return null;
                }
                int n = this.position;
                this.position = n + 1;
                Integer n2 = this.base64value(this.string.charAt(n));
                if (n2 == null) {
                    return null;
                }
                int digit = n2;
                int digitValue = digit & 0x1F;
                value2 |= digitValue << shift;
                if ((digit & 0x20) == 0) break;
                shift += 5;
            }
            int unsignedValue = value2 >>> 1;
            return (value2 & 1) == 0 ? Integer.valueOf(unsignedValue) : Integer.valueOf(-unsignedValue);
        }

        private final Integer base64value(char c) {
            char c2 = c;
            char c3 = c2;
            return 'A' <= c3 && 'Z' >= c3 ? Integer.valueOf(c - 65) : ('a' <= (c3 = c2) && 'z' >= c3 ? Integer.valueOf(c - 97 + 26) : ('0' <= (c3 = c2) && '9' >= c3 ? Integer.valueOf(c - 48 + 52) : (c2 == '+' ? Integer.valueOf(62) : (c2 == '/' ? Integer.valueOf(63) : null))));
        }

        @NotNull
        public final SourceMapError createError(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            return new SourceMapError("Error parsing stream at offset " + this.position + ": " + error);
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public MappingStream(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            this.string = string;
        }
    }
}

