/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.SmartList;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMultipleContextsManager {
    private static final FileAttribute CURRENT_SPRING_CONTEXT = new FileAttribute("spring_context", 1, false);

    public static SpringMultipleContextsManager getInstance() {
        return (SpringMultipleContextsManager)ServiceManager.getService(SpringMultipleContextsManager.class);
    }

    @NotNull
    public SpringContextDescriptor getContextDescriptor(@NotNull PsiFile file) {
        SpringContextDescriptor cached;
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(0);
        }
        if ((cached = this.getCachedContextDescriptor(file)) != null) {
            SpringContextDescriptor springContextDescriptor = cached;
            if (springContextDescriptor == null) {
                SpringMultipleContextsManager.$$$reportNull$$$0(1);
            }
            return springContextDescriptor;
        }
        SpringContextDescriptor descriptor = this.calculateDescriptor(file);
        file.putUserData(SpringContextDescriptor.KEY, (Object)descriptor);
        SpringContextDescriptor springContextDescriptor = descriptor;
        if (springContextDescriptor == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(2);
        }
        return springContextDescriptor;
    }

    @Nullable
    public SpringContextDescriptor getCachedContextDescriptor(@NotNull PsiFile file) {
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(3);
        }
        PsiFile originalFile = file.getOriginalFile();
        return (SpringContextDescriptor)originalFile.getUserData(SpringContextDescriptor.KEY);
    }

    @NotNull
    List<SpringContextDescriptor> getAllContextDescriptors(@NotNull PsiFile psiFile) {
        Set<SpringModel> modelsByFile;
        if (psiFile == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(4);
        }
        if ((modelsByFile = SpringManager.getInstance(psiFile.getProject()).getSpringModelsByFile(psiFile)).size() <= 1) {
            List<SpringContextDescriptor> list = Collections.emptyList();
            if (list == null) {
                SpringMultipleContextsManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        SmartList descriptors = new SmartList();
        ArrayList<SpringContextDescriptor> localFileDescriptors = new ArrayList<SpringContextDescriptor>();
        for (SpringModel model : modelsByFile) {
            VirtualFile virtualFile;
            SpringFileSet fileSet = model.getFileSet();
            if (fileSet == null) {
                List<SpringContextDescriptor> list = Collections.emptyList();
                if (list == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<VirtualFilePointer> files = fileSet.getFiles();
            boolean isLocal = false;
            if (files.size() == 1 && (virtualFile = files.get(0).getFile()) != null && virtualFile.equals(psiFile.getVirtualFile())) {
                isLocal = true;
            }
            SpringContextDescriptor descriptor = SpringMultipleContextsManager.createDescriptor(model, fileSet);
            if (isLocal) {
                localFileDescriptors.add(descriptor);
                continue;
            }
            descriptors.add(descriptor);
        }
        if (!descriptors.isEmpty()) {
            descriptors.addAll(localFileDescriptors);
            Collections.sort(descriptors, (o, o1) -> o.getName().compareTo(o1.getName()));
        }
        SmartList smartList = descriptors;
        if (smartList == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static SpringContextDescriptor createDescriptor(@NotNull SpringModel model, @NotNull SpringFileSet fileSet) {
        if (model == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(8);
        }
        if (fileSet == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(9);
        }
        final String qualifiedName = fileSet.getQualifiedName();
        return new SpringContextDescriptor(model.getModule(), fileSet.getId(), fileSet.getName()){

            @Override
            @NotNull
            public String getQualifiedName() {
                String string = qualifiedName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager$1", "getQualifiedName"));
            }
        };
    }

    void persistDescriptor(@NotNull PsiFile file, @NotNull SpringContextDescriptor descriptor) {
        VirtualFile virtualFile;
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(10);
        }
        if (descriptor == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(11);
        }
        if ((virtualFile = file.getVirtualFile()) == null || virtualFile.isDirectory()) {
            return;
        }
        file.putUserData(SpringContextDescriptor.KEY, (Object)descriptor);
        String id = descriptor.getQualifiedName();
        try (DataOutputStream outputStream = CURRENT_SPRING_CONTEXT.writeAttribute(virtualFile);){
            outputStream.writeUTF(StringUtil.notNullize((String)id));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getPersistedDescriptor(@NotNull PsiFile file) {
        block7: {
            String string;
            VirtualFile virtualFile;
            if (file == null) {
                SpringMultipleContextsManager.$$$reportNull$$$0(12);
            }
            if ((virtualFile = file.getVirtualFile()) == null || virtualFile.isDirectory()) {
                return null;
            }
            DataInputStream inputStream = CURRENT_SPRING_CONTEXT.readAttribute(virtualFile);
            if (inputStream == null) break block7;
            try {
                string = inputStream.readUTF();
            }
            catch (Throwable throwable) {
                try {
                    StreamUtil.closeStream((Closeable)inputStream);
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            StreamUtil.closeStream((Closeable)inputStream);
            return string;
        }
        return null;
    }

    @NotNull
    private SpringContextDescriptor calculateDescriptor(@NotNull PsiFile file) {
        Module currentModule;
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(13);
        }
        List<SpringContextDescriptor> descriptors = null;
        String qualifiedName = SpringMultipleContextsManager.getPersistedDescriptor(file);
        if (qualifiedName != null) {
            if (qualifiedName.equals(SpringContextDescriptor.LOCAL_CONTEXT.getQualifiedName())) {
                SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.LOCAL_CONTEXT;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(14);
                }
                return springContextDescriptor;
            }
            if (qualifiedName.equals(SpringContextDescriptor.ALL_CONTEXTS.getQualifiedName())) {
                SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.ALL_CONTEXTS;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(15);
                }
                return springContextDescriptor;
            }
            descriptors = this.getAllContextDescriptors(file);
            for (SpringContextDescriptor descriptor : descriptors) {
                if (!qualifiedName.equals(descriptor.getQualifiedName())) continue;
                SpringContextDescriptor springContextDescriptor = descriptor;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(16);
                }
                return springContextDescriptor;
            }
        }
        if ((currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null) {
            if (descriptors == null) {
                descriptors = this.getAllContextDescriptors(file);
            }
            for (SpringContextDescriptor descriptor : descriptors) {
                if (!currentModule.equals(descriptor.getModule())) continue;
                SpringContextDescriptor springContextDescriptor = descriptor;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(17);
                }
                return springContextDescriptor;
            }
        }
        SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.DEFAULT;
        if (springContextDescriptor == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(18);
        }
        return springContextDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContextDescriptors";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachedContextDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllContextDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "persistDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPersistedDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calculateDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

