/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSpringModelImpl
extends XmlSpringModel {
    @NotNull
    private final Set<XmlFile> myConfigFiles;

    public XmlSpringModelImpl(@NotNull Set<XmlFile> configFiles, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (configFiles == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(1);
        }
        super(module, fileSet);
        this.myConfigFiles = configFiles;
    }

    @Override
    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        models.addAll(this.getLocalSpringModels());
        models.addAll(this.getDependencies());
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @Override
    public Set<LocalXmlModel> getLocalSpringModels() {
        SpringFileSet fileSet = this.getFileSet();
        Set<String> activeProfiles = fileSet == null ? this.getActiveProfiles() : fileSet.getActiveProfiles();
        return new LinkedHashSet<LocalXmlModel>(ContainerUtil.mapNotNull(this.getXmlConfigFiles(), xmlFile -> SpringCachedModelFactory.getOrCreateLocalXmlModel(xmlFile, this.getModule(), activeProfiles)));
    }

    @Override
    @NotNull
    public Set<String> getAllProfiles() {
        LinkedHashSet<String> profiles = new LinkedHashSet<String>();
        for (CommonSpringModel commonSpringModel : this.getLocalSpringModels()) {
            profiles.addAll(commonSpringModel.getAllProfiles());
        }
        LinkedHashSet<String> linkedHashSet = profiles;
        if (linkedHashSet == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Set<XmlFile> getXmlConfigFiles() {
        Set<XmlFile> set = this.myConfigFiles;
        if (set == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(5);
        }
        if (configFile instanceof XmlFile) {
            if (this.myConfigFiles.contains(configFile)) {
                return true;
            }
            if (this.hasImportedConfigs((XmlFile)configFile)) {
                return true;
            }
        }
        for (SpringModel model : this.getDependencies()) {
            ProgressManager.checkCanceled();
            if (!model.hasConfigFile(configFile)) continue;
            return true;
        }
        return false;
    }

    private boolean hasImportedConfigs(final @NotNull XmlFile file) {
        if (file == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(6);
        }
        CommonProcessors.FindProcessor<CommonSpringModel> findProcessor = new CommonProcessors.FindProcessor<CommonSpringModel>(){

            protected boolean accept(CommonSpringModel model) {
                return model instanceof LocalXmlModel && ((XmlFile)((LocalXmlModel)model).getConfig()).equals(file);
            }
        };
        for (LocalXmlModel model : this.getLocalSpringModels()) {
            if (model.processRelatedModels((Processor<CommonSpringModel>)findProcessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<DomFileElement<Beans>> getLocalModelsRoots() {
        Set<LocalXmlModel> localModels = this.getLocalSpringModels();
        LinkedHashSet<DomFileElement<Beans>> set = new LinkedHashSet<DomFileElement<Beans>>(localModels.size());
        for (LocalXmlModel localXmlModel : localModels) {
            DomFileElement<Beans> root = localXmlModel.getRoot();
            ContainerUtil.addIfNotNull(set, root);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/XmlSpringModelImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/XmlSpringModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsToProcess";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasImportedConfigs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

