/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.AbstractSimpleLocalModel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelDiagramNodeContentManager;
import com.intellij.spring.contexts.model.diagram.SpringNodeGroupRealizer;
import com.intellij.spring.contexts.model.diagram.beans.FilesetLocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.ModuleLocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDependencyEdge;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDiagramNode;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.SpringProfile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringLocalModelsDataModel
extends DiagramDataModel<LocalModelGraphElementWrapper> {
    private final ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter;
    @NotNull
    private final LocalModelGraphElementWrapper myModel;
    @NotNull
    private final SpringLocalModelDiagramNode myRootNode;
    private final boolean showModuleFilesetNodes;
    private final Collection<SpringLocalModelDiagramNode> myNodes;
    private final Collection<SpringLocalModelDependencyEdge> myEdges;
    private final Map<String, NodesGroup> myNodesGroups;

    public SpringLocalModelsDataModel(@NotNull Project project, @NotNull DiagramProvider<LocalModelGraphElementWrapper> provider, @NotNull LocalModelGraphElementWrapper model, boolean showModuleFilesetNodes) {
        if (project == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(2);
        }
        super(project, provider);
        this.myNodes = ContainerUtil.newLinkedHashSet();
        this.myEdges = ContainerUtil.newLinkedHashSet();
        this.myNodesGroups = ContainerUtil.newLinkedHashMap();
        this.myModel = model;
        this.myRootNode = new SpringLocalModelDiagramNode(model, provider);
        this.showModuleFilesetNodes = showModuleFilesetNodes;
        DomEventListener domEventListener = new DomEventListener(){

            public void eventOccured(DomEvent event) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }
        };
        DomManager.getDomManager((Project)project).addDomEventListener(domEventListener, (Disposable)this);
        this.myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(SpringFacet facet) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            public void facetRemoved(SpringFacet facet) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            public void facetAdded(SpringFacet facet) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }
        });
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        messageBusConnection.subscribe(ProjectTopics.MODULES);
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC);
    }

    @NotNull
    public Collection<? extends DiagramNode<LocalModelGraphElementWrapper>> getNodes() {
        Collection<SpringLocalModelDiagramNode> collection = this.myNodes;
        if (collection == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<LocalModelGraphElementWrapper>> getEdges() {
        Collection<SpringLocalModelDependencyEdge> collection = this.myEdges;
        if (collection == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<LocalModelGraphElementWrapper> n) {
        String string = ((LocalModelGraphElementWrapper)n.getIdentifyingElement()).getTitle();
        if (string == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public DiagramNode<LocalModelGraphElementWrapper> addElement(LocalModelGraphElementWrapper element) {
        return null;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    protected void updateDataModel() {
        RelatedVisitor visitor = new RelatedVisitor(this.getProject());
        this.myModel.accept(visitor);
    }

    @NotNull
    private SpringLocalModelDiagramNode getDiagramNode(@NotNull LocalModelGraphElementWrapper model) {
        if (model == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(6);
        }
        if (model.equals(this.myRootNode.getIdentifyingElement())) {
            SpringLocalModelDiagramNode springLocalModelDiagramNode = this.myRootNode;
            if (springLocalModelDiagramNode == null) {
                SpringLocalModelsDataModel.$$$reportNull$$$0(7);
            }
            return springLocalModelDiagramNode;
        }
        for (SpringLocalModelDiagramNode node : this.myNodes) {
            if (!model.equals(node.getIdentifyingElement())) continue;
            SpringLocalModelDiagramNode springLocalModelDiagramNode = node;
            if (springLocalModelDiagramNode == null) {
                SpringLocalModelsDataModel.$$$reportNull$$$0(8);
            }
            return springLocalModelDiagramNode;
        }
        SpringLocalModelDiagramNode springLocalModelDiagramNode = new SpringLocalModelDiagramNode(model, (DiagramProvider<LocalModelGraphElementWrapper>)this.getProvider());
        if (springLocalModelDiagramNode == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(9);
        }
        return springLocalModelDiagramNode;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SpringLocalModelsDataModel springLocalModelsDataModel = this;
        if (springLocalModelsDataModel == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(10);
        }
        return springLocalModelsDataModel;
    }

    public void dispose() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).unregisterListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter);
    }

    @NotNull
    public SpringLocalModelDiagramNode getRootNode() {
        SpringLocalModelDiagramNode springLocalModelDiagramNode = this.myNodes.iterator().next();
        if (springLocalModelDiagramNode == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(11);
        }
        return springLocalModelDiagramNode;
    }

    private static boolean isLibraryConfig(LocalModelGraphElementWrapper element) {
        if (element instanceof LocalModelWrapper) {
            LocalModel localModel = (LocalModel)element.getElement();
            Project project = localModel.getConfig().getProject();
            return ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(localModel.getConfig().getContainingFile().getVirtualFile());
        }
        return false;
    }

    private boolean showLibraryConfigs() {
        DiagramState diagramState = new DiagramState(this.getBuilder());
        return diagramState.isCategoryEnabled(SpringLocalModelDiagramNodeContentManager.SHOW_LIBRARY_CONFIGS);
    }

    private boolean showFilesetsAsGroups() {
        DiagramState diagramState = new DiagramState(this.getBuilder());
        return diagramState.isCategoryEnabled(SpringLocalModelDiagramNodeContentManager.SHOW_GROUPS);
    }

    public NodesGroup getGroup(DiagramNode<LocalModelGraphElementWrapper> n) {
        SpringFileSet localModelFileSet;
        LocalModelGraphElementWrapper elementWrapper;
        if (!this.showModuleFilesetNodes && this.showFilesetsAsGroups() && (elementWrapper = (LocalModelGraphElementWrapper)n.getIdentifyingElement()) instanceof LocalModelWrapper && (localModelFileSet = SpringLocalModelsDataModel.getFileSetLocalModelConfiguredIn((LocalModel)((LocalModelWrapper)elementWrapper).getElement())) != null) {
            String fileSetName = localModelFileSet.getName();
            NodesGroup group = this.myNodesGroups.get(fileSetName);
            if (group == null) {
                group = new SpringNodeGroupRealizer(fileSetName);
                this.myNodesGroups.put(fileSetName, group);
            }
            return group;
        }
        return super.getGroup(n);
    }

    public void removeEdge(DiagramEdge<LocalModelGraphElementWrapper> edge) {
        if (edge instanceof SpringLocalModelDependencyEdge) {
            SpringLocalModelDependencyEdge localModelDependencyEdge = (SpringLocalModelDependencyEdge)edge;
            PsiElement dependencyIdentifyingElement = localModelDependencyEdge.getDependency().getIdentifyingElement();
            if (dependencyIdentifyingElement == null) {
                return;
            }
            List<SpringLocalModelDependencyEdge> edges = this.getEdgesByIdentifyingElement(dependencyIdentifyingElement);
            if (edges.size() > 1) {
                return;
            }
            Runnable runnable = () -> ((PsiElement)dependencyIdentifyingElement).delete();
            DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), (Runnable)runnable, (String)"Remove edge", null, (PsiElement[])new PsiElement[]{dependencyIdentifyingElement.getContainingFile()});
        }
    }

    private List<SpringLocalModelDependencyEdge> getEdgesByIdentifyingElement(@NotNull PsiElement dependencyIdentifyingElement) {
        if (dependencyIdentifyingElement == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(12);
        }
        PsiElement myNavigationElement = dependencyIdentifyingElement.getNavigationElement();
        return ContainerUtil.filter(this.myEdges, edge -> {
            PsiElement otherElement = edge.getDependency().getIdentifyingElement();
            return otherElement != null && myNavigationElement.equals(otherElement.getNavigationElement());
        });
    }

    private static SpringFileSet getFileSetLocalModelConfiguredIn(@NotNull LocalModel localModel) {
        SpringFacet facet;
        Module module;
        if (localModel == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(13);
        }
        if ((module = localModel.getModule()) != null && (facet = SpringFacet.getInstance(module)) != null) {
            Set<SpringFileSet> fileSets = SpringFileSetService.getInstance().getAllSets(facet);
            for (SpringFileSet fileSet : fileSets) {
                if (!fileSet.hasFile(localModel.getConfig().getContainingFile().getVirtualFile())) continue;
                return fileSet;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyIdentifyingElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagramNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDiagramNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEdgesByIdentifyingElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileSetLocalModelConfiguredIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class RelatedVisitor {
        private final Project project;
        private final SpringManager springManager;

        private RelatedVisitor(Project project) {
            this.project = project;
            this.springManager = SpringManager.getInstance(project);
        }

        public void visitLocalModel(@NotNull LocalModel model) {
            Module module;
            if (model == null) {
                RelatedVisitor.$$$reportNull$$$0(0);
            }
            if ((module = model.getModule()) == null || module.isDisposed()) {
                return;
            }
            Set<String> profiles = model.getActiveProfiles();
            LazyModelDependenciesGraph graph = AbstractSimpleLocalModel.getOrCreateLocalModelDependenciesGraph(module, profiles == null ? SpringProfile.DEFAULT.getNames() : profiles);
            SpringLocalModelDiagramNode node = SpringLocalModelsDataModel.this.getDiagramNode(LocalModelWrapper.create(model));
            SpringLocalModelsDataModel.this.myNodes.add(node);
            this.visitRelated(node, graph);
        }

        public void visitModule(@NotNull Module module) {
            if (module == null) {
                RelatedVisitor.$$$reportNull$$$0(1);
            }
            if (module.isDisposed()) {
                return;
            }
            SpringFacet springFacet = SpringFacet.getInstance(module);
            if (springFacet == null) {
                return;
            }
            SpringLocalModelDiagramNode moduleNode = null;
            if (SpringLocalModelsDataModel.this.showModuleFilesetNodes) {
                moduleNode = SpringLocalModelsDataModel.this.getDiagramNode(ModuleLocalModelWrapper.create(module));
                SpringLocalModelsDataModel.this.myNodes.add(moduleNode);
            }
            for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(springFacet)) {
                SpringLocalModelDiagramNode toNode = null;
                if (SpringLocalModelsDataModel.this.showModuleFilesetNodes) {
                    toNode = SpringLocalModelsDataModel.this.getDiagramNode(FilesetLocalModelWrapper.create(fileSet));
                    SpringLocalModelsDataModel.this.myNodes.add(toNode);
                    moduleNode.addChild(toNode);
                    SpringLocalModelDependencyEdge edge = new SpringLocalModelDependencyEdge((DiagramNode<LocalModelGraphElementWrapper>)moduleNode, (DiagramNode<LocalModelGraphElementWrapper>)toNode, LocalModelDependency.create());
                    SpringLocalModelsDataModel.this.myEdges.add(edge);
                }
                this.visitFileSet(toNode, fileSet);
            }
        }

        public void visitFileSet(@NotNull SpringFileSet fileSet) {
            if (fileSet == null) {
                RelatedVisitor.$$$reportNull$$$0(2);
            }
            SpringLocalModelDiagramNode node = null;
            if (SpringLocalModelsDataModel.this.showModuleFilesetNodes) {
                node = SpringLocalModelsDataModel.this.getDiagramNode(FilesetLocalModelWrapper.create(fileSet));
                SpringLocalModelsDataModel.this.myNodes.add(node);
            }
            this.visitFileSet(node, fileSet);
        }

        private void visitFileSet(@Nullable SpringLocalModelDiagramNode node, @NotNull SpringFileSet fileSet) {
            if (fileSet == null) {
                RelatedVisitor.$$$reportNull$$$0(3);
            }
            Module module = fileSet.getFacet().getModule();
            Set<String> profiles = fileSet.getActiveProfiles();
            LazyModelDependenciesGraph graph = AbstractSimpleLocalModel.getOrCreateLocalModelDependenciesGraph(module, profiles);
            List<VirtualFilePointer> files = fileSet.getFiles();
            for (VirtualFilePointer file : files) {
                PsiClass[] psiClasses;
                VirtualFile virtualFile = file.getFile();
                if (virtualFile == null || !SpringLocalModelsDataModel.this.showLibraryConfigs() && ProjectRootManager.getInstance((Project)this.project).getFileIndex().isInLibraryClasses(virtualFile)) continue;
                PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
                if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
                    LocalXmlModel model = this.springManager.getLocalSpringModel((XmlFile)psiFile, module);
                    if (model == null) continue;
                    this.createEdgeToLocalModelAndVisitIt(node, graph, LocalModelWrapper.create(model), LocalModelDependency.create());
                    continue;
                }
                if (!(psiFile instanceof PsiClassOwner)) continue;
                PsiClassOwner classOwner = (PsiClassOwner)psiFile;
                for (PsiClass psiClass : psiClasses = classOwner.getClasses()) {
                    LocalAnnotationModel model = this.springManager.getLocalSpringModel(psiClass, module);
                    if (model == null) continue;
                    this.createEdgeToLocalModelAndVisitIt(node, graph, LocalModelWrapper.create(model), LocalModelDependency.create());
                }
            }
        }

        private void visitRelated(@NotNull SpringLocalModelDiagramNode fromNode, @NotNull LazyModelDependenciesGraph graph) {
            if (fromNode == null) {
                RelatedVisitor.$$$reportNull$$$0(4);
            }
            if (graph == null) {
                RelatedVisitor.$$$reportNull$$$0(5);
            }
            for (Pair to : graph.getOrCreateOutDependencies(((LocalModelWrapper)fromNode.getIdentifyingElement()).getElement())) {
                this.createEdgeToLocalModelAndVisitIt(fromNode, graph, LocalModelWrapper.create((LocalModel)to.first), (LocalModelDependency)to.second);
            }
        }

        private void createEdgeToLocalModelAndVisitIt(@Nullable SpringLocalModelDiagramNode fromNode, @NotNull LazyModelDependenciesGraph graph, LocalModelWrapper toNodeLocalModelWrapper, LocalModelDependency dependency) {
            SpringLocalModelDiagramNode toNode;
            if (graph == null) {
                RelatedVisitor.$$$reportNull$$$0(6);
            }
            if ((toNode = SpringLocalModelsDataModel.this.getDiagramNode(toNodeLocalModelWrapper)) == fromNode) {
                return;
            }
            boolean error = false;
            if (!SpringLocalModelsDataModel.this.myNodes.contains((Object)toNode)) {
                SpringLocalModelsDataModel.this.myNodes.add(toNode);
                if (SpringLocalModelsDataModel.this.showLibraryConfigs() || !SpringLocalModelsDataModel.isLibraryConfig(toNode.getIdentifyingElement())) {
                    this.visitRelated(toNode, graph);
                }
            } else {
                error = true;
            }
            if (fromNode != null) {
                SpringLocalModelDependencyEdge edge = new SpringLocalModelDependencyEdge((DiagramNode<LocalModelGraphElementWrapper>)fromNode, (DiagramNode<LocalModelGraphElementWrapper>)toNode, dependency);
                if (error) {
                    edge.setError(true);
                } else {
                    fromNode.addChild(toNode);
                }
                SpringLocalModelsDataModel.this.myEdges.add(edge);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileSet";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromNode";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModule";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFileSet";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRelated";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createEdgeToLocalModelAndVisitIt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

