/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.FrameworkSupportWithLibrary;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurator;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.SpringProjectCategory;
import com.intellij.spring.library.SpringLibraryType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<SpringFacet> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.facet.SpringFrameworkSupportProvider");
    @NonNls
    private static final String SPRING_CONFIG_XML = "spring-config.xml";
    private boolean myCreateEmptySpringXml;

    public SpringFrameworkSupportProvider() {
        super(SpringFacet.getSpringFacetType());
    }

    public String[] getPrecedingFrameworkProviderIds() {
        return new String[]{"facet:web", "facet:jsf"};
    }

    public String getTitle() {
        return SpringBundle.message("framework.title.spring", new Object[0]);
    }

    @NotNull
    public String[] getProjectCategories() {
        String[] stringArray = new String[]{SpringFacet.FACET_TYPE_ID.toString()};
        if (stringArray == null) {
            SpringFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public FrameworkRole[] getRoles() {
        return new FrameworkRole[]{SpringProjectCategory.ROLE};
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            SpringFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        SpringFrameworkSupportConfigurable springFrameworkSupportConfigurable = new SpringFrameworkSupportConfigurable(model);
        if (springFrameworkSupportConfigurable == null) {
            SpringFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        return springFrameworkSupportConfigurable;
    }

    public void setupConfiguration(SpringFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
    }

    protected void onFacetCreated(SpringFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        Module module = facet.getModule();
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(() -> DumbService.getInstance((Project)module.getProject()).runWhenSmart(() -> {
            SpringConfigurator configurator;
            if (module.isDisposed()) {
                return;
            }
            boolean configured = false;
            SpringConfigurator[] springConfiguratorArray = (SpringConfigurator[])Extensions.getExtensions(SpringConfigurator.EP_NAME);
            int n = springConfiguratorArray.length;
            for (int i = 0; i < n && !(configured = (configurator = springConfiguratorArray[i]).configure(module)); ++i) {
            }
            if (!configured && this.myCreateEmptySpringXml) {
                try {
                    PsiDirectory directory;
                    VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                    if (sourceRoots.length > 0 && (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoots[0])) != null && directory.findFile(SPRING_CONFIG_XML) == null) {
                        FileTemplate template = SpringCommonUtils.getSpringXmlTemplate(module);
                        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)SPRING_CONFIG_XML, null, (PsiDirectory)directory);
                        if (!(psiElement instanceof XmlFile)) {
                            return;
                        }
                        VirtualFile file = ((XmlFile)psiElement).getVirtualFile();
                        assert (file != null) : psiElement;
                        SpringFileSetService fileSetService = SpringFileSetService.getInstance();
                        Set<SpringFileSet> existingSets = Collections.emptySet();
                        String defaultUniqueId = fileSetService.getUniqueId(existingSets);
                        String uniqueName = fileSetService.getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), existingSets);
                        SpringFileSet fileSet = facet.addFileSet(defaultUniqueId, uniqueName);
                        fileSet.addFile(file);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCategories";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringFrameworkSupportProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SpringFrameworkSupportConfigurable
    extends FrameworkSupportConfigurableBase
    implements FrameworkSupportWithLibrary {
        public SpringFrameworkSupportConfigurable(FrameworkSupportModel model) {
            super((FrameworkSupportProviderBase)SpringFrameworkSupportProvider.this, model, SpringFrameworkSupportProvider.this.getVersions(), SpringFrameworkSupportProvider.this.getVersionLabelText());
        }

        public JComponent getComponent() {
            JPanel allPanel = new JPanel(new BorderLayout());
            JBCheckBox createEmptySpringXml = new JBCheckBox("Create empty spring-config.xml");
            createEmptySpringXml.addChangeListener(e -> SpringFrameworkSupportProvider.this.myCreateEmptySpringXml = createEmptySpringXml.isSelected());
            allPanel.add((Component)createEmptySpringXml, "North");
            allPanel.add((Component)ObjectUtils.assertNotNull((Object)super.getComponent()), "Center");
            return allPanel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
            if (module == null) {
                SpringFrameworkSupportConfigurable.$$$reportNull$$$0(0);
            }
            if (rootModel == null) {
                SpringFrameworkSupportConfigurable.$$$reportNull$$$0(1);
            }
            super.addSupport(module, rootModel, library);
        }

        @NotNull
        public CustomLibraryDescription createLibraryDescription() {
            CustomLibraryDescription customLibraryDescription = DownloadableLibraryService.getInstance().createDescriptionForType(SpringLibraryType.class);
            if (customLibraryDescription == null) {
                SpringFrameworkSupportConfigurable.$$$reportNull$$$0(2);
            }
            return customLibraryDescription;
        }

        public boolean isLibraryOnly() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/facet/SpringFrameworkSupportProvider$SpringFrameworkSupportConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/facet/SpringFrameworkSupportProvider$SpringFrameworkSupportConfigurable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibraryDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addSupport";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

