/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.patterns.PatternIcons;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AddHibernateAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String HIBERNATE_STRING_ID = "hibernate";
    @NonNls
    private static final String HIBERNATE_FACET_NAME = "Hibernate";

    @Override
    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.orm.hibernate3.LocalSessionFactoryBean", "org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean"};
    }

    @Override
    public LibrariesInfo getLibrariesInfo(Module module) {
        LibraryInfo[] libraryInfos = LibrariesConfigurationManager.getInstance(module.getProject()).getLibraryInfos(HIBERNATE_STRING_ID);
        return new LibrariesInfo(libraryInfos, module, HIBERNATE_STRING_ID);
    }

    @Override
    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateInfo datasource = new TemplateInfo(module, settings.getTemplateById("datasource"), SpringBundle.message("spring.patterns.data.access.data.source", new Object[0]), null);
        TemplateInfo jndiDatasource = new TemplateInfo(module, settings.getTemplateById("jndi-datasource"), SpringBundle.message("spring.patterns.data.access.jndi.data.source", new Object[0]), null);
        jndiDatasource.setAccepted(false);
        TemplateInfo sessionFactory = new TemplateInfo(module, settings.getTemplateById("hibernatefactory"), SpringBundle.message("spring.patterns.data.access.hibernate.session.factory", new Object[0]), null);
        TemplateInfo transctionManager = new TemplateInfo(module, settings.getTemplateById("hibernate-tm"), SpringBundle.message("spring.patterns.data.access.hibernate.transaction.manager", new Object[0]), null);
        infos.add(datasource);
        infos.add(jndiDatasource);
        infos.add(sessionFactory);
        infos.add(transctionManager);
        return infos;
    }

    @Override
    @Nullable
    protected String getFacetId() {
        return HIBERNATE_STRING_ID;
    }

    @Override
    public String getDescription() {
        return SpringBundle.message("spring.patterns.hibernate", new Object[0]);
    }

    @Override
    @Nullable
    protected Icon getIcon() {
        return PatternIcons.HIBERNATE_ICON;
    }
}

