/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.patterns.PatternIcons;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AddJdkTimerAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String JDK_TIMER_STRING_ID = "jdk-timer";

    @Override
    public LibrariesInfo getLibrariesInfo(Module module) {
        LibraryInfo[] libraryInfos = LibrariesConfigurationManager.getInstance(module.getProject()).getLibraryInfos(JDK_TIMER_STRING_ID);
        return new LibrariesInfo(libraryInfos, module, JDK_TIMER_STRING_ID);
    }

    @Override
    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.scheduling.timer.ScheduledTimerTask", "org.springframework.scheduling.timer.TimerFactoryBean"};
    }

    @Override
    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateInfo sf = new TemplateInfo(module, settings.getTemplateById("jdk-scheduled-timer-task"), SpringBundle.message("spring.patterns.integration.jdk.scheduled.timer.task", new Object[0]), null);
        TemplateInfo tfb = new TemplateInfo(module, settings.getTemplateById("jdk-timer-factory-bean"), SpringBundle.message("spring.patterns.integration.jdk.timer.factory.bean", new Object[0]), null);
        infos.add(sf);
        infos.add(tfb);
        return infos;
    }

    @Override
    public String getDescription() {
        return SpringBundle.message("spring.patterns.jdk.timer", new Object[0]);
    }

    @Override
    @Nullable
    protected Icon getIcon() {
        return PatternIcons.JDK_ICON;
    }
}

