/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.jam.SpringJamBaseCacheableElement;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheConfig;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringCacheNamesInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod umethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (umethod == null) {
            SpringCacheNamesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringCacheNamesInspection.$$$reportNull$$$0(1);
        }
        if (this.isInSpringEnabledModule((UElement)umethod)) {
            PsiMethod method = (PsiMethod)umethod.getJavaPsi();
            assert (method != null);
            PsiElement sourcePsi = umethod.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)method);
            SpringCacheNamesInspection.checkCacheNames(method.getContainingClass(), holder, elements);
            return holder.getResultsArray();
        }
        return null;
    }

    private static boolean hasDefaultCacheNamesOrCustomCacheResolver(@Nullable PsiClass aClass) {
        if (aClass != null) {
            SemService service = SemService.getSemService((Project)aClass.getProject());
            SpringJamCacheConfig cacheConfig = (SpringJamCacheConfig)service.getSemElement(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, (PsiElement)aClass);
            if (cacheConfig != null) {
                return !cacheConfig.getCacheNamesElement().isEmpty() || cacheConfig.getCacheResolverElement().getValue() != null;
            }
            SpringJamCustomCacheConfig customCacheConfig = (SpringJamCustomCacheConfig)service.getSemElement(SpringJamCustomCacheConfig.JAM_KEY, (PsiElement)aClass);
            if (customCacheConfig != null) {
                return !customCacheConfig.getCacheNames().isEmpty();
            }
        }
        return false;
    }

    private static void checkCacheNames(@Nullable PsiClass containingClass, ProblemsHolder holder, List<SpringJamCacheableElement> elements) {
        if (SpringCacheNamesInspection.hasDefaultCacheNamesOrCustomCacheResolver(containingClass)) {
            return;
        }
        for (SpringJamCacheableElement cacheable : elements) {
            PsiElement annotation;
            if (cacheable instanceof SpringJamCacheConfig || SpringCacheNamesInspection.containsNonEmptyNames(cacheable.getCacheNames()) || SpringCacheNamesInspection.hasCustomCacheResolver(cacheable) || (annotation = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)cacheable.getAnnotation(), UAnnotation.class)))) == null) continue;
            holder.registerProblem(annotation, SpringBundle.message("cacheable.no.cache.could.be.resolved.for.cache.operation", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static boolean containsNonEmptyNames(@NotNull Set<String> names) {
        if (names == null) {
            SpringCacheNamesInspection.$$$reportNull$$$0(2);
        }
        if (names.isEmpty()) {
            return false;
        }
        for (String name : names) {
            if (!StringUtil.isNotEmpty((String)name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCustomCacheResolver(SpringJamCacheableElement cacheable) {
        if (cacheable instanceof SpringJamBaseCacheableElement) {
            return ((SpringJamBaseCacheableElement)cacheable).getCacheResolverElement().getValue() != null;
        }
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uClass == null) {
            SpringCacheNamesInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SpringCacheNamesInspection.$$$reportNull$$$0(4);
        }
        if (this.isInSpringEnabledModule((UElement)uClass) && uClass.isInterface() && !uClass.isAnnotationType()) {
            PsiClass aClass = (PsiClass)uClass.getJavaPsi();
            assert (aClass != null);
            PsiElement sourcePsi = uClass.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringCacheNamesInspection.checkCacheNames(aClass, holder, SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)aClass));
            return holder.getResultsArray();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheNamesInspection" == null) {
            SpringCacheNamesInspection.$$$reportNull$$$0(5);
        }
        return "SpringCacheNamesInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umethod";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheNamesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheNamesInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsNonEmptyNames";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

