/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixManager;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanListConverter
extends DelimitedListConverter<SpringBeanPointer> {
    public SpringBeanListConverter() {
        super(",; ");
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(SpringBeanPointer.class, elementClass);
    }

    @Nullable
    protected SpringBeanPointer convertString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        SpringModel model = SpringConverterUtil.getSpringModel(context);
        if (model == null) {
            return null;
        }
        return SpringModelSearchers.findBean(model, s);
    }

    @Nullable
    protected String toString(@Nullable SpringBeanPointer springBeanPointer) {
        return springBeanPointer == null ? null : springBeanPointer.getName();
    }

    @Nullable
    protected PsiElement resolveReference(SpringBeanPointer springBeanPointer, ConvertContext context) {
        return springBeanPointer == null ? null : springBeanPointer.getPsiElement();
    }

    protected String getUnresolvedMessage(String value) {
        return SpringApiBundle.message("model.bean.error.message", value);
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<List<SpringBeanPointer>> genericDomValue) {
        SpringModel model = SpringConverterUtil.getSpringModel(context);
        if (model == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<SpringBeanPointer> variants = new ArrayList<SpringBeanPointer>();
        DomSpringBean currentBean = SpringConverterUtil.getCurrentBean(context);
        Collection<SpringBeanPointer> allBeans = this.getVariantBeans(context, model);
        for (SpringBeanPointer pointer : allBeans) {
            String beanName;
            if (pointer.isReferenceTo(currentBean) || (beanName = pointer.getName()) == null) continue;
            for (String string : model.getAllBeanNames(beanName)) {
                if (!StringUtil.isNotEmpty((String)string)) continue;
                variants.add(pointer.derive(string));
            }
        }
        List existingBeans = (List)genericDomValue.getValue();
        if (existingBeans != null) {
            Iterator it = variants.iterator();
            block2: while (it.hasNext()) {
                Object variant = ((SpringBeanPointer)it.next()).getSpringBean();
                for (SpringBeanPointer existing : existingBeans) {
                    if (!existing.isReferenceTo((CommonSpringBean)variant)) continue;
                    it.remove();
                    continue block2;
                }
            }
        }
        ArrayList result = new ArrayList(variants.size());
        for (SpringBeanPointer pointer : variants) {
            ContainerUtil.addIfNotNull(result, (Object)SpringConverterUtil.createCompletionVariant(pointer));
        }
        return result.toArray();
    }

    protected Collection<SpringBeanPointer> getVariantBeans(ConvertContext convertContext, @NotNull SpringModel model) {
        List<PsiClassType> requiredBeanTypeClasses;
        if (model == null) {
            SpringBeanListConverter.$$$reportNull$$$0(0);
        }
        if (!(requiredBeanTypeClasses = SpringConverterUtil.getRequiredBeanTypeClasses(convertContext)).isEmpty()) {
            CommonSpringBean currentBean = SpringConverterUtil.getCurrentBeanCustomAware(convertContext);
            return SpringConverterUtil.getSmartVariants(currentBean, requiredBeanTypeClasses, model);
        }
        return model.getAllCommonBeans();
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, ConvertContext context, GenericDomValue<List<SpringBeanPointer>> genericDomValue, boolean delimitersOnly) {
        MyFixableReference myFixableReference = new MyFixableReference(element, this.getTextRange(genericDomValue, start, end), context, genericDomValue, delimitersOnly);
        if (myFixableReference == null) {
            SpringBeanListConverter.$$$reportNull$$$0(1);
        }
        return myFixableReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanListConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanListConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariantBeans";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFixableReference
    extends DelimitedListConverter.MyPsiReference
    implements LocalQuickFixProvider {
        private final Beans beans;

        private MyFixableReference(PsiElement element, TextRange range, ConvertContext context, GenericDomValue<List<SpringBeanPointer>> genericDomValue, boolean delimitersOnly) {
            super((DelimitedListConverter)SpringBeanListConverter.this, element, range, context, genericDomValue, delimitersOnly);
            this.beans = (Beans)genericDomValue.getParentOfType(Beans.class, false);
        }

        public LocalQuickFix[] getQuickFixes() {
            return SpringBeanResolveQuickFixManager.getInstance().getQuickFixes(this.myContext, this.beans, this.getValue(), SpringConverterUtil.getRequiredBeanTypeClasses(this.myContext));
        }
    }
}

