/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LanguageAnnotationSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationSupport;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.fixes.ShowBeansQuickFix;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.spring.references.SpringUastQualifierReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class SpringUastInjectionPointsAutowiringInspection
extends SpringUastInspectionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.model.highlighting.autowire.SpringUastInjectionPointsAutowiringInspection");

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        CommonSpringModel model;
        if (psiMethod == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(1);
        }
        if (SpringAutowireUtil.isAutowiringRelevantClass(psiMethod.getContainingClass()) && SpringAutowireUtil.isInjectionPoint(psiMethod.getPsi()) && (model = SpringAutowireUtil.getProcessingSpringModel(psiMethod.getContainingClass())) != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, psiMethod.getContainingFile(), isOnTheFly);
            boolean required = SpringAutowireUtil.isRequired((PsiModifierListOwner)psiMethod);
            if (SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)psiMethod) != null) {
                SpringUastInjectionPointsAutowiringInspection.checkResourceMethod(psiMethod, holder, model, required);
            } else if (psiMethod.getParameterList().getParametersCount() == 0 && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) {
                PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
                if (nameIdentifier != null) {
                    String msg = SpringBundle.message("bean.autowiring.by.type.no.parameter.for.autowired.method", psiMethod.isConstructor() ? "constructor" : "method");
                    holder.registerProblem((PsiElement)nameIdentifier, msg, new LocalQuickFix[0]);
                }
            } else {
                SpringUastInjectionPointsAutowiringInspection.checkAutowiredMethodInjections(psiMethod, holder, model, required);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull UField psiField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        CommonSpringModel model;
        if (psiField == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(3);
        }
        if (SpringAutowireUtil.isAutowiringRelevantClass(psiField.getContainingClass()) && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField) && (model = SpringAutowireUtil.getProcessingSpringModel(psiField.getContainingClass())) != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, psiField.getContainingFile(), isOnTheFly);
            SpringUastInjectionPointsAutowiringInspection.checkInjectionPoint((UDeclaration)psiField, psiField.getType(), holder, model, SpringAutowireUtil.isRequired((PsiModifierListOwner)psiField));
            return holder.getResultsArray();
        }
        return null;
    }

    private static void checkAutowiredMethodInjections(UMethod psiMethod, @NotNull ProblemsHolder holder, CommonSpringModel springModel, boolean required) {
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(4);
        }
        for (UParameter parameter : psiMethod.getUastParameters()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"org.springframework.beans.factory.annotation.Value", (int)1)) continue;
            SpringUastInjectionPointsAutowiringInspection.checkInjectionPoint((UDeclaration)parameter, parameter.getType(), holder, springModel, required);
        }
    }

    private static void checkResourceMethod(@NotNull UMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        PsiType type;
        if (psiMethod == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(6);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(7);
        }
        if ((type = PropertyUtilBase.getPropertyType((PsiMember)psiMethod)) != null) {
            SpringUastInjectionPointsAutowiringInspection.checkInjectionPoint((UDeclaration)psiMethod, type, holder, springModel, required);
        }
    }

    public static void checkInjectionPoint(@NotNull UDeclaration injectionPointOwner, @NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        if (injectionPointOwner == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(8);
        }
        if (psiType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(10);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(11);
        }
        if (!psiType.isValid()) {
            return;
        }
        PsiAnnotation resourceAnnotation = SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)injectionPointOwner);
        if (resourceAnnotation != null && injectionPointOwner instanceof PsiMember) {
            SpringUastInjectionPointsAutowiringInspection.checkResourceInjectionPoint((PsiModifierListOwner)injectionPointOwner, psiType, holder, springModel, resourceAnnotation);
            return;
        }
        UAnnotation annotation = SpringUastInjectionPointsAutowiringInspection.getEffectiveQualifiedUAnnotation(injectionPointOwner);
        if (annotation != null) {
            SpringUastInjectionPointsAutowiringInspection.checkQualifiedAutowiring(psiType, annotation, holder, springModel);
            return;
        }
        SpringUastInjectionPointsAutowiringInspection.checkByTypeAutowire(injectionPointOwner, psiType, holder, springModel, required);
    }

    @Nullable
    private static UAnnotation getEffectiveQualifiedUAnnotation(UDeclaration injectionPointOwner) {
        PsiAnnotation annotation = SpringAutowireUtil.getEffectiveQualifiedAnnotation((PsiModifierListOwner)injectionPointOwner);
        if (annotation == null) {
            return null;
        }
        UAnnotation qualifiedAnnotation = null;
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName != null) {
            qualifiedAnnotation = injectionPointOwner.findAnnotation(qualifiedName);
        }
        if (qualifiedAnnotation == null) {
            qualifiedAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)annotation, UAnnotation.class);
        }
        if (qualifiedAnnotation == null) {
            LOG.error("Psi annotation '" + annotation + "' from '" + injectionPointOwner.getPsi().getText() + "' was not converted to UAST");
        }
        return qualifiedAnnotation;
    }

    private static void checkResourceInjectionPoint(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, @NotNull PsiAnnotation resourceAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (injectionPointOwner == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(12);
        }
        if (psiType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(14);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(15);
        }
        if (resourceAnnotation == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(16);
        }
        if ((attributeValue = resourceAnnotation.findDeclaredAttributeValue("name")) != null) {
            SpringUastInjectionPointsAutowiringInspection.checkByNameAutowiring(attributeValue, holder, springModel, psiType);
        }
    }

    private static void checkByNameAutowiring(@NotNull PsiAnnotationMemberValue annotationMemberValue, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType) {
        if (annotationMemberValue == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(18);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(19);
        }
        if (memberEffectiveType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(20);
        }
        for (PsiReference reference : annotationMemberValue.getReferences()) {
            PsiConstantEvaluationHelper helper;
            Object o;
            PsiElement element;
            if (reference instanceof SpringBeanReference) {
                SpringBeanReference sbReference = (SpringBeanReference)reference;
                SpringUastInjectionPointsAutowiringInspection.checkResourceBeanReference(holder, model, memberEffectiveType, reference, sbReference.getValue(), sbReference.isFactoryBeanRef());
                break;
            }
            if (!(reference instanceof PsiReferenceExpression) || !((element = reference.resolve()) instanceof PsiField) || !((o = (helper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)((PsiField)element).getInitializer())) instanceof String)) continue;
            SpringUastInjectionPointsAutowiringInspection.checkResourceBeanReference(holder, model, memberEffectiveType, reference, (String)o, false);
        }
    }

    private static void checkResourceBeanReference(@NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType, @NotNull PsiReference ref, @Nullable String beanName, boolean isFactoryBeanRef) {
        SpringBeanPointer bean;
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(21);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(22);
        }
        if (memberEffectiveType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(23);
        }
        if (ref == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(24);
        }
        if (beanName != null && (bean = SpringModelSearchers.findBean(model, beanName)) != null) {
            PsiType[] beanTypes;
            for (PsiType psiType : beanTypes = SpringUastInjectionPointsAutowiringInspection.getEffectiveBeanTypes(isFactoryBeanRef, bean)) {
                if (!SpringAutowireUtil.canBeAutowiredByType(memberEffectiveType, psiType)) continue;
                return;
            }
            holder.registerProblem(ref, SpringBundle.message("cannot.autowire.bean.of.type", memberEffectiveType.getCanonicalText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return;
        }
        if (ref instanceof SpringBeanReference) {
            holder.registerProblem(ref);
        } else if (beanName != null) {
            holder.registerProblem(ref.getElement(), SpringApiBundle.message("model.bean.error.message", beanName), new LocalQuickFix[0]);
        }
    }

    private static PsiType[] getEffectiveBeanTypes(boolean factoryBeanRef, SpringBeanPointer bean) {
        PsiClass beanClass;
        if (factoryBeanRef && (beanClass = bean.getBeanClass()) != null) {
            return new PsiType[]{PsiTypesUtil.getClassType((PsiClass)beanClass)};
        }
        return bean.getEffectiveBeanTypes();
    }

    private static void checkQualifiedAutowiring(PsiType searchType, UAnnotation qualifiedAnnotation, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model) {
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(25);
        }
        UExpression attributeValue = qualifiedAnnotation.findDeclaredAttributeValue("value");
        PsiAnnotation psiAnnotation = (PsiAnnotation)UElementKt.getAsJavaPsiElement((UElement)qualifiedAnnotation, PsiAnnotation.class);
        if (psiAnnotation == null) {
            return;
        }
        String name = SpringAutowireUtil.getQualifiedBeanName(psiAnnotation);
        PsiReference qreference = null;
        if (attributeValue instanceof ULiteralExpression) {
            PsiReference[] references;
            PsiLanguageInjectionHost host = UastLiteralUtils.getPsiLanguageInjectionHost((ULiteralExpression)((ULiteralExpression)attributeValue));
            for (PsiReference reference : references = host.getReferences()) {
                if (!(reference instanceof SpringUastQualifierReference)) continue;
                qreference = reference;
                if (((SpringUastQualifierReference)reference).multiResolve(false).length != 0) continue;
                if (holder != null && reference.getElement().isPhysical()) {
                    holder.registerProblem(reference, SpringBundle.message("bean.class.unknown.qualifier.bean", name), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
                return;
            }
        }
        Set<SpringBeanPointer> beanPointers = SpringAutowireUtil.getQualifiedBeanPointers(psiAnnotation, model);
        PsiElement attributeValueSourcePsi = UElementKt.getSourcePsiElement((UElement)attributeValue);
        PsiElement annotationSourcePsi = UElementKt.getSourcePsiElement((UElement)qualifiedAnnotation);
        if (beanPointers.size() == 0) {
            if (holder != null) {
                if (attributeValueSourcePsi != null) {
                    SpringUastInjectionPointsAutowiringInspection.reportProblem(holder, qreference, attributeValueSourcePsi, SpringBundle.message("bean.class.unknown.qualifier.bean", name));
                } else {
                    String qualifiedName = qualifiedAnnotation.getQualifiedName();
                    assert (qualifiedName != null);
                    if (annotationSourcePsi != null) {
                        SpringUastInjectionPointsAutowiringInspection.reportProblem(holder, qreference, annotationSourcePsi, SpringBundle.message("cannot.find.bean.qualified.by", "@" + StringUtil.getShortName((String)qualifiedName)));
                    }
                }
            }
            return;
        }
        Set<SpringBeanPointer> autowiredPointers = SpringAutowireUtil.filterPointersByAutowiredType(searchType, beanPointers);
        if (autowiredPointers.isEmpty() && SpringAutowireUtil.getIterableBeanPointers(searchType, model, null).size() == 0 && holder != null) {
            PsiElement elementToReport;
            String message = SpringBundle.message("bean.class.autowired.incorrect.qualifier.type", searchType.getPresentableText());
            PsiElement psiElement = elementToReport = attributeValueSourcePsi == null ? annotationSourcePsi : attributeValueSourcePsi;
            if (elementToReport != null) {
                SpringUastInjectionPointsAutowiringInspection.reportProblem(holder, qreference, elementToReport, message);
            }
        }
    }

    private static void reportProblem(@NotNull ProblemsHolder holder, @Nullable PsiReference qreference, @NotNull PsiElement attributeValue, String text) {
        if (holder == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(26);
        }
        if (attributeValue == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(27);
        }
        if (qreference == null) {
            holder.registerProblem(attributeValue, text, new LocalQuickFix[0]);
        } else {
            holder.registerProblem(qreference, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static void checkByTypeAutowire(UDeclaration psiNameIdentifierOwner, @NotNull PsiType searchType, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model, boolean required) {
        UIdentifier uIdentifier;
        if (searchType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(28);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(29);
        }
        if ((uIdentifier = (UIdentifier)psiNameIdentifierOwner.getUastAnchor()) == null) {
            return;
        }
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uIdentifier);
        if (psiElement == null) {
            return;
        }
        if (psiElement.getTextRange().isEmpty()) {
            return;
        }
        String primaryCandidateName = uIdentifier.getName();
        Set<SpringBeanPointer> beanPointers = SpringAutowireUtil.autowireByType(model, searchType, primaryCandidateName);
        Set<SpringBeanPointer> iterableBeanPointers = SpringAutowireUtil.getIterableBeanPointers(searchType, model, primaryCandidateName);
        if (beanPointers.isEmpty() && iterableBeanPointers.isEmpty() && required) {
            if (!(holder == null || SpringAutowireUtil.isAutowiredByDefault(searchType) || SpringUastInjectionPointsAutowiringInspection.isObjectFactory(searchType) || SpringUastInjectionPointsAutowiringInspection.isInjectionPoint(searchType) || SpringAutowireUtil.isJavaUtilOptional(searchType))) {
                holder.registerProblem(psiElement, SpringUastInjectionPointsAutowiringInspection.getBeansNotFoundMessage(searchType), new LocalQuickFix[0]);
            }
        } else if (iterableBeanPointers.isEmpty() && beanPointers.size() > 1 && holder != null) {
            Set<SpringBeanPointer> filtered = SpringUastInjectionPointsAutowiringInspection.filterOverridenBeans(beanPointers);
            if ((filtered = SpringUastInjectionPointsAutowiringInspection.filterSelfReferencedBeans((PsiElement)psiNameIdentifierOwner, filtered)).size() > 1) {
                if (SpringUastInjectionPointsAutowiringInspection.isNonDefinedActiveProfile(model.getActiveProfiles()) && SpringUastInjectionPointsAutowiringInspection.isAllBeansInDifferentProfiles(filtered)) {
                    return;
                }
                holder.registerProblem(psiElement, SpringUastInjectionPointsAutowiringInspection.getErrorMessage(searchType, filtered), new LocalQuickFix[]{new AddSpringBeanQualifierFix((PsiModifierListOwner)psiNameIdentifierOwner, beanPointers, SpringUastInjectionPointsAutowiringInspection.getQualifierAnnotation((PsiModifierListOwner)psiNameIdentifierOwner)), new ShowBeansQuickFix(beanPointers)});
            }
        }
    }

    private static String getBeansNotFoundMessage(@NotNull PsiType searchType) {
        PsiType secondarySearchType;
        if (searchType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(30);
        }
        return (secondarySearchType = SpringAutowireUtil.getIterableSearchType(searchType)) != null ? SpringBundle.message("bean.autowiring.by.type.no.beans", secondarySearchType.getPresentableText(), searchType.getPresentableText()) : SpringBundle.message("bean.autowiring.by.type.none", searchType.getPresentableText());
    }

    private static boolean isObjectFactory(@NotNull PsiType type) {
        if (type == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(31);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.ObjectFactory");
        }
        return false;
    }

    private static boolean isInjectionPoint(@NotNull PsiType type) {
        if (type == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(32);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && "org.springframework.beans.factory.InjectionPoint".equals(psiClass.getQualifiedName());
        }
        return false;
    }

    @NotNull
    private static String getErrorMessage(@NotNull PsiType beanType, Set<SpringBeanPointer> autowiredPointers) {
        if (beanType == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(33);
        }
        SortedList sortedByNamePointers = new SortedList((o1, o2) -> ((String)o1.first).compareTo((String)o2.first));
        for (SpringBeanPointer pointer : autowiredPointers) {
            sortedByNamePointers.add(Pair.create((Object)SpringPresentationProvider.getSpringBeanName(pointer), (Object)SpringPresentationProvider.getSpringBeanLocation(pointer)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        sb.append("<tr><td>");
        sb.append(SpringBundle.message("bean.class.autowired.by.type", beanType.getPresentableText()));
        sb.append("</td></tr>");
        sb.append("<tr><td>");
        sb.append("<table>");
        sb.append("<tr><td valign='top'>Beans:</td>");
        sb.append("<td>");
        for (Pair pair : sortedByNamePointers) {
            sb.append((String)pair.first);
            sb.append("&nbsp;&nbsp; (");
            sb.append((String)pair.second);
            sb.append(")<br>");
        }
        sb.append("</td></tr>");
        sb.append("</table>");
        sb.append("</td></tr>");
        sb.append("</table></html>");
        String string = sb.toString();
        if (string == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterSelfReferencedBeans(@NotNull PsiElement psiNameIdentifierOwner, @NotNull Set<SpringBeanPointer> pointers) {
        PsiMethod psiMethod;
        if (psiNameIdentifierOwner == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(35);
        }
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(36);
        }
        if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiNameIdentifierOwner, PsiMethod.class)) == null) {
            Set<SpringBeanPointer> set = pointers;
            if (set == null) {
                SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(37);
            }
            return set;
        }
        LinkedHashSet filtered = ContainerUtil.newLinkedHashSet();
        for (SpringBeanPointer pointer : pointers) {
            if (psiMethod.equals(pointer.getSpringBean().getIdentifyingPsiElement())) continue;
            filtered.add(pointer);
        }
        LinkedHashSet linkedHashSet = filtered;
        if (linkedHashSet == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(38);
        }
        return linkedHashSet;
    }

    private static boolean isAllBeansInDifferentProfiles(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(39);
        }
        Set names = ContainerUtil.newConcurrentSet();
        for (SpringBeanPointer pointer : pointers) {
            Object bean = pointer.getSpringBean();
            for (String profileName : bean.getProfile().getNames()) {
                if (names.contains(profileName)) {
                    return false;
                }
                names.add(profileName);
            }
        }
        return true;
    }

    private static boolean isNonDefinedActiveProfile(@Nullable Set<String> activeProfiles) {
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        boolean isDefaultProfile = activeProfiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(activeProfiles.iterator().next());
        return !isDefaultProfile;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterOverridenBeans(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(40);
        }
        MultiMap names = new MultiMap();
        Set set = ContainerUtil.map2SetNotNull(pointers, pointer -> {
            boolean isOverriden = false;
            String name = pointer.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                VirtualFile containingFile = pointer.getContainingFile().getVirtualFile();
                if (names.containsKey((Object)name) && !names.values().contains(containingFile)) {
                    isOverriden = true;
                }
                names.putValue((Object)name, (Object)containingFile);
            }
            return isOverriden ? null : pointer;
        });
        if (set == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(41);
        }
        return set;
    }

    @NotNull
    private static String getQualifierAnnotation(@Nullable PsiModifierListOwner psiModifierListOwner) {
        PsiMember psiMember;
        if (psiModifierListOwner != null && (psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiMember.class, (boolean)false)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.inject.Inject", (int)1)) {
            if ("javax.inject.Named" == null) {
                SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(42);
            }
            return "javax.inject.Named";
        }
        if ("org.springframework.beans.factory.annotation.Qualifier" == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(43);
        }
        return "org.springframework.beans.factory.annotation.Qualifier";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringJavaInjectionPointsAutowiringInspection" == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(44);
        }
        return "SpringJavaInjectionPointsAutowiringInspection";
    }

    private static Expression getQualifierNamesSuggestNamesExpression(final PsiLiteral psiLiteral, final @NotNull Collection<SpringBeanPointer> beanPointers) {
        if (beanPointers == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(45);
        }
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                return new TextResult(ElementManipulators.getValueText((PsiElement)psiLiteral));
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElement> items = new LinkedHashSet<LookupElement>();
                PsiClass psiAnnoClass = SpringUastInjectionPointsAutowiringInspection.findAnnoPsiClass(psiLiteral);
                for (SpringBeanPointer pointer : beanPointers) {
                    Object bean = pointer.getSpringBean();
                    if (psiAnnoClass == null) continue;
                    for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                        String value = qualifier.getQualifierValue();
                        if (value == null || !(qualifier instanceof DefaultSpringBeanQualifier) && !Comparing.equal((Object)qualifier.getQualifierType(), (Object)psiAnnoClass)) continue;
                        items.add(SpringConverterUtil.createCompletionVariant(pointer, value));
                    }
                }
                LookupElement[] elements = items.toArray(LookupElement.EMPTY_ARRAY);
                Arrays.sort(elements, Comparator.comparing(e -> e.getLookupString()));
                return elements;
            }
        };
    }

    @Nullable
    public static PsiClass findAnnoPsiClass(@NotNull PsiLiteral expression) {
        PsiAnnotation annotation;
        if (expression == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(46);
        }
        if ((annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAnnotation.class)) == null) {
            return null;
        }
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
        if (module == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(qualifiedName, expression.getResolveScope());
    }

    @NotNull
    private static String getBeanPointerName(@NotNull SpringBeanPointer beanPointer) {
        String name;
        if (beanPointer == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(47);
        }
        String string = StringUtil.isEmptyOrSpaces((String)(name = beanPointer.getName())) ? "Unknown" : name;
        if (string == null) {
            SpringUastInjectionPointsAutowiringInspection.$$$reportNull$$$0(48);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPointOwner";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceAnnotation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMemberValue";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberEffectiveType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanType";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiNameIdentifierOwner";
                break;
            }
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointers";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSelfReferencedBeans";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverridenBeans";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotation";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanPointerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAutowiredMethodInjections";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceMethod";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectionPoint";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceInjectionPoint";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkByNameAutowiring";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceBeanReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkQualifiedAutowiring";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkByTypeAutowire";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBeansNotFoundMessage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isObjectFactory";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isInjectionPoint";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "filterSelfReferencedBeans";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isAllBeansInDifferentProfiles";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "filterOverridenBeans";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierNamesSuggestNamesExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findAnnoPsiClass";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBeanPointerName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddSpringBeanQualifierFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiModifierListOwner> myModifierListOwnerPointer;
        private final Collection<SpringBeanPointer> myBeanPointers;
        private final String myQualifierAnno;

        public AddSpringBeanQualifierFix(@NotNull PsiModifierListOwner psiElement, @NotNull Collection<SpringBeanPointer> beanPointers, @NotNull String qualifierAnno) {
            if (psiElement == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(0);
            }
            if (beanPointers == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(1);
            }
            if (qualifierAnno == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(2);
            }
            this.myModifierListOwnerPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer((PsiElement)psiElement);
            this.myBeanPointers = beanPointers;
            this.myQualifierAnno = qualifierAnno;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("SpringAutowiringInspection.add.qualifier.fix", new Object[0]);
            if (string == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiModifierList modifierList;
            PsiModifierListOwner modifierListOwner;
            if (project == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(5);
            }
            if ((modifierListOwner = (PsiModifierListOwner)this.myModifierListOwnerPointer.getElement()) == null) {
                return;
            }
            if (FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)modifierListOwner) && (modifierList = modifierListOwner.getModifierList()) != null && this.myBeanPointers.size() > 0) {
                new WriteCommandAction(modifierListOwner.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        PsiAnnotation annotation = modifierList.addAnnotation(myQualifierAnno);
                        PsiAnnotationSupport support = (PsiAnnotationSupport)LanguageAnnotationSupport.INSTANCE.forLanguage(annotation.getLanguage());
                        PsiLiteral psiLiteral = (PsiLiteral)annotation.setDeclaredAttributeValue("value", (PsiAnnotationMemberValue)support.createLiteralValue(SpringUastInjectionPointsAutowiringInspection.getBeanPointerName((SpringBeanPointer)myBeanPointers.iterator().next()), (PsiElement)annotation));
                        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
                        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                        codeStyleManager.shortenClassReferences(formatter.reformat((PsiElement)annotation));
                        Editor editor = AddSpringBeanQualifierFix.getEditor(modifierListOwner);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                        TemplateManager manager = TemplateManager.getInstance((Project)modifierListOwner.getProject());
                        manager.startTemplate(editor, this.createQualifierNameTemplate(psiLiteral));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix$1", "run"));
                    }
                }.execute();
            }
        }

        private Template createQualifierNameTemplate(@NotNull PsiLiteral psiLiteral) {
            if (psiLiteral == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(6);
            }
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)psiLiteral.getContainingFile());
            TextRange textRange = psiLiteral.getTextRange();
            String valueText = ElementManipulators.getValueText((PsiElement)psiLiteral);
            builder.replaceRange(TextRange.from((int)(textRange.getStartOffset() + 1), (int)valueText.length()), SpringUastInjectionPointsAutowiringInspection.getQualifierNamesSuggestNamesExpression(psiLiteral, this.myBeanPointers));
            return builder.buildInlineTemplate();
        }

        public static Editor getEditor(PsiModifierListOwner modifierListOwner) {
            PsiFile psiFile = modifierListOwner.getContainingFile();
            Project project = psiFile.getProject();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            assert (virtualFile != null);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, 0), false);
            assert (editor != null);
            return editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beanPointers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierAnno";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiLiteral";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createQualifierNameTemplate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

