/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.fixes;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowBeansQuickFix
implements LocalQuickFix {
    private static final NullableFunction<SpringBeanPointer, NavigatablePsiElement> MAPPER = pointer -> {
        PsiElement element = pointer.isValid() ? pointer.getPsiElement() : null;
        return element instanceof NavigatablePsiElement ? (NavigatablePsiElement)element : null;
    };
    private final Collection<SpringBeanPointer> myBeans;

    public ShowBeansQuickFix(Collection<SpringBeanPointer> beans) {
        this.myBeans = beans;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringBundle.message("spring.bean.show.beans.candidates.name", new Object[0]);
        if (string == null) {
            ShowBeansQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        if (project == null) {
            ShowBeansQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            ShowBeansQuickFix.$$$reportNull$$$0(2);
        }
        if ((editor = PsiUtilBase.findEditor((PsiElement)descriptor.getPsiElement())) != null) {
            ShowBeansQuickFix.showBeanTargets(editor, this.myBeans);
        }
    }

    public static void showBeanTargets(@NotNull Editor editor, Collection<SpringBeanPointer> beans) {
        if (editor == null) {
            ShowBeansQuickFix.$$$reportNull$$$0(3);
        }
        List targets = ContainerUtil.mapNotNull(beans, MAPPER);
        PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])((NavigatablePsiElement[])ArrayUtil.toObjectArray((Collection)targets, NavigatablePsiElement.class)), (String)SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0]), (String)SpringBundle.message("spring.bean.show.beans.candidates.title", new Object[0]), SpringBeansPsiElementCellRenderer.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/fixes/ShowBeansQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/fixes/ShowBeansQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showBeanTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

