/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionValueConsistencyInspection
extends SpringBeanInspectionBase {
    @NonNls
    private static final String PROPERTY = SpringBundle.message("spring.bean.property", new Object[0]);
    @NonNls
    private static final String ARG = SpringBundle.message("spring.bean.constructor.arg", new Object[0]);
    @NonNls
    private static final String ENTRY = SpringBundle.message("spring.bean.map.entry", new Object[0]);

    @Override
    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            InjectionValueConsistencyInspection.$$$reportNull$$$0(0);
        }
        return new SpringModelVisitor(){

            @Override
            protected boolean visitProperty(SpringPropertyDefinition property) {
                if (property instanceof SpringValueHolder) {
                    InjectionValueConsistencyInspection.checkValueHolder((SpringValueHolder)((Object)property), holder, PROPERTY);
                }
                return true;
            }

            @Override
            protected boolean visitConstructorArg(ConstructorArg arg) {
                InjectionValueConsistencyInspection.checkValueHolder(arg, holder, ARG);
                return true;
            }

            @Override
            protected boolean visitMapEntry(SpringEntry entry) {
                InjectionValueConsistencyInspection.checkMapEntry(holder, entry);
                return true;
            }

            @Override
            protected boolean visitRef(SpringRef ref) {
                InjectionValueConsistencyInspection.checkRef(ref, holder);
                return true;
            }

            @Override
            protected boolean visitIdref(Idref idref) {
                InjectionValueConsistencyInspection.checkIdref(idref, holder);
                return true;
            }
        };
    }

    private static void checkValueHolder(SpringValueHolder valueHolder, DomElementAnnotationHolder holder, String elementName) {
        boolean hasRefAttribute = DomUtil.hasXml(valueHolder.getRefAttr());
        boolean hasValueAttribute = DomUtil.hasXml(valueHolder.getValueAttr());
        Set<DomElement> values = InjectionValueConsistencyInspection.getValues(valueHolder);
        if (!hasRefAttribute && !hasValueAttribute && values.size() == 0) {
            InjectionValueConsistencyInspection.reportNoValue(valueHolder, holder, elementName);
        } else if (hasRefAttribute && hasValueAttribute || (hasRefAttribute || hasValueAttribute) && values.size() > 0) {
            String message = SpringBundle.message("spring.bean.property.value.inconsistency.ref.or.value.sub.element.must.defined", elementName);
            if (hasValueAttribute) {
                InjectionValueConsistencyInspection.reportAttribute(valueHolder.getValueAttr(), holder, message);
            }
            if (hasRefAttribute) {
                InjectionValueConsistencyInspection.reportAttribute(valueHolder.getRefAttr(), holder, message);
            }
            InjectionValueConsistencyInspection.reportSubtags(values, holder, message);
        } else if (values.size() > 1) {
            String message = SpringBundle.message("spring.bean.property.value.inconsistency.more.one.sub.element", elementName);
            InjectionValueConsistencyInspection.reportSubtags(values, holder, message);
        }
    }

    private static void checkMapEntry(DomElementAnnotationHolder holder, SpringEntry entry) {
        boolean hasKeyAttr = DomUtil.hasXml(entry.getKeyAttr());
        boolean hasKeyElement = DomUtil.hasXml((DomElement)entry.getKey());
        boolean hasKeyRef = DomUtil.hasXml(entry.getKeyRef());
        if (!(hasKeyAttr || hasKeyElement || hasKeyRef)) {
            holder.createProblem((DomElement)entry, SpringBundle.message("model.inspection.injection.value.entry.key", new Object[0]), new LocalQuickFix[0]).highlightWholeElement();
        } else if (hasKeyAttr && hasKeyElement || hasKeyAttr && hasKeyRef || hasKeyElement && hasKeyRef) {
            String message = SpringBundle.message("spring.bean.property.value.inconsistency.key", new Object[0]);
            if (hasKeyAttr) {
                InjectionValueConsistencyInspection.reportAttribute(entry.getKeyAttr(), holder, message);
            }
            if (hasKeyElement) {
                InjectionValueConsistencyInspection.reportAttribute(entry.getKey(), holder, message);
            }
            if (hasKeyRef) {
                InjectionValueConsistencyInspection.reportAttribute(entry.getKeyRef(), holder, message);
            }
        }
        InjectionValueConsistencyInspection.checkValueHolder(entry, holder, ENTRY);
    }

    private static void checkRef(SpringRef ref, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)ref)) {
            return;
        }
        boolean hasBean = DomUtil.hasXml(ref.getBean());
        boolean hasLocal = DomUtil.hasXml(ref.getLocal());
        boolean hasParent = DomUtil.hasXml(ref.getParentAttr());
        if (!(hasBean || hasLocal || hasParent)) {
            holder.createProblem((DomElement)ref, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.ref.attributes.must.specify", new Object[0]), new LocalQuickFix[]{new AddRefFix((GenericDomValue)ref.getBean()), new AddRefFix((GenericDomValue)ref.getLocal()), new AddRefFix((GenericDomValue)ref.getParentAttr())}).highlightWholeElement();
        } else if (hasBean && hasLocal || hasBean && hasParent || hasLocal && hasParent) {
            String message = SpringBundle.message("spring.bean.ref.attributes.inconsistency", new Object[0]);
            InjectionValueConsistencyInspection.reportAttribute(ref.getBean(), holder, message);
            InjectionValueConsistencyInspection.reportAttribute(ref.getLocal(), holder, message);
            InjectionValueConsistencyInspection.reportAttribute(ref.getParentAttr(), holder, message);
        }
    }

    private static void checkIdref(Idref ref, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)ref)) {
            return;
        }
        boolean hasBean = DomUtil.hasXml(ref.getBean());
        boolean hasLocal = DomUtil.hasXml(ref.getLocal());
        if (!hasBean && !hasLocal) {
            holder.createProblem((DomElement)ref, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.idref.attributes.must.specify", new Object[0]), new LocalQuickFix[]{new AddRefFix((GenericDomValue)ref.getBean()), new AddRefFix((GenericDomValue)ref.getLocal())}).highlightWholeElement();
        } else if (hasBean && hasLocal) {
            String message = SpringBundle.message("spring.bean.idref.attributes.inconsistency", new Object[0]);
            InjectionValueConsistencyInspection.reportAttribute(ref.getBean(), holder, message);
            InjectionValueConsistencyInspection.reportAttribute(ref.getLocal(), holder, message);
        }
    }

    @NotNull
    private static Set<DomElement> getValues(SpringElementsHolder elementsHolder) {
        THashSet values = new THashSet((Collection)DomUtil.getDefinedChildrenOfType((DomElement)elementsHolder, DomSpringBean.class, (boolean)true, (boolean)false));
        InjectionValueConsistencyInspection.addValue(elementsHolder.getIdref(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getList(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getMap(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getNull(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getProps(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getRef(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getSet(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getValue(), (Set<DomElement>)values);
        InjectionValueConsistencyInspection.addValue(elementsHolder.getArray(), (Set<DomElement>)values);
        THashSet tHashSet = values;
        if (tHashSet == null) {
            InjectionValueConsistencyInspection.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    private static void addValue(DomElement valueElement, @NotNull Set<DomElement> values) {
        if (values == null) {
            InjectionValueConsistencyInspection.$$$reportNull$$$0(2);
        }
        if (DomUtil.hasXml((DomElement)valueElement)) {
            values.add(valueElement);
        }
    }

    private static void reportSubtags(@NotNull Set<DomElement> values, DomElementAnnotationHolder holder, String message) {
        if (values == null) {
            InjectionValueConsistencyInspection.$$$reportNull$$$0(3);
        }
        for (DomElement value : values) {
            holder.createProblem(value, HighlightSeverity.ERROR, message, new LocalQuickFix[]{new RemoveDomElementQuickFix(value)}).highlightWholeElement();
        }
    }

    private static void reportAttribute(DomElement element, DomElementAnnotationHolder holder, String message) {
        if (DomUtil.hasXml((DomElement)element)) {
            holder.createProblem(element, HighlightSeverity.ERROR, message, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)}).highlightWholeElement();
        }
    }

    private static void reportNoValue(SpringValueHolder injection, DomElementAnnotationHolder holder, String elementName) {
        List<PsiType> types = TypeHolderUtil.getRequiredTypes(injection);
        ArrayList<AddDomElementQuickFix> quickFixes = new ArrayList<AddDomElementQuickFix>();
        quickFixes.add(new AddDomElementQuickFix(injection.getValueAttr()));
        for (PsiType type : types) {
            if (type instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type).resolve();
                quickFixes.add(0, new AddRefFix((GenericDomValue)injection.getRefAttr(), psiClass));
                if (psiClass == null) continue;
                Project project = psiClass.getProject();
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
                PsiClass listClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(List.class.getName(), scope);
                if (listClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)listClass, (boolean)true)) {
                    quickFixes.add(0, new AddListOrSetFix.List(injection.getList()));
                    continue;
                }
                PsiClass mapClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(Map.class.getName(), scope);
                if (mapClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)mapClass, (boolean)true)) {
                    quickFixes.add(0, new AddMapFix(injection.getMap()));
                    continue;
                }
                PsiClass setClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(Set.class.getName(), scope);
                if (setClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)setClass, (boolean)true)) continue;
                quickFixes.add(0, new AddListOrSetFix.Set(injection.getSet()));
                continue;
            }
            if (!(type instanceof PsiArrayType)) continue;
            quickFixes.add(0, new AddListOrSetFix.Array(injection.getArray()));
            quickFixes.add(0, new AddListOrSetFix.Set(injection.getSet()));
            quickFixes.add(0, new AddListOrSetFix.List(injection.getList()));
        }
        holder.createProblem((DomElement)injection, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.message", elementName), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY)).highlightWholeElement();
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringInjectionValueConsistencyInspection" == null) {
            InjectionValueConsistencyInspection.$$$reportNull$$$0(4);
        }
        return "SpringInjectionValueConsistencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportSubtags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddMapFix
    extends AddDomElementQuickFix<SpringMap> {
        public AddMapFix(SpringMap map) {
            super((DomElement)map);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.add.map", new Object[0]);
            if (string == null) {
                AddMapFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddMapFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddMapFix.$$$reportNull$$$0(2);
            }
            ((SpringMap)this.myElement).addEntry();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddMapFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddMapFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AddListOrSetFix
    extends AddDomElementQuickFix<ListOrSet> {
        public AddListOrSetFix(@NotNull ListOrSet listOrSet) {
            if (listOrSet == null) {
                AddListOrSetFix.$$$reportNull$$$0(0);
            }
            super((DomElement)listOrSet);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddListOrSetFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddListOrSetFix.$$$reportNull$$$0(2);
            }
            SpringValue value = ((ListOrSet)this.myElement).addValue();
            value.setStringValue("x");
            value.setStringValue("");
            PsiNavigateUtil.navigate((PsiElement)value.getXmlTag());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listOrSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddListOrSetFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class Array
        extends AddListOrSetFix {
            public Array(@NotNull ListOrSet listOrSet) {
                if (listOrSet == null) {
                    Array.$$$reportNull$$$0(0);
                }
                super(listOrSet);
            }

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.inspection.injection.value.add.array", new Object[0]);
                if (string == null) {
                    Array.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listOrSet";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddListOrSetFix$Array";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddListOrSetFix$Array";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class Set
        extends AddListOrSetFix {
            public Set(@NotNull ListOrSet listOrSet) {
                if (listOrSet == null) {
                    Set.$$$reportNull$$$0(0);
                }
                super(listOrSet);
            }

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.inspection.injection.value.add.set", new Object[0]);
                if (string == null) {
                    Set.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listOrSet";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddListOrSetFix$Set";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddListOrSetFix$Set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class List
        extends AddListOrSetFix {
            public List(@NotNull ListOrSet listOrSet) {
                if (listOrSet == null) {
                    List.$$$reportNull$$$0(0);
                }
                super(listOrSet);
            }

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.inspection.injection.value.add.list", new Object[0]);
                if (string == null) {
                    List.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listOrSet";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddListOrSetFix$List";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddListOrSetFix$List";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class AddRefFix
    extends AddDomElementQuickFix<GenericDomValue> {
        @Nullable
        private final SmartPsiElementPointer<PsiClass> myPsiClassPointer;

        public AddRefFix(@NotNull GenericDomValue ref) {
            if (ref == null) {
                AddRefFix.$$$reportNull$$$0(0);
            }
            this(ref, null);
        }

        public AddRefFix(@NotNull GenericDomValue ref, @Nullable PsiClass psiClass) {
            if (ref == null) {
                AddRefFix.$$$reportNull$$$0(1);
            }
            super((DomElement)ref);
            this.myPsiClassPointer = psiClass == null ? null : SmartPointerManager.getInstance((Project)psiClass.getProject()).createSmartPsiElementPointer((PsiElement)psiClass);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.add.ref", new Object[0]);
            if (string == null) {
                AddRefFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddRefFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddRefFix.$$$reportNull$$$0(4);
            }
            super.applyFix(project, descriptor);
            if (this.myPsiClassPointer == null) {
                return;
            }
            PsiClass psiClass = (PsiClass)this.myPsiClassPointer.getElement();
            if (psiClass != null) {
                SpringModelSearchParameters.BeanClass searchParameters;
                List<SpringBeanPointer> list;
                XmlElement element = ((GenericDomValue)this.myElement).getXmlElement();
                assert (element != null);
                XmlFile xmlFile = (XmlFile)element.getContainingFile();
                SpringModel model = SpringManager.getInstance(project).getSpringModelByFile((PsiFile)xmlFile);
                if (model != null && (list = SpringModelSearchers.findBeans(model, searchParameters = SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes())).size() == 1) {
                    ((GenericDomValue)this.myElement).setStringValue(SpringBeanCoreUtils.getReferencedName(list.get(0), model.getAllCommonBeans()));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddRefFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueConsistencyInspection$AddRefFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

