/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters.resources;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceValueConverter
extends Converter<Set<PsiFileSystemItem>>
implements CustomReferenceConverter {
    public Set<PsiFileSystemItem> fromString(@Nullable @NonNls String s, ConvertContext context) {
        GenericDomValue domValue = (GenericDomValue)context.getInvocationElement();
        if (StringUtil.isEmpty((String)s)) {
            return Collections.emptySet();
        }
        return ResourceValueConverter.addResourceFilesFrom(domValue, ContainerUtil.newLinkedHashSet(), this.getFilter(), this);
    }

    private static <V extends PsiFileSystemItem> Set<V> addResourceFilesFrom(@NotNull GenericDomValue element, Set<V> result, Condition<PsiFileSystemItem> filter, Converter converter) {
        if (element == null) {
            ResourceValueConverter.$$$reportNull$$$0(0);
        }
        if (converter instanceof CustomReferenceConverter) {
            PsiReference[] references = ((CustomReferenceConverter)converter).createReferences(element, (PsiElement)element.getXmlElement(), ConvertContextFactory.createConvertContext((DomElement)element));
            result.addAll(SpringResourcesUtil.getInstance().getResourceItems(references, filter));
            return result;
        }
        return result;
    }

    public String toString(@Nullable Set<PsiFileSystemItem> o, ConvertContext context) {
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        Condition<PsiFileSystemItem> filterCondition = this.getFilter(genericDomValue);
        Function<PsiFile, Collection<PsiFileSystemItem>> customDefaultPathEvaluator = this.getCustomDefaultPathEvaluator(element);
        SmartList result = new SmartList();
        SpringReferenceUtils.processSeparatedString(genericDomValue.getStringValue(), ",", (PairProcessor<String, Integer>)((PairProcessor)(arg_0, arg_1) -> this.lambda$createReferences$0(element, startInElement, filterCondition, customDefaultPathEvaluator, (List)result, arg_0, arg_1)));
        PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ResourceValueConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    protected boolean isEndingSlashNotAllowed() {
        return false;
    }

    protected Condition<PsiFileSystemItem> getFilter() {
        return Conditions.alwaysTrue();
    }

    @Nullable
    protected Function<PsiFile, Collection<PsiFileSystemItem>> getCustomDefaultPathEvaluator(PsiElement element) {
        return null;
    }

    @NotNull
    protected Condition<PsiFileSystemItem> getFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            ResourceValueConverter.$$$reportNull$$$0(2);
        }
        for (SpringResourceTypeProvider provider : (SpringResourceTypeProvider[])Extensions.getExtensions(SpringResourceTypeProvider.EP_NAME)) {
            Condition<PsiFileSystemItem> filter = provider.getResourceFilter(genericDomValue);
            if (filter == null) continue;
            Condition<PsiFileSystemItem> condition = filter;
            if (condition == null) {
                ResourceValueConverter.$$$reportNull$$$0(3);
            }
            return condition;
        }
        Condition<PsiFileSystemItem> condition = this.getFilter();
        if (condition == null) {
            ResourceValueConverter.$$$reportNull$$$0(4);
        }
        return condition;
    }

    private /* synthetic */ boolean lambda$createReferences$0(PsiElement element, int startInElement, Condition filterCondition, Function customDefaultPathEvaluator, List result, String s, Integer offset) {
        SpringResourcesBuilder builder = SpringResourcesBuilder.create(element, s).fromRoot(true).offset(offset + startInElement).filter((Condition<PsiFileSystemItem>)filterCondition).endingSlashNotAllowed(this.isEndingSlashNotAllowed()).customDefaultPathEvaluator((Function<PsiFile, Collection<PsiFileSystemItem>>)customDefaultPathEvaluator);
        ContainerUtil.addAll((Collection)result, (Object[])SpringResourcesUtil.getInstance().getReferences(builder));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/converters/resources/ResourceValueConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/converters/resources/ResourceValueConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addResourceFilesFrom";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ResourceValueConverterCondition
    implements Condition<Pair<PsiType, GenericDomValue>> {
        public boolean value(Pair<PsiType, GenericDomValue> pair) {
            PsiType psiType = (PsiType)pair.getFirst();
            if (psiType instanceof PsiArrayType) {
                psiType = ((PsiArrayType)psiType).getComponentType();
            }
            if (!(psiType instanceof PsiClassType)) {
                return false;
            }
            String psiTypeText = psiType.getCanonicalText();
            if ("java.lang.String".equals(psiTypeText)) {
                return false;
            }
            return "org.springframework.core.io.Resource".equals(psiTypeText) || "java.io.File".equals(psiTypeText) || InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.io.InputStream");
        }
    }
}

