/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters.resources;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.spring.model.values.converters.SpringValueConditionFactory;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.GenericDomValue;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCustomResourceTypeProvider
implements SpringResourceTypeProvider {
    private final Map<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> myFilterMap = new HashMap();

    public SpringCustomResourceTypeProvider() {
        Condition condition = psiFileSystemItem -> psiFileSystemItem instanceof PsiFile && PropertiesImplUtil.isPropertiesFile((PsiFile)((PsiFile)psiFileSystemItem));
        this.addResourceFilter("org.springframework.beans.factory.config.PropertiesFactoryBean", (Condition<PsiFileSystemItem>)condition, "location", "locations");
        this.addResourceFilter("org.springframework.beans.factory.config.PlaceholderConfigurerSupport", (Condition<PsiFileSystemItem>)condition, "location", "locations");
    }

    private void addResourceFilter(@NotNull String beanClass, Condition<PsiFileSystemItem> condition, String ... propertyNames) {
        if (beanClass == null) {
            SpringCustomResourceTypeProvider.$$$reportNull$$$0(0);
        }
        if (propertyNames == null) {
            SpringCustomResourceTypeProvider.$$$reportNull$$$0(1);
        }
        this.myFilterMap.put(SpringValueConditionFactory.createBeanPropertyCondition(beanClass, propertyNames), condition);
    }

    @Override
    @Nullable
    public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            SpringCustomResourceTypeProvider.$$$reportNull$$$0(2);
        }
        for (Map.Entry<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> entry : this.myFilterMap.entrySet()) {
            if (!entry.getKey().value((Object)genericDomValue)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/values/converters/resources/SpringCustomResourceTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addResourceFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

