/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.wrappers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.wrappers.ModelType;
import com.intellij.spring.model.wrappers.WScope;
import com.intellij.spring.model.wrappers.WSpringDependency;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class WModel {
    @NotNull
    public final String name;
    @NotNull
    public final ModelType type;
    @NotNull
    public final ArrayList<WSpringDependency> dependencies;
    @NotNull
    private final WScope scope;

    public WModel(@NotNull String name, @NotNull ModelType type, @NotNull WScope scope) {
        if (name == null) {
            WModel.$$$reportNull$$$0(0);
        }
        if (type == null) {
            WModel.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            WModel.$$$reportNull$$$0(2);
        }
        this.dependencies = new ArrayList();
        this.name = name;
        this.type = type;
        this.scope = scope;
    }

    public WModel(@NotNull LocalModel model) {
        if (model == null) {
            WModel.$$$reportNull$$$0(3);
        }
        this.dependencies = new ArrayList();
        if (model instanceof LocalXmlModel) {
            this.name = WModel.getLocalXmlModelName((LocalXmlModel)model);
            this.type = ModelType.XML;
        } else if (model instanceof LocalAnnotationModel) {
            this.name = ((PsiClass)((LocalAnnotationModel)model).getConfig()).getQualifiedName();
            this.type = ModelType.ANNO;
        } else {
            throw new IllegalArgumentException(String.format("Can't get model type for model with class '%s'", model.getClass()));
        }
        this.scope = WModel.getScope(model);
    }

    public static String getLocalXmlModelName(@NotNull LocalXmlModel model) {
        VirtualFile projectBasePath;
        VirtualFile absolutePath;
        String relativePath;
        if (model == null) {
            WModel.$$$reportNull$$$0(4);
        }
        return (relativePath = VfsUtilCore.getRelativePath((VirtualFile)(absolutePath = ((XmlFile)model.getConfig()).getVirtualFile()), (VirtualFile)(projectBasePath = model.getModule().getProject().getBaseDir()))) != null ? relativePath : absolutePath.getPath();
    }

    private static WScope getScope(@NotNull LocalModel model) {
        VirtualFile file;
        ProjectFileIndex index;
        if (model == null) {
            WModel.$$$reportNull$$$0(5);
        }
        if ((index = ProjectRootManager.getInstance((Project)model.getModule().getProject()).getFileIndex()).isInSourceContent(file = model.getConfig().getContainingFile().getVirtualFile())) {
            return WScope.SOURCE;
        }
        if (index.isInTestSourceContent(file)) {
            return WScope.TEST;
        }
        if (index.isInLibrarySource(file) || index.isInLibraryClasses(file)) {
            return WScope.LIBRARY;
        }
        return WScope.UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WModel model = (WModel)o;
        if (!this.name.equals(model.name)) {
            return false;
        }
        if (this.type != model.type) {
            return false;
        }
        return this.dependencies.equals(model.dependencies);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.dependencies.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/wrappers/WModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalXmlModelName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

