/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBaseBeanPointer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CustomSpringBeanPointer
extends SpringBaseBeanPointer {
    private final SpringBeanPointer myBasePointer;
    private final int myIndex;

    private CustomSpringBeanPointer(@NotNull CustomBeanWrapper wrapper, CustomBean bean, int index) {
        if (wrapper == null) {
            CustomSpringBeanPointer.$$$reportNull$$$0(0);
        }
        super(bean.getBeanName(), wrapper.getManager().getProject());
        this.myIndex = index;
        this.myBasePointer = BeanService.getInstance().createSpringBeanPointer(wrapper);
    }

    @Override
    @NotNull
    public CustomBean getSpringBean() {
        CustomBean customBean = ((CustomBeanWrapper)this.myBasePointer.getSpringBean()).getCustomBeans().get(this.myIndex);
        if (customBean == null) {
            CustomSpringBeanPointer.$$$reportNull$$$0(1);
        }
        return customBean;
    }

    @Override
    public boolean isValid() {
        if (!this.myBasePointer.isValid()) {
            return false;
        }
        DomSpringBean baseBean = (DomSpringBean)this.myBasePointer.getSpringBean();
        if (!(baseBean instanceof CustomBeanWrapper)) {
            return false;
        }
        List<CustomBean> beans = ((CustomBeanWrapper)baseBean).getCustomBeans();
        return beans.size() > this.myIndex;
    }

    @NotNull
    public static CustomSpringBeanPointer createCustomSpringBeanPointer(CustomBean bean) {
        CustomBeanWrapper wrapper = bean.getWrapper();
        List<CustomBean> allBeans = wrapper.getCustomBeans();
        int index = allBeans.indexOf(bean);
        if (index < 0) {
            throw new AssertionError((Object)("Can't find custom bean " + bean + " among " + allBeans));
        }
        CustomSpringBeanPointer customSpringBeanPointer = new CustomSpringBeanPointer(wrapper, bean, index);
        if (customSpringBeanPointer == null) {
            CustomSpringBeanPointer.$$$reportNull$$$0(2);
        }
        return customSpringBeanPointer;
    }

    public PsiElement getPsiElement() {
        return this.getSpringBean().getIdentifyingPsiElement();
    }

    @Override
    public PsiClass getBeanClass() {
        return PsiTypesUtil.getPsiClass((PsiType)this.getSpringBean().getBeanType());
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile = this.myBasePointer.getContainingFile();
        if (psiFile == null) {
            CustomSpringBeanPointer.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomSpringBeanPointer)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomSpringBeanPointer that = (CustomSpringBeanPointer)o;
        if (this.myIndex != that.myIndex) {
            return false;
        }
        return !(this.myBasePointer != null ? !this.myBasePointer.equals(that.myBasePointer) : that.myBasePointer != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myBasePointer != null ? this.myBasePointer.hashCode() : 0);
        result = 31 * result + this.myIndex;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/CustomSpringBeanPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/CustomSpringBeanPointer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBean";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomSpringBeanPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

