/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SpringBeansView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SpringBeansViewSettings
implements PersistentStateComponent<Settings> {
    private final MessageBus myMessageBus;
    private Settings mySettings = new Settings();
    public static final Topic<Listener> TOPIC = new Topic("Spring Beans View settings", Listener.class);

    public void fireSettingsChanged(ChangeType changeType) {
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).settingsChanged(changeType);
    }

    public static SpringBeansViewSettings getInstance(Project project) {
        return (SpringBeansViewSettings)ServiceManager.getService((Project)project, SpringBeansViewSettings.class);
    }

    public SpringBeansViewSettings(MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    @Nullable
    public Settings getState() {
        return this.mySettings;
    }

    public void loadState(@NotNull Settings settings) {
        if (settings == null) {
            SpringBeansViewSettings.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)settings, (Object)this.mySettings);
    }

    public boolean isShowModules() {
        return this.mySettings.showModules;
    }

    public void setShowModules(boolean value) {
        this.mySettings.showModules = value;
    }

    public boolean isShowFileSets() {
        return this.mySettings.showFilesets;
    }

    public void setShowFileSets(boolean value) {
        this.mySettings.showFilesets = value;
    }

    public boolean isShowFiles() {
        return this.mySettings.showFiles;
    }

    public void setShowFiles(boolean value) {
        this.mySettings.showFiles = value;
    }

    public boolean isShowImplicitBeans() {
        return this.mySettings.showImplicitBeans;
    }

    public void setShowImplicitBeans(boolean value) {
        this.mySettings.showImplicitBeans = value;
    }

    public boolean isShowInfrastructureBeans() {
        return this.mySettings.showInfrastructureBeans;
    }

    public void setShowInfrastructureBeans(boolean value) {
        this.mySettings.showInfrastructureBeans = value;
    }

    public boolean isShowDoc() {
        return this.mySettings.showDoc;
    }

    public void setShowDoc(boolean value) {
        this.mySettings.showDoc = value;
    }

    public boolean isShowGraph() {
        return this.mySettings.showGraph;
    }

    public void setShowGraph(boolean value) {
        this.mySettings.showGraph = value;
    }

    public void setBeanDetailsProportion(float proportion) {
        this.mySettings.beanDetailsProportion = proportion;
    }

    public float getBeanDetailsProportion() {
        return this.mySettings.beanDetailsProportion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/toolWindow/SpringBeansViewSettings", "loadState"));
    }

    public static class Settings {
        public boolean showModules = true;
        public boolean showFilesets = true;
        public boolean showFiles = true;
        public boolean showImplicitBeans = true;
        public boolean showInfrastructureBeans = true;
        public boolean showDoc = true;
        public boolean showGraph = true;
        public float beanDetailsProportion = -1.0f;
    }

    public static enum ChangeType {
        FULL,
        UPDATE_LIST,
        UPDATE_DETAILS,
        FORCE_UPDATE_RIGHT_COMPONENT;

    }

    public static interface Listener {
        public void settingsChanged(ChangeType var1);
    }
}

