/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.BindingCacheKey;
import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.KotlinAwareBeanBinding;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import gnu.trove.THashMap;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000K\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\u0001\u001a'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\u0010\r\u001a\b\u0010\u000e\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001e\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\u0012*\u00020\u0014H\u0086\b\u00a2\u0006\u0002\u0010\u0015\u001a#\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b*\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\u0010\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0014\u001a\u0012\u0010\u001b\u001a\u00020\u0010*\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0012\u001a3\u0010\u001d\u001a\u0004\u0018\u00010\u0014\"\b\b\u0000\u0010\b*\u00020\u0012*\u0002H\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u001f\u001a\u00020 H\u0007\u00a2\u0006\u0002\u0010!\u001a\u0016\u0010\"\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0014\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"serializer", "com/intellij/configurationStore/XmlSerializer$serializer$1", "Lcom/intellij/configurationStore/XmlSerializer$serializer$1;", "skipDefaultsSerializationFilter", "Ljava/lang/ThreadLocal;", "Lcom/intellij/reference/SoftReference;", "Lcom/intellij/util/xmlb/SerializationFilter;", "deserialize", "T", "url", "Ljava/net/URL;", "aClass", "Ljava/lang/Class;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "getDefaultSerializationFilter", "serializeObjectInto", "", "o", "", "target", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)Ljava/lang/Object;", "clazz", "(Lorg/jdom/Element;Ljava/lang/Class;)Ljava/lang/Object;", "deserializeAndLoadState", "Lcom/intellij/openapi/components/PersistentStateComponent;", "element", "deserializeInto", "bean", "serialize", "filter", "createElementIfEmpty", "", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/SerializationFilter;Z)Lorg/jdom/Element;", "serializeStateInto", "intellij.platform.projectModel"})
@JvmName(name="XmlSerializer")
public final class XmlSerializer {
    private static final ThreadLocal<SoftReference<SerializationFilter>> skipDefaultsSerializationFilter = new ThreadLocal();
    private static final serializer.1 serializer = new XmlSerializerImpl.XmlSerializerBase(){
        private SoftReference<Map<BindingCacheKey, Binding>> _bindingCache;
        private final ReentrantReadWriteLock cacheLock;

        private static /* synthetic */ void _bindingCache$annotations() {
        }

        private final Map<BindingCacheKey, Binding> getBindingCache() {
            Map<K, V> map;
            SoftReference<Map<BindingCacheKey, Binding>> softReference = this._bindingCache;
            Map<K, V> map2 = map = softReference != null ? (Map<K, V>)softReference.get() : null;
            if (map == null) {
                map = (Map)new THashMap();
                this._bindingCache = new SoftReference((Object)map);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Binding getClassBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
            Binding binding;
            Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
            Intrinsics.checkParameterIsNotNull((Object)originalType, (String)"originalType");
            BindingCacheKey key = new BindingCacheKey(originalType, accessor);
            Map<BindingCacheKey, Binding> map = this.getBindingCache();
            ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                Binding binding2 = map.get(key);
                binding = binding2;
            }
            finally {
                readLock.unlock();
            }
            Binding binding3 = binding;
            if (binding == null) {
                int n;
                reentrantReadWriteLock = this.cacheLock;
                readLock = reentrantReadWriteLock.readLock();
                int n2 = 0;
                int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                int n4 = n3 - 1;
                if (n2 <= n4) {
                    do {
                        n = ++n2;
                        readLock.unlock();
                    } while (n2 != n4);
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    Binding binding4;
                    Binding binding5 = map.get(key);
                    if (binding5 != null) {
                        Binding binding6;
                        Binding it;
                        Binding binding7 = it = (binding6 = binding5);
                        return binding7;
                    }
                    Binding binding8 = serializer.1.access$createClassBinding$s572079962(aClass, accessor, originalType);
                    if (binding8 == null) {
                        binding8 = (Binding)new KotlinAwareBeanBinding(aClass, accessor);
                    }
                    Binding binding9 = binding4 = binding8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)binding9, (String)"binding");
                    map.put(key, binding9);
                    try {
                        binding4.init(originalType, (Serializer)this);
                    }
                    catch (RuntimeException e) {
                        map.remove(key);
                        throw (Throwable)e;
                    }
                    catch (Error e) {
                        map.remove(key);
                        throw (Throwable)e;
                    }
                    Binding binding10 = binding4;
                    binding3 = binding10;
                }
                finally {
                    n = 0;
                    int n5 = n3 - 1;
                    if (n <= n5) {
                        do {
                            int it = ++n;
                            readLock.lock();
                        } while (n != n5);
                    }
                    writeLock.unlock();
                }
            }
            return binding3;
        }
        {
            this.cacheLock = new ReentrantReadWriteLock();
        }

        @Nullable
        public static final /* synthetic */ Binding access$createClassBinding$s572079962(@NotNull Class p0, @Nullable MutableAccessor p1, @NotNull Type p2) {
            return XmlSerializerImpl.XmlSerializerBase.createClassBinding((Class)p0, (MutableAccessor)p1, (Type)p2);
        }
    };

    private static final SerializationFilter getDefaultSerializationFilter() {
        SerializationFilter result2 = (SerializationFilter)SoftReference.dereference((Reference)((Reference)skipDefaultsSerializationFilter.get()));
        if (result2 == null) {
            result2 = (SerializationFilter)new SkipDefaultsSerializationFilter(){

                public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                    Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
                    Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
                    return bean instanceof BaseState ? ((BaseState)bean).accepts(accessor, bean) : super.accepts(accessor, bean);
                }
            };
            skipDefaultsSerializationFilter.set((SoftReference<SerializationFilter>)new SoftReference((Object)result2));
        }
        return result2;
    }

    @JvmOverloads
    @Nullable
    public static final <T> Element serialize(@NotNull T $receiver, @Nullable SerializationFilter filter, boolean createElementIfEmpty) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        try {
            Element element;
            Class<?> clazz = $receiver.getClass();
            Binding binding = serializer.getClassBinding(clazz);
            if (binding instanceof BeanBinding) {
                element = ((BeanBinding)binding).serialize($receiver, createElementIfEmpty, filter);
            } else {
                Object object = binding.serialize($receiver, null, filter);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jdom.Element");
                }
                element = (Element)object;
            }
            return element;
        }
        catch (XmlSerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Can't serialize instance of " + $receiver.getClass(), (Throwable)e);
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Element serialize$default(Object object, SerializationFilter serializationFilter, boolean bl, int n, Object object2) {
        if ((n & 1) != 0) {
            serializationFilter = XmlSerializer.getDefaultSerializationFilter();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return XmlSerializer.serialize(object, serializationFilter, bl);
    }

    @JvmOverloads
    @Nullable
    public static final <T> Element serialize(@NotNull T $receiver, @Nullable SerializationFilter filter) {
        return XmlSerializer.serialize$default($receiver, filter, false, 2, null);
    }

    @JvmOverloads
    @Nullable
    public static final <T> Element serialize(@NotNull T $receiver) {
        return XmlSerializer.serialize$default($receiver, null, false, 3, null);
    }

    private static final <T> T deserialize(@NotNull Element $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)XmlSerializer.deserialize($receiver, Object.class);
    }

    public static final <T> T deserialize(@NotNull Element $receiver, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        if (Intrinsics.areEqual(clazz, Element.class)) {
            return (T)$receiver;
        }
        try {
            Binding binding = serializer.getClassBinding(clazz);
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.NotNullDeserializeBinding");
            }
            return (T)((NotNullDeserializeBinding)binding).deserialize(null, $receiver);
        }
        catch (XmlSerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Cannot deserialize class " + clazz.getName(), (Throwable)e);
        }
    }

    public static final <T> T deserialize(@NotNull URL url, @NotNull Class<T> aClass) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        try {
            Document document = JDOMUtil.loadDocument((URL)url);
            document = JDOMXIncluder.resolve((Document)document, (String)url.toExternalForm());
            return XmlSerializer.deserialize(document.getRootElement(), aClass);
        }
        catch (IOException e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
        catch (JDOMException e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
    }

    public static final void deserializeInto(@NotNull Element $receiver, @NotNull Object bean) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        try {
            Binding binding = serializer.getClassBinding(bean.getClass());
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            }
            ((BeanBinding)binding).deserializeInto(bean, $receiver);
        }
        catch (XmlSerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
    }

    public static final void deserializeAndLoadState(@NotNull PersistentStateComponent<?> $receiver, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Class clazz = ComponentSerializationUtil.getStateClass($receiver.getClass());
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"ComponentSerializationUt\u2026tateClass<Any>(javaClass)");
        Object state = XmlSerializer.deserialize(element, clazz);
        Object s = state;
        if (!(s instanceof BaseState)) {
            s = null;
        }
        BaseState baseState = (BaseState)s;
        if (baseState != null) {
            baseState.resetModificationCount();
        }
        $receiver.loadState(state);
    }

    public static final void serializeStateInto(@NotNull PersistentStateComponent<?> $receiver, @NotNull Element element) {
        block0: {
            Object obj;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Object obj2 = $receiver.getState();
            if (obj2 == null) break block0;
            Object it = obj = obj2;
            XmlSerializer.serializeObjectInto(it, element);
        }
    }

    public static final void serializeObjectInto(@NotNull Object o, @NotNull Element target) {
        Binding binding;
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (o instanceof Element) {
            Iterator attributeIterator;
            Iterator iterator;
            Iterator iterator2;
            Iterator iterator3 = iterator2 = (iterator = ((Element)o).getChildren().iterator());
            while (iterator3.hasNext()) {
                Element child = (Element)iterator3.next();
                iterator.remove();
                target.addContent(child);
            }
            Iterator iterator4 = attributeIterator = ((Element)o).getAttributes().iterator();
            iterator2 = iterator4;
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)iterator2.next();
                attributeIterator.remove();
                target.setAttribute(attribute);
            }
            return;
        }
        Binding binding2 = binding = serializer.getClassBinding(o.getClass());
        if (binding2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
        }
        ((BeanBinding)binding2).serializeInto(o, target, o instanceof BaseState ? null : XmlSerializer.getDefaultSerializationFilter());
    }
}

