/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.SelectionRequest;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeUpdatePass;
import com.intellij.ide.util.treeView.UpdaterTreeState;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.MutualMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.treeStructure.AlwaysExpandedTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Producer;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.LockToken;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.enumeration.EnumerationCopy;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashSet;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AbstractTreeUi {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.AbstractTreeBuilder");
    protected JTree myTree;
    protected DefaultTreeModel myTreeModel;
    private AbstractTreeStructure myTreeStructure;
    private AbstractTreeUpdater myUpdater;
    private Comparator<NodeDescriptor> myNodeDescriptorComparator;
    private final Comparator<TreeNode> myNodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode n1, TreeNode n2) {
            if (AbstractTreeUi.isLoadingNode(n1) && AbstractTreeUi.isLoadingNode(n2)) {
                return 0;
            }
            if (AbstractTreeUi.isLoadingNode(n1)) {
                return -1;
            }
            if (AbstractTreeUi.isLoadingNode(n2)) {
                return 1;
            }
            NodeDescriptor nodeDescriptor1 = AbstractTreeUi.getDescriptorFrom(n1);
            NodeDescriptor nodeDescriptor2 = AbstractTreeUi.getDescriptorFrom(n2);
            if (nodeDescriptor1 == null && nodeDescriptor2 == null) {
                return 0;
            }
            if (nodeDescriptor1 == null) {
                return -1;
            }
            if (nodeDescriptor2 == null) {
                return 1;
            }
            return AbstractTreeUi.this.myNodeDescriptorComparator != null ? AbstractTreeUi.this.myNodeDescriptorComparator.compare(nodeDescriptor1, nodeDescriptor2) : nodeDescriptor1.getIndex() - nodeDescriptor2.getIndex();
        }
    };
    long myOwnComparatorStamp;
    private long myLastComparatorStamp;
    private DefaultMutableTreeNode myRootNode;
    private final Map<Object, Object> myElementToNodeMap = new HashMap<Object, Object>();
    private final Set<DefaultMutableTreeNode> myUnbuiltNodes = new HashSet<DefaultMutableTreeNode>();
    private TreeExpansionListener myExpansionListener;
    private MySelectionListener mySelectionListener;
    private final QueueProcessor<Runnable> myWorker = new QueueProcessor(runnable -> {
        runnable.run();
        TimeoutUtil.sleep((long)1L);
    });
    private final Set<Runnable> myActiveWorkerTasks = new HashSet<Runnable>();
    private ProgressIndicator myProgress;
    private AbstractTreeNode<Object> TREE_NODE_WRAPPER;
    private boolean myRootNodeWasQueuedToInitialize = false;
    private boolean myRootNodeInitialized = false;
    private final Map<Object, List<NodeAction>> myNodeActions = new HashMap<Object, List<NodeAction>>();
    private boolean myUpdateFromRootRequested;
    private boolean myWasEverShown;
    private boolean myUpdateIfInactive;
    private final Map<Object, UpdateInfo> myLoadedInBackground = new HashMap<Object, UpdateInfo>();
    private final Map<Object, List<NodeAction>> myNodeChildrenActions = new HashMap<Object, List<NodeAction>>();
    private long myClearOnHideDelay = -1L;
    private volatile long ourUi2Countdown;
    private final Set<Runnable> myDeferredSelections = new HashSet<Runnable>();
    private final Set<Runnable> myDeferredExpansions = new HashSet<Runnable>();
    private boolean myCanProcessDeferredSelections;
    private UpdaterTreeState myUpdaterState;
    private AbstractTreeBuilder myBuilder;
    private final Set<DefaultMutableTreeNode> myUpdatingChildren = new THashSet();
    private boolean myCanYield = false;
    private final List<TreeUpdatePass> myYieldingPasses = new ArrayList<TreeUpdatePass>();
    private boolean myYieldingNow;
    private final Set<DefaultMutableTreeNode> myPendingNodeActions = new HashSet<DefaultMutableTreeNode>();
    private final Set<Runnable> myYieldingDoneRunnables = new HashSet<Runnable>();
    private final Alarm myBusyAlarm = new Alarm();
    private final Runnable myWaiterForReady = new TreeRunnable("AbstractTreeUi.myWaiterForReady"){

        @Override
        public void perform() {
            AbstractTreeUi.this.maybeSetBusyAndScheduleWaiterForReady(false, null);
        }
    };
    private final RegistryValue myYieldingUpdate = Registry.get((String)"ide.tree.yieldingUiUpdate");
    private final RegistryValue myShowBusyIndicator = Registry.get((String)"ide.tree.showBusyIndicator");
    private final RegistryValue myWaitForReadyTime = Registry.get((String)"ide.tree.waitForReadyTimeout");
    private boolean myWasEverIndexNotReady;
    private boolean myShowing;
    private final FocusAdapter myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            AbstractTreeUi.this.maybeReady();
        }
    };
    private final Set<DefaultMutableTreeNode> myNotForSmartExpand = new HashSet<DefaultMutableTreeNode>();
    private TreePath myRequestedExpand;
    private TreePath mySilentExpand;
    private TreePath mySilentSelect;
    private final ActionCallback myInitialized = new ActionCallback();
    private final BusyObject.Impl myBusyObject = new BusyObject.Impl(){

        @Override
        public boolean isReady() {
            return AbstractTreeUi.this.isReady(true);
        }

        @Override
        protected void onReadyWasSent() {
            AbstractTreeUi.this.removeActivity();
        }
    };
    private boolean myPassThroughMode = false;
    private final Set<Object> myAutoExpandRoots = new HashSet<Object>();
    private final RegistryValue myAutoExpandDepth = Registry.get((String)"ide.tree.autoExpandMaxDepth");
    private final Set<DefaultMutableTreeNode> myWillBeExpanded = new HashSet<DefaultMutableTreeNode>();
    private SimpleTimerTask myCleanupTask;
    private final AtomicBoolean myCancelRequest = new AtomicBoolean();
    private final ReentrantLock myStateLock = new ReentrantLock();
    private final AtomicBoolean myResettingToReadyNow = new AtomicBoolean();
    private final Map<Progressive, ProgressIndicator> myBatchIndicators = new HashMap<Progressive, ProgressIndicator>();
    private final Map<Progressive, ActionCallback> myBatchCallbacks = new HashMap<Progressive, ActionCallback>();
    private final Map<DefaultMutableTreeNode, DefaultMutableTreeNode> myCancelledBuild = new WeakHashMap<DefaultMutableTreeNode, DefaultMutableTreeNode>();
    private boolean mySelectionIsAdjusted;
    private boolean myReleaseRequested;
    private boolean mySelectionIsBeingAdjusted;
    private final Set<Object> myRevalidatedObjects = new HashSet<Object>();
    private final Set<Runnable> myUserRunnables = new HashSet<Runnable>();
    private UiActivityMonitor myActivityMonitor;
    @NonNls
    private UiActivity myActivityId;

    protected void init(@NotNull AbstractTreeBuilder builder, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        if (builder == null) {
            AbstractTreeUi.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            AbstractTreeUi.$$$reportNull$$$0(1);
        }
        if (treeModel == null) {
            AbstractTreeUi.$$$reportNull$$$0(2);
        }
        this.myBuilder = builder;
        this.myTree = tree;
        this.myTreeModel = treeModel;
        this.myActivityMonitor = UiActivityMonitor.getInstance();
        this.myActivityId = new UiActivity.AsyncBgOperation("TreeUi" + this);
        this.addModelListenerToDianoseAccessOutsideEdt();
        this.TREE_NODE_WRAPPER = builder.createSearchingTreeNodeWrapper();
        this.myTree.setModel(this.myTreeModel);
        this.setRootNode((DefaultMutableTreeNode)treeModel.getRoot());
        this.myTreeStructure = treeStructure;
        this.myNodeDescriptorComparator = comparator;
        this.myUpdateIfInactive = updateIfInactive;
        UIUtil.invokeLaterIfNeeded((Runnable)new TreeRunnable("AbstractTreeUi.init"){

            @Override
            public void perform() {
                if (!AbstractTreeUi.this.wasRootNodeInitialized() && AbstractTreeUi.this.myRootNode.getChildCount() == 0) {
                    AbstractTreeUi.this.insertLoadingNode(AbstractTreeUi.this.myRootNode, true);
                }
            }
        });
        this.myExpansionListener = new MyExpansionListener();
        this.myTree.addTreeExpansionListener(this.myExpansionListener);
        this.mySelectionListener = new MySelectionListener();
        this.myTree.addTreeSelectionListener(this.mySelectionListener);
        this.setUpdater(this.getBuilder().createUpdater());
        this.myProgress = this.getBuilder().createProgressIndicator();
        Disposer.register((Disposable)this.getBuilder(), (Disposable)this.getUpdater());
        if (this.myProgress != null) {
            Disposer.register((Disposable)this.getBuilder(), (Disposable)new Disposable(){

                public void dispose() {
                    AbstractTreeUi.this.myProgress.cancel();
                }
            });
        }
        UiNotifyConnector uiNotify = new UiNotifyConnector(tree, new Activatable(){

            @Override
            public void showNotify() {
                AbstractTreeUi.this.myShowing = true;
                AbstractTreeUi.this.myWasEverShown = true;
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.activate(true);
                }
            }

            @Override
            public void hideNotify() {
                AbstractTreeUi.this.myShowing = false;
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.deactivate();
                }
            }
        });
        Disposer.register((Disposable)this.getBuilder(), (Disposable)uiNotify);
        this.myTree.addFocusListener(this.myFocusListener);
    }

    private boolean isNodeActionsPending() {
        return !this.myNodeActions.isEmpty() || !this.myNodeChildrenActions.isEmpty();
    }

    private void clearNodeActions() {
        this.myNodeActions.clear();
        this.myNodeChildrenActions.clear();
    }

    private void maybeSetBusyAndScheduleWaiterForReady(boolean forcedBusy, @Nullable Object element) {
        if (!this.myShowBusyIndicator.asBoolean()) {
            return;
        }
        boolean canUpdateBusyState = false;
        if (forcedBusy) {
            if (this.canYield() || this.isToBuildChildrenInBackground(element)) {
                canUpdateBusyState = true;
            }
        } else {
            canUpdateBusyState = true;
        }
        if (!canUpdateBusyState) {
            return;
        }
        if (this.myTree instanceof Tree) {
            boolean isBusy;
            Tree tree = (Tree)this.myTree;
            boolean bl = isBusy = !this.isReady(true) || forcedBusy;
            if (isBusy && tree.isShowing()) {
                tree.setPaintBusy(true);
                this.myBusyAlarm.cancelAllRequests();
                this.myBusyAlarm.addRequest(this.myWaiterForReady, this.myWaitForReadyTime.asInteger());
            } else {
                tree.setPaintBusy(false);
            }
        }
    }

    private void setHoldSize(boolean holdSize) {
        if (this.myTree instanceof Tree) {
            Tree tree = (Tree)this.myTree;
            tree.setHoldSize(holdSize);
        }
    }

    private void cleanUpAll() {
        long now = System.currentTimeMillis();
        long timeToCleanup = this.ourUi2Countdown;
        if (timeToCleanup != 0L && now >= timeToCleanup) {
            this.ourUi2Countdown = 0L;
            TreeRunnable runnable = new TreeRunnable("AbstractTreeUi.cleanUpAll"){

                @Override
                public void perform() {
                    if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                        return;
                    }
                    AbstractTreeUi.this.myCleanupTask = null;
                    AbstractTreeUi.this.getBuilder().cleanUp();
                }
            };
            if (this.isPassthroughMode()) {
                runnable.run();
            } else {
                this.invokeLaterIfNeeded(false, runnable);
            }
        }
    }

    protected void doCleanUp() {
        TreeRunnable cleanup = new TreeRunnable("AbstractTreeUi.doCleanUp"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.cleanUpNow();
                }
            }
        };
        if (this.isPassthroughMode()) {
            cleanup.run();
        } else {
            this.invokeLaterIfNeeded(false, cleanup);
        }
    }

    void invokeLaterIfNeeded(boolean forceEdt, final @NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(3);
        }
        TreeRunnable actual = new TreeRunnable("AbstractTreeUi.invokeLaterIfNeeded"){

            @Override
            public void perform() {
                if (!AbstractTreeUi.this.isReleased()) {
                    runnable.run();
                }
            }
        };
        if (this.isPassthroughMode() || !forceEdt && !AbstractTreeUi.isEdt() && !this.isTreeShowing() && !this.myWasEverShown) {
            actual.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)actual);
        }
    }

    public void activate(boolean byShowing) {
        this.cancelCurrentCleanupTask();
        this.myCanProcessDeferredSelections = true;
        this.ourUi2Countdown = 0L;
        if (!this.myWasEverShown || this.myUpdateFromRootRequested || this.myUpdateIfInactive) {
            this.getBuilder().updateFromRoot();
        }
        this.getUpdater().showNotify();
        this.myWasEverShown |= byShowing;
    }

    private void cancelCurrentCleanupTask() {
        if (this.myCleanupTask != null) {
            this.myCleanupTask.cancel();
            this.myCleanupTask = null;
        }
    }

    void deactivate() {
        this.getUpdater().hideNotify();
        this.myBusyAlarm.cancelAllRequests();
        if (!this.myWasEverShown) {
            return;
        }
        if (this.myProgress != null && this.myProgress.isRunning()) {
            this.myProgress.cancel();
        }
        if (!this.isReady()) {
            this.cancelUpdate();
            this.myUpdateFromRootRequested = true;
        }
        if (this.getClearOnHideDelay() >= 0L) {
            this.ourUi2Countdown = System.currentTimeMillis() + this.getClearOnHideDelay();
            this.scheduleCleanUpAll();
        }
    }

    private void scheduleCleanUpAll() {
        this.cancelCurrentCleanupTask();
        this.myCleanupTask = SimpleTimer.getInstance().setUp(new TreeRunnable("AbstractTreeUi.scheduleCleanUpAll"){

            @Override
            public void perform() {
                AbstractTreeUi.this.cleanUpAll();
            }
        }, this.getClearOnHideDelay());
    }

    public void requestRelease() {
        this.myReleaseRequested = true;
        this.cancelUpdate().doWhenDone(new TreeRunnable("AbstractTreeUi.requestRelease: on done"){

            @Override
            public void perform() {
                AbstractTreeUi.this.releaseNow();
            }
        });
    }

    public ProgressIndicator getProgress() {
        return this.myProgress;
    }

    private void releaseNow() {
        try (LockToken ignored = this.acquireLock();){
            this.myTree.removeTreeExpansionListener(this.myExpansionListener);
            this.myTree.removeTreeSelectionListener(this.mySelectionListener);
            this.myTree.removeFocusListener(this.myFocusListener);
            this.disposeNode(this.getRootNode());
            this.myElementToNodeMap.clear();
            this.getUpdater().cancelAllRequests();
            this.myWorker.clear();
            this.clearWorkerTasks();
            this.TREE_NODE_WRAPPER.setValue(null);
            if (this.myProgress != null) {
                this.myProgress.cancel();
            }
            this.cancelCurrentCleanupTask();
            this.myTree = null;
            this.setUpdater(null);
            this.myTreeStructure = null;
            this.myBuilder.releaseUi();
            this.myBuilder = null;
            this.clearNodeActions();
            this.myDeferredSelections.clear();
            this.myDeferredExpansions.clear();
            this.myYieldingDoneRunnables.clear();
        }
    }

    public boolean isReleased() {
        return this.myBuilder == null;
    }

    void doExpandNodeChildren(final @NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(4);
        }
        if (!this.myUnbuiltNodes.contains(node)) {
            return;
        }
        if (this.isLoadedInBackground(this.getElementFor(node))) {
            return;
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        structure.asyncCommit().doWhenDone(new TreeRunnable("AbstractTreeUi.doExpandNodeChildren"){

            @Override
            public void perform() {
                AbstractTreeUi.this.addSubtreeToUpdate(node);
                AbstractTreeUpdater updater = AbstractTreeUi.this.getUpdater();
                if (updater != null) {
                    updater.performUpdate();
                }
            }
        });
    }

    public final AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public final JTree getTree() {
        return this.myTree;
    }

    @Nullable
    private static NodeDescriptor getDescriptorFrom(Object node) {
        Object userObject;
        if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof NodeDescriptor) {
            return (NodeDescriptor)userObject;
        }
        return null;
    }

    @Nullable
    public final DefaultMutableTreeNode getNodeForElement(Object element, boolean validateAgainstStructure) {
        DefaultMutableTreeNode result2 = null;
        if (validateAgainstStructure) {
            DefaultMutableTreeNode node;
            int index = 0;
            while ((node = this.findNode(element, index)) != null) {
                if (this.isNodeValidForElement(element, node)) {
                    result2 = node;
                    break;
                }
                ++index;
            }
        } else {
            result2 = this.getFirstNode(element);
        }
        if (result2 != null && !this.isNodeInStructure(result2)) {
            this.disposeNode(result2);
            result2 = null;
        }
        return result2;
    }

    private boolean isNodeInStructure(DefaultMutableTreeNode node) {
        return TreeUtil.isAncestor(this.getRootNode(), node) && this.getRootNode() == this.myTreeModel.getRoot();
    }

    private boolean isNodeValidForElement(@NotNull Object element, @NotNull DefaultMutableTreeNode node) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(5);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(6);
        }
        return this.isSameHierarchy(element, node) || this.isValidChildOfParent(element, node);
    }

    private boolean isValidChildOfParent(@NotNull Object element, @NotNull DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent;
        Object parentElement;
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(7);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(8);
        }
        if (!this.isInStructure(parentElement = this.getElementFor(parent = (DefaultMutableTreeNode)node.getParent()))) {
            return false;
        }
        if (parent instanceof ElementNode) {
            return ((ElementNode)parent).isValidChild(element);
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode child = parent.getChildAt(i);
            Object eachElement = this.getElementFor(child);
            if (!element.equals(eachElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameHierarchy(@Nullable Object eachParent, @Nullable DefaultMutableTreeNode eachParentNode) {
        boolean valid;
        while (true) {
            if (eachParent == null) {
                valid = eachParentNode == null;
                break;
            }
            if (!eachParent.equals(this.getElementFor(eachParentNode))) {
                valid = false;
                break;
            }
            eachParent = this.getTreeStructure().getParentElement(eachParent);
            eachParentNode = (DefaultMutableTreeNode)eachParentNode.getParent();
        }
        return valid;
    }

    @Nullable
    public final DefaultMutableTreeNode getNodeForPath(@NotNull Object[] path2) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(9);
        }
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path2) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null) break;
        }
        return node;
    }

    public final void buildNodeForElement(Object element) {
        this.getUpdater().performUpdate();
        DefaultMutableTreeNode node = this.getNodeForElement(element, false);
        if (node == null) {
            ArrayList<Object> elements = new ArrayList<Object>();
            while ((element = this.getTreeStructure().getParentElement(element)) != null) {
                elements.add(0, element);
            }
            for (Object e : elements) {
                node = this.getNodeForElement(e, false);
                if (node == null) continue;
                this.expand(node, true);
            }
        }
    }

    public final void buildNodeForPath(@NotNull Object[] path2) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(10);
        }
        this.getUpdater().performUpdate();
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path2) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null || node == path2[path2.length - 1]) continue;
            this.expand(node, true);
        }
    }

    public final void setNodeDescriptorComparator(Comparator<NodeDescriptor> nodeDescriptorComparator) {
        this.myNodeDescriptorComparator = nodeDescriptorComparator;
        this.myLastComparatorStamp = -1L;
        this.getBuilder().queueUpdateFrom(this.getTreeStructure().getRootElement(), true);
    }

    @NotNull
    protected AbstractTreeBuilder getBuilder() {
        AbstractTreeBuilder abstractTreeBuilder = this.myBuilder;
        if (abstractTreeBuilder == null) {
            AbstractTreeUi.$$$reportNull$$$0(11);
        }
        return abstractTreeBuilder;
    }

    protected final void initRootNode() {
        if (this.myUpdateIfInactive) {
            this.activate(false);
        } else {
            this.myUpdateFromRootRequested = true;
        }
    }

    private boolean initRootNodeNowIfNeeded(final @NotNull TreeUpdatePass pass) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(12);
        }
        boolean wasCleanedUp = false;
        if (this.myRootNodeWasQueuedToInitialize) {
            Object root = this.getTreeStructure().getRootElement();
            assert (root != null) : "Root element cannot be null";
            Object currentRoot = this.getElementFor(this.myRootNode);
            if (Comparing.equal((Object)root, (Object)currentRoot)) {
                return false;
            }
            Object rootAgain = this.getTreeStructure().getRootElement();
            if (root != rootAgain && !root.equals(rootAgain)) assert (false) : "getRootElement() if called twice must return either root1 == root2 or root1.equals(root2)";
            this.cleanUpNow();
            wasCleanedUp = true;
        }
        if (this.myRootNodeWasQueuedToInitialize) {
            return true;
        }
        this.myRootNodeWasQueuedToInitialize = true;
        final Object rootElement = this.getTreeStructure().getRootElement();
        this.addNodeAction(rootElement, new NodeAction(){

            @Override
            public void onReady(DefaultMutableTreeNode node) {
                AbstractTreeUi.this.processDeferredActions();
            }
        }, false);
        final Ref rootDescriptor = new Ref(null);
        boolean bgLoading = this.isToBuildChildrenInBackground(rootElement);
        TreeRunnable build = new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: build"){

            @Override
            public void perform() {
                rootDescriptor.set((Object)AbstractTreeUi.this.getTreeStructure().createDescriptor(rootElement, null));
                AbstractTreeUi.this.getRootNode().setUserObject(rootDescriptor.get());
                AbstractTreeUi.this.update((NodeDescriptor)rootDescriptor.get(), true);
                pass.addToUpdated((NodeDescriptor)rootDescriptor.get());
            }
        };
        TreeRunnable update = new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: update"){

            @Override
            public void perform() {
                Object fromDescriptor = AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)rootDescriptor.get());
                if (!AbstractTreeUi.isNodeNull(fromDescriptor)) {
                    AbstractTreeUi.this.createMapping(fromDescriptor, AbstractTreeUi.this.getRootNode());
                }
                AbstractTreeUi.this.insertLoadingNode(AbstractTreeUi.this.getRootNode(), true);
                boolean willUpdate = false;
                if (AbstractTreeUi.this.isAutoExpand((NodeDescriptor)rootDescriptor.get())) {
                    willUpdate = AbstractTreeUi.this.myUnbuiltNodes.contains(AbstractTreeUi.this.getRootNode());
                    AbstractTreeUi.this.expand(AbstractTreeUi.this.getRootNode(), true);
                }
                ActionCallback callback = willUpdate ? ActionCallback.DONE : AbstractTreeUi.this.updateNodeChildren(AbstractTreeUi.this.getRootNode(), pass, null, false, false, false, true, true);
                callback.doWhenDone(new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: on done updateNodeChildren"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.getRootNode().getChildCount() == 0) {
                            AbstractTreeUi.this.myTreeModel.nodeChanged(AbstractTreeUi.this.getRootNode());
                        }
                    }
                });
            }
        };
        if (bgLoading) {
            this.queueToBackground(build, update).done((Consumer<Void>)new TreeRunnable.TreeConsumer<Void>("AbstractTreeUi.initRootNodeNowIfNeeded: on processed queueToBackground"){

                @Override
                public void perform() {
                    AbstractTreeUi.this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: on processed queueToBackground later"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.myRootNodeInitialized = true;
                            AbstractTreeUi.this.processNodeActionsIfReady(AbstractTreeUi.this.myRootNode);
                        }
                    });
                }
            });
        } else {
            build.run();
            update.run();
            this.myRootNodeInitialized = true;
            this.processNodeActionsIfReady(this.myRootNode);
        }
        return wasCleanedUp;
    }

    private boolean isAutoExpand(NodeDescriptor descriptor) {
        return this.isAutoExpand(descriptor, true);
    }

    private boolean isAutoExpand(@Nullable NodeDescriptor descriptor, boolean validate) {
        if (descriptor == null || this.isAlwaysExpandedTree()) {
            return false;
        }
        boolean autoExpand = this.getBuilder().isAutoExpandNode(descriptor);
        Object element = this.getElementFromDescriptor(descriptor);
        if (validate) {
            autoExpand = this.validateAutoExpand(autoExpand, element);
        }
        if (!autoExpand && !this.myTree.isRootVisible() && element != null && element.equals(this.getTreeStructure().getRootElement())) {
            return true;
        }
        return autoExpand;
    }

    private boolean validateAutoExpand(boolean autoExpand, Object element) {
        if (autoExpand) {
            int distance = this.getDistanceToAutoExpandRoot(element);
            if (distance < 0) {
                this.myAutoExpandRoots.add(element);
            } else if (distance >= this.myAutoExpandDepth.asInteger() - 1) {
                autoExpand = false;
            }
            if (autoExpand) {
                DefaultMutableTreeNode node = this.getNodeForElement(element, false);
                autoExpand = this.isInVisibleAutoExpandChain(node);
            }
        }
        return autoExpand;
    }

    private boolean isInVisibleAutoExpandChain(DefaultMutableTreeNode child) {
        for (TreeNode eachParent = child; eachParent != null; eachParent = eachParent.getParent()) {
            if (this.myRootNode == eachParent) {
                return true;
            }
            NodeDescriptor eachDescriptor = AbstractTreeUi.getDescriptorFrom(eachParent);
            if (this.isAutoExpand(eachDescriptor, false)) continue;
            TreePath path2 = AbstractTreeUi.getPathFor(eachParent);
            return this.myWillBeExpanded.contains(path2.getLastPathComponent()) || this.myTree.isExpanded(path2) && this.myTree.isVisible(path2);
        }
        return false;
    }

    private int getDistanceToAutoExpandRoot(Object element) {
        int distance = 0;
        Object eachParent = element;
        while (eachParent != null && !this.myAutoExpandRoots.contains(eachParent)) {
            eachParent = this.getTreeStructure().getParentElement(eachParent);
            ++distance;
        }
        return eachParent != null ? distance : -1;
    }

    private boolean isAutoExpand(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(13);
        }
        return this.isAutoExpand(AbstractTreeUi.getDescriptorFrom(node));
    }

    private boolean isAlwaysExpandedTree() {
        return this.myTree instanceof AlwaysExpandedTree && ((AlwaysExpandedTree)((Object)this.myTree)).isAlwaysExpanded();
    }

    @NotNull
    private Promise<Boolean> update(final @NotNull NodeDescriptor nodeDescriptor, boolean now) {
        Promise<Boolean> promise;
        if (nodeDescriptor == null) {
            AbstractTreeUi.$$$reportNull$$$0(14);
        }
        if (now || this.isPassthroughMode()) {
            promise = Promise.resolve(this.update(nodeDescriptor));
        } else {
            final AsyncPromise<Boolean> result2 = new AsyncPromise<Boolean>();
            promise = result2;
            boolean bgLoading = this.isToBuildInBackground(nodeDescriptor);
            boolean edt = AbstractTreeUi.isEdt();
            if (bgLoading) {
                if (edt) {
                    final AtomicBoolean changes2 = new AtomicBoolean();
                    this.queueToBackground(new TreeRunnable("AbstractTreeUi.update: build"){

                        @Override
                        public void perform() {
                            changes2.set(AbstractTreeUi.this.update(nodeDescriptor));
                        }
                    }, new TreeRunnable("AbstractTreeUi.update: post"){

                        @Override
                        public void perform() {
                            result2.setResult(changes2.get());
                        }
                    });
                } else {
                    result2.setResult(this.update(nodeDescriptor));
                }
            } else if (edt || !this.myWasEverShown) {
                result2.setResult(this.update(nodeDescriptor));
            } else {
                this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.update: later"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.execute(new TreeRunnable("AbstractTreeUi.update: later execute"){

                            @Override
                            public void perform() {
                                result2.setResult(AbstractTreeUi.this.update(nodeDescriptor));
                            }
                        });
                    }
                });
            }
        }
        promise.done((Consumer<Boolean>)((Consumer)changes -> {
            if (nodeDescriptor == null) {
                AbstractTreeUi.$$$reportNull$$$0(189);
            }
            if (!changes.booleanValue()) {
                return;
            }
            this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.update: on done result"){

                @Override
                public void perform() {
                    TreePath path2;
                    Object element = nodeDescriptor.getElement();
                    DefaultMutableTreeNode node = AbstractTreeUi.this.getNodeForElement(element, false);
                    if (node != null && AbstractTreeUi.this.myTree.isVisible(path2 = AbstractTreeUi.getPathFor(node))) {
                        AbstractTreeUi.this.updateNodeImageAndPosition(node, false, true);
                    }
                }
            });
        }));
        Promise<Boolean> promise2 = promise;
        if (promise2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(15);
        }
        return promise2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean update(final @NotNull NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor == null) {
            AbstractTreeUi.$$$reportNull$$$0(16);
        }
        try {
            Throwable throwable;
            LockToken ignored;
            while (true) {
                block21: {
                    ignored = this.attemptLock();
                    throwable = null;
                    if (ignored != null) break;
                    if (this.myProgress != null && this.myProgress.isRunning()) {
                        this.myProgress.cancel();
                    }
                    if (ignored == null) continue;
                    if (throwable == null) break block21;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                ignored.close();
            }
            try {
                final AtomicBoolean update = new AtomicBoolean();
                this.execute(new TreeRunnable("AbstractTreeUi.update"){

                    @Override
                    public void perform() {
                        nodeDescriptor.setUpdateCount(nodeDescriptor.getUpdateCount() + 1L);
                        update.set(AbstractTreeUi.this.getBuilder().updateNodeDescriptor(nodeDescriptor));
                    }
                });
                boolean bl = update.get();
                return bl;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        catch (IndexNotReadyException e) {
            this.warnOnIndexNotReady(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    public void assertIsDispatchThread() {
        if (this.isPassthroughMode()) {
            return;
        }
        if ((this.isTreeShowing() || this.myWasEverShown) && !AbstractTreeUi.isEdt()) {
            LOG.error("Must be in event-dispatch thread");
        }
    }

    private static boolean isEdt() {
        return SwingUtilities.isEventDispatchThread();
    }

    private boolean isTreeShowing() {
        return this.myShowing;
    }

    private void assertNotDispatchThread() {
        if (this.isPassthroughMode()) {
            return;
        }
        if (AbstractTreeUi.isEdt()) {
            LOG.error("Must not be in event-dispatch thread");
        }
    }

    private void processDeferredActions() {
        AbstractTreeUi.processDeferredActions(this.myDeferredSelections);
        AbstractTreeUi.processDeferredActions(this.myDeferredExpansions);
    }

    private static void processDeferredActions(@NotNull Set<Runnable> actions) {
        if (actions == null) {
            AbstractTreeUi.$$$reportNull$$$0(17);
        }
        Runnable[] runnables = actions.toArray(new Runnable[0]);
        actions.clear();
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    @NotNull
    public ActionCallback queueUpdate(Object element) {
        ActionCallback actionCallback = this.queueUpdate(element, true);
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(18);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback queueUpdate(Object fromElement, boolean updateStructure) {
        ActionCallback actionCallback;
        block8: {
            this.assertIsDispatchThread();
            if (this.getUpdater() != null) break block8;
            ActionCallback actionCallback2 = ActionCallback.REJECTED;
            if (actionCallback2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(19);
            }
            return actionCallback2;
        }
        try {
            final ActionCallback result2 = new ActionCallback();
            DefaultMutableTreeNode nodeToUpdate = null;
            boolean updateElementStructure = updateStructure;
            Object element = fromElement;
            while (element != null) {
                DefaultMutableTreeNode node = this.getFirstNode(element);
                if (node != null) {
                    nodeToUpdate = node;
                    break;
                }
                updateElementStructure = true;
                element = this.getTreeStructure().getParentElement(element);
            }
            this.addSubtreeToUpdate(nodeToUpdate != null ? nodeToUpdate : this.getRootNode(), new TreeRunnable("AbstractTreeUi.queueUpdate"){

                @Override
                public void perform() {
                    result2.setDone();
                }
            }, updateElementStructure);
            actionCallback = result2;
        }
        catch (ProcessCanceledException e) {
            ActionCallback actionCallback3 = ActionCallback.REJECTED;
            if (actionCallback3 == null) {
                AbstractTreeUi.$$$reportNull$$$0(21);
            }
            return actionCallback3;
        }
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(20);
        }
        return actionCallback;
    }

    public void doUpdateFromRoot() {
        this.updateSubtree(this.getRootNode(), false);
    }

    public final void updateSubtree(@NotNull DefaultMutableTreeNode node, boolean canSmartExpand) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(22);
        }
        this.updateSubtree(new TreeUpdatePass(node), canSmartExpand);
    }

    public final void updateSubtree(@NotNull TreeUpdatePass pass, boolean canSmartExpand) {
        AbstractTreeUpdater updater;
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(23);
        }
        if ((updater = this.getUpdater()) != null) {
            updater.addSubtreeToUpdate(pass);
        } else {
            this.updateSubtreeNow(pass, canSmartExpand);
        }
    }

    final void updateSubtreeNow(@NotNull TreeUpdatePass pass, boolean canSmartExpand) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(24);
        }
        this.maybeSetBusyAndScheduleWaiterForReady(true, this.getElementFor(pass.getNode()));
        this.setHoldSize(true);
        boolean consumed = this.initRootNodeNowIfNeeded(pass);
        if (consumed) {
            return;
        }
        DefaultMutableTreeNode node = pass.getNode();
        NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor == null) {
            return;
        }
        if (pass.isUpdateStructure()) {
            boolean invisible;
            this.setUpdaterState(new UpdaterTreeState(this)).beforeSubtreeUpdate();
            boolean forceUpdate = true;
            TreePath path2 = AbstractTreeUi.getPathFor(node);
            boolean bl = invisible = !this.myTree.isExpanded(path2) && (path2.getParentPath() == null || !this.myTree.isExpanded(path2.getParentPath()));
            if (invisible && this.myUnbuiltNodes.contains(node)) {
                forceUpdate = false;
            }
            this.updateNodeChildren(node, pass, null, false, canSmartExpand, forceUpdate, false, pass.isUpdateChildren());
        } else {
            this.updateRow(0, pass);
        }
    }

    private void updateRow(final int row, final @NotNull TreeUpdatePass pass) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(25);
        }
        LOG.debug("updateRow: ", new Object[]{row, " - ", pass});
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.updateRow"){

            @Override
            public void perform() {
                NodeDescriptor descriptor;
                if (row >= AbstractTreeUi.this.getTree().getRowCount()) {
                    return;
                }
                TreePath path2 = AbstractTreeUi.this.getTree().getPathForRow(row);
                if (path2 != null && (descriptor = AbstractTreeUi.getDescriptorFrom(path2.getLastPathComponent())) != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
                    AbstractTreeUi.this.maybeYeild(new AsyncRunnable(){

                        @Override
                        @NotNull
                        public Promise<?> run() {
                            Promise<Boolean> promise = AbstractTreeUi.this.update(descriptor, false).done(new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.updateRow: inner"){

                                @Override
                                public void perform() {
                                    AbstractTreeUi.this.updateRow(row + 1, pass);
                                }
                            });
                            if (promise == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return promise;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeUi$24$1", "run"));
                        }
                    }, pass, node);
                }
            }
        });
    }

    boolean isToBuildChildrenInBackground(Object element) {
        AbstractTreeStructure structure = this.getTreeStructure();
        return element != null && structure.isToBuildChildrenInBackground(element);
    }

    private boolean isToBuildInBackground(NodeDescriptor descriptor) {
        return this.isToBuildChildrenInBackground(this.getElementFromDescriptor(descriptor));
    }

    @NotNull
    private UpdaterTreeState setUpdaterState(@NotNull UpdaterTreeState state) {
        if (state == null) {
            AbstractTreeUi.$$$reportNull$$$0(26);
        }
        if (this.myUpdaterState != null && this.myUpdaterState.equals(state)) {
            UpdaterTreeState updaterTreeState = state;
            if (updaterTreeState == null) {
                AbstractTreeUi.$$$reportNull$$$0(27);
            }
            return updaterTreeState;
        }
        UpdaterTreeState oldState = this.myUpdaterState;
        if (oldState == null) {
            this.myUpdaterState = state;
            UpdaterTreeState updaterTreeState = state;
            if (updaterTreeState == null) {
                AbstractTreeUi.$$$reportNull$$$0(28);
            }
            return updaterTreeState;
        }
        oldState.addAll(state);
        UpdaterTreeState updaterTreeState = oldState;
        if (updaterTreeState == null) {
            AbstractTreeUi.$$$reportNull$$$0(29);
        }
        return updaterTreeState;
    }

    protected void doUpdateNode(@NotNull DefaultMutableTreeNode node) {
        NodeDescriptor descriptor;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(30);
        }
        if ((descriptor = AbstractTreeUi.getDescriptorFrom(node)) == null) {
            return;
        }
        Object prevElement = this.getElementFromDescriptor(descriptor);
        if (prevElement == null) {
            return;
        }
        this.update(descriptor, false).done((Consumer<Boolean>)((Consumer)changes -> {
            if (node == null) {
                AbstractTreeUi.$$$reportNull$$$0(188);
            }
            if (!this.isValid(descriptor) && this.isInStructure(prevElement)) {
                this.getUpdater().addSubtreeToUpdateByElement(this.getTreeStructure().getParentElement(prevElement));
                return;
            }
            if (changes.booleanValue()) {
                this.updateNodeImageAndPosition(node, false, (boolean)changes);
            }
        }));
    }

    public Object getElementFromDescriptor(NodeDescriptor descriptor) {
        return this.getBuilder().getTreeStructureElement(descriptor);
    }

    @NotNull
    private ActionCallback updateNodeChildren(final @NotNull DefaultMutableTreeNode node, final @NotNull TreeUpdatePass pass, final @Nullable LoadedChildren loadedChildren, final boolean forcedNow, final boolean toSmartExpand, final boolean forceUpdate, final boolean descriptorIsUpToDate, final boolean updateChildren) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(31);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(32);
        }
        AbstractTreeStructure treeStructure = this.getTreeStructure();
        ActionCallback result2 = treeStructure.asyncCommit();
        result2.doWhenDone(new TreeRunnable("AbstractTreeUi.updateNodeChildren: on done"){

            @Override
            public void perform() {
                try {
                    AbstractTreeUi.this.removeFromCancelled(node);
                    AbstractTreeUi.this.execute(new TreeRunnable("AbstractTreeUi.updateNodeChildren: execute"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.doUpdateChildren(node, pass, loadedChildren, forcedNow, toSmartExpand, forceUpdate, descriptorIsUpToDate, updateChildren);
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    AbstractTreeUi.this.addToCancelled(node);
                    throw e;
                }
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(33);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateChildren(final @NotNull DefaultMutableTreeNode node, final @NotNull TreeUpdatePass pass, @Nullable LoadedChildren loadedChildren, boolean forcedNow, final boolean toSmartExpand, boolean forceUpdate, boolean descriptorIsUpToDate, final boolean updateChildren) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(34);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(35);
        }
        try {
            boolean notRequiredToUpdateChildren;
            NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
            if (descriptor == null) {
                this.removeFromUnbuilt(node);
                this.removeLoading(node, true);
                return;
            }
            boolean descriptorIsReady = descriptorIsUpToDate || pass.isUpdated(descriptor);
            final boolean wasExpanded = this.myTree.isExpanded(new TreePath(node.getPath())) || this.isAutoExpand(node);
            boolean wasLeaf = node.getChildCount() == 0;
            boolean bgBuild = this.isToBuildInBackground(descriptor);
            boolean bl = notRequiredToUpdateChildren = !forcedNow && !wasExpanded;
            if (notRequiredToUpdateChildren && forceUpdate) {
                boolean alwaysPlus = this.getBuilder().isAlwaysShowPlus(descriptor);
                if (alwaysPlus && wasLeaf) {
                    notRequiredToUpdateChildren = false;
                } else {
                    notRequiredToUpdateChildren = alwaysPlus;
                    if (notRequiredToUpdateChildren && !this.myUnbuiltNodes.contains(node)) {
                        this.removeChildren(node);
                    }
                }
            }
            final AtomicReference<LoadedChildren> preloaded = new AtomicReference<LoadedChildren>(loadedChildren);
            if (notRequiredToUpdateChildren) {
                if (this.myUnbuiltNodes.contains(node) && node.getChildCount() == 0) {
                    this.insertLoadingNode(node, true);
                }
                if (!descriptorIsReady) {
                    this.update(descriptor, false);
                }
                return;
            }
            if (!forcedNow && !bgBuild && this.myUnbuiltNodes.contains(node)) {
                if (!descriptorIsReady) {
                    this.update(descriptor, true);
                    descriptorIsReady = true;
                }
                if (this.processAlwaysLeaf(node) || !updateChildren) {
                    return;
                }
                Pair<Boolean, LoadedChildren> unbuilt = this.processUnbuilt(node, descriptor, pass, wasExpanded, null);
                if (((Boolean)unbuilt.getFirst()).booleanValue()) {
                    return;
                }
                preloaded.set((LoadedChildren)unbuilt.getSecond());
            }
            final boolean childForceUpdate = this.isChildNodeForceUpdate(node, forceUpdate, wasExpanded);
            if (!forcedNow && this.isToBuildInBackground(descriptor)) {
                boolean alwaysLeaf = this.processAlwaysLeaf(node);
                this.queueBackgroundUpdate(new UpdateInfo(descriptor, pass, this.canSmartExpand(node, toSmartExpand), wasExpanded, childForceUpdate, descriptorIsReady, !alwaysLeaf && updateChildren), node);
            } else if (!descriptorIsReady) {
                this.update(descriptor, false).done((Consumer<Boolean>)new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.doUpdateChildren"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.processAlwaysLeaf(node) || !updateChildren) {
                            return;
                        }
                        AbstractTreeUi.this.updateNodeChildrenNow(node, pass, (LoadedChildren)preloaded.get(), toSmartExpand, wasExpanded, childForceUpdate);
                    }
                });
            } else {
                if (this.processAlwaysLeaf(node) || !updateChildren) {
                    return;
                }
                this.updateNodeChildrenNow(node, pass, preloaded.get(), toSmartExpand, wasExpanded, childForceUpdate);
            }
        }
        finally {
            if (!this.isReleased()) {
                this.processNodeActionsIfReady(node);
            }
        }
    }

    private boolean processAlwaysLeaf(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(36);
        }
        Object element = this.getElementFor(node);
        NodeDescriptor desc = AbstractTreeUi.getDescriptorFrom(node);
        if (desc == null) {
            return false;
        }
        if (this.getTreeStructure().isAlwaysLeaf(element)) {
            this.removeFromUnbuilt(node);
            this.removeLoading(node, true);
            if (node.getChildCount() > 0) {
                final TreeNode[] children = new TreeNode[node.getChildCount()];
                for (int i = 0; i < node.getChildCount(); ++i) {
                    children[i] = node.getChildAt(i);
                }
                if (this.isSelectionInside(node)) {
                    this.addSelectionPath(AbstractTreeUi.getPathFor(node), true, Conditions.alwaysTrue(), null);
                }
                this.processInnerChange(new TreeRunnable("AbstractTreeUi.processAlwaysLeaf"){

                    @Override
                    public void perform() {
                        for (TreeNode each : children) {
                            AbstractTreeUi.this.removeNodeFromParent((MutableTreeNode)each, true);
                            AbstractTreeUi.this.disposeNode((DefaultMutableTreeNode)each);
                        }
                    }
                });
            }
            this.removeFromUnbuilt(node);
            desc.setWasDeclaredAlwaysLeaf(true);
            this.processNodeActionsIfReady(node);
            return true;
        }
        boolean wasLeaf = desc.isWasDeclaredAlwaysLeaf();
        desc.setWasDeclaredAlwaysLeaf(false);
        if (wasLeaf) {
            this.insertLoadingNode(node, true);
        }
        return false;
    }

    private boolean isChildNodeForceUpdate(@NotNull DefaultMutableTreeNode node, boolean parentForceUpdate, boolean parentExpanded) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(37);
        }
        TreePath path2 = AbstractTreeUi.getPathFor(node);
        return parentForceUpdate && (parentExpanded || this.myTree.isExpanded(path2));
    }

    private void updateNodeChildrenNow(final @NotNull DefaultMutableTreeNode node, final @NotNull TreeUpdatePass pass, @Nullable LoadedChildren preloadedChildren, boolean toSmartExpand, final boolean wasExpanded, final boolean forceUpdate) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(38);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(39);
        }
        if (this.isUpdatingChildrenNow(node)) {
            return;
        }
        if (!this.canInitiateNewActivity()) {
            throw new ProcessCanceledException();
        }
        final NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
        final MutualMap<Object, Integer> elementToIndexMap = this.loadElementsFromStructure(descriptor, preloadedChildren);
        final LoadedChildren loadedChildren = preloadedChildren != null ? preloadedChildren : new LoadedChildren(elementToIndexMap.getKeys().toArray());
        this.addToUpdatingChildren(node);
        pass.setCurrentNode(node);
        final boolean canSmartExpand = this.canSmartExpand(node, toSmartExpand);
        this.removeFromUnbuilt(node);
        this.processExistingNodes(node, elementToIndexMap, pass, this.canSmartExpand(node, toSmartExpand), forceUpdate, wasExpanded, preloadedChildren).done(new TreeRunnable.TreeConsumer("AbstractTreeUi.updateNodeChildrenNow: on done processExistingNodes"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.isDisposed(node)) {
                    AbstractTreeUi.this.removeFromUpdatingChildren(node);
                    return;
                }
                AbstractTreeUi.this.removeLoading(node, false);
                final boolean expanded = AbstractTreeUi.this.isExpanded(node, wasExpanded);
                if (expanded) {
                    AbstractTreeUi.this.myWillBeExpanded.add(node);
                } else {
                    AbstractTreeUi.this.myWillBeExpanded.remove(node);
                }
                AbstractTreeUi.this.collectNodesToInsert(descriptor, (MutualMap<Object, Integer>)elementToIndexMap, node, expanded, loadedChildren).doWhenDone(nodesToInsert -> {
                    if (node == null) {
                        29.$$$reportNull$$$0(0);
                    }
                    if (pass == null) {
                        29.$$$reportNull$$$0(1);
                    }
                    AbstractTreeUi.this.insertNodesInto(nodesToInsert, node);
                    ActionCallback callback = AbstractTreeUi.this.updateNodesToInsert(nodesToInsert, pass, canSmartExpand, AbstractTreeUi.this.isChildNodeForceUpdate(node, forceUpdate, expanded));
                    callback.doWhenDone(new TreeRunnable("AbstractTreeUi.updateNodeChildrenNow: on done updateNodesToInsert"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.removeLoading(node, false);
                            AbstractTreeUi.this.removeFromUpdatingChildren(node);
                            if (node.getChildCount() > 0 && expanded) {
                                AbstractTreeUi.this.expand(node, canSmartExpand);
                            }
                            if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                throw new ProcessCanceledException();
                            }
                            Object element = AbstractTreeUi.this.getElementFor(node);
                            AbstractTreeUi.this.addNodeAction(element, new NodeAction(){

                                @Override
                                public void onReady(@NotNull DefaultMutableTreeNode node1) {
                                    if (node1 == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    AbstractTreeUi.this.removeLoading(node1, false);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "com/intellij/ide/util/treeView/AbstractTreeUi$29$2$1", "onReady"));
                                }
                            }, false);
                            AbstractTreeUi.this.processNodeActionsIfReady(node);
                        }
                    });
                }).doWhenProcessed(new TreeRunnable("AbstractTreeUi.updateNodeChildrenNow: on processed collectNodesToInsert"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.myWillBeExpanded.remove(node);
                        AbstractTreeUi.this.removeFromUpdatingChildren(node);
                        AbstractTreeUi.this.processNodeActionsIfReady(node);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pass";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/util/treeView/AbstractTreeUi$29";
                objectArray[2] = "lambda$perform$0";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).rejected((Consumer<Throwable>)new TreeRunnable.TreeConsumer<Throwable>("AbstractTreeUi.updateNodeChildrenNow: on reject processExistingNodes"){

            @Override
            public void perform() {
                AbstractTreeUi.this.removeFromUpdatingChildren(node);
                AbstractTreeUi.this.processNodeActionsIfReady(node);
            }
        });
    }

    private boolean isDisposed(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(40);
        }
        return !node.isNodeAncestor((DefaultMutableTreeNode)this.myTree.getModel().getRoot());
    }

    private void expandSilently(TreePath path2) {
        this.assertIsDispatchThread();
        try {
            this.mySilentExpand = path2;
            this.getTree().expandPath(path2);
        }
        finally {
            this.mySilentExpand = null;
        }
    }

    private void addSelectionSilently(TreePath path2) {
        this.assertIsDispatchThread();
        try {
            this.mySilentSelect = path2;
            this.getTree().getSelectionModel().addSelectionPath(path2);
        }
        finally {
            this.mySilentSelect = null;
        }
    }

    private void expand(@NotNull DefaultMutableTreeNode node, boolean canSmartExpand) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(41);
        }
        this.expand(new TreePath(node.getPath()), canSmartExpand);
    }

    private void expand(@NotNull TreePath path2, boolean canSmartExpand) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(42);
        }
        Object last = path2.getLastPathComponent();
        boolean isLeaf = this.myTree.getModel().isLeaf(path2.getLastPathComponent());
        boolean isRoot = last == this.myTree.getModel().getRoot();
        TreePath parent = path2.getParentPath();
        if (isRoot && !this.myTree.isExpanded(path2)) {
            if (this.myTree.isRootVisible() || this.myUnbuiltNodes.contains(last)) {
                this.insertLoadingNode((DefaultMutableTreeNode)last, false);
            }
            this.expandPath(path2, canSmartExpand);
        } else if (this.myTree.isExpanded(path2) || isLeaf && parent != null && this.myTree.isExpanded(parent) && !this.myUnbuiltNodes.contains(last) && !this.isCancelled(last)) {
            if (last instanceof DefaultMutableTreeNode) {
                this.processNodeActionsIfReady((DefaultMutableTreeNode)last);
            }
        } else if (isLeaf && (this.myUnbuiltNodes.contains(last) || this.isCancelled(last))) {
            this.insertLoadingNode((DefaultMutableTreeNode)last, true);
            this.expandPath(path2, canSmartExpand);
        } else if (isLeaf && parent != null) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent.getLastPathComponent();
            if (parentNode != null) {
                this.addToUnbuilt(parentNode);
            }
            this.expandPath(parent, canSmartExpand);
        } else {
            this.expandPath(path2, canSmartExpand);
        }
    }

    private void addToUnbuilt(DefaultMutableTreeNode node) {
        this.myUnbuiltNodes.add(node);
    }

    private void removeFromUnbuilt(DefaultMutableTreeNode node) {
        this.myUnbuiltNodes.remove(node);
    }

    private Pair<Boolean, LoadedChildren> processUnbuilt(final @NotNull DefaultMutableTreeNode node, final NodeDescriptor descriptor, final @NotNull TreeUpdatePass pass, final boolean isExpanded, final @Nullable LoadedChildren loadedChildren) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(43);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(44);
        }
        final Ref result2 = new Ref();
        this.execute(new TreeRunnable("AbstractTreeUi.processUnbuilt"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                if (!isExpanded && AbstractTreeUi.this.getBuilder().isAlwaysShowPlus(descriptor)) {
                    result2.set((Object)new Pair((Object)true, null));
                    return;
                }
                final Object element = AbstractTreeUi.this.getElementFor(node);
                if (element == null) {
                    this.trace("null element for node " + node);
                    result2.set((Object)new Pair((Object)true, null));
                    return;
                }
                AbstractTreeUi.this.addToUpdatingChildren(node);
                try {
                    boolean processed2;
                    LoadedChildren children;
                    LoadedChildren loadedChildren2 = children = loadedChildren != null ? loadedChildren : new LoadedChildren(AbstractTreeUi.this.getChildrenFor(element));
                    if (children.getElements().isEmpty()) {
                        AbstractTreeUi.this.removeFromUnbuilt(node);
                        AbstractTreeUi.this.removeLoading(node, true);
                        processed2 = true;
                    } else {
                        if (AbstractTreeUi.this.isAutoExpand(node)) {
                            AbstractTreeUi.this.addNodeAction(AbstractTreeUi.this.getElementFor(node), new NodeAction(){

                                @Override
                                public void onReady(@NotNull DefaultMutableTreeNode node) {
                                    if (node == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    TreePath path2 = new TreePath(node.getPath());
                                    if (AbstractTreeUi.this.getTree().isExpanded(path2) || children.getElements().isEmpty()) {
                                        AbstractTreeUi.this.removeLoading(node, false);
                                    } else {
                                        AbstractTreeUi.this.maybeYeild(new AsyncRunnable(){

                                            @Override
                                            @NotNull
                                            public Promise<?> run() {
                                                AbstractTreeUi.this.expand(element, null);
                                                Promise promise = Promises.resolvedPromise();
                                                if (promise == null) {
                                                    1.$$$reportNull$$$0(0);
                                                }
                                                return promise;
                                            }

                                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeUi$30$1$1", "run"));
                                            }
                                        }, pass, node);
                                    }
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/AbstractTreeUi$30$1", "onReady"));
                                }
                            }, false);
                        }
                        processed2 = false;
                    }
                    AbstractTreeUi.this.removeFromUpdatingChildren(node);
                    AbstractTreeUi.this.processNodeActionsIfReady(node);
                    result2.set((Object)new Pair((Object)processed2, (Object)children));
                }
                finally {
                    AbstractTreeUi.this.removeFromUpdatingChildren(node);
                }
            }
        });
        return (Pair)result2.get();
    }

    private boolean removeIfLoading(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(45);
        }
        if (AbstractTreeUi.isLoadingNode(node)) {
            this.moveSelectionToParentIfNeeded(node);
            this.removeNodeFromParent((MutableTreeNode)node, false);
            return true;
        }
        return false;
    }

    private void moveSelectionToParentIfNeeded(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(46);
        }
        TreePath path2 = AbstractTreeUi.getPathFor(node);
        if (this.myTree.getSelectionModel().isPathSelected(path2)) {
            TreePath parentPath = path2.getParentPath();
            this.myTree.getSelectionModel().removeSelectionPath(path2);
            if (parentPath != null) {
                this.myTree.getSelectionModel().addSelectionPath(parentPath);
            }
        }
    }

    private Object[] getChildrenFor(final Object element) {
        final Ref passOne = new Ref();
        try (LockToken ignored = this.acquireLock();){
            this.execute(new TreeRunnable("AbstractTreeUi.getChildrenFor"){

                @Override
                public void perform() {
                    passOne.set((Object)AbstractTreeUi.this.getTreeStructure().getChildElements(element));
                }
            });
        }
        catch (IndexNotReadyException e) {
            this.warnOnIndexNotReady(e);
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (!Registry.is((String)"ide.tree.checkStructure")) {
            return (Object[])passOne.get();
        }
        Object[] passTwo = this.getTreeStructure().getChildElements(element);
        HashSet<Object> two = new HashSet<Object>(Arrays.asList(passTwo));
        if (((Object[])passOne.get()).length != passTwo.length) {
            LOG.error("AbstractTreeStructure.getChildren() must either provide same objects or new objects but with correct hashCode() and equals() methods. Wrong parent element=" + element);
        } else {
            for (Object eachInOne : (Object[])passOne.get()) {
                if (two.contains(eachInOne)) continue;
                LOG.error("AbstractTreeStructure.getChildren() must either provide same objects or new objects but with correct hashCode() and equals() methods. Wrong parent element=" + element);
                break;
            }
        }
        return (Object[])passOne.get();
    }

    private void warnOnIndexNotReady(IndexNotReadyException e) {
        if (!this.myWasEverIndexNotReady) {
            this.myWasEverIndexNotReady = true;
            LOG.error("Tree is not dumb-mode-aware; treeBuilder=" + this.getBuilder() + " treeStructure=" + this.getTreeStructure(), (Throwable)e);
        }
    }

    @NotNull
    private ActionCallback updateNodesToInsert(@NotNull List<TreeNode> nodesToInsert, @NotNull TreeUpdatePass pass, boolean canSmartExpand, boolean forceUpdate) {
        if (nodesToInsert == null) {
            AbstractTreeUi.$$$reportNull$$$0(47);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(48);
        }
        ActionCallback.Chunk chunk = new ActionCallback.Chunk();
        for (TreeNode node : nodesToInsert) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node;
            ActionCallback callback = this.updateNodeChildren(childNode, pass, null, false, canSmartExpand, forceUpdate, true, true);
            if (callback.isDone()) continue;
            chunk.add(callback);
        }
        ActionCallback actionCallback = chunk.getWhenProcessed();
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(49);
        }
        return actionCallback;
    }

    @NotNull
    private Promise<?> processExistingNodes(final @NotNull DefaultMutableTreeNode node, final @NotNull MutualMap<Object, Integer> elementToIndexMap, final @NotNull TreeUpdatePass pass, final boolean canSmartExpand, final boolean forceUpdate, final boolean wasExpaned, final @Nullable LoadedChildren preloaded) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(50);
        }
        if (elementToIndexMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(51);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(52);
        }
        final List<TreeNode> childNodes = TreeUtil.listChildren(node);
        Promise<?> promise = this.maybeYeild(new AsyncRunnable(){

            @Override
            @NotNull
            public Promise<?> run() {
                if (pass.isExpired()) {
                    Promise promise = Promises.rejectedPromise();
                    if (promise == null) {
                        32.$$$reportNull$$$0(0);
                    }
                    return promise;
                }
                if (childNodes.isEmpty()) {
                    Promise promise = Promises.resolvedPromise();
                    if (promise == null) {
                        32.$$$reportNull$$$0(1);
                    }
                    return promise;
                }
                SmartList promises = new SmartList();
                for (TreeNode each : childNodes) {
                    final DefaultMutableTreeNode eachChild = (DefaultMutableTreeNode)each;
                    if (AbstractTreeUi.isLoadingNode(eachChild)) continue;
                    final boolean childForceUpdate = AbstractTreeUi.this.isChildNodeForceUpdate(eachChild, forceUpdate, wasExpaned);
                    promises.add(AbstractTreeUi.this.maybeYeild(new AsyncRunnable(){

                        @Override
                        @NotNull
                        public Promise<?> run() {
                            NodeDescriptor descriptor = preloaded != null ? preloaded.getDescriptor(AbstractTreeUi.this.getElementFor(eachChild)) : null;
                            NodeDescriptor descriptorFromNode = AbstractTreeUi.getDescriptorFrom(eachChild);
                            if (AbstractTreeUi.this.isValid(descriptor)) {
                                eachChild.setUserObject(descriptor);
                                if (descriptorFromNode != null) {
                                    descriptor.setChildrenSortingStamp(descriptorFromNode.getChildrenSortingStamp());
                                }
                            } else {
                                descriptor = descriptorFromNode;
                            }
                            Promise promise = AbstractTreeUi.this.processExistingNode(eachChild, descriptor, node, (MutualMap<Object, Integer>)elementToIndexMap, pass, canSmartExpand, childForceUpdate, preloaded);
                            if (promise == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return promise;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeUi$32$1", "run"));
                        }
                    }, pass, node));
                    for (Promise promise : promises) {
                        if (promise.getState() != Promise.State.REJECTED) continue;
                        Promise promise2 = Promises.rejectedPromise();
                        if (promise2 == null) {
                            32.$$$reportNull$$$0(2);
                        }
                        return promise2;
                    }
                }
                Promise<?> promise = Promises.all(promises);
                if (promise == null) {
                    32.$$$reportNull$$$0(3);
                }
                return promise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeUi$32", "run"));
            }
        }, pass, node);
        if (promise == null) {
            AbstractTreeUi.$$$reportNull$$$0(53);
        }
        return promise;
    }

    private boolean isRerunNeeded(@NotNull TreeUpdatePass pass) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(54);
        }
        if (pass.isExpired() || !this.canInitiateNewActivity()) {
            return false;
        }
        boolean rerunBecauseTreeIsHidden = !pass.isExpired() && !this.isTreeShowing() && this.getUpdater().isInPostponeMode();
        return rerunBecauseTreeIsHidden || this.getUpdater().isRerunNeededFor(pass);
    }

    public static <T> T calculateYieldingToWriteAction(Producer<T> producer) throws ProcessCanceledException {
        if (!Registry.is((String)"ide.abstractTreeUi.BuildChildrenInBackgroundYieldingToWriteAction") || ApplicationManager.getApplication().isDispatchThread()) {
            return (T)producer.produce();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && indicator.isRunning()) {
            return (T)producer.produce();
        }
        Ref result2 = new Ref();
        boolean succeeded = ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> result2.set(producer.produce()), indicator);
        if (!succeeded || indicator != null && indicator.isCanceled()) {
            throw new ProcessCanceledException();
        }
        return (T)result2.get();
    }

    @NotNull
    private Promise<?> maybeYeild(final @NotNull AsyncRunnable processRunnable, final @NotNull TreeUpdatePass pass, final DefaultMutableTreeNode node) {
        Promise<?> promise;
        if (processRunnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(55);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(56);
        }
        if (this.isRerunNeeded(pass)) {
            this.getUpdater().requeue(pass);
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(57);
            }
            return promise2;
        }
        if (this.isToYieldUpdateFor(node)) {
            final AsyncPromise result2 = new AsyncPromise();
            pass.setCurrentNode(node);
            boolean wasRun = this.yieldAndRun(new TreeRunnable("AbstractTreeUi.maybeYeild"){

                @Override
                public void perform() {
                    if (pass.isExpired()) {
                        result2.setError("expired");
                        return;
                    }
                    if (AbstractTreeUi.this.isRerunNeeded(pass)) {
                        AbstractTreeUi.this.runDone(new TreeRunnable("AbstractTreeUi.maybeYeild: rerun"){

                            @Override
                            public void perform() {
                                if (!pass.isExpired()) {
                                    AbstractTreeUi.this.queueUpdate(AbstractTreeUi.this.getElementFor(node));
                                }
                            }
                        });
                        result2.setError("requeue");
                    } else {
                        try {
                            AbstractTreeUi.this.execute(processRunnable).notify(result2);
                        }
                        catch (ProcessCanceledException e) {
                            pass.expire();
                            AbstractTreeUi.this.cancelUpdate();
                            result2.setError("rejected");
                        }
                    }
                }
            }, pass);
            if (!wasRun) {
                result2.setError("rejected");
            }
            AsyncPromise asyncPromise = result2;
            if (asyncPromise == null) {
                AbstractTreeUi.$$$reportNull$$$0(58);
            }
            return asyncPromise;
        }
        try {
            promise = this.execute(processRunnable);
        }
        catch (ProcessCanceledException e) {
            pass.expire();
            this.cancelUpdate();
            Promise promise3 = Promises.rejectedPromise();
            if (promise3 == null) {
                AbstractTreeUi.$$$reportNull$$$0(60);
            }
            return promise3;
        }
        if (promise == null) {
            AbstractTreeUi.$$$reportNull$$$0(59);
        }
        return promise;
    }

    @NotNull
    private Promise<?> execute(@NotNull AsyncRunnable runnable) throws ProcessCanceledException {
        Promise<?> promise;
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(61);
        }
        try {
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
            Promise<?> promise2 = runnable.run();
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
            promise = promise2;
        }
        catch (ProcessCanceledException e) {
            if (!this.isReleased()) {
                this.setCancelRequested(true);
                this.resetToReady();
            }
            throw e;
        }
        if (promise == null) {
            AbstractTreeUi.$$$reportNull$$$0(62);
        }
        return promise;
    }

    private void execute(@NotNull Runnable runnable) throws ProcessCanceledException {
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(63);
        }
        try {
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
            runnable.run();
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
        }
        catch (ProcessCanceledException e) {
            if (!this.isReleased()) {
                this.setCancelRequested(true);
                this.resetToReady();
            }
            throw e;
        }
    }

    private boolean canInitiateNewActivity() {
        return !this.isCancelProcessed() && !this.myReleaseRequested && !this.isReleased();
    }

    private void resetToReady() {
        if (this.isReady()) {
            return;
        }
        if (this.myResettingToReadyNow.get()) {
            this._getReady();
            return;
        }
        this.myResettingToReadyNow.set(true);
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.resetToReady: later"){

            @Override
            public void perform() {
                Progressive[] progressives;
                if (!AbstractTreeUi.this.myResettingToReadyNow.get()) {
                    return;
                }
                for (Progressive each : progressives = AbstractTreeUi.this.myBatchIndicators.keySet().toArray(new Progressive[AbstractTreeUi.this.myBatchIndicators.size()])) {
                    ((ProgressIndicator)AbstractTreeUi.this.myBatchIndicators.remove(each)).cancel();
                    ((ActionCallback)AbstractTreeUi.this.myBatchCallbacks.remove(each)).setRejected();
                }
                AbstractTreeUi.this.resetToReadyNow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ActionCallback resetToReadyNow() {
        if (this.isReleased()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractTreeUi.$$$reportNull$$$0(64);
            }
            return actionCallback;
        }
        this.assertIsDispatchThread();
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = this.myUpdatingChildren;
        synchronized (this.myUpdatingChildren) {
            Object[] bg;
            DefaultMutableTreeNode[] uc = this.myUpdatingChildren.toArray(new DefaultMutableTreeNode[0]);
            // ** MonitorExit[defaultMutableTreeNodeArray] (shouldn't be in output)
            for (DefaultMutableTreeNode each : uc) {
                this.resetIncompleteNode(each);
            }
            for (Object each : bg = this.myLoadedInBackground.keySet().toArray(new Object[this.myLoadedInBackground.size()])) {
                DefaultMutableTreeNode node = this.getNodeForElement(each, false);
                if (node == null) continue;
                this.resetIncompleteNode(node);
            }
            this.myUpdaterState = null;
            this.getUpdater().reset();
            this.myYieldingNow = false;
            this.myYieldingPasses.clear();
            this.myYieldingDoneRunnables.clear();
            this.myNodeActions.clear();
            this.myNodeChildrenActions.clear();
            Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
            synchronized (set) {
                this.myUpdatingChildren.clear();
            }
            this.myLoadedInBackground.clear();
            this.myDeferredExpansions.clear();
            this.myDeferredSelections.clear();
            ActionCallback actionCallback = this._getReady();
            actionCallback.doWhenDone(new TreeRunnable("AbstractTreeUi.resetToReadyNow: on done"){

                @Override
                public void perform() {
                    AbstractTreeUi.this.myResettingToReadyNow.set(false);
                    AbstractTreeUi.this.setCancelRequested(false);
                }
            });
            this.maybeReady();
            ActionCallback actionCallback2 = actionCallback;
            if (actionCallback2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(65);
            }
            return actionCallback2;
        }
    }

    public void addToCancelled(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(66);
        }
        this.myCancelledBuild.put(node, node);
    }

    public void removeFromCancelled(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(67);
        }
        this.myCancelledBuild.remove(node);
    }

    public boolean isCancelled(Object node) {
        return node instanceof DefaultMutableTreeNode && this.myCancelledBuild.containsKey(node);
    }

    private void resetIncompleteNode(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(68);
        }
        if (this.myReleaseRequested) {
            return;
        }
        this.addToCancelled(node);
        if (!this.isExpanded(node, false)) {
            node.removeAllChildren();
            if (!this.getTreeStructure().isAlwaysLeaf(this.getElementFor(node))) {
                this.insertLoadingNode(node, true);
            }
        } else {
            this.removeFromUnbuilt(node);
            this.removeLoading(node, true);
        }
    }

    private boolean yieldAndRun(final @NotNull Runnable runnable, final @NotNull TreeUpdatePass pass) {
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(69);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(70);
        }
        this.myYieldingPasses.add(pass);
        this.myYieldingNow = true;
        this.yield(new TreeRunnable("AbstractTreeUi.yieldAndRun"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.isReleased()) {
                    return;
                }
                AbstractTreeUi.this.runOnYieldingDone(new TreeRunnable("AbstractTreeUi.yieldAndRun: inner"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isReleased()) {
                            return;
                        }
                        AbstractTreeUi.this.executeYieldingRequest(runnable, pass);
                    }
                });
            }
        });
        return true;
    }

    public boolean isYeildingNow() {
        return this.myYieldingNow;
    }

    private boolean hasScheduledUpdates() {
        return this.getUpdater().hasNodesToUpdate();
    }

    public boolean isReady() {
        return this.isReady(false);
    }

    public boolean isCancelledReady() {
        return this.isReady(false) && !this.myCancelledBuild.isEmpty();
    }

    public boolean isReady(boolean attempt) {
        if (attempt && this.myStateLock.isLocked()) {
            return false;
        }
        Boolean ready = this.checkValue((Computable<Boolean>)((Computable)() -> this.isIdle() && !this.hasPendingWork() && !this.isNodeActionsPending()), attempt);
        return ready != null && ready != false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Boolean checkValue(@NotNull Computable<Boolean> computable, boolean attempt) {
        if (computable == null) {
            AbstractTreeUi.$$$reportNull$$$0(71);
        }
        try (LockToken ignored = attempt ? this.attemptLock() : this.acquireLock();){
            Boolean bl = (Boolean)computable.compute();
            return bl;
        }
        catch (InterruptedException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @NotNull
    @NonNls
    public String getStatus() {
        String string = "isReady=" + this.isReady() + "\n isIdle=" + this.isIdle() + "\n  isYeildingNow=" + this.isYeildingNow() + "\n  isWorkerBusy=" + this.isWorkerBusy() + "\n  hasUpdatingChildrenNow=" + this.hasUpdatingChildrenNow() + "\n  isLoadingInBackgroundNow=" + this.isLoadingInBackgroundNow() + "\n hasPendingWork=" + this.hasPendingWork() + "\n  hasNodesToUpdate=" + this.hasNodesToUpdate() + "\n  updaterState=" + this.myUpdaterState + "\n  hasScheduledUpdates=" + this.hasScheduledUpdates() + "\n  isPostponedMode=" + this.getUpdater().isInPostponeMode() + "\n nodeActions=" + this.myNodeActions.keySet() + "\n nodeChildrenActions=" + this.myNodeChildrenActions.keySet() + "\nisReleased=" + this.isReleased() + "\n isReleaseRequested=" + this.isReleaseRequested() + "\nisCancelProcessed=" + this.isCancelProcessed() + "\n isCancelRequested=" + this.myCancelRequest + "\n isResettingToReadyNow=" + this.myResettingToReadyNow + "\ncanInitiateNewActivity=" + this.canInitiateNewActivity() + "batchIndicators=" + this.myBatchIndicators;
        if (string == null) {
            AbstractTreeUi.$$$reportNull$$$0(72);
        }
        return string;
    }

    public boolean hasPendingWork() {
        return this.hasNodesToUpdate() || this.myUpdaterState != null && this.myUpdaterState.isProcessingNow() || this.hasScheduledUpdates() && !this.getUpdater().isInPostponeMode();
    }

    public boolean isIdle() {
        return !this.isYeildingNow() && !this.isWorkerBusy() && !this.hasUpdatingChildrenNow() && !this.isLoadingInBackgroundNow();
    }

    private void executeYieldingRequest(@NotNull Runnable runnable, @NotNull TreeUpdatePass pass) {
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(73);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(74);
        }
        try {
            try {
                this.myYieldingPasses.remove(pass);
                if (!this.canInitiateNewActivity()) {
                    throw new ProcessCanceledException();
                }
                runnable.run();
            }
            finally {
                if (!this.isReleased()) {
                    this.maybeYeildingFinished();
                }
            }
        }
        catch (ProcessCanceledException e) {
            this.resetToReady();
        }
    }

    private void maybeYeildingFinished() {
        if (this.myYieldingPasses.isEmpty()) {
            this.myYieldingNow = false;
            this.flushPendingNodeActions();
        }
    }

    void maybeReady() {
        this.assertIsDispatchThread();
        if (this.isReleased()) {
            return;
        }
        boolean ready = this.isReady(true);
        if (!ready) {
            return;
        }
        this.myRevalidatedObjects.clear();
        this.setCancelRequested(false);
        this.myResettingToReadyNow.set(false);
        this.myInitialized.setDone();
        if (this.canInitiateNewActivity() && this.myUpdaterState != null && !this.myUpdaterState.isProcessingNow()) {
            UpdaterTreeState oldState = this.myUpdaterState;
            if (!this.myUpdaterState.restore(null)) {
                this.setUpdaterState(oldState);
            }
            if (!this.isReady(true)) {
                return;
            }
        }
        this.setHoldSize(false);
        if (this.myTree.isShowing() && this.getBuilder().isToEnsureSelectionOnFocusGained() && Registry.is((String)"ide.tree.ensureSelectionOnFocusGained")) {
            TreeUtil.ensureSelection(this.myTree);
        }
        if (this.myInitialized.isDone()) {
            if (this.isReleaseRequested() || this.isCancelProcessed()) {
                this.myBusyObject.onReady(this);
            } else {
                this.myBusyObject.onReady();
            }
        }
        if (this.canInitiateNewActivity()) {
            TreePath[] selection = this.getTree().getSelectionPaths();
            Rectangle visible = this.getTree().getVisibleRect();
            if (selection != null) {
                for (TreePath each : selection) {
                    Rectangle bounds = this.getTree().getPathBounds(each);
                    if (bounds == null || !visible.contains(bounds) && !visible.intersects(bounds)) continue;
                    this.getTree().repaint(bounds);
                }
            }
        }
    }

    private void flushPendingNodeActions() {
        Runnable[] actions;
        DefaultMutableTreeNode[] nodes = this.myPendingNodeActions.toArray(new DefaultMutableTreeNode[0]);
        this.myPendingNodeActions.clear();
        for (DefaultMutableTreeNode each : nodes) {
            this.processNodeActionsIfReady(each);
        }
        for (Runnable each : actions = this.myYieldingDoneRunnables.toArray(new Runnable[0])) {
            if (this.isYeildingNow()) continue;
            this.myYieldingDoneRunnables.remove(each);
            each.run();
        }
        this.maybeReady();
    }

    protected void runOnYieldingDone(Runnable onDone) {
        this.getBuilder().runOnYeildingDone(onDone);
    }

    protected void yield(Runnable runnable) {
        this.getBuilder().yield(runnable);
    }

    private boolean isToYieldUpdateFor(DefaultMutableTreeNode node) {
        return this.canYield() && this.getBuilder().isToYieldUpdateFor(node);
    }

    @NotNull
    private MutualMap<Object, Integer> loadElementsFromStructure(NodeDescriptor descriptor, @Nullable LoadedChildren preloadedChildren) {
        MutualMap elementToIndexMap = new MutualMap(true);
        Object element = this.getElementFromDescriptor(descriptor);
        if (!this.isValid(element)) {
            MutualMap mutualMap = elementToIndexMap;
            if (mutualMap == null) {
                AbstractTreeUi.$$$reportNull$$$0(75);
            }
            return mutualMap;
        }
        List<Object> children = preloadedChildren != null ? preloadedChildren.getElements() : Arrays.asList(this.getChildrenFor(element));
        int index = 0;
        for (Object child : children) {
            if (!this.isValid(child)) continue;
            elementToIndexMap.put(child, (Object)index);
            ++index;
        }
        MutualMap mutualMap = elementToIndexMap;
        if (mutualMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(76);
        }
        return mutualMap;
    }

    public static boolean isLoadingNode(Object node) {
        return node instanceof LoadingNode;
    }

    @NotNull
    private AsyncResult<List<TreeNode>> collectNodesToInsert(NodeDescriptor descriptor, @NotNull MutualMap<Object, Integer> elementToIndexMap, final DefaultMutableTreeNode parent, final boolean addLoadingNode, @NotNull LoadedChildren loadedChildren) {
        if (elementToIndexMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(77);
        }
        if (loadedChildren == null) {
            AbstractTreeUi.$$$reportNull$$$0(78);
        }
        final AsyncResult<List<TreeNode>> result2 = new AsyncResult<List<TreeNode>>();
        final ArrayList nodesToInsert = new ArrayList();
        Collection allElements = elementToIndexMap.getKeys();
        final ActionCallback processingDone = new ActionCallback(allElements.size());
        for (Object child : allElements) {
            NodeDescriptor childDescr;
            Integer index = (Integer)elementToIndexMap.getValue(child);
            boolean needToUpdate = false;
            NodeDescriptor loadedDesc = loadedChildren.getDescriptor(child);
            if (!this.isValid(loadedDesc, descriptor)) {
                childDescr = this.getTreeStructure().createDescriptor(child, descriptor);
                needToUpdate = true;
            } else {
                childDescr = loadedDesc;
            }
            if (index == null) {
                index = Integer.MAX_VALUE;
                needToUpdate = true;
            }
            childDescr.setIndex(index);
            ActionCallback update = new ActionCallback();
            if (needToUpdate) {
                this.update(childDescr, false).done((Consumer<Boolean>)((Consumer)changes -> {
                    if (loadedChildren == null) {
                        AbstractTreeUi.$$$reportNull$$$0(187);
                    }
                    loadedChildren.putDescriptor(child, childDescr, (boolean)changes);
                    update.setDone();
                }));
            } else {
                update.setDone();
            }
            update.doWhenDone(new TreeRunnable("AbstractTreeUi.collectNodesToInsert: on done update"){

                @Override
                public void perform() {
                    DefaultMutableTreeNode node;
                    Object element = AbstractTreeUi.this.getElementFromDescriptor(childDescr);
                    if (!(AbstractTreeUi.isNodeNull(element) || (node = AbstractTreeUi.this.getNodeForElement(element, false)) != null && node.getParent() == parent)) {
                        DefaultMutableTreeNode childNode = AbstractTreeUi.this.createChildNode(childDescr);
                        if (addLoadingNode || AbstractTreeUi.this.getBuilder().isAlwaysShowPlus(childDescr)) {
                            AbstractTreeUi.this.insertLoadingNode(childNode, true);
                        } else {
                            AbstractTreeUi.this.addToUnbuilt(childNode);
                        }
                        nodesToInsert.add(childNode);
                        AbstractTreeUi.this.createMapping(element, childNode);
                    }
                    processingDone.setDone();
                }
            });
        }
        processingDone.doWhenDone(new TreeRunnable("AbstractTreeUi.collectNodesToInsert: on done processing"){

            @Override
            public void perform() {
                result2.setDone(nodesToInsert);
            }
        });
        AsyncResult<List<TreeNode>> asyncResult = result2;
        if (asyncResult == null) {
            AbstractTreeUi.$$$reportNull$$$0(79);
        }
        return asyncResult;
    }

    @NotNull
    protected DefaultMutableTreeNode createChildNode(NodeDescriptor descriptor) {
        ElementNode elementNode = new ElementNode(this, descriptor);
        if (elementNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(80);
        }
        return elementNode;
    }

    protected boolean canYield() {
        return this.myCanYield && this.myYieldingUpdate.asBoolean();
    }

    public long getClearOnHideDelay() {
        return this.myClearOnHideDelay;
    }

    @NotNull
    public ActionCallback getInitialized() {
        ActionCallback actionCallback = this.myInitialized;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(81);
        }
        return actionCallback;
    }

    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            AbstractTreeUi.$$$reportNull$$$0(82);
        }
        return this.myBusyObject.getReady(requestor);
    }

    private ActionCallback _getReady() {
        return this.getReady(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUpdatingChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(83);
        }
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            this.myUpdatingChildren.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromUpdatingChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(84);
        }
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            this.myUpdatingChildren.remove(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdatingChildrenNow(DefaultMutableTreeNode node) {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            return this.myUpdatingChildren.contains(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParentUpdatingChildrenNow(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(85);
        }
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            for (DefaultMutableTreeNode eachParent = (DefaultMutableTreeNode)node.getParent(); eachParent != null; eachParent = (DefaultMutableTreeNode)eachParent.getParent()) {
                if (!this.myUpdatingChildren.contains(eachParent)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasUpdatingChildrenNow() {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            return !this.myUpdatingChildren.isEmpty();
        }
    }

    @NotNull
    public Map<Object, List<NodeAction>> getNodeActions() {
        Map<Object, List<NodeAction>> map = this.myNodeActions;
        if (map == null) {
            AbstractTreeUi.$$$reportNull$$$0(86);
        }
        return map;
    }

    @NotNull
    public List<Object> getLoadedChildrenFor(Object element) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        DefaultMutableTreeNode node = this.getNodeForElement(element, false);
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode each = node.getChildAt(i);
                if (AbstractTreeUi.isLoadingNode(each)) continue;
                result2.add(this.getElementFor(each));
            }
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            AbstractTreeUi.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    public boolean hasNodesToUpdate() {
        return this.getUpdater().hasNodesToUpdate();
    }

    @NotNull
    public List<Object> getExpandedElements() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (this.isReleased()) {
            ArrayList<Object> arrayList = result2;
            if (arrayList == null) {
                AbstractTreeUi.$$$reportNull$$$0(88);
            }
            return arrayList;
        }
        Enumeration<TreePath> enumeration = this.myTree.getExpandedDescendants(AbstractTreeUi.getPathFor(this.getRootNode()));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath each = enumeration.nextElement();
                Object eachElement = this.getElementFor(each.getLastPathComponent());
                if (eachElement == null) continue;
                result2.add(eachElement);
            }
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            AbstractTreeUi.$$$reportNull$$$0(89);
        }
        return arrayList;
    }

    @NotNull
    public ActionCallback cancelUpdate() {
        if (this.isReleased()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractTreeUi.$$$reportNull$$$0(90);
            }
            return actionCallback;
        }
        this.setCancelRequested(true);
        final ActionCallback done2 = new ActionCallback();
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.cancelUpdate"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.isReleased()) {
                    done2.setRejected();
                    return;
                }
                if (AbstractTreeUi.this.myResettingToReadyNow.get()) {
                    AbstractTreeUi.this._getReady().notify(done2);
                } else if (AbstractTreeUi.this.isReady()) {
                    AbstractTreeUi.this.resetToReadyNow();
                    done2.setDone();
                } else if (AbstractTreeUi.this.isIdle() && AbstractTreeUi.this.hasPendingWork()) {
                    AbstractTreeUi.this.resetToReadyNow();
                    done2.setDone();
                } else {
                    AbstractTreeUi.this._getReady().notify(done2);
                }
                AbstractTreeUi.this.maybeReady();
            }
        });
        if (AbstractTreeUi.isEdt() || this.isPassthroughMode()) {
            this.maybeReady();
        }
        ActionCallback actionCallback = done2;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(91);
        }
        return actionCallback;
    }

    private void setCancelRequested(boolean requested) {
        try (LockToken ignored = AbstractTreeUi.isUnitTestingMode() ? this.acquireLock() : this.attemptLock();){
            this.myCancelRequest.set(requested);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Nullable
    private LockToken attemptLock() throws InterruptedException {
        return LockToken.attemptLock((Lock)this.myStateLock, (long)Registry.intValue((String)"ide.tree.uiLockAttempt"));
    }

    @NotNull
    private LockToken acquireLock() {
        LockToken lockToken = LockToken.acquireLock((Lock)this.myStateLock);
        if (lockToken == null) {
            AbstractTreeUi.$$$reportNull$$$0(92);
        }
        return lockToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ActionCallback batch(@NotNull Progressive progressive) {
        ActionCallback callback;
        block11: {
            ActionCallback actionCallback;
            if (progressive == null) {
                AbstractTreeUi.$$$reportNull$$$0(93);
            }
            this.assertIsDispatchThread();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            callback = new ActionCallback();
            this.myBatchIndicators.put(progressive, indicator);
            this.myBatchCallbacks.put(progressive, callback);
            try {
                progressive.run(indicator);
                if (!this.isReleased()) break block11;
                actionCallback = ActionCallback.REJECTED;
            }
            catch (ProcessCanceledException e) {
                ActionCallback actionCallback2;
                block12: {
                    ActionCallback actionCallback3;
                    try {
                        this.resetToReadyNow().doWhenProcessed(new TreeRunnable("AbstractTreeUi.batch: catch"){

                            @Override
                            public void perform() {
                                callback.setRejected();
                            }
                        });
                        actionCallback2 = callback;
                        if (!this.isReleased()) break block12;
                        actionCallback3 = ActionCallback.REJECTED;
                    }
                    catch (Throwable throwable) {
                        if (this.isReleased()) {
                            ActionCallback actionCallback4 = ActionCallback.REJECTED;
                            if (actionCallback4 == null) {
                                AbstractTreeUi.$$$reportNull$$$0(97);
                            }
                            return actionCallback4;
                        }
                        this._getReady().doWhenDone(new TreeRunnable("AbstractTreeUi.batch: finally", progressive, callback){
                            final /* synthetic */ Progressive val$progressive;
                            final /* synthetic */ ActionCallback val$callback;
                            {
                                this.val$progressive = progressive;
                                this.val$callback = actionCallback;
                                super(name);
                            }

                            @Override
                            public void perform() {
                                if (AbstractTreeUi.this.myBatchIndicators.containsKey(this.val$progressive)) {
                                    ProgressIndicator indicator = (ProgressIndicator)AbstractTreeUi.this.myBatchIndicators.remove(this.val$progressive);
                                    AbstractTreeUi.this.myBatchCallbacks.remove(this.val$progressive);
                                    if (indicator.isCanceled()) {
                                        this.val$callback.setRejected();
                                    } else {
                                        this.val$callback.setDone();
                                    }
                                } else {
                                    this.val$callback.setRejected();
                                }
                            }
                        });
                        this.maybeReady();
                        throw throwable;
                    }
                    if (actionCallback3 == null) {
                        AbstractTreeUi.$$$reportNull$$$0(95);
                    }
                    return actionCallback3;
                }
                this._getReady().doWhenDone(new /* invalid duplicate definition of identical inner class */);
                this.maybeReady();
                ActionCallback actionCallback5 = actionCallback2;
                if (actionCallback5 == null) {
                    AbstractTreeUi.$$$reportNull$$$0(96);
                }
                return actionCallback5;
            }
            if (actionCallback == null) {
                AbstractTreeUi.$$$reportNull$$$0(94);
            }
            return actionCallback;
        }
        this._getReady().doWhenDone(new /* invalid duplicate definition of identical inner class */);
        this.maybeReady();
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(98);
        }
        return actionCallback;
    }

    public boolean isCancelProcessed() {
        return this.myCancelRequest.get() || this.myResettingToReadyNow.get();
    }

    public boolean isToPaintSelection() {
        return this.isReady(true) || !this.mySelectionIsAdjusted;
    }

    public boolean isReleaseRequested() {
        return this.myReleaseRequested;
    }

    public void executeUserRunnable(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(99);
        }
        try {
            this.myUserRunnables.add(runnable);
            runnable.run();
        }
        finally {
            this.myUserRunnables.remove(runnable);
        }
    }

    private boolean isUpdatingParent(DefaultMutableTreeNode kid) {
        return this.getUpdatingParent(kid) != null;
    }

    @Nullable
    private DefaultMutableTreeNode getUpdatingParent(DefaultMutableTreeNode kid) {
        for (DefaultMutableTreeNode eachParent = kid; eachParent != null; eachParent = (DefaultMutableTreeNode)eachParent.getParent()) {
            if (!this.isUpdatingChildrenNow(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    private boolean isLoadedInBackground(Object element) {
        return this.getLoadedInBackground(element) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateInfo getLoadedInBackground(Object element) {
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            return AbstractTreeUi.isNodeNull(element) ? null : this.myLoadedInBackground.get(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLoadedInBackground(Object element, UpdateInfo info) {
        if (AbstractTreeUi.isNodeNull(element)) {
            return;
        }
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            this.warnMap("put into myLoadedInBackground: ", this.myLoadedInBackground);
            this.myLoadedInBackground.put(element, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLoadedInBackground(Object element) {
        if (AbstractTreeUi.isNodeNull(element)) {
            return;
        }
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            this.warnMap("remove from myLoadedInBackground: ", this.myLoadedInBackground);
            this.myLoadedInBackground.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoadingInBackgroundNow() {
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            return !this.myLoadedInBackground.isEmpty();
        }
    }

    private boolean queueBackgroundUpdate(final @NotNull UpdateInfo updateInfo, final @NotNull DefaultMutableTreeNode node) {
        if (updateInfo == null) {
            AbstractTreeUi.$$$reportNull$$$0(100);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(101);
        }
        this.assertIsDispatchThread();
        final Object oldElementFromDescriptor = this.getElementFromDescriptor(updateInfo.getDescriptor());
        if (AbstractTreeUi.isNodeNull(oldElementFromDescriptor)) {
            return false;
        }
        UpdateInfo loaded = this.getLoadedInBackground(oldElementFromDescriptor);
        if (loaded != null) {
            loaded.apply(updateInfo);
            return false;
        }
        this.addToLoadedInBackground(oldElementFromDescriptor, updateInfo);
        this.maybeSetBusyAndScheduleWaiterForReady(true, oldElementFromDescriptor);
        if (!this.isNodeBeingBuilt(node)) {
            LoadingNode loadingNode = new LoadingNode(AbstractTreeUi.getLoadingNodeText());
            this.myTreeModel.insertNodeInto(loadingNode, node, node.getChildCount());
        }
        this.removeFromUnbuilt(node);
        final Ref children = new Ref();
        final Ref elementFromDescriptor = new Ref();
        final DefaultMutableTreeNode[] nodeToProcessActions = new DefaultMutableTreeNode[1];
        final TreeRunnable.TreeConsumer<Void> finalizeRunnable = new TreeRunnable.TreeConsumer<Void>("AbstractTreeUi.queueBackgroundUpdate: finalize"){

            @Override
            public void perform() {
                AbstractTreeUi.this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: finalize later"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isReleased()) {
                            return;
                        }
                        AbstractTreeUi.this.removeLoading(node, false);
                        AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                        AbstractTreeUi.this.removeFromLoadedInBackground(oldElementFromDescriptor);
                        if (nodeToProcessActions[0] != null) {
                            AbstractTreeUi.this.processNodeActionsIfReady(nodeToProcessActions[0]);
                        }
                    }
                });
            }
        };
        TreeRunnable buildRunnable = new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: build"){

            @Override
            public void perform() {
                if (updateInfo.getPass().isExpired()) {
                    finalizeRunnable.run();
                    return;
                }
                if (!updateInfo.isDescriptorIsUpToDate()) {
                    AbstractTreeUi.this.update(updateInfo.getDescriptor(), true);
                }
                if (!updateInfo.isUpdateChildren()) {
                    nodeToProcessActions[0] = node;
                    return;
                }
                Object element = AbstractTreeUi.this.getElementFromDescriptor(updateInfo.getDescriptor());
                if (element == null) {
                    AbstractTreeUi.this.removeFromLoadedInBackground(oldElementFromDescriptor);
                    finalizeRunnable.run();
                    return;
                }
                elementFromDescriptor.set(element);
                Object[] loadedElements = AbstractTreeUi.this.getChildrenFor(element);
                final LoadedChildren loaded = new LoadedChildren(loadedElements);
                for (final Object each : loadedElements) {
                    NodeDescriptor existingDesc = AbstractTreeUi.getDescriptorFrom(AbstractTreeUi.this.getNodeForElement(each, true));
                    final NodeDescriptor eachChildDescriptor = AbstractTreeUi.this.isValid(existingDesc, updateInfo.getDescriptor()) ? existingDesc : AbstractTreeUi.this.getTreeStructure().createDescriptor(each, updateInfo.getDescriptor());
                    AbstractTreeUi.this.execute(new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate"){

                        @Override
                        public void perform() {
                            Promise promise = AbstractTreeUi.this.update(eachChildDescriptor, true);
                            LOG.assertTrue(promise instanceof Getter);
                            loaded.putDescriptor(each, eachChildDescriptor, (Boolean)((Getter)promise).get());
                        }
                    });
                }
                children.set((Object)loaded);
            }

            @Override
            @NotNull
            @NonNls
            public String toString() {
                String string = "runnable=" + oldElementFromDescriptor;
                if (string == null) {
                    43.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeUi$43", "toString"));
            }
        };
        TreeRunnable updateRunnable = new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: update"){

            @Override
            public void perform() {
                Pair unbuilt;
                if (updateInfo.getPass().isExpired()) {
                    finalizeRunnable.run();
                    return;
                }
                if (children.get() == null) {
                    finalizeRunnable.run();
                    return;
                }
                if (AbstractTreeUi.this.isRerunNeeded(updateInfo.getPass())) {
                    AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                    AbstractTreeUi.this.getUpdater().requeue(updateInfo.getPass());
                    return;
                }
                AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                if (AbstractTreeUi.this.myUnbuiltNodes.contains(node) && ((Boolean)(unbuilt = AbstractTreeUi.this.processUnbuilt(node, updateInfo.getDescriptor(), updateInfo.getPass(), AbstractTreeUi.this.isExpanded(node, updateInfo.isWasExpanded()), (LoadedChildren)children.get())).getFirst()).booleanValue()) {
                    nodeToProcessActions[0] = node;
                    return;
                }
                ActionCallback callback = AbstractTreeUi.this.updateNodeChildren(node, updateInfo.getPass(), (LoadedChildren)children.get(), true, updateInfo.isCanSmartExpand(), updateInfo.isForceUpdate(), true, true);
                callback.doWhenDone(new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: on done updateNodeChildren"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isRerunNeeded(updateInfo.getPass())) {
                            AbstractTreeUi.this.getUpdater().requeue(updateInfo.getPass());
                            return;
                        }
                        Object element = elementFromDescriptor.get();
                        if (element != null) {
                            AbstractTreeUi.this.removeLoading(node, false);
                            nodeToProcessActions[0] = node;
                        }
                    }
                });
            }
        };
        this.queueToBackground(buildRunnable, updateRunnable).done((Consumer<Void>)finalizeRunnable).rejected((Consumer<Throwable>)new TreeRunnable.TreeConsumer<Throwable>("AbstractTreeUi.queueBackgroundUpdate: on rejected"){

            @Override
            public void perform() {
                updateInfo.getPass().expire();
            }
        });
        return true;
    }

    private boolean isExpanded(@NotNull DefaultMutableTreeNode node, boolean isExpanded) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(102);
        }
        return isExpanded || this.myTree.isExpanded(AbstractTreeUi.getPathFor(node));
    }

    private void removeLoading(@NotNull DefaultMutableTreeNode parent, boolean forced) {
        if (parent == null) {
            AbstractTreeUi.$$$reportNull$$$0(103);
        }
        if (!forced && this.myUnbuiltNodes.contains(parent) && !this.myCancelledBuild.containsKey(parent)) {
            return;
        }
        boolean reallyRemoved = false;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode child = parent.getChildAt(i);
            if (!this.removeIfLoading(child)) continue;
            reallyRemoved = true;
            --i;
        }
        this.maybeReady();
        if (reallyRemoved) {
            this.nodeStructureChanged(parent);
        }
    }

    private void processNodeActionsIfReady(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(104);
        }
        this.assertIsDispatchThread();
        if (this.isNodeBeingBuilt(node)) {
            return;
        }
        NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor == null) {
            return;
        }
        if (this.isYeildingNow()) {
            this.myPendingNodeActions.add(node);
            return;
        }
        Object element = this.getElementFromDescriptor(descriptor);
        boolean childrenReady = !this.isLoadedInBackground(element) && !this.isUpdatingChildrenNow(node);
        AbstractTreeUi.processActions(node, element, this.myNodeActions, childrenReady ? this.myNodeChildrenActions : null);
        if (childrenReady) {
            AbstractTreeUi.processActions(node, element, this.myNodeChildrenActions, null);
        }
        this.warnMap("myNodeActions: processNodeActionsIfReady: ", this.myNodeActions);
        this.warnMap("myNodeChildrenActions: processNodeActionsIfReady: ", this.myNodeChildrenActions);
        if (!this.isUpdatingParent(node) && !this.isWorkerBusy()) {
            UpdaterTreeState state = this.myUpdaterState;
            if (this.myNodeActions.isEmpty() && state != null && !state.isProcessingNow() && this.canInitiateNewActivity() && !state.restore(childrenReady ? node : null)) {
                this.setUpdaterState(state);
            }
        }
        this.maybeReady();
    }

    private static void processActions(DefaultMutableTreeNode node, Object element, @NotNull Map<Object, List<NodeAction>> nodeActions, @Nullable Map<Object, List<NodeAction>> secondaryNodeAction) {
        List<NodeAction> actions;
        if (nodeActions == null) {
            AbstractTreeUi.$$$reportNull$$$0(105);
        }
        if ((actions = nodeActions.get(element)) != null) {
            nodeActions.remove(element);
            List<NodeAction> secondary = secondaryNodeAction != null ? secondaryNodeAction.get(element) : null;
            for (NodeAction each : actions) {
                if (secondary != null && secondary.contains(each)) {
                    secondary.remove(each);
                }
                each.onReady(node);
            }
        }
    }

    private boolean canSmartExpand(DefaultMutableTreeNode node, boolean canSmartExpand) {
        if (!this.canInitiateNewActivity()) {
            return false;
        }
        if (!this.getBuilder().isSmartExpand()) {
            return false;
        }
        boolean smartExpand = !this.myNotForSmartExpand.contains(node) && canSmartExpand;
        return smartExpand && this.validateAutoExpand(true, this.getElementFor(node));
    }

    private void processSmartExpand(@NotNull DefaultMutableTreeNode node, final boolean canSmartExpand, boolean forced) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(106);
        }
        if (!this.canInitiateNewActivity()) {
            return;
        }
        if (!this.getBuilder().isSmartExpand()) {
            return;
        }
        boolean can = this.canSmartExpand(node, canSmartExpand);
        if (!can && !forced) {
            return;
        }
        if (this.isNodeBeingBuilt(node) && !forced) {
            this.addNodeAction(this.getElementFor(node), new NodeAction(){

                @Override
                public void onReady(@NotNull DefaultMutableTreeNode node) {
                    if (node == null) {
                        46.$$$reportNull$$$0(0);
                    }
                    AbstractTreeUi.this.processSmartExpand(node, canSmartExpand, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/AbstractTreeUi$46", "onReady"));
                }
            }, true);
        } else {
            TreeNode child = AbstractTreeUi.getChildForSmartExpand(node);
            if (child != null) {
                final TreePath childPath = new TreePath(node.getPath()).pathByAddingChild(child);
                this.processInnerChange(new TreeRunnable("AbstractTreeUi.processSmartExpand"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.myTree.expandPath(childPath);
                    }
                });
            }
        }
    }

    @Nullable
    private static TreeNode getChildForSmartExpand(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(107);
        }
        int realChildCount = 0;
        TreeNode nodeToExpand = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode eachChild = node.getChildAt(i);
            if (!AbstractTreeUi.isLoadingNode(eachChild)) {
                ++realChildCount;
                if (nodeToExpand == null) {
                    nodeToExpand = eachChild;
                }
            }
            if (realChildCount <= 1) continue;
            nodeToExpand = null;
            break;
        }
        return nodeToExpand;
    }

    public static boolean isLoadingChildrenFor(Object nodeObject) {
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        int loadingNodes = 0;
        for (int i = 0; i < Math.min(node.getChildCount(), 2); ++i) {
            TreeNode child = node.getChildAt(i);
            if (!AbstractTreeUi.isLoadingNode(child)) continue;
            ++loadingNodes;
        }
        return loadingNodes > 0 && loadingNodes == node.getChildCount();
    }

    public boolean isParentLoadingInBackground(Object nodeObject) {
        return this.getParentLoadingInBackground(nodeObject) != null;
    }

    @Nullable
    private DefaultMutableTreeNode getParentLoadingInBackground(Object nodeObject) {
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        TreeNode eachParent = node.getParent();
        while (eachParent != null) {
            Object eachElement;
            if (!((eachParent = eachParent.getParent()) instanceof DefaultMutableTreeNode) || !this.isLoadedInBackground(eachElement = this.getElementFor(eachParent))) continue;
            return (DefaultMutableTreeNode)eachParent;
        }
        return null;
    }

    protected static String getLoadingNodeText() {
        return IdeBundle.message("progress.searching", new Object[0]);
    }

    @NotNull
    private Promise<?> processExistingNode(final @NotNull DefaultMutableTreeNode childNode, NodeDescriptor childDescriptor, final @NotNull DefaultMutableTreeNode parentNode, final @NotNull MutualMap<Object, Integer> elementToIndexMap, final @NotNull TreeUpdatePass pass, final boolean canSmartExpand, final boolean forceUpdate, @Nullable LoadedChildren parentPreloadedChildren) {
        if (childNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(108);
        }
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(109);
        }
        if (elementToIndexMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(110);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(111);
        }
        if (pass.isExpired()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AbstractTreeUi.$$$reportNull$$$0(112);
            }
            return promise;
        }
        if (childDescriptor == null) {
            pass.expire();
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AbstractTreeUi.$$$reportNull$$$0(113);
            }
            return promise;
        }
        final Object oldElement = this.getElementFromDescriptor(childDescriptor);
        if (AbstractTreeUi.isNodeNull(oldElement)) {
            this.removeNodeFromParent(childNode, true);
            this.doUpdateNode(parentNode);
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                AbstractTreeUi.$$$reportNull$$$0(114);
            }
            return promise;
        }
        Promise<Boolean> update = parentPreloadedChildren != null && parentPreloadedChildren.getDescriptor(oldElement) == childDescriptor ? Promise.resolve(parentPreloadedChildren.isUpdated(oldElement)) : this.update(childDescriptor, false);
        final AsyncPromise result2 = new AsyncPromise();
        final Ref childDesc = new Ref((Object)childDescriptor);
        update.done((Consumer<Boolean>)((Consumer)isChanged -> {
            Promise<Boolean> promise;
            Integer index;
            if (elementToIndexMap == null) {
                AbstractTreeUi.$$$reportNull$$$0(183);
            }
            if (parentNode == null) {
                AbstractTreeUi.$$$reportNull$$$0(184);
            }
            if (childNode == null) {
                AbstractTreeUi.$$$reportNull$$$0(185);
            }
            if (pass == null) {
                AbstractTreeUi.$$$reportNull$$$0(186);
            }
            final AtomicBoolean changes = new AtomicBoolean((boolean)isChanged);
            final AtomicBoolean forceRemapping = new AtomicBoolean();
            final Ref newElement = new Ref(this.getElementFromDescriptor((NodeDescriptor)childDesc.get()));
            Integer n = index = newElement.get() == null ? null : (Integer)elementToIndexMap.getValue(this.getElementFromDescriptor((NodeDescriptor)childDesc.get()));
            if (index == null) {
                promise = Promise.resolve(false);
            } else {
                Object elementFromMap = elementToIndexMap.getKey(index);
                if (elementFromMap != newElement.get() && elementFromMap.equals(newElement.get())) {
                    if (this.isInStructure(elementFromMap) && this.isInStructure(newElement.get())) {
                        AsyncPromise<Boolean> updateIndexDone = new AsyncPromise<Boolean>();
                        promise = updateIndexDone;
                        NodeDescriptor parentDescriptor = AbstractTreeUi.getDescriptorFrom(parentNode);
                        if (parentDescriptor != null) {
                            childDesc.set((Object)this.getTreeStructure().createDescriptor(elementFromMap, parentDescriptor));
                            NodeDescriptor oldDesc = AbstractTreeUi.getDescriptorFrom(childNode);
                            if (this.isValid(oldDesc)) {
                                ((NodeDescriptor)childDesc.get()).applyFrom(oldDesc);
                            }
                            childNode.setUserObject(childDesc.get());
                            newElement.set(elementFromMap);
                            forceRemapping.set(true);
                            this.update((NodeDescriptor)childDesc.get(), false).done((Consumer<Boolean>)((Consumer)isChanged1 -> {
                                changes.set((boolean)isChanged1);
                                updateIndexDone.setResult((Boolean)isChanged1);
                            }));
                        }
                    } else {
                        promise = Promise.resolve(changes.get());
                    }
                } else {
                    promise = Promise.resolve(changes.get());
                }
                promise.done((Consumer<Boolean>)new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.processExistingNode: on done index updating after update"){

                    @Override
                    public void perform() {
                        if (((NodeDescriptor)childDesc.get()).getIndex() != index.intValue()) {
                            changes.set(true);
                        }
                        ((NodeDescriptor)childDesc.get()).setIndex(index);
                    }
                });
            }
            promise.done((Consumer<Boolean>)new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.processExistingNode: on done index updating"){

                @Override
                public void perform() {
                    if (!oldElement.equals(newElement.get()) || forceRemapping.get()) {
                        NodeDescriptor parentDescriptor;
                        AbstractTreeUi.this.removeMapping(oldElement, childNode, newElement.get());
                        Object newE = newElement.get();
                        if (!AbstractTreeUi.isNodeNull(newE)) {
                            AbstractTreeUi.this.createMapping(newE, childNode);
                        }
                        if ((parentDescriptor = AbstractTreeUi.getDescriptorFrom(parentNode)) != null) {
                            parentDescriptor.setChildrenSortingStamp(-1L);
                        }
                    }
                    if (index == null) {
                        DefaultMutableTreeNode parent;
                        int selectedIndex = -1;
                        if (TreeBuilderUtil.isNodeOrChildSelected(AbstractTreeUi.this.myTree, childNode)) {
                            selectedIndex = parentNode.getIndex(childNode);
                        }
                        if (childNode.getParent() instanceof DefaultMutableTreeNode && AbstractTreeUi.this.myTree.isExpanded(new TreePath((parent = (DefaultMutableTreeNode)childNode.getParent()).getPath())) && parent.getChildCount() == 1 && parent.getChildAt(0) == childNode) {
                            AbstractTreeUi.this.insertLoadingNode(parent, false);
                        }
                        Object disposedElement = AbstractTreeUi.this.getElementFor(childNode);
                        AbstractTreeUi.this.removeNodeFromParent(childNode, selectedIndex >= 0);
                        AbstractTreeUi.this.disposeNode(childNode);
                        AbstractTreeUi.this.adjustSelectionOnChildRemove(parentNode, selectedIndex, disposedElement);
                        result2.setResult(null);
                    } else {
                        elementToIndexMap.remove(AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)childDesc.get()));
                        AbstractTreeUi.this.updateNodeChildren(childNode, pass, null, false, canSmartExpand, forceUpdate, true, true).doWhenDone(() -> result2.setResult(null));
                    }
                }
            });
        }));
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            AbstractTreeUi.$$$reportNull$$$0(115);
        }
        return asyncPromise;
    }

    private void adjustSelectionOnChildRemove(@NotNull DefaultMutableTreeNode parentNode, int selectedIndex, Object disposedElement) {
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(116);
        }
        if (selectedIndex >= 0 && !this.getSelectedElements().isEmpty()) {
            return;
        }
        DefaultMutableTreeNode node = this.getNodeForElement(disposedElement, false);
        if (node != null && this.isValidForSelectionAdjusting(node)) {
            Object newElement = this.getElementFor(node);
            this.addSelectionPath(AbstractTreeUi.getPathFor(node), true, this.getExpiredElementCondition(newElement), disposedElement);
            return;
        }
        if (selectedIndex >= 0) {
            if (parentNode.getChildCount() > 0) {
                if (parentNode.getChildCount() > selectedIndex) {
                    TreeNode newChildNode = parentNode.getChildAt(selectedIndex);
                    if (this.isValidForSelectionAdjusting(newChildNode)) {
                        this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChildNode)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
                    }
                } else {
                    TreeNode newChild = parentNode.getChildAt(parentNode.getChildCount() - 1);
                    if (this.isValidForSelectionAdjusting(newChild)) {
                        this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChild)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
                    }
                }
            } else {
                this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(parentNode)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
            }
        }
    }

    private boolean isValidForSelectionAdjusting(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(117);
        }
        if (!this.myTree.isRootVisible() && this.getRootNode() == node) {
            return false;
        }
        if (AbstractTreeUi.isLoadingNode(node)) {
            return true;
        }
        Object elementInTree = this.getElementFor(node);
        if (elementInTree == null) {
            return false;
        }
        TreeNode parentNode = node.getParent();
        Object parentElementInTree = this.getElementFor(parentNode);
        if (parentElementInTree == null) {
            return false;
        }
        Object parentElement = this.getTreeStructure().getParentElement(elementInTree);
        return parentElementInTree.equals(parentElement);
    }

    @NotNull
    public Condition getExpiredElementCondition(Object element) {
        Condition condition = o -> this.isInStructure(element);
        if (condition == null) {
            AbstractTreeUi.$$$reportNull$$$0(118);
        }
        return condition;
    }

    private void addSelectionPath(final @NotNull TreePath path2, final boolean isAdjustedSelection, final Condition isExpiredAdjustement, final @Nullable Object adjustmentCause) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(119);
        }
        this.processInnerChange(new TreeRunnable("AbstractTreeUi.addSelectionPath"){

            @Override
            public void perform() {
                TreePath toSelect = null;
                if (AbstractTreeUi.isLoadingNode(path2.getLastPathComponent())) {
                    TreePath parentPath = path2.getParentPath();
                    if (parentPath != null) {
                        toSelect = AbstractTreeUi.this.isValidForSelectionAdjusting((TreeNode)parentPath.getLastPathComponent()) ? parentPath : null;
                    }
                } else {
                    toSelect = path2;
                }
                if (toSelect != null) {
                    AbstractTreeUi.this.mySelectionIsAdjusted = isAdjustedSelection;
                    AbstractTreeUi.this.myTree.addSelectionPath(toSelect);
                    if (isAdjustedSelection && AbstractTreeUi.this.myUpdaterState != null) {
                        Object toSelectElement = AbstractTreeUi.this.getElementFor(toSelect.getLastPathComponent());
                        AbstractTreeUi.this.myUpdaterState.addAdjustedSelection(toSelectElement, isExpiredAdjustement, adjustmentCause);
                    }
                }
            }
        });
    }

    @NotNull
    private static TreePath getPathFor(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(120);
        }
        if (node instanceof DefaultMutableTreeNode) {
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)node).getPath());
            if (treePath == null) {
                AbstractTreeUi.$$$reportNull$$$0(121);
            }
            return treePath;
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (TreeNode eachParent = node; eachParent != null; eachParent = eachParent.getParent()) {
            nodes.add(eachParent);
        }
        TreePath treePath = new TreePath(ArrayUtil.toObjectArray(nodes));
        if (treePath == null) {
            AbstractTreeUi.$$$reportNull$$$0(122);
        }
        return treePath;
    }

    private void removeNodeFromParent(final @NotNull MutableTreeNode node, final boolean willAdjustSelection) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(123);
        }
        this.processInnerChange(new TreeRunnable("AbstractTreeUi.removeNodeFromParent"){

            @Override
            public void perform() {
                TreePath path2;
                if (willAdjustSelection && AbstractTreeUi.this.myTree.isPathSelected(path2 = AbstractTreeUi.getPathFor(node))) {
                    AbstractTreeUi.this.myTree.removeSelectionPath(path2);
                }
                if (node.getParent() != null) {
                    AbstractTreeUi.this.myTreeModel.removeNodeFromParent(node);
                }
            }
        });
    }

    private void expandPath(final @NotNull TreePath path2, final boolean canSmartExpand) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(124);
        }
        this.processInnerChange(new TreeRunnable("AbstractTreeUi.expandPath"){

            @Override
            public void perform() {
                if (path2.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
                    if (node.getChildCount() > 0 && !AbstractTreeUi.this.myTree.isExpanded(path2)) {
                        if (!canSmartExpand) {
                            AbstractTreeUi.this.myNotForSmartExpand.add(node);
                        }
                        try {
                            AbstractTreeUi.this.myRequestedExpand = path2;
                            AbstractTreeUi.this.myTree.expandPath(path2);
                            AbstractTreeUi.this.processSmartExpand(node, canSmartExpand, false);
                        }
                        finally {
                            AbstractTreeUi.this.myNotForSmartExpand.remove(node);
                            AbstractTreeUi.this.myRequestedExpand = null;
                        }
                    } else {
                        AbstractTreeUi.this.processNodeActionsIfReady(node);
                    }
                }
            }
        });
    }

    private void processInnerChange(Runnable runnable) {
        if (this.myUpdaterState == null) {
            this.setUpdaterState(new UpdaterTreeState(this));
        }
        this.myUpdaterState.process(runnable);
    }

    private boolean isInnerChange() {
        return this.myUpdaterState != null && this.myUpdaterState.isProcessingNow() && this.myUserRunnables.isEmpty();
    }

    private void makeLoadingOrLeafIfNoChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(125);
        }
        TreePath path2 = AbstractTreeUi.getPathFor(node);
        this.insertLoadingNode(node, true);
        NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor == null) {
            return;
        }
        descriptor.setChildrenSortingStamp(-1L);
        if (this.getBuilder().isAlwaysShowPlus(descriptor)) {
            return;
        }
        TreePath parentPath = path2.getParentPath();
        if (this.myTree.isVisible(path2) || parentPath != null && this.myTree.isExpanded(parentPath)) {
            if (this.myTree.isExpanded(path2)) {
                this.addSubtreeToUpdate(node);
            } else {
                this.insertLoadingNode(node, false);
            }
        }
    }

    private boolean isValid(NodeDescriptor descriptor, NodeDescriptor parent) {
        if (descriptor == null) {
            return false;
        }
        if (parent != null && parent != descriptor.getParentDescriptor()) {
            return false;
        }
        return this.isValid(this.getElementFromDescriptor(descriptor));
    }

    private boolean isValid(@Nullable NodeDescriptor descriptor) {
        return descriptor != null && this.isValid(this.getElementFromDescriptor(descriptor));
    }

    private boolean isValid(Object element) {
        if (AbstractTreeUi.isNodeNull(element)) {
            return false;
        }
        if (element instanceof ValidateableNode && !((ValidateableNode)element).isValid()) {
            return false;
        }
        return this.getBuilder().validateNode(element);
    }

    private void insertLoadingNode(DefaultMutableTreeNode node, boolean addToUnbuilt) {
        if (!AbstractTreeUi.isLoadingChildrenFor(node)) {
            this.myTreeModel.insertNodeInto(new LoadingNode(), node, 0);
        }
        if (addToUnbuilt) {
            this.addToUnbuilt(node);
        }
    }

    @NotNull
    private Promise<Void> queueToBackground(final @NotNull Runnable bgBuildAction, final @Nullable Runnable edtPostRunnable) {
        if (bgBuildAction == null) {
            AbstractTreeUi.$$$reportNull$$$0(126);
        }
        if (!this.canInitiateNewActivity()) {
            Promise<Void> promise = Promises.rejectedPromise();
            if (promise == null) {
                AbstractTreeUi.$$$reportNull$$$0(127);
            }
            return promise;
        }
        final AsyncPromise<Void> result2 = new AsyncPromise<Void>();
        final AtomicReference fail = new AtomicReference();
        final TreeRunnable finalizer = new TreeRunnable("AbstractTreeUi.queueToBackground: finalizer"){

            @Override
            public void perform() {
                ProcessCanceledException exception = (ProcessCanceledException)((Object)fail.get());
                if (exception == null) {
                    result2.setResult(null);
                } else {
                    result2.setError(exception);
                }
            }
        };
        this.registerWorkerTask(bgBuildAction);
        final TreeRunnable pooledThreadWithProgressRunnable = new TreeRunnable("AbstractTreeUi.queueToBackground: progress"){

            @Override
            public void perform() {
                try {
                    final AbstractTreeBuilder builder = AbstractTreeUi.this.getBuilder();
                    if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                        throw new ProcessCanceledException();
                    }
                    builder.runBackgroundLoading(new TreeRunnable("AbstractTreeUi.queueToBackground: background"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.assertNotDispatchThread();
                            try {
                                if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                    throw new ProcessCanceledException();
                                }
                                AbstractTreeUi.this.execute(bgBuildAction);
                                if (edtPostRunnable != null) {
                                    builder.updateAfterLoadedInBackground(new TreeRunnable("AbstractTreeUi.queueToBackground: update after"){

                                        @Override
                                        public void perform() {
                                            try {
                                                AbstractTreeUi.this.assertIsDispatchThread();
                                                if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                                    throw new ProcessCanceledException();
                                                }
                                                AbstractTreeUi.this.execute(edtPostRunnable);
                                            }
                                            catch (ProcessCanceledException e) {
                                                fail.set(e);
                                                AbstractTreeUi.this.cancelUpdate();
                                            }
                                            finally {
                                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                            }
                                        }
                                    });
                                } else {
                                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                }
                            }
                            catch (ProcessCanceledException e) {
                                fail.set(e);
                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                AbstractTreeUi.this.cancelUpdate();
                            }
                            catch (Throwable t) {
                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                throw new RuntimeException(t);
                            }
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                    AbstractTreeUi.this.cancelUpdate();
                }
            }
        };
        TreeRunnable pooledThreadRunnable = new TreeRunnable("AbstractTreeUi.queueToBackground"){

            @Override
            public void perform() {
                try {
                    if (AbstractTreeUi.this.myProgress != null) {
                        ProgressManager.getInstance().runProcess(pooledThreadWithProgressRunnable, AbstractTreeUi.this.myProgress);
                    } else {
                        AbstractTreeUi.this.execute(pooledThreadWithProgressRunnable);
                    }
                }
                catch (ProcessCanceledException e) {
                    fail.set(e);
                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                    AbstractTreeUi.this.cancelUpdate();
                }
            }
        };
        if (this.isPassthroughMode()) {
            this.execute(pooledThreadRunnable);
        } else {
            this.myWorker.addFirst(pooledThreadRunnable);
        }
        AsyncPromise<Void> asyncPromise = result2;
        if (asyncPromise == null) {
            AbstractTreeUi.$$$reportNull$$$0(128);
        }
        return asyncPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWorkerTask(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(129);
        }
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            this.myActiveWorkerTasks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterWorkerTask(@NotNull Runnable runnable, @Nullable Runnable finalizeRunnable) {
        boolean wasRemoved;
        if (runnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(130);
        }
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            wasRemoved = this.myActiveWorkerTasks.remove(runnable);
        }
        if (wasRemoved && finalizeRunnable != null) {
            finalizeRunnable.run();
        }
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.unregisterWorkerTask"){

            @Override
            public void perform() {
                AbstractTreeUi.this.maybeReady();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorkerBusy() {
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            return !this.myActiveWorkerTasks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWorkerTasks() {
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            this.myActiveWorkerTasks.clear();
        }
    }

    private void updateNodeImageAndPosition(@NotNull DefaultMutableTreeNode node, boolean updatePosition, boolean nodeChanged) {
        NodeDescriptor descriptor;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(131);
        }
        if ((descriptor = AbstractTreeUi.getDescriptorFrom(node)) == null) {
            return;
        }
        if (this.getElementFromDescriptor(descriptor) == null) {
            return;
        }
        if (updatePosition) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            if (parentNode == null) {
                this.nodeChanged(node);
            } else {
                int oldIndex;
                ApplicationManager.getApplication().assertIsDispatchThread();
                int newIndex = oldIndex = parentNode.getIndex(node);
                if (AbstractTreeUi.isLoadingChildrenFor(node.getParent()) || this.getBuilder().isChildrenResortingNeeded(descriptor)) {
                    ArrayList<TreeNode> children = new ArrayList<TreeNode>(parentNode.getChildCount());
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        TreeNode child = parentNode.getChildAt(i);
                        LOG.assertTrue(child != null);
                        children.add(child);
                    }
                    this.sortChildren(node, children, true, false);
                    newIndex = children.indexOf(node);
                }
                if (oldIndex != newIndex) {
                    ArrayList<Object> pathsToExpand = new ArrayList<Object>();
                    ArrayList<Object> selectionPaths = new ArrayList<Object>();
                    TreeBuilderUtil.storePaths(this.getBuilder(), node, pathsToExpand, selectionPaths, false);
                    this.removeNodeFromParent(node, false);
                    this.myTreeModel.insertNodeInto(node, parentNode, newIndex);
                    TreeBuilderUtil.restorePaths(this.getBuilder(), pathsToExpand, selectionPaths, false);
                } else {
                    this.nodeChanged(node);
                }
            }
        } else if (nodeChanged) {
            this.nodeChanged(node);
        }
    }

    private void nodeChanged(final DefaultMutableTreeNode node) {
        this.invokeLaterIfNeeded(true, new TreeRunnable("AbstractTreeUi.nodeChanged"){

            @Override
            public void perform() {
                AbstractTreeUi.this.myTreeModel.nodeChanged(node);
            }
        });
    }

    private void nodeStructureChanged(final DefaultMutableTreeNode node) {
        this.invokeLaterIfNeeded(true, new TreeRunnable("AbstractTreeUi.nodeStructureChanged"){

            @Override
            public void perform() {
                AbstractTreeUi.this.myTreeModel.nodeStructureChanged(node);
            }
        });
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    private void insertNodesInto(@NotNull List<TreeNode> toInsert, final @NotNull DefaultMutableTreeNode parentNode) {
        if (toInsert == null) {
            AbstractTreeUi.$$$reportNull$$$0(132);
        }
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(133);
        }
        this.sortChildren(parentNode, toInsert, false, true);
        final ArrayList<TreeNode> all2 = new ArrayList<TreeNode>(toInsert.size() + parentNode.getChildCount());
        all2.addAll(toInsert);
        all2.addAll(TreeUtil.listChildren(parentNode));
        if (!toInsert.isEmpty()) {
            this.sortChildren(parentNode, all2, true, true);
            int[] newNodeIndices = new int[toInsert.size()];
            int eachNewNodeIndex = 0;
            TreeMap<Integer, TreeNode> insertSet = new TreeMap<Integer, TreeNode>();
            for (int i = 0; i < toInsert.size(); ++i) {
                TreeNode eachNewNode = toInsert.get(i);
                while (all2.get(eachNewNodeIndex) != eachNewNode) {
                    ++eachNewNodeIndex;
                }
                newNodeIndices[i] = eachNewNodeIndex;
                insertSet.put(eachNewNodeIndex, eachNewNode);
            }
            for (Integer eachIndex : insertSet.keySet()) {
                TreeNode eachNode = (TreeNode)insertSet.get(eachIndex);
                parentNode.insert((MutableTreeNode)eachNode, eachIndex);
            }
            this.myTreeModel.nodesWereInserted(parentNode, newNodeIndices);
        } else {
            ArrayList before = new ArrayList(all2);
            this.sortChildren(parentNode, all2, true, false);
            if (!before.equals(all2)) {
                this.processInnerChange(new TreeRunnable("AbstractTreeUi.insertNodesInto"){

                    @Override
                    public void perform() {
                        Enumeration<TreePath> expanded = AbstractTreeUi.this.getTree().getExpandedDescendants(AbstractTreeUi.getPathFor(parentNode));
                        TreePath[] selected = AbstractTreeUi.this.getTree().getSelectionModel().getSelectionPaths();
                        parentNode.removeAllChildren();
                        for (TreeNode each : all2) {
                            parentNode.add((MutableTreeNode)each);
                        }
                        AbstractTreeUi.this.nodeStructureChanged(parentNode);
                        if (expanded != null) {
                            while (expanded.hasMoreElements()) {
                                AbstractTreeUi.this.expandSilently(expanded.nextElement());
                            }
                        }
                        if (selected != null) {
                            for (TreePath each : selected) {
                                if (AbstractTreeUi.this.getTree().getSelectionModel().isPathSelected(each)) continue;
                                AbstractTreeUi.this.addSelectionSilently(each);
                            }
                        }
                    }
                });
            }
        }
    }

    private void sortChildren(@NotNull DefaultMutableTreeNode node, @NotNull List<TreeNode> children, boolean updateStamp, boolean forceSort) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(134);
        }
        if (children == null) {
            AbstractTreeUi.$$$reportNull$$$0(135);
        }
        NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
        assert (descriptor != null);
        if (descriptor.getChildrenSortingStamp() >= this.getComparatorStamp() && !forceSort) {
            return;
        }
        if (!children.isEmpty()) {
            try {
                this.getBuilder().sortChildren(this.myNodeComparator, node, (ArrayList)children);
            }
            catch (IllegalArgumentException exception) {
                StringBuilder sb = new StringBuilder("cannot sort children");
                children.forEach(child -> sb.append('\n').append(child));
                throw new IllegalArgumentException(sb.toString(), exception);
            }
        }
        if (updateStamp) {
            descriptor.setChildrenSortingStamp(this.getComparatorStamp());
        }
    }

    public Comparator getNodeDescriptorComparator() {
        return this.myNodeDescriptorComparator;
    }

    private void disposeNode(@NotNull DefaultMutableTreeNode node) {
        TreeNode parent;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(136);
        }
        if ((parent = node.getParent()) instanceof DefaultMutableTreeNode) {
            this.addToUnbuilt((DefaultMutableTreeNode)parent);
        }
        if (node.getChildCount() > 0) {
            for (DefaultMutableTreeNode _node = (DefaultMutableTreeNode)node.getFirstChild(); _node != null; _node = _node.getNextSibling()) {
                this.disposeNode(_node);
            }
        }
        this.removeFromUpdatingChildren(node);
        this.removeFromUnbuilt(node);
        this.removeFromCancelled(node);
        if (AbstractTreeUi.isLoadingNode(node)) {
            return;
        }
        NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor == null) {
            return;
        }
        Object element = this.getElementFromDescriptor(descriptor);
        if (!AbstractTreeUi.isNodeNull(element)) {
            this.removeMapping(element, node, null);
        }
        this.myAutoExpandRoots.remove(element);
        node.setUserObject(null);
        node.removeAllChildren();
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root) {
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(137);
        }
        return this.addSubtreeToUpdate(root, true);
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root, boolean updateStructure) {
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(138);
        }
        return this.addSubtreeToUpdate(root, null, updateStructure);
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root, Runnable runAfterUpdate) {
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(139);
        }
        return this.addSubtreeToUpdate(root, runAfterUpdate, true);
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root, @Nullable Runnable runAfterUpdate, boolean updateStructure) {
        TreeUpdatePass updatePass;
        Object element;
        boolean alwaysLeaf;
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(140);
        }
        boolean bl = alwaysLeaf = (element = this.getElementFor(root)) != null && this.getTreeStructure().isAlwaysLeaf(element);
        if (alwaysLeaf) {
            this.removeFromUnbuilt(root);
            this.removeLoading(root, true);
            updatePass = new TreeUpdatePass(root).setUpdateChildren(false);
        } else {
            updatePass = new TreeUpdatePass(root).setUpdateStructure(updateStructure).setUpdateStamp(-1L);
        }
        AbstractTreeUpdater updater = this.getUpdater();
        updater.runAfterUpdate(runAfterUpdate);
        updater.addSubtreeToUpdate(updatePass);
        return !alwaysLeaf;
    }

    public boolean wasRootNodeInitialized() {
        return this.myRootNodeWasQueuedToInitialize && this.myRootNodeInitialized;
    }

    public void select(@NotNull Object[] elements, @Nullable Runnable onDone) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(141);
        }
        this.select(elements, onDone, false);
    }

    public void select(@NotNull Object[] elements, @Nullable Runnable onDone, boolean addToSelection) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(142);
        }
        this.select(elements, onDone, addToSelection, false);
    }

    public void select(@NotNull Object[] elements, @Nullable Runnable onDone, boolean addToSelection, boolean deferred) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(143);
        }
        this._select(elements, onDone, addToSelection, true, false, true, deferred, false, false);
    }

    void _select(@NotNull Object[] elements, Runnable onDone, boolean addToSelection, boolean checkCurrentSelection, boolean checkIfInStructure) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(144);
        }
        this._select(elements, onDone, addToSelection, checkCurrentSelection, checkIfInStructure, true, false, false, false);
    }

    void _select(@NotNull Object[] elements, Runnable onDone, boolean addToSelection, boolean checkCurrentSelection, boolean checkIfInStructure, boolean scrollToVisible) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(145);
        }
        this._select(elements, onDone, addToSelection, checkCurrentSelection, checkIfInStructure, scrollToVisible, false, false, false);
    }

    public void userSelect(@NotNull Object[] elements, Runnable onDone, boolean addToSelection, boolean scroll) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(146);
        }
        this._select(elements, onDone, addToSelection, true, false, scroll, false, true, true);
    }

    void _select(final @NotNull Object[] elements, final Runnable onDone, final boolean addToSelection, final boolean checkCurrentSelection, final boolean checkIfInStructure, final boolean scrollToVisible, final boolean deferred, final boolean canSmartExpand, boolean mayQueue) {
        boolean willAffectSelection;
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(147);
        }
        this.assertIsDispatchThread();
        AbstractTreeUpdater updater = this.getUpdater();
        if (mayQueue && updater != null) {
            updater.queueSelection(new SelectionRequest(elements, onDone, addToSelection, checkCurrentSelection, checkIfInStructure, scrollToVisible, deferred, canSmartExpand));
            return;
        }
        boolean bl = willAffectSelection = elements.length > 0 || elements.length == 0 && addToSelection;
        if (!willAffectSelection) {
            this.runDone(onDone);
            this.maybeReady();
            return;
        }
        boolean oldCanProcessDeferredSelection = this.myCanProcessDeferredSelections;
        if (!deferred && this.wasRootNodeInitialized()) {
            this._getReady().doWhenDone(new TreeRunnable("AbstractTreeUi._select: on done getReady"){

                @Override
                public void perform() {
                    AbstractTreeUi.this.myCanProcessDeferredSelections = false;
                }
            });
        }
        if (!this.checkDeferred(deferred, onDone)) {
            return;
        }
        if (!deferred && oldCanProcessDeferredSelection && !this.myCanProcessDeferredSelections && !addToSelection) {
            this.getTree().clearSelection();
        }
        this.runDone(new TreeRunnable("AbstractTreeUi._select"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                try {
                    if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                        return;
                    }
                    final Set<Object> currentElements = AbstractTreeUi.this.getSelectedElements();
                    if (checkCurrentSelection && !currentElements.isEmpty() && elements.length == currentElements.size()) {
                        boolean runSelection = false;
                        for (Object eachToSelect : elements) {
                            if (currentElements.contains(eachToSelect)) continue;
                            runSelection = true;
                            break;
                        }
                        if (!runSelection) {
                            if (elements.length > 0) {
                                AbstractTreeUi.this.selectVisible(elements[0], onDone, false, false, scrollToVisible);
                            }
                            return;
                        }
                    }
                    AbstractTreeUi.this.clearSelection();
                    THashSet toSelect = new THashSet();
                    ContainerUtil.addAllNotNull((Collection)toSelect, (Object[])elements);
                    if (addToSelection) {
                        ContainerUtil.addAllNotNull((Collection)toSelect, currentElements);
                    }
                    if (checkIfInStructure) {
                        Iterator allToSelect = toSelect.iterator();
                        while (allToSelect.hasNext()) {
                            Object each = allToSelect.next();
                            if (AbstractTreeUi.this.isInStructure(each)) continue;
                            allToSelect.remove();
                        }
                    }
                    Object[] elementsToSelect = ArrayUtil.toObjectArray((Collection)toSelect);
                    if (AbstractTreeUi.this.wasRootNodeInitialized()) {
                        int[] originalRows = AbstractTreeUi.this.myTree.getSelectionRows();
                        if (!addToSelection) {
                            AbstractTreeUi.this.clearSelection();
                        }
                        AbstractTreeUi.this.addNext(elementsToSelect, 0, new TreeRunnable("AbstractTreeUi._select: addNext"){

                            @Override
                            public void perform() {
                                if (AbstractTreeUi.this.getTree().isSelectionEmpty()) {
                                    AbstractTreeUi.this.processInnerChange(new TreeRunnable("AbstractTreeUi._select: addNext: processInnerChange"){

                                        @Override
                                        public void perform() {
                                            AbstractTreeUi.this.restoreSelection(currentElements);
                                        }
                                    });
                                }
                                AbstractTreeUi.this.runDone(onDone);
                            }
                        }, originalRows, deferred, scrollToVisible, canSmartExpand);
                    } else {
                        AbstractTreeUi.this.addToDeferred(elementsToSelect, onDone, addToSelection);
                    }
                }
                finally {
                    AbstractTreeUi.this.maybeReady();
                }
            }
        });
    }

    private void clearSelection() {
        this.mySelectionIsBeingAdjusted = true;
        try {
            this.myTree.clearSelection();
        }
        finally {
            this.mySelectionIsBeingAdjusted = false;
        }
    }

    public boolean isSelectionBeingAdjusted() {
        return this.mySelectionIsBeingAdjusted;
    }

    private void restoreSelection(@NotNull Set<Object> selection) {
        if (selection == null) {
            AbstractTreeUi.$$$reportNull$$$0(148);
        }
        for (Object each : selection) {
            DefaultMutableTreeNode node = this.getNodeForElement(each, false);
            if (node == null || !this.isValidForSelectionAdjusting(node)) continue;
            this.addSelectionPath(AbstractTreeUi.getPathFor(node), false, null, null);
        }
    }

    private void addToDeferred(final @NotNull Object[] elementsToSelect, final Runnable onDone, final boolean addToSelection) {
        if (elementsToSelect == null) {
            AbstractTreeUi.$$$reportNull$$$0(149);
        }
        if (!addToSelection) {
            this.myDeferredSelections.clear();
        }
        this.myDeferredSelections.add(new TreeRunnable("AbstractTreeUi.addToDeferred"){

            @Override
            public void perform() {
                AbstractTreeUi.this.select(elementsToSelect, onDone, addToSelection, true);
            }
        });
    }

    private boolean checkDeferred(boolean isDeferred, @Nullable Runnable onDone) {
        if (!isDeferred || this.myCanProcessDeferredSelections || !this.wasRootNodeInitialized()) {
            return true;
        }
        this.runDone(onDone);
        return false;
    }

    @NotNull
    final Set<Object> getSelectedElements() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        if (paths != null) {
            for (TreePath eachPath : paths) {
                Object eachElement;
                DefaultMutableTreeNode eachNode;
                if (!(eachPath.getLastPathComponent() instanceof DefaultMutableTreeNode) || (eachNode = (DefaultMutableTreeNode)eachPath.getLastPathComponent()) == this.myRootNode && !this.myTree.isRootVisible() || (eachElement = this.getElementFor(eachNode)) == null) continue;
                result2.add(eachElement);
            }
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            AbstractTreeUi.$$$reportNull$$$0(150);
        }
        return linkedHashSet;
    }

    private void addNext(final @NotNull Object[] elements, final int i, final @Nullable Runnable onDone, final int[] originalRows, final boolean deferred, final boolean scrollToVisible, final boolean canSmartExpand) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(151);
        }
        if (i >= elements.length) {
            if (this.myTree.isSelectionEmpty()) {
                this.myTree.setSelectionRows(originalRows);
            }
            this.runDone(onDone);
        } else {
            if (!this.checkDeferred(deferred, onDone)) {
                return;
            }
            this.doSelect(elements[i], new TreeRunnable("AbstractTreeUi.addNext"){

                @Override
                public void perform() {
                    if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                        return;
                    }
                    AbstractTreeUi.this.addNext(elements, i + 1, onDone, originalRows, deferred, scrollToVisible, canSmartExpand);
                }
            }, true, deferred, i == 0, scrollToVisible, canSmartExpand);
        }
    }

    public void select(@Nullable Object element, @Nullable Runnable onDone) {
        this.select(element, onDone, false);
    }

    public void select(@Nullable Object element, @Nullable Runnable onDone, boolean addToSelection) {
        if (element == null) {
            return;
        }
        this._select(new Object[]{element}, onDone, addToSelection, true, false);
    }

    private void doSelect(final @NotNull Object element, final Runnable onDone, final boolean addToSelection, final boolean deferred, final boolean canBeCentered, final boolean scrollToVisible, final boolean canSmartExpand) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(152);
        }
        TreeRunnable _onDone = new TreeRunnable("AbstractTreeUi.doSelect"){

            @Override
            public void perform() {
                if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                    return;
                }
                AbstractTreeUi.this.checkPathAndMaybeRevalidate(element, new TreeRunnable("AbstractTreeUi.doSelect: checkPathAndMaybeRevalidate"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.selectVisible(element, onDone, addToSelection, canBeCentered, scrollToVisible);
                    }
                }, true, false, canSmartExpand);
            }
        };
        this._expand(element, (Runnable)_onDone, true, false, canSmartExpand);
    }

    private void checkPathAndMaybeRevalidate(@NotNull Object element, final @NotNull Runnable onDone, final boolean parentsOnly, final boolean checkIfInStructure, final boolean canSmartExpand) {
        boolean toRevalidate;
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(153);
        }
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(154);
        }
        boolean bl = toRevalidate = this.isValid(element) && !this.myRevalidatedObjects.contains(element) && this.getNodeForElement(element, false) == null && this.isInStructure(element);
        if (!toRevalidate) {
            this.runDone(onDone);
            return;
        }
        this.myRevalidatedObjects.add(element);
        this.getBuilder().revalidateElement(element).doWhenDone((Consumer<Object>)((Consumer)o -> {
            if (onDone == null) {
                AbstractTreeUi.$$$reportNull$$$0(182);
            }
            this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.checkPathAndMaybeRevalidate: on done revalidateElement"){

                @Override
                public void perform() {
                    AbstractTreeUi.this._expand(o, onDone, parentsOnly, checkIfInStructure, canSmartExpand);
                }
            });
        })).doWhenRejected(this.wrapDone(onDone, "AbstractTreeUi.checkPathAndMaybeRevalidate: on rejected revalidateElement"));
    }

    public void scrollSelectionToVisible(final @Nullable Runnable onDone, final boolean shouldBeCentered) {
        SwingUtilities.invokeLater(new TreeRunnable("AbstractTreeUi.scrollSelectionToVisible"){

            @Override
            public void perform() {
                int eachRow;
                TreePath path2;
                if (AbstractTreeUi.this.isReleased()) {
                    return;
                }
                int[] rows = AbstractTreeUi.this.myTree.getSelectionRows();
                if (rows == null || rows.length == 0) {
                    AbstractTreeUi.this.runDone(onDone);
                    return;
                }
                Object toSelect = null;
                int[] nArray = rows;
                int n = nArray.length;
                for (int i = 0; i < n && (toSelect = AbstractTreeUi.this.getElementFor((path2 = AbstractTreeUi.this.myTree.getPathForRow(eachRow = nArray[i])).getLastPathComponent())) == null; ++i) {
                }
                if (toSelect != null) {
                    AbstractTreeUi.this.selectVisible(toSelect, onDone, true, shouldBeCentered, true);
                }
            }
        });
    }

    private void selectVisible(@NotNull Object element, Runnable onDone, boolean addToSelection, boolean canBeCentered, boolean scroll) {
        DefaultMutableTreeNode toSelect;
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(155);
        }
        if ((toSelect = this.getNodeToScroll(element)) == null) {
            this.runDone(onDone);
            return;
        }
        if (this.myUpdaterState != null) {
            this.myUpdaterState.addSelection(element);
        }
        this.setHoldSize(false);
        this.runDone(this.wrapScrollTo(onDone, element, toSelect, addToSelection, canBeCentered, scroll));
    }

    public void userScrollTo(Object element, Runnable onDone) {
        DefaultMutableTreeNode node = this.getNodeToScroll(element);
        this.runDone(node == null ? onDone : this.wrapScrollTo(onDone, element, node, false, true, true));
    }

    private DefaultMutableTreeNode getNodeToScroll(Object element) {
        if (element == null) {
            return null;
        }
        DefaultMutableTreeNode node = this.getNodeForElement(element, false);
        if (node == null) {
            return null;
        }
        return this.myTree.isRootVisible() || node != this.getRootNode() ? node : null;
    }

    private Runnable wrapDone(final Runnable onDone, String name) {
        return new TreeRunnable(name){

            @Override
            public void perform() {
                AbstractTreeUi.this.runDone(onDone);
            }
        };
    }

    private Runnable wrapScrollTo(final Runnable onDone, final Object element, final DefaultMutableTreeNode node, final boolean addToSelection, final boolean canBeCentered, final boolean scroll) {
        return new TreeRunnable("AbstractTreeUi.wrapScrollTo"){

            @Override
            public void perform() {
                int row = AbstractTreeUi.this.getRowIfUnderSelection(element);
                if (row == -1) {
                    row = AbstractTreeUi.this.myTree.getRowForPath(new TreePath(node.getPath()));
                }
                int top = row - 2;
                int bottom = row - 2;
                if (canBeCentered && Registry.is((String)"ide.tree.autoscrollToVCenter")) {
                    int count = TreeUtil.getVisibleRowCount(AbstractTreeUi.this.myTree) - 1;
                    top = count > 0 ? row - count / 2 : row;
                    bottom = count > 0 ? top + count : row;
                }
                TreeUtil.showAndSelect(AbstractTreeUi.this.myTree, top, bottom, row, -1, addToSelection, scroll).doWhenDone(AbstractTreeUi.this.wrapDone(onDone, "AbstractTreeUi.wrapScrollTo.onDone"));
            }
        };
    }

    private int getRowIfUnderSelection(@NotNull Object element) {
        TreePath[] paths;
        Set<Object> selection;
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(156);
        }
        if ((selection = this.getSelectedElements()).contains(element)) {
            TreePath[] paths2;
            for (TreePath each : paths2 = this.getTree().getSelectionPaths()) {
                if (!element.equals(this.getElementFor(each.getLastPathComponent()))) continue;
                return this.getTree().getRowForPath(each);
            }
            return -1;
        }
        Object anchor = TreeAnchorizer.getService().createAnchor(element);
        Object o = AbstractTreeUi.isNodeNull(anchor) ? null : this.myElementToNodeMap.get(anchor);
        TreeAnchorizer.getService().freeAnchor(anchor);
        if (o instanceof List && (paths = this.getTree().getSelectionPaths()) != null && paths.length > 0) {
            HashSet<DefaultMutableTreeNode> selectedNodes = new HashSet<DefaultMutableTreeNode>();
            for (TreePath eachPAth : paths) {
                if (!(eachPAth.getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
                selectedNodes.add((DefaultMutableTreeNode)eachPAth.getLastPathComponent());
            }
            Iterator iterator = ((List)o).iterator();
            while (iterator.hasNext()) {
                for (DefaultMutableTreeNode eachNode = (DefaultMutableTreeNode)iterator.next(); eachNode != null; eachNode = (DefaultMutableTreeNode)eachNode.getParent()) {
                    if (!selectedNodes.contains(eachNode)) continue;
                    return this.getTree().getRowForPath(AbstractTreeUi.getPathFor(eachNode));
                }
            }
        }
        return -1;
    }

    public void expandAllWithoutRecursion(@Nullable Runnable onDone) {
        JTree tree = this.getTree();
        if (tree.getRowCount() > 0) {
            for (int myCurrentRow = 0; myCurrentRow < tree.getRowCount(); ++myCurrentRow) {
                TreePath path2 = tree.getPathForRow(myCurrentRow);
                Object last = path2.getLastPathComponent();
                Object elem = this.getElementFor(last);
                this.expand(elem, null);
            }
        }
        this.runDone(onDone);
    }

    public void expandAll(final @Nullable Runnable onDone) {
        final JTree tree = this.getTree();
        if (tree.getRowCount() > 0) {
            final int expandRecursionDepth = Math.max(2, Registry.intValue((String)"ide.tree.expandRecursionDepth"));
            new TreeRunnable("AbstractTreeUi.expandAll"){
                private int myCurrentRow;
                private int myInvocationCount;
                {
                    super(name);
                    this.myCurrentRow = 0;
                    this.myInvocationCount = 0;
                }

                @Override
                public void perform() {
                    int row;
                    if (++this.myInvocationCount > expandRecursionDepth) {
                        this.myInvocationCount = 0;
                        if (AbstractTreeUi.this.isPassthroughMode()) {
                            this.run();
                        } else {
                            SwingUtilities.invokeLater(this);
                        }
                    } else if ((row = this.myCurrentRow++) < tree.getRowCount()) {
                        TreePath path2 = tree.getPathForRow(row);
                        Object last = path2.getLastPathComponent();
                        Object elem = AbstractTreeUi.this.getElementFor(last);
                        AbstractTreeUi.this.expand(elem, (Runnable)this);
                    } else {
                        AbstractTreeUi.this.runDone(onDone);
                    }
                }
            }.run();
        } else {
            this.runDone(onDone);
        }
    }

    public void expand(Object element, @Nullable Runnable onDone) {
        this.expand(new Object[]{element}, onDone);
    }

    public void expand(@NotNull Object[] element, @Nullable Runnable onDone) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(157);
        }
        this.expand(element, onDone, false);
    }

    void expand(@NotNull Object[] element, @Nullable Runnable onDone, boolean checkIfInStructure) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(158);
        }
        this._expand(element, (Runnable)(onDone == null ? new EmptyRunnable() : onDone), false, checkIfInStructure, false);
    }

    void _expand(final @NotNull Object[] element, final @NotNull Runnable onDone, final boolean parentsOnly, final boolean checkIfInStructure, final boolean canSmartExpand) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(159);
        }
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(160);
        }
        try {
            this.runDone(new TreeRunnable("AbstractTreeUi._expand"){

                @Override
                public void perform() {
                    if (element.length == 0) {
                        AbstractTreeUi.this.runDone(onDone);
                        return;
                    }
                    if (AbstractTreeUi.this.myUpdaterState != null) {
                        AbstractTreeUi.this.myUpdaterState.clearExpansion();
                    }
                    ActionCallback done2 = new ActionCallback(element.length);
                    done2.doWhenDone(AbstractTreeUi.this.wrapDone(onDone, "AbstractTreeUi._expand: on done expandNext")).doWhenRejected(AbstractTreeUi.this.wrapDone(onDone, "AbstractTreeUi._expand: on rejected expandNext"));
                    AbstractTreeUi.this.expandNext(element, 0, parentsOnly, checkIfInStructure, canSmartExpand, done2, 0);
                }
            });
        }
        catch (ProcessCanceledException e) {
            try {
                this.runDone(onDone);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private void expandNext(final @NotNull Object[] elements, final int index, final boolean parentsOnly, final boolean checkIfInStricture, final boolean canSmartExpand, final @NotNull ActionCallback done2, int currentDepth) {
        if (elements == null) {
            AbstractTreeUi.$$$reportNull$$$0(161);
        }
        if (done2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(162);
        }
        if (elements.length <= 0) {
            done2.setDone();
            return;
        }
        if (index >= elements.length) {
            return;
        }
        final int[] actualDepth = new int[]{currentDepth};
        boolean breakCallChain = false;
        if (actualDepth[0] > Registry.intValue((String)"ide.tree.expandRecursionDepth")) {
            actualDepth[0] = 0;
            breakCallChain = true;
        }
        TreeRunnable expandRunnable = new TreeRunnable("AbstractTreeUi.expandNext"){

            @Override
            public void perform() {
                AbstractTreeUi.this._expand(elements[index], new TreeRunnable("AbstractTreeUi.expandNext: on done"){

                    @Override
                    public void perform() {
                        done2.setDone();
                        AbstractTreeUi.this.expandNext(elements, index + 1, parentsOnly, checkIfInStricture, canSmartExpand, done2, actualDepth[0] + 1);
                    }
                }, parentsOnly, checkIfInStricture, canSmartExpand);
            }
        };
        if (breakCallChain && !this.isPassthroughMode()) {
            SwingUtilities.invokeLater(expandRunnable);
        } else {
            expandRunnable.run();
        }
    }

    public void collapseChildren(final @NotNull Object element, final @Nullable Runnable onDone) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(163);
        }
        this.runDone(new TreeRunnable("AbstractTreeUi.collapseChildren"){

            @Override
            public void perform() {
                DefaultMutableTreeNode node = AbstractTreeUi.this.getNodeForElement(element, false);
                if (node != null) {
                    AbstractTreeUi.this.getTree().collapsePath(new TreePath(node.getPath()));
                    AbstractTreeUi.this.runDone(onDone);
                }
            }
        });
    }

    private void runDone(@Nullable Runnable done2) {
        if (done2 == null) {
            return;
        }
        if (!this.canInitiateNewActivity() && done2 instanceof AbstractTreeBuilder.UserRunnable) {
            return;
        }
        if (this.isYeildingNow()) {
            if (!this.myYieldingDoneRunnables.contains(done2)) {
                this.myYieldingDoneRunnables.add(done2);
            }
        } else {
            try {
                this.execute(done2);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private void _expand(Object element, @NotNull Runnable onDone, boolean parentsOnly, boolean checkIfInStructure, boolean canSmartExpand) {
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(164);
        }
        if (checkIfInStructure && !this.isInStructure(element)) {
            this.runDone(onDone);
            return;
        }
        if (this.wasRootNodeInitialized()) {
            ArrayList<Object> kidsToExpand = new ArrayList<Object>();
            Object eachElement = element;
            DefaultMutableTreeNode firstVisible = null;
            while (eachElement != null && this.isValid(eachElement)) {
                int preselected = this.getRowIfUnderSelection(eachElement);
                firstVisible = preselected >= 0 ? (DefaultMutableTreeNode)this.getTree().getPathForRow(preselected).getLastPathComponent() : this.getNodeForElement(eachElement, true);
                if (eachElement != element || !parentsOnly) {
                    kidsToExpand.add(eachElement);
                }
                if (firstVisible != null) break;
                eachElement = this.getTreeStructure().getParentElement(eachElement);
                if (eachElement == null) {
                    firstVisible = null;
                    break;
                }
                int i = kidsToExpand.indexOf(eachElement);
                if (i == -1) continue;
                try {
                    Object existing = kidsToExpand.get(i);
                    LOG.error("Tree path contains equal elements at different levels:\n element: '" + eachElement + "'; " + eachElement.getClass() + " (" + System.identityHashCode(eachElement) + ");\nexisting: '" + existing + "'; " + existing.getClass() + " (" + System.identityHashCode(existing) + "); path='" + kidsToExpand + "'; tree structure=" + this.myTreeStructure);
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
                this.runDone(onDone);
                throw new ProcessCanceledException();
            }
            if (firstVisible == null) {
                this.runDone(onDone);
            } else if (kidsToExpand.isEmpty()) {
                TreePath parentPath;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)firstVisible.getParent();
                if (parentNode != null && !this.myTree.isExpanded(parentPath = new TreePath(parentNode.getPath()))) {
                    this.expand(parentPath, canSmartExpand);
                }
                this.runDone(onDone);
            } else {
                this.processExpand(firstVisible, kidsToExpand, kidsToExpand.size() - 1, onDone, canSmartExpand);
            }
        } else {
            this.deferExpansion(element, onDone, parentsOnly, canSmartExpand);
        }
    }

    private void deferExpansion(final Object element, final @NotNull Runnable onDone, final boolean parentsOnly, final boolean canSmartExpand) {
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(165);
        }
        this.myDeferredExpansions.add(new TreeRunnable("AbstractTreeUi.deferExpansion"){

            @Override
            public void perform() {
                AbstractTreeUi.this._expand(element, onDone, parentsOnly, false, canSmartExpand);
            }
        });
    }

    private void processExpand(DefaultMutableTreeNode toExpand, final @NotNull List<Object> kidsToExpand, final int expandIndex, final @NotNull Runnable onDone, final boolean canSmartExpand) {
        Object element;
        if (kidsToExpand == null) {
            AbstractTreeUi.$$$reportNull$$$0(166);
        }
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(167);
        }
        if ((element = this.getElementFor(toExpand)) == null) {
            this.runDone(onDone);
            return;
        }
        this.addNodeAction(element, new NodeAction(){

            @Override
            public void onReady(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    74.$$$reportNull$$$0(0);
                }
                if (node.getChildCount() > 0 && !AbstractTreeUi.this.myTree.isExpanded(new TreePath(node.getPath())) && !AbstractTreeUi.this.isAutoExpand(node)) {
                    AbstractTreeUi.this.expand(node, canSmartExpand);
                }
                if (expandIndex <= 0) {
                    AbstractTreeUi.this.runDone(onDone);
                    return;
                }
                AbstractTreeUi.this.checkPathAndMaybeRevalidate(kidsToExpand.get(expandIndex - 1), new TreeRunnable("AbstractTreeUi.processExpand"){

                    @Override
                    public void perform() {
                        DefaultMutableTreeNode nextNode = AbstractTreeUi.this.getNodeForElement(kidsToExpand.get(expandIndex - 1), false);
                        AbstractTreeUi.this.processExpand(nextNode, kidsToExpand, expandIndex - 1, onDone, canSmartExpand);
                    }
                }, false, false, canSmartExpand);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/AbstractTreeUi$74", "onReady"));
            }
        }, true);
        boolean childrenToUpdate = this.areChildrenToBeUpdated(toExpand);
        boolean expanded = this.myTree.isExpanded(AbstractTreeUi.getPathFor(toExpand));
        boolean unbuilt = this.myUnbuiltNodes.contains(toExpand);
        if (expanded) {
            if (unbuilt && !childrenToUpdate || childrenToUpdate) {
                this.addSubtreeToUpdate(toExpand);
            }
        } else {
            this.expand(toExpand, canSmartExpand);
        }
        if (!unbuilt && !childrenToUpdate) {
            this.processNodeActionsIfReady(toExpand);
        }
    }

    private boolean areChildrenToBeUpdated(DefaultMutableTreeNode node) {
        return this.getUpdater().isEnqueuedToUpdate(node) || this.isUpdatingParent(node) || this.myCancelledBuild.containsKey(node);
    }

    @Nullable
    public Object getElementFor(Object node) {
        NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
        return descriptor == null ? null : this.getElementFromDescriptor(descriptor);
    }

    public final boolean isNodeBeingBuilt(@NotNull TreePath path2) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(168);
        }
        return this.isNodeBeingBuilt(path2.getLastPathComponent());
    }

    public final boolean isNodeBeingBuilt(@NotNull Object node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(169);
        }
        return this.getParentBuiltNode(node) != null || this.myRootNode == node && !this.wasRootNodeInitialized();
    }

    @Nullable
    public final DefaultMutableTreeNode getParentBuiltNode(@NotNull Object node) {
        boolean childrenAreNoLoadedYet;
        DefaultMutableTreeNode parent;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(170);
        }
        if ((parent = this.getParentLoadingInBackground(node)) != null) {
            return parent;
        }
        if (this.isLoadingParentInBackground(node)) {
            return (DefaultMutableTreeNode)node;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        boolean bl = childrenAreNoLoadedYet = this.myUnbuiltNodes.contains(treeNode) || this.isUpdatingChildrenNow(treeNode);
        if (childrenAreNoLoadedYet) {
            TreePath nodePath = new TreePath(treeNode.getPath());
            if (!this.myTree.isExpanded(nodePath)) {
                return null;
            }
            return (DefaultMutableTreeNode)node;
        }
        return null;
    }

    private boolean isLoadingParentInBackground(Object node) {
        return node instanceof DefaultMutableTreeNode && this.isLoadedInBackground(this.getElementFor(node));
    }

    public void setTreeStructure(@NotNull AbstractTreeStructure treeStructure) {
        if (treeStructure == null) {
            AbstractTreeUi.$$$reportNull$$$0(171);
        }
        this.myTreeStructure = treeStructure;
        this.clearUpdaterState();
    }

    public AbstractTreeUpdater getUpdater() {
        return this.myUpdater;
    }

    public void setUpdater(@Nullable AbstractTreeUpdater updater) {
        this.myUpdater = updater;
        if (updater != null && this.myUpdateIfInactive) {
            updater.showNotify();
        }
        if (this.myUpdater != null) {
            this.myUpdater.setPassThroughMode(this.myPassThroughMode);
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.myRootNode;
    }

    public void setRootNode(@NotNull DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(172);
        }
        this.myRootNode = rootNode;
    }

    private void dropUpdaterStateIfExternalChange() {
        if (!this.isInnerChange()) {
            this.clearUpdaterState();
            this.myAutoExpandRoots.clear();
            this.mySelectionIsAdjusted = false;
        }
    }

    void clearUpdaterState() {
        this.myUpdaterState = null;
    }

    private void createMapping(@NotNull Object element, DefaultMutableTreeNode node) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(173);
        }
        element = TreeAnchorizer.getService().createAnchor(element);
        this.warnMap("myElementToNodeMap: createMapping: ", this.myElementToNodeMap);
        if (!this.myElementToNodeMap.containsKey(element)) {
            this.myElementToNodeMap.put(element, node);
        } else {
            ArrayList<DefaultMutableTreeNode> nodes;
            Object value = this.myElementToNodeMap.get(element);
            if (value instanceof DefaultMutableTreeNode) {
                nodes = new ArrayList<DefaultMutableTreeNode>();
                nodes.add((DefaultMutableTreeNode)value);
                this.myElementToNodeMap.put(element, nodes);
            } else {
                nodes = (ArrayList<DefaultMutableTreeNode>)value;
            }
            nodes.add(node);
        }
    }

    private void removeMapping(@NotNull Object element, DefaultMutableTreeNode node, @Nullable Object elementToPutNodeActionsFor) {
        if (element == null) {
            AbstractTreeUi.$$$reportNull$$$0(174);
        }
        element = TreeAnchorizer.getService().createAnchor(element);
        this.warnMap("myElementToNodeMap: removeMapping: ", this.myElementToNodeMap);
        Object value = this.myElementToNodeMap.get(element);
        if (value != null) {
            if (value instanceof DefaultMutableTreeNode) {
                if (value.equals(node)) {
                    this.myElementToNodeMap.remove(element);
                }
            } else {
                List nodes = (List)value;
                boolean reallyRemoved = nodes.remove(node);
                if (reallyRemoved && nodes.isEmpty()) {
                    this.myElementToNodeMap.remove(element);
                }
            }
        }
        this.remapNodeActions(element, elementToPutNodeActionsFor);
        TreeAnchorizer.getService().freeAnchor(element);
    }

    private void remapNodeActions(Object element, Object elementToPutNodeActionsFor) {
        AbstractTreeUi._remapNodeActions(element, elementToPutNodeActionsFor, this.myNodeActions);
        AbstractTreeUi._remapNodeActions(element, elementToPutNodeActionsFor, this.myNodeChildrenActions);
        this.warnMap("myNodeActions: remapNodeActions: ", this.myNodeActions);
        this.warnMap("myNodeChildrenActions: remapNodeActions: ", this.myNodeChildrenActions);
    }

    private static void _remapNodeActions(Object element, @Nullable Object elementToPutNodeActionsFor, @NotNull Map<Object, List<NodeAction>> nodeActions) {
        if (nodeActions == null) {
            AbstractTreeUi.$$$reportNull$$$0(175);
        }
        List<NodeAction> actions = nodeActions.get(element);
        nodeActions.remove(element);
        if (elementToPutNodeActionsFor != null && actions != null) {
            nodeActions.put(elementToPutNodeActionsFor, actions);
        }
    }

    @Nullable
    private DefaultMutableTreeNode getFirstNode(Object element) {
        return this.findNode(element, 0);
    }

    @Nullable
    private DefaultMutableTreeNode findNode(Object element, int startIndex) {
        Object value = this.getBuilder().findNodeByElement(element);
        if (value == null) {
            return null;
        }
        if (value instanceof DefaultMutableTreeNode) {
            return startIndex == 0 ? (DefaultMutableTreeNode)value : null;
        }
        List nodes = (List)value;
        return startIndex < nodes.size() ? (DefaultMutableTreeNode)nodes.get(startIndex) : null;
    }

    protected Object findNodeByElement(Object element) {
        element = TreeAnchorizer.getService().createAnchor(element);
        try {
            if (AbstractTreeUi.isNodeNull(element)) {
                Object var2_2 = null;
                return var2_2;
            }
            if (this.myElementToNodeMap.containsKey(element)) {
                Object object = this.myElementToNodeMap.get(element);
                return object;
            }
            this.TREE_NODE_WRAPPER.setValue(element);
            Object object = this.myElementToNodeMap.get(this.TREE_NODE_WRAPPER);
            return object;
        }
        finally {
            this.TREE_NODE_WRAPPER.setValue(null);
            TreeAnchorizer.getService().freeAnchor(element);
        }
    }

    @Nullable
    private DefaultMutableTreeNode findNodeForChildElement(@NotNull DefaultMutableTreeNode parentNode, Object element) {
        Object anchor;
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(176);
        }
        Object value = AbstractTreeUi.isNodeNull(anchor = TreeAnchorizer.getService().createAnchor(element)) ? null : this.myElementToNodeMap.get(anchor);
        TreeAnchorizer.getService().freeAnchor(anchor);
        if (value == null) {
            return null;
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode elementNode = (DefaultMutableTreeNode)value;
            return parentNode.equals(elementNode.getParent()) ? elementNode : null;
        }
        List allNodesForElement = (List)value;
        for (DefaultMutableTreeNode elementNode : allNodesForElement) {
            if (!parentNode.equals(elementNode.getParent())) continue;
            return elementNode;
        }
        return null;
    }

    private void addNodeAction(Object element, NodeAction action, boolean shouldChildrenBeReady) {
        this._addNodeAction(element, action, this.myNodeActions);
        if (shouldChildrenBeReady) {
            this._addNodeAction(element, action, this.myNodeChildrenActions);
        }
        this.warnMap("myNodeActions: addNodeAction: ", this.myNodeActions);
        this.warnMap("myNodeChildrenActions: addNodeAction: ", this.myNodeChildrenActions);
    }

    public void addActivity() {
        if (this.myActivityMonitor != null) {
            this.myActivityMonitor.addActivity(this.myActivityId, this.getUpdater().getModalityState());
        }
    }

    public void removeActivity() {
        if (this.myActivityMonitor != null) {
            this.myActivityMonitor.removeActivity(this.myActivityId);
        }
    }

    private void _addNodeAction(Object element, NodeAction action, @NotNull Map<Object, List<NodeAction>> map) {
        if (map == null) {
            AbstractTreeUi.$$$reportNull$$$0(177);
        }
        this.maybeSetBusyAndScheduleWaiterForReady(true, element);
        map.computeIfAbsent(element, k -> new ArrayList()).add(action);
        this.addActivity();
    }

    private void cleanUpNow() {
        if (!this.canInitiateNewActivity()) {
            return;
        }
        UpdaterTreeState state = new UpdaterTreeState(this);
        this.myTree.collapsePath(new TreePath(this.myTree.getModel().getRoot()));
        this.clearSelection();
        this.getRootNode().removeAllChildren();
        this.myRootNodeWasQueuedToInitialize = false;
        this.myRootNodeInitialized = false;
        this.clearNodeActions();
        this.myElementToNodeMap.clear();
        this.myDeferredSelections.clear();
        this.myDeferredExpansions.clear();
        this.myLoadedInBackground.clear();
        this.myUnbuiltNodes.clear();
        this.myUpdateFromRootRequested = true;
        this.myWorker.clear();
        this.myTree.invalidate();
        state.restore(null);
    }

    @NotNull
    public AbstractTreeUi setClearOnHideDelay(long clearOnHideDelay) {
        this.myClearOnHideDelay = clearOnHideDelay;
        AbstractTreeUi abstractTreeUi = this;
        if (abstractTreeUi == null) {
            AbstractTreeUi.$$$reportNull$$$0(178);
        }
        return abstractTreeUi;
    }

    private void removeChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(179);
        }
        EnumerationCopy copy = new EnumerationCopy(node.children());
        while (copy.hasMoreElements()) {
            this.disposeNode((DefaultMutableTreeNode)copy.nextElement());
        }
        node.removeAllChildren();
        this.nodeStructureChanged(node);
    }

    private void maybeUpdateSubtreeToUpdate(final @NotNull DefaultMutableTreeNode subtreeRoot) {
        if (subtreeRoot == null) {
            AbstractTreeUi.$$$reportNull$$$0(180);
        }
        if (!this.myUnbuiltNodes.contains(subtreeRoot)) {
            return;
        }
        TreePath path2 = AbstractTreeUi.getPathFor(subtreeRoot);
        if (this.myTree.getRowForPath(path2) == -1) {
            return;
        }
        DefaultMutableTreeNode parent = this.getParentBuiltNode(subtreeRoot);
        if (parent == null) {
            if (!this.getBuilder().isAlwaysShowPlus(AbstractTreeUi.getDescriptorFrom(subtreeRoot))) {
                this.addSubtreeToUpdate(subtreeRoot);
            }
        } else if (parent != subtreeRoot) {
            this.addNodeAction(this.getElementFor(subtreeRoot), new NodeAction(){

                @Override
                public void onReady(DefaultMutableTreeNode parent) {
                    AbstractTreeUi.this.maybeUpdateSubtreeToUpdate(subtreeRoot);
                }
            }, true);
        }
    }

    private boolean isSelectionInside(DefaultMutableTreeNode parent) {
        TreePath path2 = new TreePath(this.myTreeModel.getPathToRoot(parent));
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path1 : paths) {
            if (!path2.isDescendant(path1)) continue;
            return true;
        }
        return false;
    }

    public boolean isInStructure(@Nullable Object element) {
        if (AbstractTreeUi.isNodeNull(element)) {
            return false;
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure == null) {
            return false;
        }
        Object rootElement = structure.getRootElement();
        Object eachParent = element;
        while (eachParent != null) {
            if (Comparing.equal((Object)rootElement, (Object)eachParent)) {
                return true;
            }
            eachParent = structure.getParentElement(eachParent);
        }
        return false;
    }

    public void setCanYield(boolean canYield) {
        this.myCanYield = canYield;
    }

    @NotNull
    public Collection<TreeUpdatePass> getYeildingPasses() {
        List<TreeUpdatePass> list = this.myYieldingPasses;
        if (list == null) {
            AbstractTreeUi.$$$reportNull$$$0(181);
        }
        return list;
    }

    private long getComparatorStamp() {
        if (this.myNodeDescriptorComparator instanceof NodeDescriptor.NodeComparator) {
            long currentComparatorStamp = ((NodeDescriptor.NodeComparator)this.myNodeDescriptorComparator).getStamp();
            if (currentComparatorStamp > this.myLastComparatorStamp) {
                this.myOwnComparatorStamp = Math.max(this.myOwnComparatorStamp, currentComparatorStamp) + 1L;
            }
            this.myLastComparatorStamp = currentComparatorStamp;
            return Math.max(currentComparatorStamp, this.myOwnComparatorStamp);
        }
        return this.myOwnComparatorStamp;
    }

    public void incComparatorStamp() {
        this.myOwnComparatorStamp = this.getComparatorStamp() + 1L;
    }

    public void setPassthroughMode(boolean passthrough) {
        this.myPassThroughMode = passthrough;
        AbstractTreeUpdater updater = this.getUpdater();
        if (updater != null) {
            updater.setPassThroughMode(this.myPassThroughMode);
        }
        if (AbstractTreeUi.isUnitTestingMode() || passthrough) {
            // empty if block
        }
    }

    public boolean isPassthroughMode() {
        return this.myPassThroughMode;
    }

    private static boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    private void addModelListenerToDianoseAccessOutsideEdt() {
        this.myTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }
        });
    }

    private <V> void warnMap(String prefix, Map<Object, V> map) {
        long count;
        if (!LOG.isDebugEnabled()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread() && !this.myPassThroughMode) {
            LOG.warn(prefix + "modified on wrong thread");
        }
        if ((count = map.keySet().stream().filter(AbstractTreeUi::isNodeNull).count()) > 0L) {
            LOG.warn(prefix + "null keys: " + count + " / " + map.size());
        }
    }

    private static boolean isNodeNull(Object element) {
        if (element instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element;
            element = node.getValue();
        }
        return element == null;
    }

    public final boolean isConsistent() {
        return this.myTree != null && this.myTreeModel != null && this.myTreeModel == this.myTree.getModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 121: 
            case 122: 
            case 127: 
            case 128: 
            case 150: 
            case 178: 
            case 181: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 121: 
            case 122: 
            case 127: 
            case 128: 
            case 150: 
            case 178: 
            case 181: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 3: 
            case 61: 
            case 63: 
            case 69: 
            case 73: 
            case 99: 
            case 129: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 22: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 66: 
            case 67: 
            case 68: 
            case 83: 
            case 84: 
            case 85: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 117: 
            case 120: 
            case 123: 
            case 125: 
            case 131: 
            case 134: 
            case 136: 
            case 169: 
            case 170: 
            case 179: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 163: 
            case 173: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 42: 
            case 119: 
            case 124: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 121: 
            case 122: 
            case 127: 
            case 128: 
            case 150: 
            case 178: 
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeUi";
                break;
            }
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 35: 
            case 39: 
            case 44: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 70: 
            case 74: 
            case 111: 
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 14: 
            case 16: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeDescriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToInsert";
                break;
            }
            case 51: 
            case 77: 
            case 110: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToIndexMap";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processRunnable";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 78: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedChildren";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressive";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateInfo";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 105: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeActions";
                break;
            }
            case 108: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 109: 
            case 116: 
            case 133: 
            case 176: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bgBuildAction";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 151: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSelect";
                break;
            }
            case 154: 
            case 160: 
            case 164: 
            case 165: 
            case 167: 
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "done";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kidsToExpand";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtreeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeUi";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "queueUpdate";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpdaterState";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "updateNodeChildren";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "updateNodesToInsert";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "processExistingNodes";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "maybeYeild";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "resetToReadyNow";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "loadElementsFromStructure";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNodesToInsert";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildNode";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialized";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeActions";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildrenFor";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedElements";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelUpdate";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireLock";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "batch";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "processExistingNode";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpiredElementCondition";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFor";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "queueToBackground";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 178: {
                objectArray = objectArray2;
                objectArray2[1] = "setClearOnHideDelay";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "getYeildingPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExpandNodeChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNodeValidForElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidChildOfParent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildNodeForPath";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 121: 
            case 122: 
            case 127: 
            case 128: 
            case 150: 
            case 178: 
            case 181: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initRootNodeNowIfNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeferredActions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateSubtree";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateSubtreeNow";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateRow";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setUpdaterState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateNode";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeChildren";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateChildren";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processAlwaysLeaf";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isChildNodeForceUpdate";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeChildrenNow";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 41: 
            case 42: 
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processUnbuilt";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeIfLoading";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectionToParentIfNeeded";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "updateNodesToInsert";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processExistingNodes";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isRerunNeeded";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "maybeYeild";
                break;
            }
            case 61: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addToCancelled";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "removeFromCancelled";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "resetIncompleteNode";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "yieldAndRun";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkValue";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "executeYieldingRequest";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToInsert";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addToUpdatingChildren";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "removeFromUpdatingChildren";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isParentUpdatingChildrenNow";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "batch";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "executeUserRunnable";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "queueBackgroundUpdate";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isExpanded";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "removeLoading";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "processNodeActionsIfReady";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "processActions";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "processSmartExpand";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getChildForSmartExpand";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "processExistingNode";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectionOnChildRemove";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isValidForSelectionAdjusting";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionPath";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getPathFor";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "removeNodeFromParent";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "makeLoadingOrLeafIfNoChildren";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "queueToBackground";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "registerWorkerTask";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "unregisterWorkerTask";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeImageAndPosition";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "insertNodesInto";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "disposeNode";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "addSubtreeToUpdate";
                break;
            }
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 144: 
            case 145: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "_select";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "userSelect";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "restoreSelection";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "addToDeferred";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "addNext";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "doSelect";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "checkPathAndMaybeRevalidate";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "selectVisible";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getRowIfUnderSelection";
                break;
            }
            case 159: 
            case 160: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "_expand";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "expandNext";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "collapseChildren";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "deferExpansion";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "processExpand";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "isNodeBeingBuilt";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "getParentBuiltNode";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "setTreeStructure";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "setRootNode";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "removeMapping";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "_remapNodeActions";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "findNodeForChildElement";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "_addNodeAction";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "removeChildren";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "maybeUpdateSubtreeToUpdate";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkPathAndMaybeRevalidate$10";
                break;
            }
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExistingNode$7";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectNodesToInsert$5";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doUpdateNode$2";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "lambda$update$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 121: 
            case 122: 
            case 127: 
            case 128: 
            case 150: 
            case 178: 
            case 181: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UpdateInfo {
        NodeDescriptor myDescriptor;
        TreeUpdatePass myPass;
        boolean myCanSmartExpand;
        boolean myWasExpanded;
        boolean myForceUpdate;
        boolean myDescriptorIsUpToDate;
        boolean myUpdateChildren;

        public UpdateInfo(NodeDescriptor descriptor, TreeUpdatePass pass, boolean canSmartExpand, boolean wasExpanded, boolean forceUpdate, boolean descriptorIsUpToDate, boolean updateChildren) {
            this.myDescriptor = descriptor;
            this.myPass = pass;
            this.myCanSmartExpand = canSmartExpand;
            this.myWasExpanded = wasExpanded;
            this.myForceUpdate = forceUpdate;
            this.myDescriptorIsUpToDate = descriptorIsUpToDate;
            this.myUpdateChildren = updateChildren;
        }

        synchronized NodeDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        synchronized TreeUpdatePass getPass() {
            return this.myPass;
        }

        synchronized boolean isCanSmartExpand() {
            return this.myCanSmartExpand;
        }

        synchronized boolean isWasExpanded() {
            return this.myWasExpanded;
        }

        synchronized boolean isForceUpdate() {
            return this.myForceUpdate;
        }

        synchronized boolean isDescriptorIsUpToDate() {
            return this.myDescriptorIsUpToDate;
        }

        public synchronized void apply(@NotNull UpdateInfo updateInfo) {
            if (updateInfo == null) {
                UpdateInfo.$$$reportNull$$$0(0);
            }
            this.myDescriptor = updateInfo.myDescriptor;
            this.myPass = updateInfo.myPass;
            this.myCanSmartExpand = updateInfo.myCanSmartExpand;
            this.myWasExpanded = updateInfo.myWasExpanded;
            this.myForceUpdate = updateInfo.myForceUpdate;
            this.myDescriptorIsUpToDate = updateInfo.myDescriptorIsUpToDate;
        }

        public synchronized boolean isUpdateChildren() {
            return this.myUpdateChildren;
        }

        @NotNull
        @NonNls
        public synchronized String toString() {
            String string = "UpdateInfo: desc=" + this.myDescriptor + " pass=" + this.myPass + " canSmartExpand=" + this.myCanSmartExpand + " wasExpanded=" + this.myWasExpanded + " forceUpdate=" + this.myForceUpdate + " descriptorUpToDate=" + this.myDescriptorIsUpToDate;
            if (string == null) {
                UpdateInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeUi$UpdateInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeUi$UpdateInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LoadedChildren {
        @NotNull
        private final List<Object> myElements;
        private final Map<Object, NodeDescriptor> myDescriptors = new HashMap<Object, NodeDescriptor>();
        private final Map<NodeDescriptor, Boolean> myChanges = new HashMap<NodeDescriptor, Boolean>();

        LoadedChildren(@Nullable Object[] elements) {
            this.myElements = Arrays.asList(elements != null ? elements : ArrayUtil.EMPTY_OBJECT_ARRAY);
        }

        void putDescriptor(Object element, NodeDescriptor descriptor, boolean isChanged) {
            if (AbstractTreeUi.isUnitTestingMode()) assert (this.myElements.contains(element));
            this.myDescriptors.put(element, descriptor);
            this.myChanges.put(descriptor, isChanged);
        }

        @NotNull
        List<Object> getElements() {
            List<Object> list = this.myElements;
            if (list == null) {
                LoadedChildren.$$$reportNull$$$0(0);
            }
            return list;
        }

        NodeDescriptor getDescriptor(Object element) {
            return this.myDescriptors.get(element);
        }

        @NotNull
        public String toString() {
            String string = this.myElements + "->" + this.myChanges;
            if (string == null) {
                LoadedChildren.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isUpdated(Object element) {
            NodeDescriptor desc = this.getDescriptor(element);
            return this.myChanges.get(desc);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/util/treeView/AbstractTreeUi$LoadedChildren";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static interface NodeAction {
        public void onReady(DefaultMutableTreeNode var1);
    }

    private class MyExpansionListener
    implements TreeExpansionListener {
        private MyExpansionListener() {
        }

        @Override
        public void treeExpanded(@NotNull TreeExpansionEvent event) {
            if (event == null) {
                MyExpansionListener.$$$reportNull$$$0(0);
            }
            final TreePath path2 = event.getPath();
            if (AbstractTreeUi.this.mySilentExpand != null && AbstractTreeUi.this.mySilentExpand.equals(path2)) {
                return;
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
            if (AbstractTreeUi.this.myRequestedExpand != null && !AbstractTreeUi.this.myRequestedExpand.equals(path2)) {
                AbstractTreeUi.this._getReady().doWhenDone(new TreeRunnable("AbstractTreeUi.MyExpansionListener.treeExpanded"){

                    @Override
                    public void perform() {
                        Object element = AbstractTreeUi.this.getElementFor(path2.getLastPathComponent());
                        AbstractTreeUi.this.expand(element, null);
                    }
                });
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
            if (!AbstractTreeUi.this.myUnbuiltNodes.contains(node)) {
                AbstractTreeUi.this.removeLoading(node, false);
                HashSet<DefaultMutableTreeNode> childrenToUpdate = new HashSet<DefaultMutableTreeNode>();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode each = (DefaultMutableTreeNode)node.getChildAt(i);
                    if (!AbstractTreeUi.this.myUnbuiltNodes.contains(each)) continue;
                    AbstractTreeUi.this.makeLoadingOrLeafIfNoChildren(each);
                    childrenToUpdate.add(each);
                }
                if (!childrenToUpdate.isEmpty()) {
                    for (DefaultMutableTreeNode each : childrenToUpdate) {
                        AbstractTreeUi.this.maybeUpdateSubtreeToUpdate(each);
                    }
                }
            } else {
                AbstractTreeUi.this.getBuilder().expandNodeChildren(node);
            }
            AbstractTreeUi.this.processSmartExpand(node, AbstractTreeUi.this.canSmartExpand(node, true), false);
            AbstractTreeUi.this.processNodeActionsIfReady(node);
        }

        @Override
        public void treeCollapsed(@NotNull TreeExpansionEvent e) {
            if (e == null) {
                MyExpansionListener.$$$reportNull$$$0(1);
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
            TreePath path2 = e.getPath();
            final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
            NodeDescriptor descriptor = AbstractTreeUi.getDescriptorFrom(node);
            if (descriptor == null) {
                return;
            }
            TreePath pathToSelect = null;
            if (AbstractTreeUi.this.isSelectionInside(node)) {
                pathToSelect = new TreePath(node.getPath());
            }
            if (AbstractTreeUi.this.getBuilder().isDisposeOnCollapsing(descriptor)) {
                AbstractTreeUi.this.runDone(new TreeRunnable("AbstractTreeUi.MyExpansionListener.treeCollapsed"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isDisposed(node)) {
                            return;
                        }
                        TreePath nodePath = new TreePath(node.getPath());
                        if (AbstractTreeUi.this.myTree.isExpanded(nodePath)) {
                            return;
                        }
                        AbstractTreeUi.this.removeChildren(node);
                        AbstractTreeUi.this.makeLoadingOrLeafIfNoChildren(node);
                    }
                });
                if (node.equals(AbstractTreeUi.this.getRootNode())) {
                    if (AbstractTreeUi.this.myTree.isRootVisible()) {
                        // empty if block
                    }
                } else {
                    AbstractTreeUi.this.myTreeModel.reload(node);
                }
            }
            if (pathToSelect != null && AbstractTreeUi.this.myTree.isSelectionEmpty()) {
                AbstractTreeUi.this.addSelectionPath(pathToSelect, true, Conditions.alwaysFalse(), null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeUi$MyExpansionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "treeExpanded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "treeCollapsed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySelectionListener
    implements TreeSelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                MySelectionListener.$$$reportNull$$$0(0);
            }
            if (AbstractTreeUi.this.mySilentSelect != null && AbstractTreeUi.this.mySilentSelect.equals(e.getNewLeadSelectionPath())) {
                return;
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/treeView/AbstractTreeUi$MySelectionListener", "valueChanged"));
        }
    }

    static class ElementNode
    extends DefaultMutableTreeNode {
        Set<Object> myElements = new HashSet<Object>();
        AbstractTreeUi myUi;

        ElementNode(AbstractTreeUi ui, NodeDescriptor descriptor) {
            super(descriptor);
            this.myUi = ui;
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            Object element = this.myUi.getElementFor(newChild);
            if (element != null) {
                this.myElements.add(element);
            }
        }

        @Override
        public void remove(int childIndex) {
            TreeNode node = this.getChildAt(childIndex);
            super.remove(childIndex);
            Object element = this.myUi.getElementFor(node);
            if (element != null) {
                this.myElements.remove(element);
            }
        }

        boolean isValidChild(Object childElement) {
            return this.myElements.contains(childElement);
        }

        @Override
        public String toString() {
            return String.valueOf(this.getUserObject());
        }
    }

    private static abstract class AsyncRunnable {
        private AsyncRunnable() {
        }

        @NotNull
        public abstract Promise<?> run();
    }
}

