/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MacOtherAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapperButtonLayout;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public abstract class DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.DialogWrapper");
    public static final int OK_EXIT_CODE = 0;
    public static final int CANCEL_EXIT_CODE = 1;
    public static final int CLOSE_EXIT_CODE = 1;
    public static final int NEXT_USER_EXIT_CODE = 2;
    @NonNls
    public static final String DEFAULT_ACTION = "DefaultAction";
    @NonNls
    public static final String FOCUSED_ACTION = "FocusedAction";
    @NonNls
    private static final String NO_AUTORESIZE = "NoAutoResizeAndFit";
    private static final KeyStroke SHOW_OPTION_KEYSTROKE = KeyStroke.getKeyStroke(10, 9);
    @NotNull
    private final DialogWrapperPeer myPeer;
    private int myExitCode;
    public static final Border ourDefaultBorder = new EmptyBorder(UIUtil.PANEL_REGULAR_INSETS);
    private float myHorizontalStretch;
    private float myVerticalStretch;
    private int myButtonAlignment;
    private boolean myCrossClosesWindow;
    private Insets myButtonMargins;
    protected Action myOKAction;
    protected Action myCancelAction;
    protected Action myHelpAction;
    private final Map<Action, JButton> myButtonMap;
    private boolean myClosed;
    protected boolean myPerformAction;
    private Action myYesAction;
    private Action myNoAction;
    protected JCheckBox myCheckBoxDoNotShowDialog;
    @Nullable
    private DoNotAskOption myDoNotAsk;
    protected JComponent myPreferredFocusedComponent;
    private Computable<Point> myInitialLocationCallback;
    private Dimension myActualSize;
    private List<ValidationInfo> myInfo;
    @NotNull
    protected final Disposable myDisposable;
    private final List<JBOptionButton> myOptionsButtons;
    private int myCurrentOptionsButtonIndex;
    private boolean myResizeInProgress;
    private ComponentAdapter myResizeListener;
    private ErrorText myErrorText;
    private final Alarm myErrorTextAlarm;
    public static final Color BALLOON_ERROR_BORDER = new JBColor(new Color(14723241), new Color(7554379));
    public static final Color BALLOON_ERROR_BACKGROUND = new JBColor(new Color(16115431), new Color(5848385));
    public static final Color BALLOON_WARNING_BORDER = new JBColor(new Color(13412457), new Color(5129519));
    public static final Color BALLOON_WARNING_BACKGROUND = new JBColor(new Color(16381166), new Color(5852722));
    private final Alarm myValidationAlarm;
    private int myValidationDelay;
    private boolean myDisposed;
    private boolean myValidationStarted;
    private final ErrorPainter myErrorPainter;
    private boolean myErrorPainterInstalled;

    @NotNull
    protected String getDoNotShowMessage() {
        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
        if (string == null) {
            DialogWrapper.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setDoNotAskOption(@Nullable DoNotAskOption doNotAsk) {
        this.myDoNotAsk = doNotAsk;
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent) {
        this(project, canBeParent, IdeModalityType.IDE);
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(1);
        }
        this(project, null, canBeParent, ideModalityType);
    }

    protected DialogWrapper(@Nullable Project project, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(2);
        }
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myButtonMargins = JBUI.insets((int)2, (int)16);
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.myClosed = false;
        this.myPerformAction = false;
        this.myYesAction = null;
        this.myNoAction = null;
        this.myActualSize = null;
        this.myInfo = Collections.emptyList();
        this.myDisposable = new Disposable(){

            public String toString() {
                return DialogWrapper.this.toString();
            }

            public void dispose() {
                DialogWrapper.this.dispose();
            }
        };
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myCurrentOptionsButtonIndex = -1;
        this.myResizeInProgress = false;
        this.myErrorTextAlarm = new Alarm();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myValidationDelay = 300;
        this.myDisposed = false;
        this.myValidationStarted = false;
        this.myErrorPainter = new ErrorPainter();
        this.myErrorPainterInstalled = false;
        this.myPeer = parentComponent == null ? this.createPeer(project, canBeParent, project == null ? IdeModalityType.IDE : ideModalityType) : this.createPeer(parentComponent, canBeParent);
        Window window = this.myPeer.getWindow();
        if (window != null) {
            this.myResizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!DialogWrapper.this.myResizeInProgress) {
                        DialogWrapper.this.myActualSize = DialogWrapper.this.myPeer.getSize();
                        if (DialogWrapper.this.myErrorText != null && DialogWrapper.this.myErrorText.isVisible()) {
                            ((DialogWrapper)DialogWrapper.this).myActualSize.height -= ((DialogWrapper)DialogWrapper.this).myErrorText.getMinimumSize().height;
                        }
                    }
                }
            };
            window.addComponentListener(this.myResizeListener);
        }
        this.createDefaultActions();
    }

    protected DialogWrapper(@Nullable Project project) {
        this(project, true);
    }

    protected DialogWrapper(boolean canBeParent) {
        this((Project)null, canBeParent);
    }

    @Deprecated
    protected DialogWrapper(boolean canBeParent, boolean applicationModalIfPossible) {
        this(null, canBeParent, applicationModalIfPossible);
    }

    protected DialogWrapper(Project project, boolean canBeParent, boolean applicationModalIfPossible) {
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myButtonMargins = JBUI.insets((int)2, (int)16);
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.myClosed = false;
        this.myPerformAction = false;
        this.myYesAction = null;
        this.myNoAction = null;
        this.myActualSize = null;
        this.myInfo = Collections.emptyList();
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myCurrentOptionsButtonIndex = -1;
        this.myResizeInProgress = false;
        this.myErrorTextAlarm = new Alarm();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myValidationDelay = 300;
        this.myDisposed = false;
        this.myValidationStarted = false;
        this.myErrorPainter = new ErrorPainter();
        this.myErrorPainterInstalled = false;
        DialogWrapper.ensureEventDispatchThread();
        this.myPeer = ApplicationManager.getApplication() != null ? this.createPeer(project != null ? WindowManager.getInstance().suggestParentWindow(project) : WindowManager.getInstance().findVisibleFrame(), canBeParent, applicationModalIfPossible) : this.createPeer(null, canBeParent, applicationModalIfPossible);
        this.createDefaultActions();
    }

    protected DialogWrapper(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            DialogWrapper.$$$reportNull$$$0(3);
        }
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myButtonMargins = JBUI.insets((int)2, (int)16);
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.myClosed = false;
        this.myPerformAction = false;
        this.myYesAction = null;
        this.myNoAction = null;
        this.myActualSize = null;
        this.myInfo = Collections.emptyList();
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myCurrentOptionsButtonIndex = -1;
        this.myResizeInProgress = false;
        this.myErrorTextAlarm = new Alarm();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myValidationDelay = 300;
        this.myDisposed = false;
        this.myValidationStarted = false;
        this.myErrorPainter = new ErrorPainter();
        this.myErrorPainterInstalled = false;
        DialogWrapper.ensureEventDispatchThread();
        this.myPeer = this.createPeer(parent, canBeParent);
        this.createDefaultActions();
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        if (threadToUse == null) {
            DialogWrapper.$$$reportNull$$$0(4);
        }
        return threadToUse;
    }

    protected boolean postponeValidation() {
        return true;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return null;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo vi = this.doValidate();
        List<ValidationInfo> list = vi != null ? Collections.singletonList(vi) : Collections.EMPTY_LIST;
        if (list == null) {
            DialogWrapper.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setValidationDelay(int delay) {
        this.myValidationDelay = delay;
    }

    private void installErrorPainter() {
        if (this.myErrorPainterInstalled) {
            return;
        }
        this.myErrorPainterInstalled = true;
        UIUtil.invokeLaterIfNeeded(() -> IdeGlassPaneUtil.installPainter(this.getContentPanel(), this.myErrorPainter, this.myDisposable));
    }

    protected void updateErrorInfo(@NotNull List<ValidationInfo> info) {
        boolean updateNeeded;
        if (info == null) {
            DialogWrapper.$$$reportNull$$$0(6);
        }
        boolean bl = Registry.is((String)"ide.inplace.errors.balloon") ? !this.myInfo.equals(info) : (updateNeeded = !this.myErrorText.isTextSet(info));
        if (updateNeeded) {
            SwingUtilities.invokeLater(() -> {
                if (info == null) {
                    DialogWrapper.$$$reportNull$$$0(57);
                }
                if (this.myDisposed) {
                    return;
                }
                this.setErrorInfoAll(info);
                this.myPeer.getRootPane().getGlassPane().repaint();
                this.getOKAction().setEnabled(info.isEmpty());
            });
        }
    }

    protected void createDefaultActions() {
        this.myOKAction = new OkAction();
        this.myCancelAction = new CancelAction();
        this.myHelpAction = new HelpAction();
    }

    public void setUndecorated(boolean undecorated) {
        this.myPeer.setUndecorated(undecorated);
    }

    public final void addMouseListener(@NotNull MouseListener listener) {
        if (listener == null) {
            DialogWrapper.$$$reportNull$$$0(7);
        }
        this.myPeer.addMouseListener(listener);
    }

    public final void addMouseListener(@NotNull MouseMotionListener listener) {
        if (listener == null) {
            DialogWrapper.$$$reportNull$$$0(8);
        }
        this.myPeer.addMouseListener(listener);
    }

    public final void addKeyListener(@NotNull KeyListener listener) {
        if (listener == null) {
            DialogWrapper.$$$reportNull$$$0(9);
        }
        this.myPeer.addKeyListener(listener);
    }

    public final void close(int exitCode, boolean isOk) {
        DialogWrapper.ensureEventDispatchThread();
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        this.myExitCode = exitCode;
        Window window = this.getWindow();
        if (window != null && this.myResizeListener != null) {
            window.removeComponentListener(this.myResizeListener);
            this.myResizeListener = null;
        }
        if (isOk) {
            this.processDoNotAskOnOk(exitCode);
        } else {
            this.processDoNotAskOnCancel();
        }
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public final void close(int exitCode) {
        this.close(exitCode, exitCode != 1);
    }

    @Nullable
    protected Border createContentPaneBorder() {
        if (this.getStyle() == DialogStyle.COMPACT) {
            return JBUI.Borders.empty();
        }
        return ourDefaultBorder;
    }

    protected static boolean isMoveHelpButtonLeft() {
        return UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel();
    }

    private static boolean isRemoveHelpButton() {
        return SystemInfo.isWindows && (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) && Registry.is((String)"ide.win.frame.decoration") || Registry.is((String)"ide.remove.help.button.from.dialogs");
    }

    protected JComponent createSouthPanel() {
        List<Action> actions = ContainerUtil.filter((Object[])this.createActions(), (Condition)Condition.NOT_NULL);
        List<Object> leftSideActions = ContainerUtil.newArrayList((Object[])this.createLeftSideActions());
        if (!ApplicationInfo.contextHelpAvailable()) {
            actions.remove(this.getHelpAction());
        }
        boolean hasHelpToMoveToLeftSide = false;
        if (DialogWrapper.isRemoveHelpButton()) {
            actions.remove(this.getHelpAction());
        } else if (DialogWrapper.isMoveHelpButtonLeft() && actions.contains(this.getHelpAction())) {
            hasHelpToMoveToLeftSide = true;
            actions.remove(this.getHelpAction());
        }
        if (SystemInfo.isMac) {
            int cancelNdx;
            int okNdx;
            Action macOtherAction = (Action)ContainerUtil.find((Iterable)actions, MacOtherAction.class::isInstance);
            if (macOtherAction != null) {
                leftSideActions.add(macOtherAction);
                actions.remove(macOtherAction);
            }
            if ((okNdx = actions.indexOf(this.getOKAction())) >= 0 && okNdx != actions.size() - 1) {
                actions.remove(this.getOKAction());
                actions.add(this.getOKAction());
            }
            if ((cancelNdx = actions.indexOf(this.getCancelAction())) > 0) {
                actions.remove(this.getCancelAction());
                actions.add(0, this.getCancelAction());
            }
        } else if (UIUtil.isUnderGTKLookAndFeel() && actions.contains(this.getHelpAction())) {
            leftSideActions.add(this.getHelpAction());
            actions.remove(this.getHelpAction());
        }
        if (!UISettings.getShadowInstance().getAllowMergeButtons()) {
            actions = DialogWrapper.flattenOptionsActions(actions);
            leftSideActions = DialogWrapper.flattenOptionsActions((List<Action>)leftSideActions);
        }
        List<JButton> leftSideButtons = this.createButtons((List<Action>)leftSideActions);
        List<JButton> rightSideButtons = this.createButtons(actions);
        this.myButtonMap.clear();
        for (JButton button : ContainerUtil.concat(leftSideButtons, rightSideButtons)) {
            this.myButtonMap.put(button.getAction(), button);
            if (!(button instanceof JBOptionButton)) continue;
            this.myOptionsButtons.add((JBOptionButton)button);
        }
        return this.createSouthPanel(leftSideButtons, rightSideButtons, hasHelpToMoveToLeftSide);
    }

    @NotNull
    protected JButton createHelpButton(Insets insets) {
        JButton helpButton = new JButton(this.getHelpAction());
        helpButton.putClientProperty("JButton.buttonType", "help");
        helpButton.setText("");
        helpButton.setMargin(insets);
        this.setHelpTooltip(helpButton);
        JButton jButton = helpButton;
        if (jButton == null) {
            DialogWrapper.$$$reportNull$$$0(10);
        }
        return jButton;
    }

    protected void setHelpTooltip(JButton helpButton) {
        helpButton.setToolTipText(ActionsBundle.actionDescription("HelpTopics"));
    }

    @NotNull
    private static List<Action> flattenOptionsActions(@NotNull List<Action> actions) {
        if (actions == null) {
            DialogWrapper.$$$reportNull$$$0(11);
        }
        ArrayList<Action> newActions = new ArrayList<Action>();
        for (Action action : actions) {
            newActions.add(action);
            if (!(action instanceof OptionAction)) continue;
            ContainerUtil.addAll(newActions, (Object[])((OptionAction)action).getOptions());
        }
        ArrayList<Action> arrayList = newActions;
        if (arrayList == null) {
            DialogWrapper.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    protected boolean shouldAddErrorNearButtons() {
        return false;
    }

    @NotNull
    protected DialogStyle getStyle() {
        DialogStyle dialogStyle = DialogStyle.NO_STYLE;
        if (dialogStyle == null) {
            DialogWrapper.$$$reportNull$$$0(13);
        }
        return dialogStyle;
    }

    protected boolean toBeShown() {
        return !this.myCheckBoxDoNotShowDialog.isSelected();
    }

    public boolean isTypeAheadEnabled() {
        return false;
    }

    @NotNull
    private List<JButton> createButtons(@NotNull List<Action> actions) {
        if (actions == null) {
            DialogWrapper.$$$reportNull$$$0(14);
        }
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        for (Action action : actions) {
            buttons.add(this.createJButtonForAction(action));
        }
        ArrayList<JButton> arrayList = buttons;
        if (arrayList == null) {
            DialogWrapper.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private JPanel createSouthPanel(@NotNull List<JButton> leftSideButtons, @NotNull List<JButton> rightSideButtons, boolean hasHelpToMoveToLeftSide) {
        Object insets;
        if (leftSideButtons == null) {
            DialogWrapper.$$$reportNull$$$0(16);
        }
        if (rightSideButtons == null) {
            DialogWrapper.$$$reportNull$$$0(17);
        }
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                Color bg = UIManager.getColor("DialogWrapper.southPanelBackground");
                if (DialogWrapper.this.getStyle() == DialogStyle.COMPACT && bg != null) {
                    return bg;
                }
                return super.getBackground();
            }
        };
        if (this.myDoNotAsk != null) {
            this.myCheckBoxDoNotShowDialog = new JCheckBox(this.myDoNotAsk.getDoNotShowMessage());
            this.myCheckBoxDoNotShowDialog.setVisible(this.myDoNotAsk.canBeHidden());
            this.myCheckBoxDoNotShowDialog.setSelected(!this.myDoNotAsk.isToBeShown());
            DialogUtil.registerMnemonic(this.myCheckBoxDoNotShowDialog, '&');
        }
        JComponent doNotAskCheckbox = this.createDoNotAskCheckbox();
        NonOpaquePanel lrButtonsPanel = new NonOpaquePanel(new GridBagLayout());
        Object object = SystemInfo.isMacOSLeopard ? (UIUtil.isUnderIntelliJLaF() ? JBUI.insets((int)0, (int)8) : JBUI.emptyInsets()) : (insets = UIUtil.isUnderWin10LookAndFeel() ? JBUI.emptyInsets() : new Insets(8, 0, 0, 0));
        if (rightSideButtons.size() > 0 || leftSideButtons.size() > 0) {
            JPanel buttonsPanel;
            GridBag bag = new GridBag().setDefaultInsets((Insets)insets);
            if (leftSideButtons.size() > 0) {
                buttonsPanel = this.createButtonsPanel(leftSideButtons);
                if (rightSideButtons.size() > 0) {
                    buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            if (rightSideButtons.size() > 0) {
                buttonsPanel = this.createButtonsPanel(rightSideButtons);
                if (this.shouldAddErrorNearButtons()) {
                    lrButtonsPanel.add((Component)this.myErrorText, bag.next());
                    lrButtonsPanel.add(Box.createHorizontalStrut(10), bag.next());
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            if (0 == this.myButtonAlignment && doNotAskCheckbox == null) {
                lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            }
        }
        JButton helpButton = null;
        if (hasHelpToMoveToLeftSide) {
            helpButton = this.createHelpButton((Insets)insets);
        }
        if (helpButton != null || doNotAskCheckbox != null) {
            JPanel leftPanel = new JPanel(new BorderLayout());
            if (helpButton != null) {
                leftPanel.add((Component)helpButton, "West");
            }
            if (doNotAskCheckbox != null) {
                doNotAskCheckbox.setBorder((Border)JBUI.Borders.emptyRight((int)20));
                leftPanel.add((Component)doNotAskCheckbox, "Center");
            }
            panel.add((Component)leftPanel, "West");
        }
        panel.add((Component)lrButtonsPanel, "Center");
        if (this.getStyle() == DialogStyle.COMPACT) {
            Color color = UIManager.getColor("DialogWrapper.southPanelDivider");
            CustomLineBorder line = new CustomLineBorder(color != null ? color : OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            DialogWrapper.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return this.myCheckBoxDoNotShowDialog != null && this.myCheckBoxDoNotShowDialog.isVisible() ? this.myCheckBoxDoNotShowDialog : null;
    }

    @NotNull
    private JPanel createButtonsPanel(@NotNull List<JButton> buttons) {
        if (buttons == null) {
            DialogWrapper.$$$reportNull$$$0(19);
        }
        int hgap = SystemInfo.isMacOSLeopard ? (UIUtil.isUnderIntelliJLaF() ? 8 : 0) : 5;
        NonOpaquePanel buttonsPanel = new NonOpaquePanel((LayoutManager)((Object)new DialogWrapperButtonLayout(buttons.size(), hgap)));
        for (JButton button : buttons) {
            buttonsPanel.add(button);
        }
        NonOpaquePanel nonOpaquePanel = buttonsPanel;
        if (nonOpaquePanel == null) {
            DialogWrapper.$$$reportNull$$$0(20);
        }
        return nonOpaquePanel;
    }

    @Nullable
    protected JButton getButton(@NotNull Action action) {
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(21);
        }
        return this.myButtonMap.get(action);
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = action instanceof OptionAction && UISettings.getShadowInstance().getAllowMergeButtons() ? this.createJOptionsButton((OptionAction)action) : new JButton(action);
        if (SystemInfo.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        Pair<Integer, String> pair = DialogWrapper.extractMnemonic(button.getText());
        button.setText((String)pair.second);
        int mnemonic = (Integer)pair.first;
        Object value = action.getValue("MnemonicKey");
        if (value instanceof Integer) {
            mnemonic = (Integer)value;
        }
        button.setMnemonic(mnemonic);
        Object name = action.getValue("Name");
        if (mnemonic == 89 && "Yes".equals(name)) {
            this.myYesAction = action;
        } else if (mnemonic == 78 && "No".equals(name)) {
            this.myNoAction = action;
        }
        this.setMargin(button);
        if (action.getValue(DEFAULT_ACTION) != null && !this.myPeer.isHeadless()) {
            this.getRootPane().setDefaultButton(button);
        }
        if (action.getValue(FOCUSED_ACTION) != null) {
            this.myPreferredFocusedComponent = button;
        }
        return button;
    }

    @NotNull
    private JButton createJOptionsButton(@NotNull OptionAction action) {
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(22);
        }
        JBOptionButton optionButton = new JBOptionButton(action, action.getOptions());
        String tooltip = String.format("Show drop-down menu (%s)", KeymapUtil.getKeystrokeText(SHOW_OPTION_KEYSTROKE));
        optionButton.setOptionTooltipText(tooltip);
        optionButton.setOkToProcessDefaultMnemonics(false);
        JBOptionButton jBOptionButton = optionButton;
        if (jBOptionButton == null) {
            DialogWrapper.$$$reportNull$$$0(23);
        }
        return jBOptionButton;
    }

    @NotNull
    private static Pair<Integer, String> extractMnemonic(@Nullable String text) {
        if (text == null) {
            Pair pair = Pair.create((Object)0, null);
            if (pair == null) {
                DialogWrapper.$$$reportNull$$$0(24);
            }
            return pair;
        }
        int mnemonic = 0;
        StringBuilder plainText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int ch = text.charAt(i);
            if (ch == 95 || ch == 38) {
                if (++i >= text.length()) break;
                ch = text.charAt(i);
                if (ch != 95 && ch != 38) {
                    int vk = ch;
                    if (vk >= 97 && vk <= 122) {
                        vk -= 32;
                    }
                    mnemonic = vk;
                }
            }
            plainText.append((char)ch);
        }
        Pair pair = Pair.create((Object)mnemonic, (Object)plainText.toString());
        if (pair == null) {
            DialogWrapper.$$$reportNull$$$0(25);
        }
        return pair;
    }

    private void setMargin(@NotNull JButton button) {
        if (button == null) {
            DialogWrapper.$$$reportNull$$$0(26);
        }
        if (!SystemInfo.isMac) {
            if (this.myButtonMargins == null) {
                return;
            }
            button.setMargin(this.myButtonMargins);
        }
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            DialogWrapper.$$$reportNull$$$0(27);
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, parent, canBeParent);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(28);
        }
        return dialogWrapperPeer;
    }

    @Deprecated
    @NotNull
    protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapperPeer dialogWrapperPeer = this.createPeer(null, canBeParent, applicationModalIfPossible);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(29);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, IdeModalityType ideModalityType) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, owner, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(30);
        }
        return dialogWrapperPeer;
    }

    @Deprecated
    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, owner, canBeParent, applicationModalIfPossible ? IdeModalityType.IDE : IdeModalityType.PROJECT);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(31);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(32);
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(33);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(34);
        }
        return dialogWrapperPeer;
    }

    @Nullable
    protected JComponent createTitlePane() {
        return null;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected abstract JComponent createCenterPanel();

    public void toFront() {
        this.myPeer.toFront();
    }

    public void toBack() {
        this.myPeer.toBack();
    }

    protected boolean setAutoAdjustable(boolean autoAdjustable) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return false;
        }
        rootPane.putClientProperty(NO_AUTORESIZE, autoAdjustable ? null : Boolean.TRUE);
        return true;
    }

    public boolean isAutoAdjustable() {
        JRootPane rootPane = this.getRootPane();
        return rootPane == null || rootPane.getClientProperty(NO_AUTORESIZE) == null;
    }

    protected void dispose() {
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorTextAlarm.cancelAllRequests();
        this.myValidationAlarm.cancelAllRequests();
        this.myDisposed = true;
        for (JButton button : this.myButtonMap.values()) {
            button.setAction(null);
        }
        this.myButtonMap.clear();
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            DialogWrapper.unregisterKeyboardActions(rootPane);
            if (this.myActualSize != null && this.isAutoAdjustable()) {
                this.setSize(this.myActualSize.width, this.myActualSize.height);
            }
            this.myPeer.dispose();
        }
    }

    public static void cleanupRootPane(@Nullable JRootPane rootPane) {
        if (rootPane == null) {
            return;
        }
        RepaintManager.currentManager(rootPane).removeInvalidComponent(rootPane);
        DialogWrapper.unregisterKeyboardActions(rootPane);
        Container contentPane = rootPane.getContentPane();
        if (contentPane != null) {
            contentPane.removeAll();
        }
        Disposer.clearOwnFields((Object)rootPane, field -> {
            String clazz = field.getDeclaringClass().getName();
            if (!clazz.startsWith("java.") && !clazz.startsWith("javax.")) {
                return true;
            }
            String name = field.getName();
            return "clientProperties".equals(name);
        });
    }

    public static void unregisterKeyboardActions(@Nullable Component rootPane) {
        int[] flags = new int[]{0, 1, 2};
        for (JComponent eachComp : UIUtil.uiTraverser((Component)rootPane).traverse().filter(JComponent.class)) {
            ActionMap actionMap = eachComp.getActionMap();
            if (actionMap == null) continue;
            for (KeyStroke eachStroke : eachComp.getRegisteredKeyStrokes()) {
                boolean remove = true;
                for (int i : flags) {
                    Action action;
                    Object key = eachComp.getInputMap(i).get(eachStroke);
                    Action action2 = action = key == null ? null : actionMap.get(key);
                    if (!(action instanceof UIResource)) continue;
                    remove = false;
                }
                if (!remove) continue;
                eachComp.unregisterKeyboardAction(eachStroke);
            }
        }
    }

    public static void cleanupWindowListeners(@Nullable Window window) {
        if (window == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            for (WindowListener listener : window.getWindowListeners()) {
                if (!listener.getClass().getName().startsWith("com.intellij.")) continue;
                window.removeWindowListener(listener);
            }
        });
    }

    public void doCancelAction() {
        if (this.getCancelAction().isEnabled()) {
            this.close(1);
        }
    }

    private void processDoNotAskOnCancel() {
        if (this.myDoNotAsk != null && this.myDoNotAsk.shouldSaveOptionsOnCancel() && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), 1);
        }
    }

    public void doCancelAction(AWTEvent source) {
        this.recordAction("DialogCancelAction", source);
        this.doCancelAction();
    }

    public void clickDefaultButton() {
        JButton button = this.getRootPane().getDefaultButton();
        if (button != null) {
            button.doClick();
        }
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.close(0);
        }
    }

    protected void processDoNotAskOnOk(int exitCode) {
        if (this.myDoNotAsk != null && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), exitCode);
        }
    }

    public boolean shouldCloseOnCross() {
        return this.myCrossClosesWindow;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        Action helpAction = this.getHelpAction();
        if (helpAction == this.myHelpAction && this.getHelpId() == null) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = this.getOKAction();
            actionArray = actionArray2;
            actionArray2[1] = this.getCancelAction();
        } else {
            Action[] actionArray3 = new Action[3];
            actionArray3[0] = this.getOKAction();
            actionArray3[1] = this.getCancelAction();
            actionArray = actionArray3;
            actionArray3[2] = helpAction;
        }
        if (actionArray == null) {
            DialogWrapper.$$$reportNull$$$0(35);
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            DialogWrapper.$$$reportNull$$$0(36);
        }
        return actionArray;
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myOKAction;
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(37);
        }
        return action;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action = this.myCancelAction;
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(38);
        }
        return action;
    }

    @NotNull
    protected Action getHelpAction() {
        Action action = this.myHelpAction;
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(39);
        }
        return action;
    }

    protected boolean isProgressDialog() {
        return false;
    }

    public final boolean isModalProgress() {
        return this.isProgressDialog();
    }

    public Container getContentPane() {
        return this.myPeer.getContentPane();
    }

    public void validate() {
        this.myPeer.validate();
    }

    public void repaint() {
        this.myPeer.repaint();
    }

    @Nullable
    @NonNls
    protected String getDimensionServiceKey() {
        return null;
    }

    @Nullable
    public final String getDimensionKey() {
        return this.getDimensionServiceKey();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return SystemInfo.isMac ? this.myPreferredFocusedComponent : null;
    }

    public final float getHorizontalStretch() {
        return this.myHorizontalStretch;
    }

    public final float getVerticalStretch() {
        return this.myVerticalStretch;
    }

    protected final void setHorizontalStretch(float hStretch) {
        this.myHorizontalStretch = hStretch;
    }

    protected final void setVerticalStretch(float vStretch) {
        this.myVerticalStretch = vStretch;
    }

    public Window getOwner() {
        return this.myPeer.getOwner();
    }

    public Window getWindow() {
        return this.myPeer.getWindow();
    }

    public JComponent getContentPanel() {
        return (JComponent)this.myPeer.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.myPeer.getRootPane();
    }

    public Dimension getSize() {
        return this.myPeer.getSize();
    }

    public String getTitle() {
        return this.myPeer.getTitle();
    }

    protected void init() {
        JComponent c;
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorText = new ErrorText(this.getErrorTextAlignment());
        this.myErrorText.setVisible(false);
        final ComponentAdapter resizeListener = new ComponentAdapter(){
            private int myHeight;

            @Override
            public void componentResized(ComponentEvent event) {
                int height;
                int n = height = !DialogWrapper.this.myErrorText.isVisible() ? 0 : event.getComponent().getHeight();
                if (height != this.myHeight) {
                    this.myHeight = height;
                    DialogWrapper.this.myResizeInProgress = true;
                    DialogWrapper.this.myErrorText.setMinimumSize(new Dimension(0, height));
                    JRootPane root = DialogWrapper.this.myPeer.getRootPane();
                    if (root != null) {
                        root.validate();
                    }
                    if (DialogWrapper.this.myActualSize != null && !DialogWrapper.this.shouldAddErrorNearButtons()) {
                        DialogWrapper.this.myPeer.setSize(((DialogWrapper)DialogWrapper.this).myActualSize.width, ((DialogWrapper)DialogWrapper.this).myActualSize.height + height);
                    }
                    DialogWrapper.this.myErrorText.revalidate();
                    DialogWrapper.this.myResizeInProgress = false;
                }
            }
        };
        this.myErrorText.myLabel.addComponentListener(resizeListener);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DialogWrapper.this.myErrorText.myLabel.removeComponentListener(resizeListener);
            }
        });
        JPanel root = new JPanel(this.createRootLayout());
        this.myPeer.setContentPane(root);
        CustomShortcutSet sc = new CustomShortcutSet(SHOW_OPTION_KEYSTROKE);
        DumbAwareAction toggleShowOptions = DumbAwareAction.create((Consumer<AnActionEvent>)((Consumer)e -> this.expandNextOptionButton()));
        toggleShowOptions.registerCustomShortcutSet(sc, root, this.myDisposable);
        JComponent titlePane = this.createTitlePane();
        if (titlePane != null) {
            JPanel northSection = new JPanel(new BorderLayout());
            root.add((Component)northSection, "North");
            northSection.add((Component)titlePane, "Center");
        }
        JPanel centerSection = new JPanel(new BorderLayout());
        root.add((Component)centerSection, "Center");
        root.setBorder(this.createContentPaneBorder());
        JComponent n = this.createNorthPanel();
        if (n != null) {
            centerSection.add((Component)n, "North");
        }
        if ((c = this.createCenterPanel()) != null) {
            centerSection.add((Component)c, "Center");
        }
        JPanel southSection = new JPanel(new BorderLayout());
        root.add((Component)southSection, "South");
        southSection.add((Component)this.myErrorText, "Center");
        JComponent south = this.createSouthPanel();
        if (south != null) {
            southSection.add((Component)south, "South");
        }
        MnemonicHelper.init(root);
        if (!this.postponeValidation()) {
            this.startTrackingValidation();
        }
        if (SystemInfo.isWindows) {
            DialogWrapper.installEnterHook(root, this.myDisposable);
        }
        this.myErrorTextAlarm.setActivationComponent(root);
    }

    protected int getErrorTextAlignment() {
        return 10;
    }

    @NotNull
    LayoutManager createRootLayout() {
        BorderLayout borderLayout = new BorderLayout();
        if (borderLayout == null) {
            DialogWrapper.$$$reportNull$$$0(40);
        }
        return borderLayout;
    }

    private static void installEnterHook(JComponent root, Disposable disposable) {
        new DumbAwareAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (owner instanceof JButton && owner.isEnabled()) {
                    ((JButton)owner).doClick();
                }
            }

            @Override
            public void update(AnActionEvent e) {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                e.getPresentation().setEnabled(owner instanceof JButton && owner.isEnabled());
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("ENTER"), root, disposable);
    }

    private void expandNextOptionButton() {
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).closePopup();
        }
        this.myCurrentOptionsButtonIndex = DialogWrapper.getEnabledIndexCyclic(this.myOptionsButtons, this.myCurrentOptionsButtonIndex, true).orElse(-1);
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).showPopup(null, true);
        }
    }

    void startTrackingValidation() {
        SwingUtilities.invokeLater(() -> {
            if (!this.myValidationStarted && !this.myDisposed) {
                this.myValidationStarted = true;
                this.initValidation();
            }
        });
    }

    protected final void initValidation() {
        this.myValidationAlarm.cancelAllRequests();
        Runnable validateRequest = () -> {
            if (this.myDisposed) {
                return;
            }
            List<ValidationInfo> result2 = this.doValidateAll();
            if (!result2.isEmpty()) {
                this.installErrorPainter();
            }
            this.myErrorPainter.setValidationInfo(result2);
            this.updateErrorInfo(result2);
            if (!this.myDisposed) {
                this.initValidation();
            }
        };
        if (this.getValidationThreadToUse() == Alarm.ThreadToUse.SWING_THREAD) {
            JRootPane rootPane = this.getRootPane();
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay, ApplicationManager.getApplication() == null ? null : (rootPane == null ? ModalityState.current() : ModalityState.stateForComponent(rootPane)));
        } else {
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay);
        }
    }

    protected boolean isNorthStrictedToPreferredSize() {
        return true;
    }

    protected boolean isCenterStrictedToPreferredSize() {
        return false;
    }

    protected boolean isSouthStrictedToPreferredSize() {
        return true;
    }

    @NotNull
    protected JComponent createContentPane() {
        JPanel jPanel = new JPanel();
        if (jPanel == null) {
            DialogWrapper.$$$reportNull$$$0(41);
        }
        return jPanel;
    }

    public void pack() {
        this.myPeer.pack();
    }

    public Dimension getPreferredSize() {
        return this.myPeer.getPreferredSize();
    }

    protected final void setButtonsAlignment(int alignment) {
        if (0 != alignment && 4 != alignment) {
            throw new IllegalArgumentException("unknown alignment: " + alignment);
        }
        this.myButtonAlignment = alignment;
    }

    public final void setButtonsMargin(@Nullable Insets insets) {
        this.myButtonMargins = insets;
    }

    public final void setCrossClosesWindow(boolean crossClosesWindow) {
        this.myCrossClosesWindow = crossClosesWindow;
    }

    protected final void setCancelButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myCancelAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setCancelButtonText(String text) {
        this.myCancelAction.putValue("Name", text);
    }

    public void setModal(boolean modal) {
        this.myPeer.setModal(modal);
    }

    public boolean isModal() {
        return this.myPeer.isModal();
    }

    public boolean isOKActionEnabled() {
        return this.myOKAction.isEnabled();
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.myOKAction.setEnabled(isEnabled);
    }

    protected final void setOKButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myOKAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setOKButtonText(String text) {
        this.myOKAction.putValue("Name", text);
    }

    protected final void setOKButtonMnemonic(int c) {
        this.myOKAction.putValue("MnemonicKey", c);
    }

    @Nullable
    @NonNls
    protected String getHelpId() {
        return null;
    }

    protected void doHelpAction() {
        if (this.myHelpAction.isEnabled()) {
            String helpId = this.getHelpId();
            if (helpId != null) {
                HelpManager.getInstance().invokeHelp(helpId);
            } else {
                Messages.showMessageDialog(this.getContentPane(), UIBundle.message((String)"there.is.no.help.for.this.dialog.error.message", (Object[])new Object[0]), UIBundle.message((String)"no.help.available.dialog.title", (Object[])new Object[0]), Messages.getInformationIcon());
            }
        }
    }

    public boolean isOK() {
        return this.getExitCode() == 0;
    }

    public boolean isVisible() {
        return this.myPeer.isVisible();
    }

    public boolean isShowing() {
        return this.myPeer.isShowing();
    }

    public void setSize(int width, int height) {
        this.myPeer.setSize(width, height);
    }

    public void setTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.myPeer.setTitle(title);
    }

    public void isResizable() {
        this.myPeer.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myPeer.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myPeer.getLocation();
        if (point == null) {
            DialogWrapper.$$$reportNull$$$0(42);
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            DialogWrapper.$$$reportNull$$$0(43);
        }
        this.myPeer.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myPeer.setLocation(x, y);
    }

    public void centerRelativeToParent() {
        this.myPeer.centerInParent();
    }

    public void show() {
        this.invokeShow();
    }

    public boolean showAndGet() {
        if (!this.isModal()) {
            throw new IllegalStateException("The showAndGet() method is for modal dialogs only");
        }
        this.show();
        return this.isOK();
    }

    @NotNull
    public AsyncResult<Boolean> showAndGetOk() {
        if (this.isModal()) {
            throw new IllegalStateException("The showAndGetOk() method is for modeless dialogs only");
        }
        AsyncResult<Boolean> asyncResult = this.invokeShow();
        if (asyncResult == null) {
            DialogWrapper.$$$reportNull$$$0(44);
        }
        return asyncResult;
    }

    @NotNull
    private AsyncResult<Boolean> invokeShow() {
        final AsyncResult<Boolean> result2 = new AsyncResult<Boolean>();
        DialogWrapper.ensureEventDispatchThread();
        this.registerKeyboardShortcuts();
        Disposable uiParent = Disposer.get((String)"ui");
        if (uiParent != null) {
            Disposer.register((Disposable)uiParent, (Disposable)this.myDisposable);
        }
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                result2.setDone(DialogWrapper.this.isOK());
            }
        });
        this.myPeer.show();
        AsyncResult<Boolean> asyncResult = result2;
        if (asyncResult == null) {
            DialogWrapper.$$$reportNull$$$0(45);
        }
        return asyncResult;
    }

    @Nullable
    public Point getInitialLocation() {
        return this.myInitialLocationCallback == null ? null : (Point)this.myInitialLocationCallback.compute();
    }

    public void setInitialLocationCallback(@NotNull Computable<Point> callback) {
        if (callback == null) {
            DialogWrapper.$$$reportNull$$$0(46);
        }
        this.myInitialLocationCallback = callback;
    }

    private void registerKeyboardShortcuts() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return;
        }
        ActionListener cancelKeyboardAction = this.createCancelAction();
        if (cancelKeyboardAction != null) {
            rootPane.registerKeyboardAction(cancelKeyboardAction, KeyStroke.getKeyStroke(27, 0), 2);
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), cancelKeyboardAction, CommonShortcuts.getCloseActiveWindow());
        }
        if (ApplicationInfo.contextHelpAvailable() && !this.isProgressDialog()) {
            ActionListener helpAction = e -> this.doHelpAction();
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), helpAction, CommonShortcuts.getContextHelp());
            rootPane.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        }
        rootPane.registerKeyboardAction(e -> this.focusButton(false), KeyStroke.getKeyStroke(37, 0), 1);
        rootPane.registerKeyboardAction(e -> this.focusButton(true), KeyStroke.getKeyStroke(39, 0), 1);
        if (this.myYesAction != null) {
            rootPane.registerKeyboardAction(this.myYesAction, KeyStroke.getKeyStroke(89, 0), 2);
        }
        if (this.myNoAction != null) {
            rootPane.registerKeyboardAction(this.myNoAction, KeyStroke.getKeyStroke(78, 0), 2);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PopupUtil.handleEscKeyEvent()) {
                    DialogWrapper.this.doCancelAction(e);
                }
            }
        };
    }

    private void focusButton(boolean next) {
        ArrayList buttons = ContainerUtil.newArrayList(this.myButtonMap.values());
        int focusedIndex = ContainerUtil.indexOf((List)buttons, Component::hasFocus);
        if (focusedIndex >= 0) {
            DialogWrapper.getEnabledIndexCyclic(buttons, focusedIndex, next).ifPresent(i -> ((JButton)buttons.get(i)).requestFocus());
        }
    }

    @NotNull
    private static OptionalInt getEnabledIndexCyclic(@NotNull List<? extends Component> components, int currentIndex, boolean next) {
        if (components == null) {
            DialogWrapper.$$$reportNull$$$0(47);
        }
        assert (-1 <= currentIndex && currentIndex <= components.size());
        int start = !next && currentIndex == -1 ? components.size() : currentIndex;
        OptionalInt optionalInt = IntStream.range(0, components.size()).map(i -> {
            if (components == null) {
                DialogWrapper.$$$reportNull$$$0(56);
            }
            return (next ? start + i + 1 : start + components.size() - i - 1) % components.size();
        }).filter(i -> {
            if (components == null) {
                DialogWrapper.$$$reportNull$$$0(55);
            }
            return ((Component)components.get(i)).isEnabled();
        }).findFirst();
        if (optionalInt == null) {
            DialogWrapper.$$$reportNull$$$0(48);
        }
        return optionalInt;
    }

    public long getTypeAheadTimeoutMs() {
        return 0L;
    }

    public boolean isToDispatchTypeAhead() {
        return this.isOK();
    }

    public static boolean isMultipleModalDialogs() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null) {
            DialogWrapper wrapper = DialogWrapper.findInstance(c);
            return wrapper != null && wrapper.getPeer().getCurrentModalEntities().length > 1;
        }
        return false;
    }

    private void recordAction(String name) {
        this.recordAction(name, EventQueue.getCurrentEvent());
    }

    private void recordAction(String name, AWTEvent event) {
        if (event instanceof KeyEvent) {
            String shortcut = KeymapUtil.getKeystrokeText(KeyStroke.getKeyStrokeForEvent((KeyEvent)event));
            ActionsCollector.getInstance().record(name + " " + shortcut);
        }
    }

    protected void setErrorText(@Nullable String text) {
        this.setErrorText(text, null);
    }

    protected void setErrorText(@Nullable String text, @Nullable JComponent component) {
        this.setErrorInfoAll(text == null ? Collections.EMPTY_LIST : Collections.singletonList(new ValidationInfo(text, component)));
    }

    protected void setErrorInfoAll(@NotNull List<ValidationInfo> info) {
        if (info == null) {
            DialogWrapper.$$$reportNull$$$0(49);
        }
        if (this.myInfo.equals(info)) {
            return;
        }
        this.myErrorTextAlarm.cancelAllRequests();
        SwingUtilities.invokeLater(() -> {
            if (this.myErrorText != null) {
                this.myErrorText.clearError();
            }
        });
        List corrected = this.myInfo.stream().filter(vi -> {
            if (info == null) {
                DialogWrapper.$$$reportNull$$$0(54);
            }
            return !info.contains(vi);
        }).collect(Collectors.toList());
        if (Registry.is((String)"ide.inplace.errors.outline")) {
            corrected.stream().filter(vi -> vi.component != null && vi.component.getBorder() instanceof ErrorBorderCapable).forEach(vi -> vi.component.putClientProperty("JComponent.outline", null));
        }
        if (Registry.is((String)"ide.inplace.errors.balloon")) {
            corrected.stream().filter(vi -> vi.component != null).forEach(vi -> {
                Component fc;
                vi.component.putClientProperty("JComponent.error.balloon.builder", null);
                Balloon balloon = (Balloon)vi.component.getClientProperty("JComponent.error.balloon");
                if (balloon != null && !balloon.isDisposed()) {
                    balloon.hide();
                }
                if ((fc = this.getFocusable(vi.component)) != null) {
                    for (FocusListener fl : fc.getFocusListeners()) {
                        if (!(fl instanceof ErrorFocusListener)) continue;
                        fc.removeFocusListener(fl);
                    }
                }
            });
        }
        this.myInfo = info;
        if (Registry.is((String)"ide.inplace.errors.outline")) {
            this.myInfo.stream().filter(vi -> vi.component != null && vi.component.getBorder() instanceof ErrorBorderCapable).forEach(vi -> vi.component.putClientProperty("JComponent.outline", "error"));
        }
        if (Registry.is((String)"ide.inplace.errors.balloon") && !this.myInfo.isEmpty()) {
            for (ValidationInfo vi2 : this.myInfo) {
                Component fc = this.getFocusable(vi2.component);
                if (fc != null && fc.isFocusable()) {
                    if (vi2.component.getClientProperty("JComponent.error.balloon.builder") != null) continue;
                    JLabel label = new JLabel();
                    label.setHorizontalAlignment(10);
                    this.setErrorTipText(vi2.component, label, vi2.message);
                    BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder(label).setDisposable(this.getDisposable()).setBorderInsets(UIManager.getInsets("Balloon.error.textInsets")).setPointerSize((Dimension)new JBDimension(17, 6)).setCornerToPointerDistance(JBUI.scale((int)30)).setHideOnKeyOutside(false).setHideOnClickOutside(false).setHideOnAction(false).setBorderColor(BALLOON_ERROR_BORDER).setFillColor(BALLOON_ERROR_BACKGROUND).setHideOnFrameResize(false).setRequestFocus(false).setAnimationCycle(100).setShadow(true);
                    vi2.component.putClientProperty("JComponent.error.balloon.builder", balloonBuilder);
                    ErrorFocusListener fl = new ErrorFocusListener(label, vi2.message, vi2.component);
                    if (fc.hasFocus()) {
                        fl.showErrorTip();
                    }
                    fc.addFocusListener(fl);
                    Disposer.register((Disposable)this.getDisposable(), () -> fc.removeFocusListener(fl));
                    continue;
                }
                SwingUtilities.invokeLater(() -> this.myErrorText.appendError(vi.message));
            }
        } else if (!this.myInfo.isEmpty()) {
            this.myErrorTextAlarm.addRequest(() -> {
                for (ValidationInfo vi : this.myInfo) {
                    this.myErrorText.appendError(vi.message);
                }
            }, 300, (ModalityState)null);
        }
    }

    private void setErrorTipText(JComponent component, JLabel label, String text) {
        Insets insets = UIManager.getInsets("Balloon.error.textInsets");
        int oneLineWidth = SwingUtilities2.stringWidth(label, label.getFontMetrics(label.getFont()), text);
        int textWidth = this.getRootPane().getWidth() - component.getX() - insets.left - insets.right - JBUI.scale((int)30);
        if (textWidth < JBUI.scale((int)90)) {
            textWidth = JBUI.scale((int)90);
        }
        if (textWidth > oneLineWidth) {
            textWidth = oneLineWidth;
        }
        String htmlText = String.format("<html><div width=%d>%s</div></html>", textWidth, text);
        label.setText(htmlText);
    }

    private Component getFocusable(Component source) {
        return source instanceof JComboBox && !((JComboBox)source).isEditable() ? source : (Component)((JBTreeTraverser)UIUtil.uiTraverser((Component)source).filter(c -> c instanceof JTextComponent && c.isFocusable())).toList().stream().findFirst().orElse(null);
    }

    private void updateSize() {
        if (this.myActualSize == null && !this.myErrorText.isVisible()) {
            this.myActualSize = this.getSize();
        }
    }

    @Nullable
    public static DialogWrapper findInstance(Component c) {
        while (c != null) {
            if (c instanceof DialogWrapperDialog) {
                return ((DialogWrapperDialog)((Object)c)).getDialogWrapper();
            }
            c = c.getParent();
        }
        return null;
    }

    @Nullable
    public static DialogWrapper findInstanceFromFocus() {
        return DialogWrapper.findInstance(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
    }

    private void resizeWithAnimation(final @NotNull Dimension size) {
        if (size == null) {
            DialogWrapper.$$$reportNull$$$0(50);
        }
        this.myResizeInProgress = true;
        if (!Registry.is((String)"enable.animation.on.dialogs")) {
            this.setSize(size.width, size.height);
            this.myResizeInProgress = false;
            return;
        }
        new Thread("DialogWrapper resizer"){
            int time;
            int steps;
            {
                super(x0);
                this.time = 200;
                this.steps = 7;
            }

            @Override
            public void run() {
                int step = 0;
                Dimension cur = DialogWrapper.this.getSize();
                int h = (size.height - cur.height) / this.steps;
                int w = (size.width - cur.width) / this.steps;
                while (step++ < this.steps) {
                    DialogWrapper.this.setSize(cur.width + w * step, cur.height + h * step);
                    TimeoutUtil.sleep((long)(this.time / this.steps));
                }
                DialogWrapper.this.setSize(size.width, size.height);
                if (DialogWrapper.this.myErrorText.shouldBeVisible()) {
                    DialogWrapper.this.myErrorText.setVisible(true);
                }
                DialogWrapper.this.myResizeInProgress = false;
            }
        }.start();
    }

    @NotNull
    public final DialogWrapperPeer getPeer() {
        DialogWrapperPeer dialogWrapperPeer = this.myPeer;
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(51);
        }
        return dialogWrapperPeer;
    }

    private static void ensureEventDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("The DialogWrapper can only be used in event dispatch thread. Current thread: " + Thread.currentThread());
        }
    }

    @NotNull
    public final Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            DialogWrapper.$$$reportNull$$$0(52);
        }
        return disposable;
    }

    @NotNull
    private ErrorPaintingType getErrorPaintingType() {
        ErrorPaintingType errorPaintingType = ErrorPaintingType.SIGN;
        if (errorPaintingType == null) {
            DialogWrapper.$$$reportNull$$$0(53);
        }
        return errorPaintingType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/DialogWrapper";
                break;
            }
            case 1: 
            case 2: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 3: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 49: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftSideButtons";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightSideButtons";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 47: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/DialogWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationThreadToUse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelpButton";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenOptionsActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtons";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonsPanel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createJOptionsButton";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMnemonic";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelAction";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpAction";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootLayout";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentPane";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndGetOk";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeShow";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIndexCyclic";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeer";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorPaintingType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addKeyListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "flattenOptionsActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSouthPanel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createButtonsPanel";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getButton";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createJOptionsButton";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setMargin";
                break;
            }
            case 27: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createPeer";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setInitialLocationCallback";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledIndexCyclic";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setErrorInfoAll";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resizeWithAnimation";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setErrorInfoAll$14";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEnabledIndexCyclic$12";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEnabledIndexCyclic$11";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateErrorInfo$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 43: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DialogStyle {
        NO_STYLE,
        COMPACT;

    }

    private static enum ErrorPaintingType {
        DOT,
        SIGN,
        LINE;

    }

    private class ErrorFocusListener
    implements FocusListener {
        private final JLabel label;
        private final String text;
        private final JComponent component;

        private ErrorFocusListener(JLabel label, String text, JComponent component) {
            this.label = label;
            this.text = text;
            this.component = component;
        }

        @Override
        public void focusGained(FocusEvent e) {
            Balloon b = (Balloon)this.component.getClientProperty("JComponent.error.balloon");
            if (b == null || b.isDisposed()) {
                this.showErrorTip();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Balloon b = (Balloon)this.component.getClientProperty("JComponent.error.balloon");
            if (b != null && !b.isDisposed()) {
                b.hide();
            }
        }

        private void showErrorTip() {
            int top;
            BalloonBuilder balloonBuilder = (BalloonBuilder)this.component.getClientProperty("JComponent.error.balloon.builder");
            if (balloonBuilder == null) {
                return;
            }
            final Balloon balloon = balloonBuilder.createBalloon();
            final ComponentAdapter rl = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!balloon.isDisposed()) {
                        DialogWrapper.this.setErrorTipText(ErrorFocusListener.this.component, ErrorFocusListener.this.label, ErrorFocusListener.this.text);
                        balloon.revalidate();
                    }
                }
            };
            balloon.addListener(new JBPopupListener.Adapter(){

                @Override
                public void onClosed(LightweightWindowEvent event) {
                    JRootPane rootPane = DialogWrapper.this.getRootPane();
                    if (rootPane != null) {
                        rootPane.removeComponentListener(rl);
                    }
                    if (ErrorFocusListener.this.component.getClientProperty("JComponent.error.balloon") == event.asBalloon()) {
                        ErrorFocusListener.this.component.putClientProperty("JComponent.error.balloon", null);
                    }
                }
            });
            DialogWrapper.this.getRootPane().addComponentListener(rl);
            Point componentPos = SwingUtilities.convertPoint(this.component, 0, 0, DialogWrapper.this.getRootPane().getLayeredPane());
            Dimension bSize = balloon.getPreferredSize();
            Insets cInsets = this.component.getInsets();
            int n = top = cInsets != null ? cInsets.top : 0;
            if (componentPos.y >= bSize.height + top) {
                balloon.show(new ErrorTipTracker(this.component, 0), Balloon.Position.above);
            } else {
                balloon.show(new ErrorTipTracker(this.component, this.component.getHeight()), Balloon.Position.below);
            }
            this.component.putClientProperty("JComponent.error.balloon", balloon);
        }
    }

    private static class ErrorTipTracker
    extends PositionTracker<Balloon> {
        private final int y;

        private ErrorTipTracker(JComponent component, int y) {
            super(component);
            this.y = y;
        }

        @Override
        public RelativePoint recalculateLocation(Balloon balloon) {
            int width = this.getComponent().getWidth();
            int delta = width < JBUI.scale((int)120) ? width / 2 : JBUI.scale((int)60);
            return new RelativePoint(this.getComponent(), new Point(delta, this.y));
        }
    }

    private class ErrorPainter
    extends AbstractPainter {
        private List<ValidationInfo> info;

        private ErrorPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executePaint(Component component, Graphics2D g) {
            block8: for (ValidationInfo i : this.info) {
                if (i.component == null || Registry.is((String)"ide.inplace.errors.outline")) continue;
                int w = i.component.getWidth();
                int h = i.component.getHeight();
                switch (DialogWrapper.this.getErrorPaintingType()) {
                    case DOT: {
                        Point p = SwingUtilities.convertPoint(i.component, 2, h / 2, component);
                        AllIcons.Ide.ErrorPoint.paintIcon(component, g, p.x, p.y);
                        break;
                    }
                    case SIGN: {
                        Point p = SwingUtilities.convertPoint(i.component, w, 0, component);
                        AllIcons.General.Error.paintIcon(component, g, p.x - 8, p.y - 8);
                        break;
                    }
                    case LINE: {
                        Point p = SwingUtilities.convertPoint(i.component, 0, h, component);
                        Graphics g2 = g.create();
                        try {
                            g2.setColor(new Color(255, 0, 0, 100));
                            g2.fillRoundRect(p.x, p.y - 2, w, 4, 2, 2);
                            continue block8;
                        }
                        finally {
                            g2.dispose();
                            continue block8;
                        }
                    }
                }
            }
        }

        @Override
        public boolean needsRepaint() {
            return true;
        }

        private void setValidationInfo(@NotNull List<ValidationInfo> info) {
            if (info == null) {
                ErrorPainter.$$$reportNull$$$0(0);
            }
            this.info = info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/ui/DialogWrapper$ErrorPainter", "setValidationInfo"));
        }
    }

    public static interface DoNotAskOption {
        public boolean isToBeShown();

        public void setToBeShown(boolean var1, int var2);

        public boolean canBeHidden();

        public boolean shouldSaveOptionsOnCancel();

        @NotNull
        public String getDoNotShowMessage();

        public static abstract class Adapter
        implements DoNotAskOption {
            public abstract void rememberChoice(boolean var1, int var2);

            public boolean isSelectedByDefault() {
                return false;
            }

            @Override
            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    Adapter.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public final boolean isToBeShown() {
                return !this.isSelectedByDefault();
            }

            @Override
            public final void setToBeShown(boolean toBeShown, int exitCode) {
                this.rememberChoice(!toBeShown, exitCode);
            }

            @Override
            public final boolean canBeHidden() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$DoNotAskOption$Adapter", "getDoNotShowMessage"));
            }
        }
    }

    private class ErrorText
    extends JPanel {
        private final JLabel myLabel = new JLabel();
        private List<String> errors = new ArrayList<String>();

        private ErrorText(int horizontalAlignment) {
            this.setLayout(new BorderLayout());
            this.myLabel.setBorder((Border)JBUI.Borders.empty((int)16, (int)13));
            this.myLabel.setHorizontalAlignment(horizontalAlignment);
            JBScrollPane pane = new JBScrollPane(this.myLabel, 21, 31);
            pane.setBorder((Border)JBUI.Borders.empty());
            pane.setBackground(null);
            pane.getViewport().setBackground(null);
            pane.setOpaque(false);
            this.add((Component)pane, "Center");
        }

        private void clearError() {
            this.errors.clear();
            this.myLabel.setBounds(0, 0, 0, 0);
            this.myLabel.setText("");
            this.setVisible(false);
            DialogWrapper.this.updateSize();
        }

        private void appendError(String text) {
            this.errors.add(text);
            this.myLabel.setBounds(0, 0, 0, 0);
            StringBuilder sb = new StringBuilder("<html><font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>");
            this.errors.forEach(error -> sb.append("<left>").append((String)error).append("</left><br/>"));
            sb.append("</font></html>");
            this.myLabel.setText(sb.toString());
            this.setVisible(true);
            DialogWrapper.this.updateSize();
        }

        private boolean shouldBeVisible() {
            return !this.errors.isEmpty();
        }

        private boolean isTextSet(@NotNull List<ValidationInfo> info) {
            if (info == null) {
                ErrorText.$$$reportNull$$$0(0);
            }
            if (info.isEmpty()) {
                return this.errors.isEmpty();
            }
            if (this.errors.size() == info.size()) {
                return this.errors.equals(info.stream().map(i -> i.message).collect(Collectors.toList()));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/ui/DialogWrapper$ErrorText", "isTextSet"));
        }
    }

    private class HelpAction
    extends AbstractAction {
        private HelpAction() {
            this.putValue("Name", CommonBundle.getHelpButtonText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogWrapper.this.doHelpAction();
        }
    }

    protected class DialogWrapperExitAction
    extends DialogWrapperAction {
        protected final int myExitCode;

        public DialogWrapperExitAction(String name, int exitCode) {
            super(name);
            this.myExitCode = exitCode;
        }

        @Override
        protected void doAction(ActionEvent e) {
            if (this.isEnabled()) {
                DialogWrapper.this.close(this.myExitCode);
            }
        }
    }

    protected class CancelAction
    extends DialogWrapperAction {
        private CancelAction() {
            super(CommonBundle.getCancelButtonText());
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.doCancelAction();
        }
    }

    protected class OkAction
    extends DialogWrapperAction {
        protected OkAction() {
            super(CommonBundle.getOkButtonText());
            this.putValue(DialogWrapper.DEFAULT_ACTION, Boolean.TRUE);
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.recordAction("DialogOkAction");
            List<ValidationInfo> infoList = DialogWrapper.this.doValidateAll();
            if (!infoList.isEmpty()) {
                ValidationInfo info = infoList.get(0);
                if (info.component != null && info.component.isVisible()) {
                    IdeFocusManager.getInstance(null).requestFocus(info.component, true);
                }
                if (!Registry.is((String)"ide.inplace.errors.balloon")) {
                    DialogEarthquakeShaker.shake(DialogWrapper.this.getPeer().getWindow());
                }
                DialogWrapper.this.startTrackingValidation();
                return;
            }
            DialogWrapper.this.doOKAction();
        }
    }

    protected abstract class DialogWrapperAction
    extends AbstractAction {
        protected DialogWrapperAction(String name) {
            if (name == null) {
                DialogWrapperAction.$$$reportNull$$$0(0);
            }
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogWrapper.this.myClosed) {
                return;
            }
            if (DialogWrapper.this.myPerformAction) {
                return;
            }
            try {
                DialogWrapper.this.myPerformAction = true;
                this.doAction(e);
            }
            finally {
                DialogWrapper.this.myPerformAction = false;
            }
        }

        protected abstract void doAction(ActionEvent var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/ui/DialogWrapper$DialogWrapperAction", "<init>"));
        }
    }

    public static enum IdeModalityType {
        IDE,
        PROJECT,
        MODELESS;


        @NotNull
        public Dialog.ModalityType toAwtModality() {
            switch (this) {
                case IDE: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.APPLICATION_MODAL;
                    if (modalityType == null) {
                        IdeModalityType.$$$reportNull$$$0(0);
                    }
                    return modalityType;
                }
                case PROJECT: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.DOCUMENT_MODAL;
                    if (modalityType == null) {
                        IdeModalityType.$$$reportNull$$$0(1);
                    }
                    return modalityType;
                }
                case MODELESS: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.MODELESS;
                    if (modalityType == null) {
                        IdeModalityType.$$$reportNull$$$0(2);
                    }
                    return modalityType;
                }
            }
            throw new IllegalStateException(this.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$IdeModalityType", "toAwtModality"));
        }
    }
}

