/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanel;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.TextComponent;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class ComponentPanelBuilder
implements GridBagPanelBuilder {
    private final JComponent myComponent;
    private String myLabelText;
    private boolean myLabelOnTop;
    private String myComment;
    private boolean myCommentBelow = true;
    private String myHTDescription;
    private String myHTLinkText;
    private Runnable myHTAction;
    private boolean valid = true;

    public ComponentPanelBuilder(JComponent component) {
        this.myComponent = component;
    }

    public ComponentPanelBuilder withLabel(@NotNull String labelText) {
        if (labelText == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(0);
        }
        this.myLabelText = labelText;
        return this;
    }

    public ComponentPanelBuilder moveLabelOnTop() {
        this.myLabelOnTop = true;
        return this;
    }

    public ComponentPanelBuilder withComment(@NotNull String comment) {
        if (comment == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(1);
        }
        this.myComment = comment;
        this.valid = StringUtil.isNotEmpty((String)comment) && StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder moveCommentRight() {
        this.myCommentBelow = false;
        return this;
    }

    public ComponentPanelBuilder withTooltip(@NotNull String description) {
        if (description == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(2);
        }
        this.myHTDescription = description;
        this.valid = StringUtil.isNotEmpty((String)description) && StringUtil.isEmpty((String)this.myComment);
        return this;
    }

    public ComponentPanelBuilder withTooltipLink(@NotNull String linkText, @NotNull Runnable action) {
        if (linkText == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(3);
        }
        if (action == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(4);
        }
        this.myHTLinkText = linkText;
        this.myHTAction = action;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel, gc);
        JPanel jPanel = panel;
        if (jPanel == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public boolean constrainsValid() {
        return this.valid;
    }

    @Override
    public int gridWidth() {
        return 2;
    }

    @Override
    public void addToPanel(JPanel panel, GridBagConstraints gc) {
        if (this.constrainsValid()) {
            new ComponentPanelImpl().addToPanel(panel, gc);
        }
    }

    private int getCommentOffset() {
        boolean isMacDefault = UIUtil.isUnderDefaultMacTheme();
        if (this.myComponent instanceof JRadioButton || this.myComponent instanceof JCheckBox) {
            return isMacDefault ? 8 : 13;
        }
        if (this.myComponent instanceof JTextField || this.myComponent instanceof TextComponent || this.myComponent instanceof JComboBox || this.myComponent instanceof ComponentWithBrowseButton) {
            return isMacDefault ? 13 : 14;
        }
        return 14;
    }

    private Insets getCommentInsets() {
        boolean isMacDefault = UIUtil.isUnderDefaultMacTheme();
        boolean isWin10 = UIUtil.isUnderWin10LookAndFeel();
        int top = 8;
        int left = 2;
        int bottom = 0;
        if (this.myComponent instanceof JRadioButton || this.myComponent instanceof JCheckBox) {
            top = 0;
            int n = isMacDefault ? 27 : (left = isWin10 ? 17 : 24);
            bottom = isWin10 ? 10 : (isMacDefault ? 8 : 9);
        } else if (this.myComponent instanceof JTextField || this.myComponent instanceof TextComponent || this.myComponent instanceof JComboBox || this.myComponent instanceof ComponentWithBrowseButton) {
            int n = top = isWin10 ? 3 : 4;
            int n2 = isWin10 ? 2 : (left = isMacDefault ? 5 : 4);
            bottom = isWin10 ? 10 : (isMacDefault ? 8 : 9);
        } else if (this.myComponent instanceof JButton) {
            int n = top = isWin10 ? 2 : 4;
            left = isWin10 ? 2 : (isMacDefault ? 5 : 4);
            bottom = 0;
        }
        return JBUI.insets((int)top, (int)left, (int)bottom, (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/panel/ComponentPanelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/panel/ComponentPanelBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLabel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withComment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withTooltip";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withTooltipLink";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ComponentPanelImpl
    extends ComponentPanel {
        private final JLabel label;
        private final JLabel comment;

        private ComponentPanelImpl() {
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                this.label = new JLabel();
                LabeledComponent.TextWithMnemonic.fromTextWithMnemonic(ComponentPanelBuilder.this.myLabelText).setToLabel(this.label);
                this.label.setLabelFor(ComponentPanelBuilder.this.myComponent);
            } else {
                this.label = new JLabel("");
            }
            this.comment = new JLabel(StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myComment) ? ComponentPanelBuilder.this.myComment : "");
            this.comment.setForeground((Color)Gray.x78);
            if (SystemInfo.isMac) {
                Font font = this.comment.getFont();
                float size = font.getSize2D();
                Font smallFont = font.deriveFont(size - 2.0f);
                this.comment.setFont(smallFont);
            }
        }

        @Override
        public String getCommentText() {
            return ComponentPanelBuilder.this.myComment;
        }

        @Override
        public void setCommentText(String commentText) {
            ComponentPanelBuilder.this.myComment = commentText;
            Insets i = ComponentPanelBuilder.this.myComponent.getInsets();
            int maxWidth = ComponentPanelBuilder.this.myComponent.getWidth() - (i.left + i.right);
            this.comment.setText(String.format("<html><div width=%d>%s</div></html>", maxWidth, commentText));
        }

        private void addToPanel(JPanel panel, GridBagConstraints gc) {
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.anchor = 21;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                if (ComponentPanelBuilder.this.myLabelOnTop) {
                    gc.insets = JBUI.insetsBottom((int)4);
                    panel.add((Component)this.label, gc);
                    ++gc.gridy;
                } else {
                    gc.insets = JBUI.insetsRight((int)8);
                    panel.add((Component)this.label, gc);
                }
            }
            gc.gridx = ++gc.gridx + (ComponentPanelBuilder.this.myLabelOnTop ? 0 : 1);
            gc.weightx = 1.0;
            gc.insets = JBUI.emptyInsets();
            JPanel componentPanel = new JPanel();
            componentPanel.setLayout(new BoxLayout(componentPanel, 0));
            componentPanel.add(ComponentPanelBuilder.this.myComponent);
            ComponentPanelBuilder.this.myComponent.putClientProperty("JComponent.decoratedPanel", this);
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription)) {
                ContextHelpLabel lbl = StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTLinkText) && ComponentPanelBuilder.this.myHTAction != null ? ContextHelpLabel.createWithLink(null, ComponentPanelBuilder.this.myHTDescription, ComponentPanelBuilder.this.myHTLinkText, ComponentPanelBuilder.this.myHTAction) : ContextHelpLabel.create(ComponentPanelBuilder.this.myHTDescription);
                componentPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)7, (int)0)));
                componentPanel.add(lbl);
            } else if (!ComponentPanelBuilder.this.myCommentBelow) {
                componentPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)ComponentPanelBuilder.this.getCommentOffset(), (int)0)));
                componentPanel.add(this.comment);
            }
            panel.add((Component)componentPanel, gc);
            if (ComponentPanelBuilder.this.myCommentBelow) {
                gc.gridx = 1;
                ++gc.gridy;
                gc.weightx = 0.0;
                gc.anchor = 18;
                gc.insets = ComponentPanelBuilder.this.getCommentInsets();
                panel.add((Component)this.comment, gc);
            }
            ++gc.gridy;
        }
    }
}

