/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.values;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Generation {
    private static int GENERATION_POOL_SIZE = 45;
    private static int MUTATION_PER_GEN = 10;
    public static int GEN_COUNT = 40;
    private List<Gens> myGensPool;
    private int myAge;
    private int myParentKind;

    private Generation(@NotNull Gens bestGens) {
        if (bestGens == null) {
            Generation.$$$reportNull$$$0(0);
        }
        this.myParentKind = -1;
        this.myGensPool = new ArrayList<Gens>(GENERATION_POOL_SIZE);
        for (int i = 0; i < GENERATION_POOL_SIZE; ++i) {
            this.myGensPool.add(new Gens(bestGens).mutate(i == 0 ? 0 : MUTATION_PER_GEN));
        }
        this.myAge = 0;
    }

    private Generation(@NotNull Generation previous, int parentKind) {
        if (previous == null) {
            Generation.$$$reportNull$$$0(1);
        }
        this.myAge = previous.myAge + 1;
        this.myParentKind = parentKind;
        this.myGensPool = new ArrayList<Gens>(GENERATION_POOL_SIZE);
        int mutationsCount = MUTATION_PER_GEN;
        int prevPullSize = previous.myGensPool.size();
        for (int i = 0; i < GENERATION_POOL_SIZE; ++i) {
            int parent1 = 0;
            int parent2 = 0;
            int iterations = 0;
            while (parent1 == parent2) {
                parent1 = Utils.getRandomLess(prevPullSize);
                parent2 = Utils.getRandomLess(prevPullSize);
                if (++iterations <= 25) continue;
            }
            this.myGensPool.add(Gens.breed(previous.myGensPool.get(parent1), previous.myGensPool.get(parent2), mutationsCount));
        }
    }

    @NotNull
    public static Generation createZeroGeneration(@NotNull Gens gens) {
        if (gens == null) {
            Generation.$$$reportNull$$$0(2);
        }
        Generation generation = new Generation(gens);
        if (generation == null) {
            Generation.$$$reportNull$$$0(3);
        }
        return generation;
    }

    public static Generation createNextGeneration(@NotNull Differ differ, @NotNull Generation previous) {
        if (differ == null) {
            Generation.$$$reportNull$$$0(4);
        }
        if (previous == null) {
            Generation.$$$reportNull$$$0(5);
        }
        int parentKind = previous.reduceToSize(differ, (int)(0.2 * (double)previous.myGensPool.size()));
        return previous.tryAgain() ? new Generation(previous, parentKind) : previous;
    }

    private int reduceToSize(@NotNull Differ differ, int newPoolSize) {
        if (differ == null) {
            Generation.$$$reportNull$$$0(6);
        }
        ArrayList<Pair> ranges = new ArrayList<Pair>(this.myGensPool.size());
        int i = 0;
        for (Gens gens : this.myGensPool) {
            int range = differ.getDifference(gens);
            ranges.add(Pair.create((Object)range, (Object)i++));
            if (range != 0) continue;
            this.myAge = GEN_COUNT;
            newPoolSize = 1;
            break;
        }
        Collections.sort(ranges, Comparator.comparingInt(o -> (Integer)o.first));
        ArrayList<Gens> gensPool = new ArrayList<Gens>(newPoolSize);
        int count = 0;
        int worseForward = 0;
        for (Pair pair : ranges) {
            if (count >= newPoolSize) break;
            Gens gens = this.myGensPool.get((Integer)pair.second);
            gensPool.add(gens);
            ++count;
            worseForward = (Integer)pair.first;
        }
        this.myGensPool = gensPool;
        return worseForward;
    }

    public boolean tryAgain() {
        return this.myAge < GEN_COUNT;
    }

    public Gens getBestGens(Differ differ) {
        this.reduceToSize(differ, 1);
        return this.myGensPool.get(0);
    }

    public int getAge() {
        return this.myAge;
    }

    public int getParentKind() {
        return this.myParentKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bestGens";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previous";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gens";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/extractor/values/Generation";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "differ";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/extractor/values/Generation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createZeroGeneration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createZeroGeneration";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNextGeneration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reduceToSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

