/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerValueEditor
extends TextFieldValueEditor<Integer> {
    private int myMinValue;
    private int myMaxValue;
    private boolean myCanBeEmpty;

    public IntegerValueEditor(@NotNull JTextField field, @Nullable String valueName, @NotNull Integer defaultValue) {
        if (field == null) {
            IntegerValueEditor.$$$reportNull$$$0(0);
        }
        if (defaultValue == null) {
            IntegerValueEditor.$$$reportNull$$$0(1);
        }
        super(field, valueName, defaultValue);
    }

    @Override
    @NotNull
    public Integer parseValue(@Nullable String text) {
        block7: {
            Integer n;
            try {
                if (!StringUtil.isEmpty((String)text)) break block7;
                if (!this.myCanBeEmpty) {
                    throw new InvalidDataException(ApplicationBundle.message("integer.field.value.expected", new Object[0]));
                }
                n = (Integer)this.getDefaultValue();
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDataException(ApplicationBundle.message("integer.field.value.not.a.number", text));
            }
            if (n == null) {
                IntegerValueEditor.$$$reportNull$$$0(2);
            }
            return n;
        }
        int value = Integer.parseInt(text);
        if (value < this.myMinValue || value > this.myMaxValue) {
            throw new InvalidDataException(ApplicationBundle.message("integer.field.value.out.of.range", value, this.myMinValue, this.myMaxValue));
        }
        Integer n = value;
        if (n == null) {
            IntegerValueEditor.$$$reportNull$$$0(3);
        }
        return n;
    }

    @Override
    public String valueToString(@NotNull Integer value) {
        if (value == null) {
            IntegerValueEditor.$$$reportNull$$$0(4);
        }
        if (this.myCanBeEmpty && value.equals(this.getDefaultValue())) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public boolean isValid(@NotNull Integer value) {
        if (value == null) {
            IntegerValueEditor.$$$reportNull$$$0(5);
        }
        return value >= this.myMinValue && value <= this.myMaxValue;
    }

    public int getMinValue() {
        return this.myMinValue;
    }

    public int getMaxValue() {
        return this.myMaxValue;
    }

    public void setMinValue(int minValue) {
        this.myMinValue = minValue;
    }

    public void setMaxValue(int maxValue) {
        this.myMaxValue = maxValue;
    }

    public boolean isCanBeEmpty() {
        return this.myCanBeEmpty;
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.myCanBeEmpty = canBeEmpty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/valueEditors/IntegerValueEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/valueEditors/IntegerValueEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "valueToString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

