/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.GradleIcons;
import java.io.File;
import java.util.regex.Matcher;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GradleLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    private static final LibraryKind GRADLE_KIND = LibraryKind.create((String)"gradle");
    private final GradleInstallationManager myLibraryManager;

    public GradleLibraryPresentationProvider(@NotNull GradleInstallationManager libraryManager) {
        if (libraryManager == null) {
            GradleLibraryPresentationProvider.$$$reportNull$$$0(0);
        }
        super(GRADLE_KIND);
        this.myLibraryManager = libraryManager;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GradleIcons.Gradle;
        if (icon == null) {
            GradleLibraryPresentationProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GradleLibraryPresentationProvider.getGradleVersion(libraryFiles);
    }

    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            GradleLibraryPresentationProvider.$$$reportNull$$$0(2);
        }
        return this.myLibraryManager.isGradleSdkHome(file);
    }

    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return this.myLibraryManager.isGradleSdk(libraryFiles);
    }

    @NotNull
    public String getSDKVersion(String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        assert (file != null);
        VirtualFile lib = file.findChild("lib");
        assert (lib != null);
        for (VirtualFile virtualFile : lib.getChildren()) {
            String version = GradleLibraryPresentationProvider.getGradleJarVersion(virtualFile);
            if (version == null) continue;
            String string = version;
            if (string == null) {
                GradleLibraryPresentationProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        throw new AssertionError((Object)path);
    }

    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Gradle" == null) {
            GradleLibraryPresentationProvider.$$$reportNull$$$0(4);
        }
        return "Gradle";
    }

    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File[] jars;
        File lib = new File(path + "/lib");
        File[] fileArray = jars = lib.exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }

    @Nullable
    private static String getGradleVersion(VirtualFile[] libraryFiles) {
        for (VirtualFile file : libraryFiles) {
            String version = GradleLibraryPresentationProvider.getGradleJarVersion(file);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Nullable
    private static String getGradleJarVersion(VirtualFile file) {
        Matcher matcher = GradleInstallationManager.GRADLE_JAR_FILE_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryManager";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/config/GradleLibraryPresentationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradleLibraryPresentationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryCategoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSDKHome";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

