/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleMethodContextContributor;", "()V", "getDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "process", "", "methodCallInfo", "", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.gradle"})
public final class GradleMiscContributor
implements GradleMethodContextContributor {
    @NotNull
    private static final GroovyClosurePattern useJUnitClosure;
    @NotNull
    private static final GroovyClosurePattern testLoggingClosure;
    @NotNull
    private static final GroovyClosurePattern downloadClosure;
    @NotNull
    private static final GroovyClosurePattern domainCollectionWithTypeClosure;
    @NotNull
    private static final GroovyClosurePattern manifestClosure;
    @NotNull
    private static final String downloadSpecFqn = "de.undercouch.gradle.tasks.download.DownloadSpec";
    @NotNull
    private static final String pluginDependenciesSpecFqn = "org.gradle.plugin.use.PluginDependenciesSpec";
    public static final Companion Companion;

    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closure) {
        PsiType psiType;
        Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
        if (Companion.getUseJUnitClosure().accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.tasks.testing.junit.JUnitOptions", (PsiElement)((PsiElement)closure)), 1);
        }
        if (Companion.getTestLoggingClosure().accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.tasks.testing.logging.TestLoggingContainer", (PsiElement)((PsiElement)closure)), 1);
        }
        if (Companion.getDownloadClosure().accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)Companion.getDownloadSpecFqn(), (PsiElement)((PsiElement)closure)), 1);
        }
        if (Companion.getManifestClosure().accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.java.archives.Manifest", (PsiElement)((PsiElement)closure)), 1);
        }
        PsiElement parent = closure.getParent();
        if (Companion.getDomainCollectionWithTypeClosure().accepts((Object)closure) && parent instanceof GrMethodCallExpression) {
            PsiElement psiElement;
            GroovyPsiElement groovyPsiElement = (GroovyPsiElement)ArraysKt.singleOrNull((Object[])((GrMethodCallExpression)parent).getArgumentList().getAllArguments());
            PsiElement psiElement2 = groovyPsiElement != null && (groovyPsiElement = groovyPsiElement.getReference()) != null ? groovyPsiElement.resolve() : (psiElement = null);
            if (psiElement instanceof PsiClass) {
                return new DelegatesToInfo((PsiType)TypesUtil.createType((String)((PsiClass)psiElement).getQualifiedName(), (PsiElement)((PsiElement)closure)), 1);
            }
        }
        if (parent instanceof GrMethodCall && (psiType = ((GrMethodCall)parent).getInvokedExpression().getType()) != null && Intrinsics.areEqual((Object)psiType, (Object)PsiType.VOID) ^ true) {
            return new DelegatesToInfo(psiType, 1);
        }
        return null;
    }

    @Override
    public boolean process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull(methodCallInfo, (String)"methodCallInfo");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        boolean shouldProcessMethods = ResolveUtil.shouldProcessMethods((ElementClassHint)classHint);
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GlobalSearchScope resolveScope = place.getResolveScope();
        if (shouldProcessMethods) {
            PsiElement psiElement = place.getParent();
            if ((psiElement != null ? psiElement.getParent() : null) instanceof GroovyFile && Intrinsics.areEqual((Object)place.getText(), (Object)"plugins")) {
                GrLightMethodBuilder grLightMethodBuilder;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass(Companion.getPluginDependenciesSpecFqn(), resolveScope);
                if (psiClass == null) {
                    return true;
                }
                PsiClass pluginsDependenciesClass = psiClass;
                PsiClassType psiClassType = groovyPsiManager.createTypeByFQClassName(Companion.getPluginDependenciesSpecFqn(), resolveScope);
                if (psiClassType == null) {
                    return true;
                }
                PsiClassType returnClass = psiClassType;
                GrLightMethodBuilder $receiver = grLightMethodBuilder = new GrLightMethodBuilder(place.getManager(), "plugins");
                $receiver.setContainingClass(pluginsDependenciesClass);
                $receiver.setReturnType((PsiType)returnClass);
                GrLightMethodBuilder methodBuilder = grLightMethodBuilder;
                methodBuilder.addAndGetParameter("configuration", "groovy.lang.Closure", false).putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, (Object)Companion.getPluginDependenciesSpecFqn());
                place.putUserData(UtilKt.RESOLVED_CODE, (Object)true);
                if (!processor.execute((PsiElement)methodBuilder, state)) {
                    return false;
                }
            }
        }
        ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)Companion.getDomainCollectionWithTypeClosure())).accepts((Object)place);
        return true;
    }

    static {
        Companion = new Companion(null);
        useJUnitClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.tasks.testing.Test", (String[])new String[]{"useJUnit"}));
        testLoggingClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.tasks.testing.Test", (String[])new String[]{"testLogging"}));
        downloadClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.Project", (String[])new String[]{"download"}));
        domainCollectionWithTypeClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.DomainObjectCollection", (String[])new String[]{"withType"}));
        manifestClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.jvm.tasks.Jar", (String[])new String[]{"manifest"}));
        downloadSpecFqn = downloadSpecFqn;
        pluginDependenciesSpecFqn = pluginDependenciesSpecFqn;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor$Companion;", "", "()V", "domainCollectionWithTypeClosure", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "getDomainCollectionWithTypeClosure", "()Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "downloadClosure", "getDownloadClosure", "downloadSpecFqn", "", "getDownloadSpecFqn", "()Ljava/lang/String;", "manifestClosure", "getManifestClosure", "pluginDependenciesSpecFqn", "getPluginDependenciesSpecFqn", "testLoggingClosure", "getTestLoggingClosure", "useJUnitClosure", "getUseJUnitClosure", "intellij.gradle"})
    public static final class Companion {
        @NotNull
        public final GroovyClosurePattern getUseJUnitClosure() {
            return useJUnitClosure;
        }

        @NotNull
        public final GroovyClosurePattern getTestLoggingClosure() {
            return testLoggingClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDownloadClosure() {
            return downloadClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDomainCollectionWithTypeClosure() {
            return domainCollectionWithTypeClosure;
        }

        @NotNull
        public final GroovyClosurePattern getManifestClosure() {
            return manifestClosure;
        }

        @NotNull
        public final String getDownloadSpecFqn() {
            return downloadSpecFqn;
        }

        @NotNull
        public final String getPluginDependenciesSpecFqn() {
            return pluginDependenciesSpecFqn;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

