/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolver;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.components.SimpleArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.LambdaArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "", "callableReferenceResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;)V", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "analyzeLambda", "lambda", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "diagnosticHolder", "Context", "resolution"})
public final class PostponedArgumentsAnalyzer {
    private final CallableReferenceResolver callableReferenceResolver;

    public final void analyze(@NotNull Context c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedAtom argument, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(resolutionCallbacks, "resolutionCallbacks");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(diagnosticsHolder, "diagnosticsHolder");
        ResolvedAtom resolvedAtom = argument;
        if (resolvedAtom instanceof ResolvedLambdaAtom) {
            this.analyzeLambda(c, resolutionCallbacks, (ResolvedLambdaAtom)argument, diagnosticsHolder);
        } else if (resolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
            this.analyzeLambda(c, resolutionCallbacks, PostponeArgumentsChecksKt.transformToResolvedLambda((LambdaWithTypeVariableAsExpectedTypeAtom)argument, c.getBuilder()), diagnosticsHolder);
        } else if (resolvedAtom instanceof ResolvedCallableReferenceAtom) {
            this.callableReferenceResolver.processCallableReferenceArgument(c.getBuilder(), (ResolvedCallableReferenceAtom)argument, diagnosticsHolder);
        } else {
            if (resolvedAtom instanceof ResolvedCollectionLiteralAtom) {
                String string = "Not supported";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            String string = "Unexpected resolved primitive: " + argument.getClass().getCanonicalName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeLambda(Context c, KotlinResolutionCallbacks resolutionCallbacks, ResolvedLambdaAtom lambda2, KotlinDiagnosticsHolder diagnosticHolder) {
        void $receiver$iv$iv;
        Object element$iv2;
        UnwrappedType unwrappedType;
        Object object;
        UnwrappedType p1;
        Object object2;
        UnwrappedType $receiver$iv$iv2;
        Iterable $receiver$iv;
        UnwrappedType unwrappedType2;
        NewTypeSubstitutor currentSubstitutor2 = c.buildCurrentSubstitutor();
        Function1<UnwrappedType, UnwrappedType> substitute$ = new Function1<UnwrappedType, UnwrappedType>(currentSubstitutor2){
            final /* synthetic */ NewTypeSubstitutor $currentSubstitutor;

            @NotNull
            public final UnwrappedType invoke(@NotNull UnwrappedType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return this.$currentSubstitutor.safeSubstitute(type2);
            }
            {
                this.$currentSubstitutor = newTypeSubstitutor;
                super(1);
            }
        };
        UnwrappedType unwrappedType3 = lambda2.getReceiver();
        if (unwrappedType3 != null) {
            UnwrappedType unwrappedType4;
            UnwrappedType p12 = unwrappedType4 = unwrappedType3;
            unwrappedType2 = substitute$.invoke(p12);
        } else {
            unwrappedType2 = null;
        }
        UnwrappedType receiver = unwrappedType2;
        Iterable $i$a$1$unknown = $receiver$iv = (Iterable)lambda2.getParameters();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            UnwrappedType unwrappedType5 = (UnwrappedType)item$iv$iv;
            object2 = destination$iv$iv;
            object = substitute$.invoke(p1);
            object2.add(object);
        }
        List parameters2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = lambda2.getReturnType();
        UnwrappedType it = $receiver$iv$iv2;
        UnwrappedType unwrappedType6 = c.canBeProper(it) ? $receiver$iv$iv2 : null;
        if (unwrappedType6 != null) {
            UnwrappedType p13 = $receiver$iv$iv2 = unwrappedType6;
            unwrappedType = substitute$.invoke(p13);
        } else {
            unwrappedType = null;
        }
        UnwrappedType expectedType2 = unwrappedType;
        List<SimpleKotlinCallArgument> returnArguments = resolutionCallbacks.analyzeAndGetLambdaReturnArguments(lambda2.getAtom(), lambda2.isSuspend(), receiver, parameters2, expectedType2);
        Iterable $receiver$iv2 = returnArguments;
        for (Object element$iv2 : $receiver$iv2) {
            SimpleKotlinCallArgument it2 = (SimpleKotlinCallArgument)element$iv2;
            ConstraintSystemBuilderKt.addSubsystemFromArgument(c, it2);
        }
        Iterable $receiver$iv3 = returnArguments;
        element$iv2 = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it3;
            SimpleKotlinCallArgument $i$f$map = (SimpleKotlinCallArgument)item$iv$iv;
            object2 = destination$iv$iv2;
            UnwrappedType unwrappedType7 = lambda2.getReturnType();
            void var19_21 = it3;
            ConstraintSystemBuilder constraintSystemBuilder = c.getBuilder();
            UnwrappedType p14 = unwrappedType7;
            UnwrappedType unwrappedType8 = substitute$.invoke(p14);
            object = SimpleArgumentsChecksKt.checkSimpleArgument(constraintSystemBuilder, (SimpleKotlinCallArgument)var19_21, unwrappedType8, diagnosticHolder, false);
            object2.add(object);
        }
        List subResolvedKtPrimitives = (List)destination$iv$iv2;
        if (returnArguments.isEmpty()) {
            SimpleType unitType = TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType();
            UnwrappedType unwrappedType9 = lambda2.getReturnType();
            object2 = c.getBuilder();
            p1 = unwrappedType9;
            object = substitute$.invoke(p1);
            SimpleType simpleType2 = unitType;
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "unitType");
            object2.addSubtypeConstraint((UnwrappedType)object, simpleType2, new LambdaArgumentConstraintPosition(lambda2));
        }
        lambda2.setAnalyzedResults(returnArguments, subResolvedKtPrimitives);
    }

    public PostponedArgumentsAnalyzer(@NotNull CallableReferenceResolver callableReferenceResolver) {
        Intrinsics.checkParameterIsNotNull(callableReferenceResolver, "callableReferenceResolver");
        this.callableReferenceResolver = callableReferenceResolver;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "", "addOtherSystem", "", "otherSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "buildCurrentSubstitutor", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "canBeProper", "", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "getBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "resolution"})
    public static interface Context {
        @NotNull
        public NewTypeSubstitutor buildCurrentSubstitutor();

        public boolean canBeProper(@NotNull UnwrappedType var1);

        public void addOtherSystem(@NotNull ConstraintStorage var1);

        @NotNull
        public ConstraintSystemBuilder getBuilder();
    }
}

