/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectSettings;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenTestRunningConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myMainPanel;
    private JBCheckBox myPassArgLineCB;
    private JBCheckBox myPassSystemPropertiesCB;
    private JBCheckBox myPassEnvironmentVariablesCB;
    private final Project myProject;

    public MavenTestRunningConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message("maven.testRunning", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.project.maven.testRunning";
    }

    private void getSettingsFromUI(MavenTestRunningSettings settings) {
        settings.setPassArgLine(this.myPassArgLineCB.isSelected());
        settings.setPassSystemProperties(this.myPassSystemPropertiesCB.isSelected());
        settings.setPassEnvironmentVariables(this.myPassEnvironmentVariablesCB.isSelected());
    }

    public void apply() throws ConfigurationException {
        this.getSettingsFromUI(MavenProjectSettings.getInstance(this.myProject).getTestRunningSettings());
    }

    public void reset() {
        MavenTestRunningSettings settings = MavenProjectSettings.getInstance(this.myProject).getTestRunningSettings();
        this.myPassArgLineCB.setSelected(settings.isPassArgLine());
        this.myPassSystemPropertiesCB.setSelected(settings.isPassSystemProperties());
        this.myPassEnvironmentVariablesCB.setSelected(settings.isPassEnvironmentVariables());
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        MavenTestRunningSettings uiSettings = new MavenTestRunningSettings();
        this.getSettingsFromUI(uiSettings);
        MavenTestRunningSettings projectSettings = MavenProjectSettings.getInstance(this.myProject).getTestRunningSettings();
        return !projectSettings.equals(uiSettings);
    }

    public void disposeUIResources() {
    }

    @NotNull
    public String getId() {
        if ("reference.settings.project.maven.testRunning" == null) {
            MavenTestRunningConfigurable.$$$reportNull$$$0(0);
        }
        return "reference.settings.project.maven.testRunning";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenTestRunningConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPassArgLineCB = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("<html><i>argLine</i></html>");
        jBCheckBox3.setMnemonic('A');
        jBCheckBox3.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 4, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("<html>Pass to JUnit process following <b>maven-surefire-plugin</b> and <b>maven-failsafe-plugin</b> settings:</html>");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 5, 8, 0, 3, 0, null, null, null));
        this.myPassSystemPropertiesCB = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("<html><i>systemPropertyVariables</i></html>");
        jBCheckBox2.setMnemonic('S');
        jBCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myPassEnvironmentVariablesCB = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("<html><i>environmentVariables</i></html>");
        jBCheckBox.setMnemonic('E');
        jBCheckBox.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 5, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

