/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.ImplicitVariableImpl;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ELImplicitVariable
extends ImplicitVariableImpl
implements JspImplicitVariable,
ItemPresentation {
    @NonNls
    public static final String BEGIN_RANGE = "AT_BEGIN";
    @NonNls
    public static final String END_RANGE = "AT_END";
    @NonNls
    public static final String NESTED_RANGE = "NESTED";
    protected final PsiElement myDeclaration;
    protected final int myScope;

    private ELImplicitVariable(@NotNull PsiElement scope, PsiIdentifier nameIdentifier, PsiType type, PsiElement declaration, String range) {
        if (scope == null) {
            ELImplicitVariable.$$$reportNull$$$0(0);
        }
        super(scope.getManager(), nameIdentifier, type, declaration != null && ElementManipulators.getManipulator((PsiElement)declaration) != null, scope);
        this.myScope = BEGIN_RANGE.equals(range) ? 3 : (END_RANGE.equals(range) ? 2 : 1);
        this.myDeclaration = declaration;
    }

    public ELImplicitVariable(@NotNull PsiElement scope, String name, PsiType type, PsiElement declaration, String range) {
        if (scope == null) {
            ELImplicitVariable.$$$reportNull$$$0(1);
        }
        this(scope, (PsiIdentifier)null, type, declaration, range);
        this.myNameIdentifier = new MyIdentifier(this.myManager, name);
    }

    public ELImplicitVariable(PsiElement scope, String name, PsiType type, PsiFile declarationFile) {
        this(scope, (PsiIdentifier)null, type, (PsiElement)declarationFile, NESTED_RANGE);
        this.myNameIdentifier = new MyIdentifier(this.myManager, name);
    }

    public ELImplicitVariable(PsiElement scope, @NonNls String name, @NonNls String type, PsiFile declarationFile) {
        this(scope, (PsiIdentifier)null, (PsiType)JavaPsiFacade.getInstance((Project)scope.getProject()).getElementFactory().createTypeByFQClassName(type, scope.getResolveScope()), (PsiElement)declarationFile, NESTED_RANGE);
        this.myNameIdentifier = new MyIdentifier(this.myManager, name);
    }

    @Override
    public int getDeclarationRange() {
        return this.myScope;
    }

    @Override
    public PsiElement getDeclaration() {
        return this.myDeclaration;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement declaration = this.getDeclaration();
        Object object = declaration != null ? declaration : this;
        if (object == null) {
            ELImplicitVariable.$$$reportNull$$$0(2);
        }
        return object;
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    @Nullable
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return this.myDeclaration != null ? this.myDeclaration.getContainingFile() : null;
    }

    public String getText() {
        PsiIdentifier identifier = this.getNameIdentifier();
        return this.getType().getPresentableText() + " " + (identifier != null ? identifier.getText() : null);
    }

    public String getPresentableText() {
        return this.getName();
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return PlatformIcons.VARIABLE_ICON;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another == this) {
            return true;
        }
        if (another instanceof ELImplicitVariable) {
            ELImplicitVariable implicitVariable = (ELImplicitVariable)another;
            String name = implicitVariable.getName();
            return name.equals(this.getName()) && another.getManager().areElementsEquivalent(implicitVariable.getDeclaration(), this.getDeclaration());
        }
        return this.getManager().areElementsEquivalent(this.getDeclaration(), another);
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiFile file = (this.myDeclaration != null ? this.myDeclaration : this.getDeclarationScope()).getContainingFile();
        SearchScope searchScope = file.getUseScope();
        if (searchScope == null) {
            ELImplicitVariable.$$$reportNull$$$0(3);
        }
        return searchScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ELImplicitVariable)) {
            return false;
        }
        ELImplicitVariable variable = (ELImplicitVariable)o;
        if (this.myScope != variable.myScope) {
            return false;
        }
        return !(this.myDeclaration != null ? !this.myDeclaration.equals(variable.myDeclaration) : variable.myDeclaration != null);
    }

    public int hashCode() {
        int result = this.myDeclaration != null ? this.myDeclaration.hashCode() : 0;
        result = 31 * result + this.myScope;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/ELImplicitVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/ELImplicitVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyIdentifier
    extends LightIdentifier {
        public MyIdentifier(PsiManager manager, String name) {
            super(manager, name);
        }

        public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
            if (newElement == null) {
                MyIdentifier.$$$reportNull$$$0(0);
            }
            String newName = newElement.getText();
            PsiElement declaration = ELImplicitVariable.this.getDeclaration();
            this.doContentChange(declaration, newName);
            ELImplicitVariable.this.myNameIdentifier = (PsiIdentifier)new MyIdentifier(this.myManager, newName);
            return ELImplicitVariable.this.myNameIdentifier;
        }

        private void doContentChange(PsiElement declaration, String newName) {
            if (declaration instanceof XmlTag) {
                return;
            }
            if (!declaration.isValid()) {
                return;
            }
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)declaration);
            if (manipulator != null) {
                manipulator.handleContentChange(declaration, newName);
            } else if (declaration instanceof PsiNamedElement) {
                ((PsiNamedElement)declaration).setName(newName);
            }
        }

        public boolean isValid() {
            return ELImplicitVariable.this.myDeclaration == null || ELImplicitVariable.this.myDeclaration.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/jsp/ELImplicitVariable$MyIdentifier", "replace"));
        }
    }
}

